"use strict";
var __awaiter = (this && this.__awaiter) || function (thisArg, _arguments, P, generator) {
    function adopt(value) { return value instanceof P ? value : new P(function (resolve) { resolve(value); }); }
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : adopt(result.value).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.SynchronousMatrixClient = void 0;
const MatrixClient_1 = require("./MatrixClient");
/**
 * A MatrixClient class that handles events in sync for the /sync loop, instead
 * of trying to push its way through the /sync loop as fast as possible. It is
 * intended that the consumer extend this class and override the onWhatever()
 * functions it needs. All of the onWhatever() functions have a default behaviour
 * of doing nothing.
 */
class SynchronousMatrixClient extends MatrixClient_1.MatrixClient {
    /**
     * Creates a new SynchronousMatrixClient. Note that this accepts a MatrixClient, though
     * much of the class's properties are not brought over. Always convert your MatrixClient
     * instance to a SynchronousMatrixClient as soon as possible to avoid diversion in which
     * properties are proxied over.
     * @param {MatrixClient} baseClient The client to wrap.
     */
    constructor(baseClient) {
        super(baseClient.homeserverUrl, baseClient.accessToken, baseClient.storageProvider);
    }
    handleEvent(emitType, arg1, arg2) {
        return __awaiter(this, void 0, void 0, function* () {
            if (emitType === 'account_data')
                yield this.onAccountData(arg1);
            if (emitType === 'room.account_data')
                yield this.onRoomAccountData(arg1, arg2);
            if (emitType === 'room.leave')
                yield this.onRoomLeave(arg1, arg2);
            if (emitType === 'room.invite')
                yield this.onRoomInvite(arg1, arg2);
            if (emitType === 'room.join')
                yield this.onRoomJoin(arg1, arg2);
            if (emitType === 'room.archived')
                yield this.onRoomArchived(arg1, arg2);
            if (emitType === 'room.upgraded')
                yield this.onRoomUpgraded(arg1, arg2);
            if (emitType === 'room.message')
                yield this.onRoomMessage(arg1, arg2);
            if (emitType === 'room.event')
                yield this.onRoomEvent(arg1, arg2);
            // Still emit though for easier support of plugins.
            this.emit(emitType, arg1, arg2);
        });
    }
    startSyncInternal() {
        return this.startSync(this.handleEvent.bind(this));
    }
    /**
     * Handles the `account_data` event raised by the client.
     * @param {any} event The account data event.
     * @returns {Promise<any>} Resolves when complete.
     */
    onAccountData(event) {
        return;
    }
    /**
     * Handles the `room.account_data` event raised by the client.
     * @param {string} roomId The Room ID the account data applies to.
     * @param {any} event The room account data event.
     * @returns {Promise<any>} Resolves when complete.
     */
    onRoomAccountData(roomId, event) {
        return;
    }
    /**
     * Handles the `room.leave` event raised by the client.
     * @param {string} roomId The Room ID the event happened in.
     * @param {any} event The event.
     * @returns {Promise<any>} Resolves when complete.
     */
    onRoomLeave(roomId, event) {
        return;
    }
    /**
     * Handles the `room.invite` event raised by the client.
     * @param {string} roomId The Room ID the event happened in.
     * @param {any} event The event.
     * @returns {Promise<any>} Resolves when complete.
     */
    onRoomInvite(roomId, event) {
        return;
    }
    /**
     * Handles the `room.join` event raised by the client.
     * @param {string} roomId The Room ID the event happened in.
     * @param {any} event The event.
     * @returns {Promise<any>} Resolves when complete.
     */
    onRoomJoin(roomId, event) {
        return;
    }
    /**
     * Handles the `room.message` event raised by the client.
     * @param {string} roomId The Room ID the event happened in.
     * @param {any} event The event.
     * @returns {Promise<any>} Resolves when complete.
     */
    onRoomMessage(roomId, event) {
        return;
    }
    /**
     * Handles the `room.archived` event raised by the client.
     * @param {string} roomId The Room ID the event happened in.
     * @param {any} event The event.
     * @returns {Promise<any>} Resolves when complete.
     */
    onRoomArchived(roomId, event) {
        return;
    }
    /**
     * Handles the `room.upgraded` event raised by the client.
     * @param {string} roomId The Room ID the event happened in.
     * @param {any} event The event.
     * @returns {Promise<any>} Resolves when complete.
     */
    onRoomUpgraded(roomId, event) {
        return;
    }
    /**
     * Handles the `room.event` event raised by the client.
     * @param {string} roomId The Room ID the event happened in.
     * @param {any} event The event.
     * @returns {Promise<any>} Resolves when complete.
     */
    onRoomEvent(roomId, event) {
        return;
    }
}
exports.SynchronousMatrixClient = SynchronousMatrixClient;
