/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller;

import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.nio.charset.StandardCharsets;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.concurrent.RejectedExecutionException;
import javax.xml.stream.XMLOutputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.XMLStreamWriter;
import mediathek.config.Daten;
import mediathek.config.MVConfig;
import mediathek.daten.DatenAbo;
import mediathek.daten.DatenDownload;
import mediathek.daten.DatenMediaPath;
import mediathek.daten.DatenProg;
import mediathek.daten.DatenPset;
import mediathek.daten.blacklist.BlacklistRule;
import mediathek.tool.ApplicationConfiguration;
import mediathek.tool.ReplaceList;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class IoXmlSchreiben {
    private static final Logger logger = LogManager.getLogger(IoXmlSchreiben.class);
    private final XMLOutputFactory outFactory = XMLOutputFactory.newInstance();

    private void writeFileHeader(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeStartDocument(StandardCharsets.UTF_8.name(), "1.0");
        this.writeNewLine(writer);
        writer.writeStartElement("Mediathek");
        this.writeNewLine(writer);
    }

    private void writeFileEnd(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeEndElement();
        writer.writeEndDocument();
        writer.flush();
        writer.close();
    }

    private void writeAbos(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeCharacters("\n\n");
        this.writeNewLine(writer);
        for (DatenAbo datenAbo : Daten.getInstance().getListeAbo()) {
            datenAbo.writeToConfig(writer);
        }
    }

    private void writeBlacklist(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeCharacters("\n\n");
        this.writeNewLine(writer);
        for (BlacklistRule blacklist : Daten.getInstance().getListeBlacklist()) {
            this.xmlSchreibenDaten(writer, "Blacklist", BlacklistRule.XML_NAMES, blacklist.arr, false);
        }
    }

    private void writeProgramSettings(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeCharacters("\n\n");
        writer.writeCharacters("\n\n");
        this.writeNewLine(writer);
        this.xmlSchreibenConfig(writer, MVConfig.getAll());
        this.writeNewLine(writer);
    }

    private void writeProgramSets(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeCharacters("\n\n");
        this.writeNewLine(writer);
        for (DatenPset datenPset : Daten.listePset) {
            this.xmlSchreibenDaten(writer, "Programmset", DatenPset.XML_NAMES, datenPset.arr, true);
            for (DatenProg datenProg : datenPset.getListeProg()) {
                this.xmlSchreibenDaten(writer, "Programm", DatenProg.XML_NAMES, datenProg.arr, true);
            }
        }
    }

    private void writeReplacementTable(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeCharacters("\n\n");
        this.writeNewLine(writer);
        for (String[] sa : ReplaceList.list) {
            this.xmlSchreibenDaten(writer, "Ersetzungstabelle", ReplaceList.COLUMN_NAMES, sa, false);
        }
    }

    private void writeDownloads(XMLStreamWriter writer) throws XMLStreamException {
        boolean dl_list_version = true;
        try {
            ApplicationConfiguration.getConfiguration().setProperty("cli.client.download_list_format", 1);
        }
        catch (RejectedExecutionException rejectedExecutionException) {
        }
        catch (Exception e) {
            logger.error("writeDownloads error!", (Throwable)e);
        }
        writer.writeCharacters("\n\n");
        this.writeNewLine(writer);
        for (DatenDownload download : Daten.getInstance().getListeDownloads()) {
            if (download.isInterrupted()) {
                download.writeConfigEntry(writer);
                continue;
            }
            if (download.isFinished() || download.isFromAbo()) continue;
            download.writeConfigEntry(writer);
        }
    }

    private void writeMediaDatabase(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeCharacters("\n\n");
        this.writeNewLine(writer);
        for (DatenMediaPath mp : Daten.getInstance().getListeMediaPath()) {
            this.xmlSchreibenDaten(writer, "MediaPath", DatenMediaPath.XML_NAMES, mp.arr, false);
        }
    }

    private void xmlSchreibenPset(XMLStreamWriter writer, DatenPset[] psetArray) throws XMLStreamException {
        writer.writeCharacters("\n\n");
        for (DatenPset pset : psetArray) {
            this.xmlSchreibenDaten(writer, "Programmset", DatenPset.XML_NAMES, pset.arr, true);
            for (DatenProg datenProg : pset.getListeProg()) {
                this.xmlSchreibenDaten(writer, "Programm", DatenProg.XML_NAMES, datenProg.arr, true);
            }
            writer.writeCharacters("\n\n");
        }
    }

    private void xmlSchreibenDaten(XMLStreamWriter writer, String xmlName, String[] xmlSpalten, String[] datenArray, boolean newLine) {
        int xmlMax = datenArray.length;
        try {
            writer.writeStartElement(xmlName);
            if (newLine) {
                this.writeNewLine(writer);
            }
            for (int i = 0; i < xmlMax; ++i) {
                if (datenArray[i].isEmpty()) continue;
                if (newLine) {
                    writer.writeCharacters("\t");
                }
                writer.writeStartElement(xmlSpalten[i]);
                writer.writeCharacters(datenArray[i]);
                writer.writeEndElement();
                if (!newLine) continue;
                this.writeNewLine(writer);
            }
            writer.writeEndElement();
            this.writeNewLine(writer);
        }
        catch (Exception ex) {
            logger.error("xmlSchreibenDaten", (Throwable)ex);
        }
    }

    private void writeNewLine(XMLStreamWriter writer) throws XMLStreamException {
        writer.writeCharacters("\n");
    }

    private void xmlSchreibenConfig(XMLStreamWriter writer, String[][] xmlSpalten) {
        try {
            writer.writeStartElement("system");
            this.writeNewLine(writer);
            for (String[] xmlSpalte : xmlSpalten) {
                if (!MVConfig.Configs.find(xmlSpalte[0])) continue;
                writer.writeCharacters("\t");
                writer.writeStartElement(xmlSpalte[0]);
                writer.writeCharacters(xmlSpalte[1]);
                writer.writeEndElement();
                this.writeNewLine(writer);
            }
            writer.writeEndElement();
            this.writeNewLine(writer);
        }
        catch (Exception ex) {
            logger.error(ex);
        }
    }

    public synchronized void writeConfigurationFile(Path xmlFilePath) {
        logger.info("Daten Schreiben nach: {}", (Object)xmlFilePath.toString());
        this.xmlDatenSchreiben(xmlFilePath);
    }

    public synchronized void exportPset(DatenPset[] pSet, String datei) {
        Path xmlFilePath = Paths.get(datei, new String[0]);
        try (OutputStream os = Files.newOutputStream(xmlFilePath, new OpenOption[0]);
             OutputStreamWriter out = new OutputStreamWriter(os, StandardCharsets.UTF_8);){
            XMLStreamWriter writer = this.outFactory.createXMLStreamWriter(out);
            logger.info("Pset exportieren nach: {}", (Object)xmlFilePath.toString());
            logger.info("Start Schreiben nach: {}", (Object)xmlFilePath.toAbsolutePath());
            this.writeFileHeader(writer);
            this.xmlSchreibenPset(writer, pSet);
            this.writeFileEnd(writer);
            logger.info("geschrieben!");
        }
        catch (Exception ex) {
            logger.error("nach {}", (Object)datei, (Object)ex);
        }
    }

    private void xmlDatenSchreiben(Path xmlFilePath) {
        logger.info("Config Schreiben nach: {} startet", (Object)xmlFilePath.toAbsolutePath());
        try (OutputStream os = Files.newOutputStream(xmlFilePath, new OpenOption[0]);
             OutputStreamWriter out = new OutputStreamWriter(os, StandardCharsets.UTF_8);){
            XMLStreamWriter writer = this.outFactory.createXMLStreamWriter(out);
            this.writeFileHeader(writer);
            this.writeAbos(writer);
            this.writeBlacklist(writer);
            this.writeProgramSettings(writer);
            this.writeProgramSets(writer);
            this.writeReplacementTable(writer);
            this.writeDownloads(writer);
            this.writeMediaDatabase(writer);
            writer.writeCharacters("\n\n");
            this.writeFileEnd(writer);
            logger.info("Config Schreiben beendet");
        }
        catch (Exception ex) {
            logger.error("xmlDatenSchreiben", (Throwable)ex);
        }
    }
}

