/*
 * Decompiled with CFR 0.152.
 */
package mediathek.javafx;

import java.net.URISyntaxException;
import javafx.application.Platform;
import javafx.scene.Node;
import javafx.scene.control.Alert;
import javafx.scene.control.Hyperlink;
import javafx.scene.control.Label;
import javafx.scene.layout.FlowPane;
import mediathek.gui.actions.UrlHyperlinkAction;
import mediathek.mainwindow.MediathekGui;
import mediathek.tool.ApplicationConfiguration;
import org.apache.commons.configuration2.Configuration;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class OrfSetupInformationThread
implements Runnable {
    private static final Logger logger = LogManager.getLogger(OrfSetupInformationThread.class);

    @Override
    public void run() {
        String location;
        logger.trace("ORF setup tutorial display check started");
        Configuration config = ApplicationConfiguration.getConfiguration();
        if (config.getBoolean("application.orf.show_config_help", true) && (location = config.getString("geo.location", "")).equals("AT")) {
            Platform.runLater(() -> {
                Alert alert = new Alert(Alert.AlertType.INFORMATION);
                alert.setTitle("MediathekView");
                alert.setHeaderText("Wichtige Information f\u00fcr ORF");
                FlowPane fp = new FlowPane();
                Label lbl = new Label("Um den ORF erfolgreich zu nutzen sind zus\u00e4tzlich Einstellungen erforderlich.\nBitte lesen Sie sich hierzu folgenden Link durch: ");
                Hyperlink link = new Hyperlink("Link zum Tutorial");
                fp.getChildren().addAll((Node[])new Node[]{lbl, link});
                link.setOnAction(evt -> {
                    config.setProperty("application.orf.show_config_help", false);
                    try {
                        UrlHyperlinkAction.openURL(MediathekGui.ui(), "https://forum.mediathekview.de/topic/2546/anleitung-einstellungen-f\u00fcr-orf-download");
                    }
                    catch (URISyntaxException uRISyntaxException) {
                        // empty catch block
                    }
                    alert.close();
                });
                alert.getDialogPane().contentProperty().set(fp);
                alert.show();
            });
        }
        logger.trace("ORF setup tutorial display check finished");
    }
}

