/*
 * Decompiled with CFR 0.152.
 */
package net.sourceforge.plantuml.compositediagram.command;

import net.sourceforge.plantuml.LineLocation;
import net.sourceforge.plantuml.command.CommandExecutionResult;
import net.sourceforge.plantuml.command.SingleLineCommand2;
import net.sourceforge.plantuml.command.regex.IRegex;
import net.sourceforge.plantuml.command.regex.RegexConcat;
import net.sourceforge.plantuml.command.regex.RegexLeaf;
import net.sourceforge.plantuml.command.regex.RegexOptional;
import net.sourceforge.plantuml.command.regex.RegexResult;
import net.sourceforge.plantuml.compositediagram.CompositeDiagram;
import net.sourceforge.plantuml.cucadiagram.Code;
import net.sourceforge.plantuml.cucadiagram.Display;
import net.sourceforge.plantuml.cucadiagram.IEntity;

public class CommandCreateBlock
extends SingleLineCommand2<CompositeDiagram> {
    public CommandCreateBlock() {
        super(CommandCreateBlock.getRegexConcat());
    }

    static IRegex getRegexConcat() {
        return RegexConcat.build(CommandCreateBlock.class.getName(), RegexLeaf.start(), new RegexLeaf("block"), RegexLeaf.spaceOneOrMore(), new RegexOptional((IRegex)new RegexConcat(new RegexLeaf("DISPLAY", "[%g]([^%g]+)[%g]"), RegexLeaf.spaceOneOrMore(), new RegexLeaf("as"), RegexLeaf.spaceOneOrMore())), new RegexLeaf("CODE", "([%pLN_.]+)"), RegexLeaf.end());
    }

    @Override
    protected CommandExecutionResult executeArg(CompositeDiagram diagram, LineLocation location, RegexResult arg) {
        String display = arg.get("DISPLAY", 0);
        String idShort = arg.get("CODE", 0);
        Code code = diagram.buildCode(idShort);
        if (display == null) {
            display = code.getName();
        }
        IEntity ent = diagram.getOrCreateLeaf(diagram.buildLeafIdent(idShort), code, null, null);
        ent.setDisplay(Display.getWithNewlines(display));
        return CommandExecutionResult.ok();
    }
}

