/*
 * Decompiled with CFR 0.152.
 */
package org.apache.batik.transcoder;

import java.awt.Toolkit;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import org.apache.batik.dom.svg.SVGDOMImplementation;
import org.apache.batik.svggen.SVGGraphics2D;
import org.apache.batik.transcoder.AbstractTranscoder;
import org.apache.batik.transcoder.TranscoderException;
import org.apache.batik.transcoder.TranscoderOutput;
import org.apache.batik.transcoder.TranscodingHints;
import org.apache.batik.transcoder.keys.BooleanKey;
import org.apache.batik.transcoder.keys.FloatKey;
import org.apache.batik.transcoder.keys.IntegerKey;
import org.apache.batik.util.SVGConstants;
import org.w3c.dom.DOMImplementation;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.XMLFilter;

public abstract class ToSVGAbstractTranscoder
extends AbstractTranscoder
implements SVGConstants {
    public static float PIXEL_TO_MILLIMETERS = 25.4f / (float)Toolkit.getDefaultToolkit().getScreenResolution();
    public static float PIXEL_PER_INCH = Toolkit.getDefaultToolkit().getScreenResolution();
    public static final int TRANSCODER_ERROR_BASE = 65280;
    public static final int ERROR_NULL_INPUT = 65280;
    public static final int ERROR_INCOMPATIBLE_INPUT_TYPE = 65281;
    public static final int ERROR_INCOMPATIBLE_OUTPUT_TYPE = 65282;
    public static final TranscodingHints.Key KEY_WIDTH = new FloatKey();
    public static final TranscodingHints.Key KEY_HEIGHT = new FloatKey();
    public static final TranscodingHints.Key KEY_INPUT_WIDTH = new IntegerKey();
    public static final TranscodingHints.Key KEY_INPUT_HEIGHT = new IntegerKey();
    public static final TranscodingHints.Key KEY_XOFFSET = new IntegerKey();
    public static final TranscodingHints.Key KEY_YOFFSET = new IntegerKey();
    public static final TranscodingHints.Key KEY_ESCAPED = new BooleanKey();
    protected SVGGraphics2D svgGenerator;

    protected Document createDocument(TranscoderOutput transcoderOutput) {
        Document document;
        if (transcoderOutput.getDocument() == null) {
            DOMImplementation dOMImplementation = SVGDOMImplementation.getDOMImplementation();
            document = dOMImplementation.createDocument("http://www.w3.org/2000/svg", "svg", null);
        } else {
            document = transcoderOutput.getDocument();
        }
        return document;
    }

    public SVGGraphics2D getGraphics2D() {
        return this.svgGenerator;
    }

    protected void writeSVGToOutput(SVGGraphics2D sVGGraphics2D, Element element, TranscoderOutput transcoderOutput) throws TranscoderException {
        block10: {
            Document document = transcoderOutput.getDocument();
            if (document != null) {
                return;
            }
            XMLFilter xMLFilter = transcoderOutput.getXMLFilter();
            if (xMLFilter != null) {
                this.handler.fatalError(new TranscoderException("65282"));
            }
            try {
                OutputStream outputStream;
                boolean bl = false;
                if (this.hints.containsKey(KEY_ESCAPED)) {
                    bl = (Boolean)this.hints.get(KEY_ESCAPED);
                }
                if ((outputStream = transcoderOutput.getOutputStream()) != null) {
                    sVGGraphics2D.stream(element, new OutputStreamWriter(outputStream), false, bl);
                    return;
                }
                Writer writer = transcoderOutput.getWriter();
                if (writer != null) {
                    sVGGraphics2D.stream(element, writer, false, bl);
                    return;
                }
                String string = transcoderOutput.getURI();
                if (string == null) break block10;
                try {
                    URL uRL = new URL(string);
                    URLConnection uRLConnection = uRL.openConnection();
                    outputStream = uRLConnection.getOutputStream();
                    sVGGraphics2D.stream(element, new OutputStreamWriter(outputStream), false, bl);
                    return;
                }
                catch (MalformedURLException malformedURLException) {
                    this.handler.fatalError(new TranscoderException(malformedURLException));
                }
                catch (IOException iOException) {
                    this.handler.fatalError(new TranscoderException(iOException));
                }
            }
            catch (IOException iOException) {
                throw new TranscoderException(iOException);
            }
        }
        throw new TranscoderException("65282");
    }
}

