/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.ontology.imports;

import com.google.common.util.concurrent.ListeningExecutorService;
import com.google.common.util.concurrent.MoreExecutors;
import java.awt.Component;
import java.io.File;
import java.io.IOException;
import java.io.Serializable;
import java.net.URI;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import javax.swing.JOptionPane;
import javax.swing.SwingUtilities;
import org.protege.editor.core.log.LogBanner;
import org.protege.editor.core.ui.util.UIUtil;
import org.protege.editor.owl.OWLEditorKit;
import org.protege.editor.owl.model.OntologyManagerFactory;
import org.protege.editor.owl.model.io.ProgressDialogOntologyLoaderListener;
import org.protege.editor.owl.model.library.OntologyCatalogManager;
import org.protege.editor.owl.ui.ontology.imports.wizard.ImportInfo;
import org.protege.editor.owl.ui.util.ProgressDialog;
import org.protege.xmlcatalog.CatalogUtilities;
import org.protege.xmlcatalog.XMLCatalog;
import org.protege.xmlcatalog.entry.UriEntry;
import org.semanticweb.owlapi.io.IRIDocumentSource;
import org.semanticweb.owlapi.io.OWLOntologyDocumentSource;
import org.semanticweb.owlapi.model.AddImport;
import org.semanticweb.owlapi.model.IRI;
import org.semanticweb.owlapi.model.MissingImportHandlingStrategy;
import org.semanticweb.owlapi.model.OWLImportsDeclaration;
import org.semanticweb.owlapi.model.OWLOntology;
import org.semanticweb.owlapi.model.OWLOntologyChange;
import org.semanticweb.owlapi.model.OWLOntologyCreationException;
import org.semanticweb.owlapi.model.OWLOntologyLoaderConfiguration;
import org.semanticweb.owlapi.model.OWLOntologyLoaderListener;
import org.semanticweb.owlapi.model.OWLOntologyManager;
import org.semanticweb.owlapi.model.parameters.OntologyCopy;
import org.semanticweb.owlapi.util.SimpleIRIMapper;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AddImportsStrategy {
    private final Logger logger = LoggerFactory.getLogger(AddImportsStrategy.class);
    private final OWLEditorKit editorKit;
    private final OWLOntology toOntology;
    private final Collection<ImportInfo> importInfo;
    private final ProgressDialog dlg = new ProgressDialog();
    private final ListeningExecutorService service = MoreExecutors.listeningDecorator((ExecutorService)Executors.newSingleThreadExecutor());

    public AddImportsStrategy(OWLEditorKit editorKit, OWLOntology toOntology, Collection<ImportInfo> importInfo) {
        this.editorKit = editorKit;
        this.toOntology = toOntology;
        this.importInfo = new ArrayList<ImportInfo>(importInfo);
    }

    public void addImports() {
        this.addImportsInOtherThread();
    }

    private void addImportsInOtherThread() {
        this.service.submit(() -> {
            try {
                List<OWLOntologyChange> result = this.loadImportsInternal();
                SwingUtilities.invokeLater(() -> {
                    this.logger.info("Adding imports statements");
                    this.editorKit.getModelManager().applyChanges(result);
                    this.logger.info("Finished adding imports");
                });
                List<OWLOntologyChange> list = result;
                return list;
            }
            finally {
                this.dlg.setVisible(false);
            }
        });
        this.dlg.setVisible(true);
    }

    private List<OWLOntologyChange> loadImportsInternal() {
        ArrayList<OWLOntologyChange> changes = new ArrayList<OWLOntologyChange>();
        for (ImportInfo importParameters : this.importInfo) {
            this.logger.info(LogBanner.start((String)"Importing ontology and imports closure"));
            this.logger.info("Processing {}", (Object)importParameters.getImportsDeclarationIRI());
            this.dlg.setMessage("Importing " + importParameters.getImportsDeclarationIRI());
            IRI importedOntologyDocumentIRI = importParameters.getImportsDeclarationIRI();
            URI physicalLocation = importParameters.getPhysicalLocation();
            OntologyCatalogManager catalogManager = this.editorKit.getOWLModelManager().getOntologyCatalogManager();
            if (AddImportsStrategy.willRedirectTotheWrongPlace(catalogManager, importedOntologyDocumentIRI, physicalLocation)) {
                OWLOntology activeOntology = this.editorKit.getModelManager().getActiveOntology();
                this.addImportMapping(activeOntology, importedOntologyDocumentIRI, IRI.create((URI)physicalLocation));
            }
            OWLOntologyManager man = this.editorKit.getOWLModelManager().getOWLOntologyManager();
            OWLImportsDeclaration decl = man.getOWLDataFactory().getOWLImportsDeclaration(importedOntologyDocumentIRI);
            if (!man.contains(importParameters.getOntologyID())) {
                try {
                    OWLOntology importedOnt;
                    OWLOntologyManager loadingManager = OntologyManagerFactory.createManager();
                    loadingManager.getIRIMappers().add((Iterable)man.getIRIMappers());
                    ProgressDialogOntologyLoaderListener listener = new ProgressDialogOntologyLoaderListener(this.dlg, this.logger);
                    loadingManager.addOntologyLoaderListener((OWLOntologyLoaderListener)listener);
                    loadingManager.loadOntologyFromOntologyDocument((OWLOntologyDocumentSource)new IRIDocumentSource(IRI.create((URI)physicalLocation)), new OWLOntologyLoaderConfiguration().setMissingImportHandlingStrategy(MissingImportHandlingStrategy.SILENT));
                    loadingManager.removeOntologyLoaderListener((OWLOntologyLoaderListener)listener);
                    for (OWLOntology importedOntology : loadingManager.getOntologies()) {
                        IRI ontologyDocumentIRI = loadingManager.getOntologyDocumentIRI(importedOntology);
                        if (!man.contains(importedOntology.getOntologyID())) {
                            this.logger.info("Copying imported ontology: {}", (Object)ontologyDocumentIRI);
                            man.copyOntology(importedOntology, OntologyCopy.MOVE);
                            continue;
                        }
                        this.logger.info("Not copying ontology {} as it is already loaded", (Object)ontologyDocumentIRI);
                    }
                    if (importParameters.getOntologyID() != null && !importParameters.getOntologyID().isAnonymous() && (importedOnt = man.getOntology(importParameters.getOntologyID())) == null) {
                        this.logger.warn("Imported ontology has unexpected id. During imports processing we anticipated " + importParameters.getOntologyID());
                        continue;
                    }
                }
                catch (OWLOntologyCreationException e) {
                    this.logger.error("There was a problem loading the ontology from {}.  Error: {}", new Object[]{importedOntologyDocumentIRI, e.getMessage(), e});
                    JOptionPane.showMessageDialog((Component)((Object)this.editorKit.getOWLWorkspace()), "An error occurred whilst the ontology at " + importedOntologyDocumentIRI + " was being loaded.", "Error loading ontology", 0);
                }
            }
            changes.add((OWLOntologyChange)new AddImport(this.toOntology, decl));
            this.logger.info(LogBanner.end());
        }
        return changes;
    }

    private static boolean willRedirectTotheWrongPlace(OntologyCatalogManager catalogManager, IRI importLocation, URI physicalLocation) {
        if (catalogManager.getRedirect(importLocation.toURI()) == null) {
            return !importLocation.equals((Object)IRI.create((URI)physicalLocation));
        }
        return !physicalLocation.equals(catalogManager.getRedirect(importLocation.toURI()));
    }

    private void addImportMapping(OWLOntology ontology, IRI importLocation, IRI physicalLocation) {
        OWLOntologyManager manager = ontology.getOWLOntologyManager();
        manager.getIRIMappers().add((Serializable)new SimpleIRIMapper(importLocation, physicalLocation));
        IRI importersDocumentLocation = manager.getOntologyDocumentIRI(ontology);
        if (UIUtil.isLocalFile((URI)importersDocumentLocation.toURI())) {
            File f = new File(importersDocumentLocation.toURI());
            XMLCatalog catalog = this.editorKit.getModelManager().addRootFolder(f.getParentFile());
            URI physicalUri = CatalogUtilities.relativize(physicalLocation.toURI(), catalog);
            catalog.addEntry(0, new UriEntry("Imports Wizard Entry", catalog, importLocation.toURI().toString(), physicalUri, null));
            try {
                CatalogUtilities.save(catalog, OntologyCatalogManager.getCatalogFile(f.getParentFile()));
            }
            catch (IOException e) {
                this.logger.warn("An error occurred whilst saving the catalog file: {}", (Throwable)e);
            }
        }
    }
}

