/*
 * Decompiled with CFR 0.152.
 */
package org.protege.editor.owl.ui.renderer.layout;

import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import org.protege.editor.owl.ui.renderer.OWLRendererPreferences;
import org.protege.editor.owl.ui.renderer.layout.Page;
import org.protege.editor.owl.ui.renderer.layout.PageCacheKey;

public class PageCache {
    public static final int DEFAULT_CACHE_SIZE = 200;
    private int lastFontSize = OWLRendererPreferences.getInstance().getFontSize();
    private int cacheSize = 200;
    private Map<PageCacheKey, Page> map = new LinkedHashMap<PageCacheKey, Page>();

    public int getCacheSize() {
        return this.cacheSize;
    }

    public void setCacheSize(int cacheSize) {
        this.cacheSize = cacheSize;
    }

    public Page getPage(PageCacheKey key) {
        if (this.hasFontSizeChanged()) {
            this.map.clear();
        }
        return this.map.get(key);
    }

    public void put(PageCacheKey key, Page page) {
        if (this.map.size() == this.cacheSize) {
            Iterator<PageCacheKey> iterator = this.map.keySet().iterator();
            iterator.next();
            iterator.remove();
        }
        this.map.put(key, page);
    }

    private boolean hasFontSizeChanged() {
        int currentSize = OWLRendererPreferences.getInstance().getFontSize();
        if (currentSize != this.lastFontSize) {
            this.lastFontSize = currentSize;
            return true;
        }
        return false;
    }

    public void invalidate() {
        this.map.clear();
    }
}

