# This file has been autogenerated by the pywayland scanner

# Copyright © 2020 Aleix Pol Gonzalez <aleixpol@kde.org>
# Copyright © 2020 Carlos Garnacho <carlosg@gnome.org>
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from pywayland.protocol_core import Argument, ArgumentType, Global, Interface, Proxy, Resource
from ..wayland import WlSurface
from .xdg_activation_token_v1 import XdgActivationTokenV1


class XdgActivationV1(Interface):
    """Interface for activating surfaces

    A global interface used for informing the compositor about applications
    being activated or started, or for applications to request to be activated.
    """

    name = "xdg_activation_v1"
    version = 1


class XdgActivationV1Proxy(Proxy):
    interface = XdgActivationV1

    @XdgActivationV1.request()
    def destroy(self):
        """Destroy the xdg_activation object

        Notify the compositor that the xdg_activation object will no longer be
        used.

        The child objects created via this interface are unaffected and should
        be destroyed separately.
        """
        self._marshal(0)
        self._destroy()

    @XdgActivationV1.request(
        Argument(ArgumentType.NewId, interface=XdgActivationTokenV1),
    )
    def get_activation_token(self):
        """Requests a token

        Creates an
        :class:`~pywayland.protocol.xdg_activation_v1.XdgActivationTokenV1`
        object that will provide the initiating client with a unique token for
        this activation. This token should be offered to the clients to be
        activated.

        :returns:
            :class:`~pywayland.protocol.xdg_activation_v1.XdgActivationTokenV1`
        """
        id = self._marshal_constructor(1, XdgActivationTokenV1)
        return id

    @XdgActivationV1.request(
        Argument(ArgumentType.String),
        Argument(ArgumentType.Object, interface=WlSurface),
    )
    def activate(self, token, surface):
        """Notify new interaction being available

        Requests surface activation. It's up to the compositor to display this
        information as desired, for example by placing the surface above the
        rest.

        The compositor may know who requested this by checking the activation
        token and might decide not to follow through with the activation if
        it's considered unwanted.

        Compositors can ignore unknown activation tokens when an invalid token
        is passed.

        :param token:
            the activation token of the initiating client
        :type token:
            `ArgumentType.String`
        :param surface:
            the :class:`~pywayland.protocol.wayland.WlSurface` to activate
        :type surface:
            :class:`~pywayland.protocol.wayland.WlSurface`
        """
        self._marshal(2, token, surface)


class XdgActivationV1Resource(Resource):
    interface = XdgActivationV1


class XdgActivationV1Global(Global):
    interface = XdgActivationV1


XdgActivationV1._gen_c()
XdgActivationV1.proxy_class = XdgActivationV1Proxy
XdgActivationV1.resource_class = XdgActivationV1Resource
XdgActivationV1.global_class = XdgActivationV1Global
