/**
 * 
 * Rhonabwy JSON Web Key (JWK) library
 * 
 * rhonabwy-cfg.h: configuration file
 * 
 * Copyright 2020-2021 Nicolas Mora <mail@babelouest.org>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public License
 * as published by the Free Software Foundation;
 * version 2.1 of the License.
 *
 * This library is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU GENERAL PUBLIC LICENSE for more details.
 *
 * You should have received a copy of the GNU General Public
 * License along with this library.  If not, see <http://www.gnu.org/licenses/>.
 * 
 */

#ifndef _RHONABWY_CFG_H_
#define _RHONABWY_CFG_H_

#define RHONABWY_VERSION 1.1.1
#define RHONABWY_VERSION_STR "1.1.1"

#define RHONABWY_VERSION_MAJOR 1
#define RHONABWY_VERSION_MINOR 1
#define RHONABWY_VERSION_PATCH 1

#define RHONABWY_VERSION_NUMBER ((RHONABWY_VERSION_MAJOR << 16) | (RHONABWY_VERSION_MINOR << 8) | (RHONABWY_VERSION_PATCH << 0))

#define RHONABWY_CHECK_VERSION(major,minor,patch)                        \
  (RHONABWY_VERSION_MAJOR > (major) ||                                    \
   (RHONABWY_VERSION_MAJOR == (major) && RHONABWY_VERSION_MINOR > (minor)) || \
   (RHONABWY_VERSION_MAJOR == (major) && RHONABWY_VERSION_MINOR == (minor) && \
    RHONABWY_VERSION_PATCH >= (patch)))

#define NETTLE_VERSION_NUMBER ((NETTLE_VERSION_MAJOR << 16) | (NETTLE_VERSION_MINOR << 8))

#define R_WITH_CURL

#endif /* _RHONABWY_CFG_H_ */
