/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.j3d;

import com.eteks.sweethome3d.j3d.ModelManager;
import com.eteks.sweethome3d.j3d.Object3DBranch;
import com.eteks.sweethome3d.j3d.TextureManager;
import com.eteks.sweethome3d.model.Baseboard;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeDoorOrWindow;
import com.eteks.sweethome3d.model.HomeEnvironment;
import com.eteks.sweethome3d.model.HomeFurnitureGroup;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.HomeTexture;
import com.eteks.sweethome3d.model.Level;
import com.eteks.sweethome3d.model.Wall;
import com.sun.j3d.utils.geometry.GeometryInfo;
import com.sun.j3d.utils.geometry.NormalGenerator;
import java.awt.EventQueue;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.Area;
import java.awt.geom.GeneralPath;
import java.awt.geom.Line2D;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;
import javax.media.j3d.Appearance;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Geometry;
import javax.media.j3d.Group;
import javax.media.j3d.Node;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.media.j3d.TransparencyAttributes;
import javax.vecmath.Point3f;
import javax.vecmath.TexCoord2f;
import javax.vecmath.Vector3f;

public class Wall3D
extends Object3DBranch {
    private static final float LEVEL_ELEVATION_SHIFT = 0.1f;
    private static final Area FULL_FACE_CUT_OUT_AREA = new Area(new Rectangle2D.Float(-0.5f, 0.5f, 1.0f, 1.0f));
    private static final int WALL_LEFT_SIDE = 0;
    private static final int WALL_RIGHT_SIDE = 1;
    private static Map<HomePieceOfFurniture, ModelRotationTuple> doorOrWindowRotatedModels = new WeakHashMap<HomePieceOfFurniture, ModelRotationTuple>();
    private static Map<ModelRotationTuple, Area> rotatedModelsFrontAreas = new WeakHashMap<ModelRotationTuple, Area>();
    private final Home home;

    public Wall3D(Wall wall, Home home) {
        this(wall, home, false, false);
    }

    public Wall3D(Wall wall, Home home, boolean bl, boolean bl2) {
        this.setUserData(wall);
        this.home = home;
        this.setCapability(17);
        this.setCapability(12);
        this.setCapability(6);
        for (int i = 0; i < 8; ++i) {
            Group group = new Group();
            group.setCapability(12);
            group.addChild(this.createWallPartShape(false));
            if (!bl) {
                group.addChild(this.createWallPartShape(true));
            }
            this.addChild((Node)group);
        }
        this.updateWallGeometry(bl2);
        this.updateWallAppearance(bl2);
    }

    private Node createWallPartShape(boolean bl) {
        Shape3D shape3D = new Shape3D();
        shape3D.setCapability(13);
        shape3D.setCapability(12);
        shape3D.setCapability(14);
        Appearance appearance = new Appearance();
        shape3D.setAppearance(appearance);
        appearance.setCapability(10);
        TransparencyAttributes transparencyAttributes = new TransparencyAttributes();
        transparencyAttributes.setCapability(3);
        transparencyAttributes.setCapability(1);
        appearance.setTransparencyAttributes(transparencyAttributes);
        appearance.setCapability(12);
        RenderingAttributes renderingAttributes = new RenderingAttributes();
        renderingAttributes.setCapability(6);
        appearance.setRenderingAttributes(renderingAttributes);
        if (bl) {
            appearance.setColoringAttributes(Object3DBranch.OUTLINE_COLORING_ATTRIBUTES);
            appearance.setPolygonAttributes(Object3DBranch.OUTLINE_POLYGON_ATTRIBUTES);
            appearance.setLineAttributes(Object3DBranch.OUTLINE_LINE_ATTRIBUTES);
        } else {
            appearance.setCapability(1);
            appearance.setMaterial(DEFAULT_MATERIAL);
            appearance.setCapability(3);
            appearance.setCapability(2);
            appearance.setCapability(7);
        }
        return shape3D;
    }

    @Override
    public void update() {
        this.updateWallGeometry(false);
        this.updateWallAppearance(false);
    }

    private void updateWallGeometry(boolean bl) {
        this.updateWallSideGeometry(0, bl);
        this.updateWallSideGeometry(1, bl);
        this.setPickable(this.home.getEnvironment().getWallsAlpha() == 0.0f);
    }

    private void updateWallSideGeometry(int n, boolean bl) {
        int n2;
        int n3;
        Baseboard baseboard;
        HomeTexture homeTexture;
        Wall wall = (Wall)this.getUserData();
        if (n == 0) {
            homeTexture = wall.getLeftSideTexture();
            baseboard = wall.getLeftSideBaseboard();
        } else {
            homeTexture = wall.getRightSideTexture();
            baseboard = wall.getRightSideBaseboard();
        }
        Group[] groupArray = new Group[]{(Group)this.getChild(n), (Group)this.getChild(n + 2), (Group)this.getChild(n + 4), (Group)this.getChild(n + 6)};
        Shape3D[] shape3DArray = new Shape3D[groupArray.length];
        Shape3D[] shape3DArray2 = new Shape3D[groupArray.length];
        int[] nArray = new int[groupArray.length];
        for (n3 = 0; n3 < groupArray.length; ++n3) {
            shape3DArray[n3] = (Shape3D)groupArray[n3].getChild(0);
            shape3DArray2[n3] = groupArray[n3].numChildren() > 1 ? (Shape3D)groupArray[n3].getChild(1) : null;
            nArray[n3] = shape3DArray[n3].numGeometries();
        }
        if (wall.getLevel() == null || wall.getLevel().isViewableAndVisible()) {
            List[] listArray = new List[]{new ArrayList(), new ArrayList(), new ArrayList(), new ArrayList()};
            this.createWallGeometries(listArray[0], listArray[2], listArray[3], n, null, homeTexture, bl);
            if (baseboard != null) {
                HomeTexture homeTexture2 = baseboard.getTexture();
                if (homeTexture2 == null && baseboard.getColor() == null) {
                    homeTexture2 = homeTexture;
                }
                this.createWallGeometries(listArray[1], listArray[1], listArray[1], n, baseboard, homeTexture2, bl);
            }
            for (n2 = 0; n2 < groupArray.length; ++n2) {
                for (Geometry geometry : listArray[n2]) {
                    if (geometry == null) continue;
                    shape3DArray[n2].addGeometry(geometry);
                    if (shape3DArray2[n2] == null) continue;
                    shape3DArray2[n2].addGeometry(geometry);
                }
            }
        }
        for (n3 = 0; n3 < groupArray.length; ++n3) {
            for (n2 = nArray[n3] - 1; n2 >= 0; --n2) {
                shape3DArray[n3].removeGeometry(n2);
                if (shape3DArray2[n3] == null) continue;
                shape3DArray2[n3].removeGeometry(n2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    private void createWallGeometries(List<Geometry> list, List<Geometry> list2, List<Geometry> list3, int n, Baseboard baseboard, HomeTexture homeTexture, boolean bl) {
        Object object;
        Object object22;
        double d;
        double d2;
        boolean bl2;
        float f;
        float f2;
        Wall wall = (Wall)this.getUserData();
        Shape shape = this.getShape(wall.getPoints());
        float[][] fArray = this.getWallSidePoints(n);
        Shape shape2 = this.getShape(fArray);
        float[][] fArray2 = baseboard == null ? fArray : this.getWallBaseboardPoints(n);
        Shape shape3 = this.getShape(fArray2);
        Area area = new Area(shape3);
        float[] fArray3 = n == 0 ? (float[])fArray2[0].clone() : (float[])fArray2[fArray2.length - 1].clone();
        float f3 = this.getWallElevation(baseboard != null);
        if (baseboard == null) {
            f2 = this.getWallTopElevationAtStart();
            f = this.getWallTopElevationAtEnd();
        } else {
            f2 = f = this.getBaseboardTopElevation(baseboard);
        }
        float f4 = Math.max(f2, f);
        double d3 = Math.atan2(wall.getYEnd() - wall.getYStart(), wall.getXEnd() - wall.getXStart());
        double d4 = Math.cos(d3);
        double d5 = Math.sin(d3);
        double d6 = d4 * (double)wall.getXStart() + d5 * (double)wall.getYStart();
        double d7 = d4 * (double)wall.getXEnd() + d5 * (double)wall.getYEnd();
        Float f5 = wall.getArcExtent();
        boolean bl3 = bl2 = f5 != null && f5.floatValue() != 0.0f;
        if (f2 == f) {
            d2 = 0.0;
            d = f2;
        } else {
            d2 = (double)(f - f2) / (d7 - d6);
            d = (double)f2 - d2 * d6;
        }
        ArrayList<DoorOrWindowArea> arrayList = new ArrayList<DoorOrWindowArea>();
        ArrayList<HomePieceOfFurniture> arrayList2 = new ArrayList<HomePieceOfFurniture>();
        for (HomePieceOfFurniture object52 : this.getVisibleDoorsAndWindows(this.home.getFurniture())) {
            void var42_56;
            void var43_65;
            float f6 = object52.getGroundElevation();
            if (!(f6 + object52.getHeight() > f3) || !(f6 < f4)) continue;
            Area area2 = new Area(this.getShape(object52.getPoints()));
            Area area3 = new Area(shape);
            area3.intersect(area2);
            if (area3.isEmpty()) continue;
            Object var43_66 = null;
            if (object52.isParallelToWall(wall)) {
                if (baseboard != null) {
                    HomePieceOfFurniture homePieceOfFurniture = object52.clone();
                    homePieceOfFurniture.setDepthInPlan(homePieceOfFurniture.getDepth() + 2.0f * baseboard.getThickness());
                }
                if (object52 instanceof HomeDoorOrWindow && ((HomeDoorOrWindow)(object22 = (HomeDoorOrWindow)object52)).isWallCutOutOnBothSides()) {
                    void var43_68;
                    if (var43_68 == null) {
                        HomePieceOfFurniture homePieceOfFurniture = object52.clone();
                    }
                    var43_65.setDepthInPlan(var43_65.getDepth() + 4.0f * wall.getThickness());
                }
            }
            if (var43_65 != null) {
                area2 = new Area(this.getShape(var43_65.getPoints()));
                Area area4 = new Area(shape3);
                area4.intersect(area2);
            } else {
                Area area5 = new Area(shape2);
                area5.intersect(area2);
            }
            if (var42_56.isEmpty() || wall.isTrapezoidal() && !(f6 < this.getMaxElevationAtWallIntersection((Area)var42_56, d4, d5, d2, d))) continue;
            arrayList.add(new DoorOrWindowArea((Area)var42_56, Arrays.asList(object52)));
            arrayList2.add(object52);
            area.subtract(area2);
        }
        if (arrayList.size() > 1) {
            for (int i = 0; i < arrayList.size(); ++i) {
                DoorOrWindowArea doorOrWindowArea = (DoorOrWindowArea)arrayList.get(i);
                ArrayList<DoorOrWindowArea> arrayList3 = new ArrayList<DoorOrWindowArea>();
                int n2 = 0;
                for (DoorOrWindowArea doorOrWindowArea2 : arrayList) {
                    if (doorOrWindowArea.getArea().isEmpty()) break;
                    if (n2 > i) {
                        object22 = new Area(doorOrWindowArea2.getArea());
                        ((Area)object22).intersect(doorOrWindowArea.getArea());
                        if (!((Area)object22).isEmpty()) {
                            doorOrWindowArea2.getArea().subtract((Area)object22);
                            doorOrWindowArea.getArea().subtract((Area)object22);
                            object = new ArrayList<HomePieceOfFurniture>(doorOrWindowArea.getDoorsOrWindows());
                            object.addAll(doorOrWindowArea2.getDoorsOrWindows());
                            arrayList3.add(new DoorOrWindowArea((Area)object22, (List<HomePieceOfFurniture>)object));
                        }
                    }
                    ++n2;
                }
                arrayList.addAll(arrayList3);
            }
        }
        ArrayList arrayList4 = new ArrayList(4);
        Object var39_36 = null;
        Object object3 = area.getPathIterator(null);
        while (!object3.isDone()) {
            void var39_37;
            float[] fArray4 = new float[2];
            if (object3.currentSegment(fArray4) == 4) {
                if (arrayList4.size() > 2) {
                    if (Arrays.equals((float[])arrayList4.get(0), (float[])arrayList4.get(arrayList4.size() - 1))) {
                        arrayList4.remove(arrayList4.size() - 1);
                    }
                    if (arrayList4.size() > 2) {
                        float[][] fArray5 = (float[][])arrayList4.toArray((T[])new float[arrayList4.size()][]);
                        list2.add(this.createVerticalPartGeometry(wall, fArray5, f3, d4, d5, d2, d, baseboard, homeTexture, fArray3, n));
                        list.add(this.createHorizontalPartGeometry(fArray5, f3, true, bl2));
                        list3.add(this.createTopPartGeometry(fArray5, d4, d5, d2, d, bl2));
                    }
                }
                arrayList4.clear();
                Object var39_38 = null;
            } else if (var39_37 == null || !Arrays.equals(fArray4, (float[])var39_37)) {
                arrayList4.add(fArray4);
                float[] fArray6 = fArray4;
            }
            object3.next();
        }
        object3 = wall.getLevel();
        Object var39_40 = null;
        for (DoorOrWindowArea doorOrWindowArea : arrayList) {
            if (doorOrWindowArea.getArea().isEmpty()) continue;
            PathIterator pathIterator = doorOrWindowArea.getArea().getPathIterator(null);
            while (!pathIterator.isDone()) {
                void var39_41;
                object22 = new float[2];
                if (pathIterator.currentSegment((float[])object22) == 4) {
                    if (Arrays.equals((float[])arrayList4.get(0), (float[])arrayList4.get(arrayList4.size() - 1))) {
                        arrayList4.remove(arrayList4.size() - 1);
                    }
                    if (arrayList4.size() > 2) {
                        HomePieceOfFurniture homePieceOfFurniture;
                        float f7;
                        HomePieceOfFurniture homePieceOfFurniture2;
                        float f8;
                        object = (float[][])arrayList4.toArray((T[])new float[arrayList4.size()][]);
                        List<HomePieceOfFurniture> list4 = doorOrWindowArea.getDoorsOrWindows();
                        if (list4.size() > 1) {
                            Collections.sort(list4, new Comparator<HomePieceOfFurniture>(){

                                @Override
                                public int compare(HomePieceOfFurniture homePieceOfFurniture, HomePieceOfFurniture homePieceOfFurniture2) {
                                    float f;
                                    float f2 = homePieceOfFurniture.getGroundElevation();
                                    if (f2 < (f = homePieceOfFurniture2.getGroundElevation())) {
                                        return -1;
                                    }
                                    if (f2 > f) {
                                        return 1;
                                    }
                                    return 0;
                                }
                            });
                        }
                        if ((f8 = (homePieceOfFurniture2 = list4.get(0)).getGroundElevation()) > f3) {
                            if (object3 != null && ((Level)object3).getElevation() != f3 && homePieceOfFurniture2.getElevation() < 0.1f) {
                                f8 -= 0.1f;
                            }
                            list2.add(this.createVerticalPartGeometry(wall, (float[][])object, f3, d4, d5, 0.0, f8, baseboard, homeTexture, fArray3, n));
                            list.add(this.createHorizontalPartGeometry((float[][])object, f3, true, bl2));
                            list2.add(this.createHorizontalPartGeometry((float[][])object, f8, false, bl2));
                        }
                        int n3 = 0;
                        while (n3 < list4.size() - 1) {
                            HomePieceOfFurniture homePieceOfFurniture3 = list4.get(n3);
                            f7 = homePieceOfFurniture3.getGroundElevation();
                            homePieceOfFurniture = list4.get(++n3);
                            float f9 = homePieceOfFurniture.getGroundElevation();
                            while (f7 + homePieceOfFurniture3.getHeight() >= f9 + homePieceOfFurniture.getHeight() && ++n3 < list4.size()) {
                                homePieceOfFurniture = list4.get(n3);
                            }
                            if (n3 >= list4.size() || !(f7 + homePieceOfFurniture3.getHeight() < f9)) continue;
                            list2.add(this.createVerticalPartGeometry(wall, (float[][])object, f7 + homePieceOfFurniture3.getHeight(), d4, d5, 0.0, f9, baseboard, homeTexture, fArray3, n));
                            list2.add(this.createHorizontalPartGeometry((float[][])object, f7 + homePieceOfFurniture3.getHeight(), true, bl2));
                            list2.add(this.createHorizontalPartGeometry((float[][])object, f9, false, bl2));
                        }
                        HomePieceOfFurniture homePieceOfFurniture4 = list4.get(list4.size() - 1);
                        float f10 = homePieceOfFurniture4.getGroundElevation();
                        for (int i = list4.size() - 2; i >= 0; --i) {
                            homePieceOfFurniture = list4.get(i);
                            if (!(homePieceOfFurniture.getGroundElevation() + homePieceOfFurniture.getHeight() > f10 + homePieceOfFurniture4.getHeight())) continue;
                            homePieceOfFurniture4 = homePieceOfFurniture;
                        }
                        f7 = f10 + homePieceOfFurniture4.getHeight();
                        boolean bl4 = true;
                        for (int i = 0; i < ((Object)object).length; ++i) {
                            double d8 = d4 * (double)object[i][0] + d5 * (double)object[i][1];
                            double d9 = d2 * d8 + d;
                            if (!((double)f7 > d9)) continue;
                            if (d2 == 0.0 || bl2) {
                                bl4 = false;
                                break;
                            }
                            double d10 = ((double)f7 - d9) / d2;
                            Object object4 = object[i];
                            object4[0] = object4[0] + (float)(d10 * d4);
                            Object object5 = object[i];
                            object5[1] = object5[1] + (float)(d10 * d5);
                        }
                        if (bl4) {
                            list2.add(this.createVerticalPartGeometry(wall, (float[][])object, f7, d4, d5, d2, d, baseboard, homeTexture, fArray3, n));
                            list2.add(this.createHorizontalPartGeometry((float[][])object, f7, true, bl2));
                            list3.add(this.createTopPartGeometry((float[][])object, d4, d5, d2, d, bl2));
                        }
                    }
                    arrayList4.clear();
                    Object var39_42 = null;
                } else if (var39_41 == null || !Arrays.equals((float[])object22, (float[])var39_41)) {
                    arrayList4.add(object22);
                    Object object6 = object22;
                }
                pathIterator.next();
            }
        }
        if (!bl2 && arrayList2.size() > 0) {
            ArrayList arrayList5 = new ArrayList(arrayList2.size());
            for (HomePieceOfFurniture homePieceOfFurniture : arrayList2) {
                double d11;
                if (!(homePieceOfFurniture instanceof HomeDoorOrWindow) || "M0,0 v1 h1 v-1 z".equals(((HomeDoorOrWindow)(object22 = (HomeDoorOrWindow)homePieceOfFurniture)).getCutOutShape()) && ((HomeDoorOrWindow)object22).getWallWidth() == 1.0f && ((HomeDoorOrWindow)object22).getWallLeft() == 0.0f && ((HomeDoorOrWindow)object22).getWallHeight() == 1.0f && ((HomeDoorOrWindow)object22).getWallTop() == 0.0f || !((d11 = Math.abs(d3 - (double)((HomePieceOfFurniture)object22).getAngle()) % (Math.PI * 2)) < 0.004363323129985824) && !(d11 > 6.278821984049601) && !(Math.abs(d11 - Math.PI) < 0.004363323129985824)) continue;
                int n4 = Math.abs(d11 - Math.PI) < 0.004363323129985824 ? 1 : -1;
                ModelRotationTuple modelRotationTuple = doorOrWindowRotatedModels.get(object22);
                if (modelRotationTuple != null && modelRotationTuple.equals(((HomePieceOfFurniture)object22).getModel(), ((HomePieceOfFurniture)object22).getModelRotation(), ((HomeDoorOrWindow)object22).getCutOutShape()) && (arrayList5.size() == 0 || !bl)) {
                    this.createGeometriesSurroundingDoorOrWindow((HomeDoorOrWindow)object22, rotatedModelsFrontAreas.get(modelRotationTuple), n4, wall, list2, list3, fArray2, f3, d4, d5, d2, d, homeTexture, fArray3, n);
                    continue;
                }
                arrayList5.add(object22);
            }
            if (arrayList5.size() > 0) {
                ModelManager modelManager = ModelManager.getInstance();
                for (Object object22 : (List)arrayList5.clone()) {
                    double d12 = Math.abs(d3 - (double)((HomePieceOfFurniture)object22).getAngle()) % (Math.PI * 2);
                    int n5 = Math.abs(d12 - Math.PI) < 0.004363323129985824 ? 1 : -1;
                    modelManager.loadModel(((HomePieceOfFurniture)object22).getModel(), bl, new ModelManager.ModelObserver(){
                        final /* synthetic */ HomeDoorOrWindow val$doorOrWindow;
                        final /* synthetic */ ModelManager val$modelManager;
                        final /* synthetic */ boolean val$waitDoorOrWindowModelsLoadingEnd;
                        final /* synthetic */ int val$frontOrBackSide;
                        final /* synthetic */ Wall val$wall;
                        final /* synthetic */ List val$sideGeometries;
                        final /* synthetic */ List val$topGeometries;
                        final /* synthetic */ float[][] val$wallSideOrBaseboardPoints;
                        final /* synthetic */ float val$wallElevation;
                        final /* synthetic */ double val$cosWallYawAngle;
                        final /* synthetic */ double val$sinWallYawAngle;
                        final /* synthetic */ double val$topLineAlpha;
                        final /* synthetic */ double val$topLineBeta;
                        final /* synthetic */ HomeTexture val$texture;
                        final /* synthetic */ float[] val$textureReferencePoint;
                        final /* synthetic */ int val$wallSide;
                        final /* synthetic */ ArrayList val$missingModels;
                        final /* synthetic */ Baseboard val$baseboard;
                        {
                            this.val$doorOrWindow = homeDoorOrWindow;
                            this.val$modelManager = modelManager;
                            this.val$waitDoorOrWindowModelsLoadingEnd = bl;
                            this.val$frontOrBackSide = n;
                            this.val$wall = wall;
                            this.val$sideGeometries = list;
                            this.val$topGeometries = list2;
                            this.val$wallSideOrBaseboardPoints = fArray;
                            this.val$wallElevation = f;
                            this.val$cosWallYawAngle = d;
                            this.val$sinWallYawAngle = d2;
                            this.val$topLineAlpha = d3;
                            this.val$topLineBeta = d4;
                            this.val$texture = homeTexture;
                            this.val$textureReferencePoint = fArray2;
                            this.val$wallSide = n2;
                            this.val$missingModels = arrayList;
                            this.val$baseboard = baseboard;
                        }

                        @Override
                        public void modelUpdated(BranchGroup branchGroup) {
                            Area area;
                            ModelRotationTuple modelRotationTuple = (ModelRotationTuple)doorOrWindowRotatedModels.get(this.val$doorOrWindow);
                            if (modelRotationTuple == null || !modelRotationTuple.equals(this.val$doorOrWindow.getModel(), this.val$doorOrWindow.getModelRotation(), this.val$doorOrWindow.getCutOutShape())) {
                                modelRotationTuple = new ModelRotationTuple(this.val$doorOrWindow.getModel(), this.val$doorOrWindow.getModelRotation(), this.val$doorOrWindow.getCutOutShape());
                                area = (Area)rotatedModelsFrontAreas.get(modelRotationTuple);
                                if (area == null) {
                                    TransformGroup transformGroup = new TransformGroup(this.val$modelManager.getRotationTransformation(this.val$doorOrWindow.getModelRotation()));
                                    transformGroup.addChild((Node)branchGroup);
                                    area = this.val$modelManager.getFrontArea(this.val$doorOrWindow.getCutOutShape(), (Node)transformGroup);
                                    rotatedModelsFrontAreas.put(modelRotationTuple, area);
                                } else {
                                    for (ModelRotationTuple modelRotationTuple2 : rotatedModelsFrontAreas.keySet()) {
                                        if (!modelRotationTuple2.equals(modelRotationTuple)) continue;
                                        modelRotationTuple = modelRotationTuple2;
                                        break;
                                    }
                                }
                                doorOrWindowRotatedModels.put(this.val$doorOrWindow, modelRotationTuple);
                            } else {
                                area = (Area)rotatedModelsFrontAreas.get(modelRotationTuple);
                            }
                            if (this.val$waitDoorOrWindowModelsLoadingEnd) {
                                Wall3D.this.createGeometriesSurroundingDoorOrWindow(this.val$doorOrWindow, area, this.val$frontOrBackSide, this.val$wall, this.val$sideGeometries, this.val$topGeometries, this.val$wallSideOrBaseboardPoints, this.val$wallElevation, this.val$cosWallYawAngle, this.val$sinWallYawAngle, this.val$topLineAlpha, this.val$topLineBeta, this.val$texture, this.val$textureReferencePoint, this.val$wallSide);
                            } else {
                                this.val$missingModels.remove(this.val$doorOrWindow);
                                if (this.val$missingModels.size() == 0 && this.val$baseboard == null) {
                                    EventQueue.invokeLater(new Runnable(){

                                        @Override
                                        public void run() {
                                            Wall3D.this.updateWallSideGeometry(val$wallSide, val$waitDoorOrWindowModelsLoadingEnd);
                                        }
                                    });
                                }
                            }
                        }

                        @Override
                        public void modelError(Exception exception) {
                            ModelRotationTuple modelRotationTuple = new ModelRotationTuple(this.val$doorOrWindow.getModel(), this.val$doorOrWindow.getModelRotation(), this.val$doorOrWindow.getCutOutShape());
                            doorOrWindowRotatedModels.put(this.val$doorOrWindow, modelRotationTuple);
                            if (rotatedModelsFrontAreas.get(modelRotationTuple) == null) {
                                rotatedModelsFrontAreas.put(modelRotationTuple, FULL_FACE_CUT_OUT_AREA);
                            }
                            if (!this.val$waitDoorOrWindowModelsLoadingEnd) {
                                this.val$missingModels.remove(this.val$doorOrWindow);
                            }
                        }
                    });
                }
            }
        }
    }

    private List<HomePieceOfFurniture> getVisibleDoorsAndWindows(List<HomePieceOfFurniture> list) {
        ArrayList<HomePieceOfFurniture> arrayList = new ArrayList<HomePieceOfFurniture>(list.size());
        for (HomePieceOfFurniture homePieceOfFurniture : list) {
            if (!homePieceOfFurniture.isVisible() || homePieceOfFurniture.getLevel() != null && !homePieceOfFurniture.getLevel().isViewableAndVisible()) continue;
            if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
                arrayList.addAll(this.getVisibleDoorsAndWindows(((HomeFurnitureGroup)homePieceOfFurniture).getFurniture()));
                continue;
            }
            if (!homePieceOfFurniture.isDoorOrWindow()) continue;
            arrayList.add(homePieceOfFurniture);
        }
        return arrayList;
    }

    private float[][] getWallSidePoints(int n) {
        Wall wall = (Wall)this.getUserData();
        float[][] fArray = wall.getPoints();
        if (n == 0) {
            for (int i = fArray.length / 2; i < fArray.length; ++i) {
                fArray[i][0] = (fArray[i][0] + fArray[fArray.length - i - 1][0]) / 2.0f;
                fArray[i][1] = (fArray[i][1] + fArray[fArray.length - i - 1][1]) / 2.0f;
            }
        } else {
            int n2 = fArray.length / 2;
            for (int i = 0; i < n2; ++i) {
                fArray[i][0] = (fArray[i][0] + fArray[fArray.length - i - 1][0]) / 2.0f;
                fArray[i][1] = (fArray[i][1] + fArray[fArray.length - i - 1][1]) / 2.0f;
            }
        }
        return fArray;
    }

    private float[][] getWallBaseboardPoints(int n) {
        Wall wall = (Wall)this.getUserData();
        float[][] fArray = wall.getPoints(true);
        float[][] fArray2 = wall.getPoints();
        if (n == 0) {
            for (int i = fArray.length / 2; i < fArray.length; ++i) {
                fArray[i] = fArray2[fArray2.length - i - 1];
            }
        } else {
            int n2 = fArray2.length / 2;
            for (int i = 0; i < n2; ++i) {
                fArray[i] = fArray2[fArray2.length - i - 1];
            }
        }
        return fArray;
    }

    private Geometry createVerticalPartGeometry(Wall wall, float[][] fArray, float f, double d, double d2, double d3, double d4, Baseboard baseboard, HomeTexture homeTexture, float[] fArray2, int n) {
        float f2;
        float f3;
        Point3f point3f;
        int n2;
        Object object;
        float f4 = this.home.getEnvironment().getSubpartSizeUnderLight();
        Float f5 = wall.getArcExtent();
        if ((f5 == null || f5.floatValue() == 0.0f) && f4 > 0.0f) {
            object = new ArrayList(fArray.length * 2);
            object.add(fArray[0]);
            for (int i = 1; i < fArray.length; ++i) {
                double d5 = Point2D.distance(fArray[i - 1][0], fArray[i - 1][1], fArray[i][0], fArray[i][1]) - (double)(f4 / 2.0f);
                double d6 = Math.atan2(fArray[i][1] - fArray[i - 1][1], fArray[i][0] - fArray[i - 1][0]);
                double d7 = Math.cos(d6);
                double d8 = Math.sin(d6);
                for (double d9 = 0.0; d9 < d5; d9 += (double)f4) {
                    object.add(new float[]{(float)((double)fArray[i - 1][0] + d9 * d7), (float)((double)fArray[i - 1][1] + d9 * d8)});
                }
                object.add(fArray[i]);
            }
            fArray = (float[][])object.toArray((T[])new float[object.size()][]);
        }
        object = new Point3f[fArray.length];
        Point3f[] point3fArray = new Point3f[fArray.length];
        Float[] floatArray = new Float[fArray.length];
        float f6 = wall.getXStart();
        float f7 = wall.getYStart();
        float f8 = wall.getXEnd();
        float f9 = wall.getYEnd();
        float[] fArray3 = null;
        float f10 = 0.0f;
        float f11 = 0.0f;
        if (f5 != null && f5.floatValue() != 0.0f) {
            fArray3 = new float[]{wall.getXArcCircleCenter(), wall.getYArcCircleCenter()};
            f10 = (float)Point2D.distance(fArray3[0], fArray3[1], f6, f7);
            f11 = (float)Math.atan2(fArray2[1] - fArray3[1], fArray2[0] - fArray3[0]);
        }
        for (int i = 0; i < fArray.length; ++i) {
            object[i] = new Point3f(fArray[i][0], f, fArray[i][1]);
            float f12 = this.getWallPointElevation(fArray[i][0], fArray[i][1], d, d2, d3, d4);
            point3fArray[i] = new Point3f(fArray[i][0], f12, fArray[i][1]);
        }
        double[] dArray = new double[fArray.length];
        for (n2 = 0; n2 < fArray.length; ++n2) {
            if (fArray3 == null) {
                dArray[n2] = f6 != f8 || f7 != f9 ? Line2D.ptLineDistSq(f6, f7, f8, f9, ((Point3f)object[n2]).x, ((Point3f)object[n2]).z) : Point2D.distanceSq(f6, f7, ((Point3f)object[n2]).x, ((Point3f)object[n2]).z);
                continue;
            }
            dArray[n2] = (double)f10 - Point2D.distance(fArray3[0], fArray3[1], ((Point3f)object[n2]).x, ((Point3f)object[n2]).z);
            int n3 = n2;
            dArray[n3] = dArray[n3] * dArray[n2];
        }
        n2 = fArray.length;
        boolean[] blArray = new boolean[fArray.length];
        if (baseboard == null) {
            for (int i = 0; i < fArray.length - 1; ++i) {
                boolean bl = blArray[i] = dArray[i] > (double)0.001f || dArray[i + 1] > (double)0.001f;
                if (blArray[i]) continue;
                --n2;
            }
            boolean bl = blArray[blArray.length - 1] = dArray[0] > (double)0.001f || dArray[fArray.length - 1] > (double)0.001f;
            if (!blArray[blArray.length - 1]) {
                --n2;
            }
            if (n2 == 0) {
                return null;
            }
        } else {
            Arrays.fill(blArray, true);
        }
        ArrayList<Object> arrayList = new ArrayList<Object>(n2 * 4);
        for (int i = 0; i < fArray.length; ++i) {
            if (!blArray[i]) continue;
            point3f = object[i];
            int n4 = (i + 1) % fArray.length;
            Object object2 = object[n4];
            if (f4 > 0.0f) {
                f3 = Math.min(point3fArray[i].y, point3fArray[n4].y) - f4 / 2.0f;
                for (f2 = f; f2 < f3; f2 += f4) {
                    arrayList.add(point3f);
                    arrayList.add(object2);
                    point3f = new Point3f(((Point3f)object[i]).x, f2, ((Point3f)object[i]).z);
                    object2 = new Point3f(((Point3f)object[n4]).x, f2, ((Point3f)object[n4]).z);
                    arrayList.add(object2);
                    arrayList.add(point3f);
                }
            }
            arrayList.add(point3f);
            arrayList.add(object2);
            arrayList.add(point3fArray[n4]);
            arrayList.add(point3fArray[i]);
        }
        GeometryInfo geometryInfo = new GeometryInfo(2);
        geometryInfo.setCoordinates(arrayList.toArray(new Point3f[arrayList.size()]));
        if (homeTexture != null) {
            if (baseboard != null) {
                f2 = wall.getThickness() / 2.0f + baseboard.getThickness();
                f2 *= f2;
            } else {
                f2 = wall.getThickness() * wall.getThickness() / 4.0f;
            }
            point3f = new TexCoord2f[arrayList.size()];
            TexCoord2f texCoord2f = new TexCoord2f(0.0f, f);
            int n5 = 0;
            f3 = fArray3 == null ? wall.getThickness() / 10000.0f : f2 / 4.0f;
            for (int i = 0; i < fArray.length; ++i) {
                TexCoord2f texCoord2f2;
                TexCoord2f texCoord2f3;
                float f13;
                float f14;
                if (!blArray[i]) continue;
                int n6 = (i + 1) % fArray.length;
                if (Math.abs(dArray[i] - (double)f2) < (double)f3 && Math.abs(dArray[n6] - (double)f2) < (double)f3) {
                    if (fArray3 == null) {
                        f14 = (float)Point2D.distance(fArray2[0], fArray2[1], fArray[i][0], fArray[i][1]);
                        f13 = (float)Point2D.distance(fArray2[0], fArray2[1], fArray[n6][0], fArray[n6][1]);
                    } else {
                        float f15;
                        if (floatArray[i] == null) {
                            f15 = (float)Math.atan2(fArray[i][1] - fArray3[1], fArray[i][0] - fArray3[0]);
                            f15 = this.adjustAngleOnReferencePointAngle(f15, f11, f5.floatValue());
                            floatArray[i] = Float.valueOf((f15 - f11) * f10);
                        }
                        if (floatArray[n6] == null) {
                            f15 = (float)Math.atan2(fArray[n6][1] - fArray3[1], fArray[n6][0] - fArray3[0]);
                            f15 = this.adjustAngleOnReferencePointAngle(f15, f11, f5.floatValue());
                            floatArray[n6] = Float.valueOf((f15 - f11) * f10);
                        }
                        f14 = floatArray[i].floatValue();
                        f13 = floatArray[n6].floatValue();
                    }
                    if (n == 0 && homeTexture.isLeftToRightOriented()) {
                        f14 = -f14;
                        f13 = -f13;
                    }
                    texCoord2f3 = new TexCoord2f(f14, f);
                    texCoord2f2 = new TexCoord2f(f13, f);
                } else {
                    texCoord2f3 = texCoord2f;
                    f14 = (float)Point2D.distance(fArray[i][0], fArray[i][1], fArray[n6][0], fArray[n6][1]);
                    texCoord2f2 = new TexCoord2f(f14, f);
                }
                if (f4 > 0.0f) {
                    f13 = Math.min(point3fArray[i].y, point3fArray[n6].y) - f4 / 2.0f;
                    for (f14 = f; f14 < f13; f14 += f4) {
                        point3f[n5++] = texCoord2f3;
                        point3f[n5++] = texCoord2f2;
                        texCoord2f3 = new TexCoord2f(texCoord2f3.x, f14);
                        texCoord2f2 = new TexCoord2f(texCoord2f2.x, f14);
                        point3f[n5++] = texCoord2f2;
                        point3f[n5++] = texCoord2f3;
                    }
                }
                point3f[n5++] = texCoord2f3;
                point3f[n5++] = texCoord2f2;
                point3f[n5++] = new TexCoord2f(texCoord2f2.x, point3fArray[n6].y);
                point3f[n5++] = new TexCoord2f(texCoord2f3.x, point3fArray[i].y);
            }
            geometryInfo.setTextureCoordinateParams(1, 2);
            geometryInfo.setTextureCoordinates(0, (TexCoord2f[])point3f);
        }
        NormalGenerator normalGenerator = new NormalGenerator();
        if (fArray3 == null) {
            normalGenerator.setCreaseAngle(0.0);
        }
        normalGenerator.generateNormals(geometryInfo);
        return geometryInfo.getIndexedGeometryArray();
    }

    private float getMaxElevationAtWallIntersection(Area area, double d, double d2, double d3, double d4) {
        float f = Float.NEGATIVE_INFINITY;
        PathIterator pathIterator = area.getPathIterator(null);
        while (!pathIterator.isDone()) {
            float[] fArray = new float[2];
            if (pathIterator.currentSegment(fArray) != 4) {
                f = Math.max(f, this.getWallPointElevation(fArray[0], fArray[1], d, d2, d3, d4));
            }
            pathIterator.next();
        }
        return f;
    }

    private float getWallPointElevation(float f, float f2, double d, double d2, double d3, double d4) {
        double d5 = d * (double)f + d2 * (double)f2;
        return (float)(d3 * d5 + d4);
    }

    private float adjustAngleOnReferencePointAngle(float f, float f2, float f3) {
        if (f3 > 0.0f) {
            if (f2 > 0.0f && (f < 0.0f || f < f2) || f2 < 0.0f && f < f2) {
                f += (float)Math.PI * 2;
            }
        } else if (f2 < 0.0f && (f > 0.0f || f2 < f) || f2 > 0.0f && f2 < f) {
            f -= (float)Math.PI * 2;
        }
        return f;
    }

    private Geometry createHorizontalPartGeometry(float[][] fArray, float f, boolean bl, boolean bl2) {
        Point3f[] point3fArray = new Point3f[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            point3fArray[i] = new Point3f(fArray[i][0], f, fArray[i][1]);
        }
        GeometryInfo geometryInfo = new GeometryInfo(5);
        geometryInfo.setCoordinates(point3fArray);
        geometryInfo.setStripCounts(new int[]{point3fArray.length});
        if (bl) {
            geometryInfo.reverse();
        }
        NormalGenerator normalGenerator = new NormalGenerator();
        if (bl2) {
            normalGenerator.setCreaseAngle(0.0);
        }
        normalGenerator.generateNormals(geometryInfo);
        return geometryInfo.getIndexedGeometryArray();
    }

    private Geometry createTopPartGeometry(float[][] fArray, double d, double d2, double d3, double d4, boolean bl) {
        Point3f[] point3fArray = new Point3f[fArray.length];
        for (int i = 0; i < fArray.length; ++i) {
            double d5 = d * (double)fArray[i][0] + d2 * (double)fArray[i][1];
            float f = (float)(d3 * d5 + d4);
            point3fArray[i] = new Point3f(fArray[i][0], f, fArray[i][1]);
        }
        GeometryInfo geometryInfo = new GeometryInfo(5);
        geometryInfo.setCoordinates(point3fArray);
        geometryInfo.setStripCounts(new int[]{point3fArray.length});
        NormalGenerator normalGenerator = new NormalGenerator();
        if (bl) {
            normalGenerator.setCreaseAngle(0.0);
        }
        normalGenerator.generateNormals(geometryInfo);
        return geometryInfo.getIndexedGeometryArray();
    }

    private void createGeometriesSurroundingDoorOrWindow(HomeDoorOrWindow homeDoorOrWindow, Area area, float f, Wall wall, List<Geometry> list, List<Geometry> list2, float[][] fArray, float f2, double d, double d2, double d3, double d4, HomeTexture homeTexture, float[] fArray2, int n) {
        if (homeDoorOrWindow.getModelTransformations() != null) {
            area = new Area(area);
            area.transform(AffineTransform.getTranslateInstance(0.5, 0.5));
            area.transform(AffineTransform.getScaleInstance(homeDoorOrWindow.getWidth() * homeDoorOrWindow.getWallWidth(), homeDoorOrWindow.getHeight() * homeDoorOrWindow.getWallHeight()));
            area.transform(AffineTransform.getTranslateInstance(homeDoorOrWindow.getWallLeft() * homeDoorOrWindow.getWidth(), (1.0f - homeDoorOrWindow.getWallHeight() - homeDoorOrWindow.getWallTop()) * homeDoorOrWindow.getHeight()));
            area.transform(AffineTransform.getScaleInstance(1.0f / homeDoorOrWindow.getWidth(), 1.0f / homeDoorOrWindow.getHeight()));
            area.transform(AffineTransform.getTranslateInstance(-0.5, -0.5));
        }
        Area area2 = new Area(FULL_FACE_CUT_OUT_AREA);
        area2.subtract(area);
        if (!area2.isEmpty()) {
            boolean bl;
            List<float[][]> list3;
            float f3 = homeDoorOrWindow.getDepth();
            float f4 = (float)((double)homeDoorOrWindow.getX() - (double)(f * f3 / 2.0f) * Math.sin(homeDoorOrWindow.getAngle()));
            float f5 = (float)((double)homeDoorOrWindow.getY() + (double)(f * f3 / 2.0f) * Math.cos(homeDoorOrWindow.getAngle()));
            float[] fArray3 = n == 0 ? fArray[0] : fArray[fArray.length - 1];
            float[] fArray4 = n == 0 ? fArray[fArray.length / 2 - 1] : fArray[fArray.length / 2];
            float f6 = fArray3[0] != fArray4[0] || fArray3[1] != fArray4[1] ? (float)Line2D.ptLineDist(fArray3[0], fArray3[1], fArray4[0], fArray4[1], f4, f5) : (float)Point2D.distance(fArray3[0], fArray3[1], f4, f5);
            float f7 = Line2D.relativeCCW(fArray3[0], fArray3[1], fArray4[0], fArray4[1], f4, f5);
            float f8 = f * (0.5f - f7 * f6 / f3);
            Transform3D transform3D = ModelManager.getInstance().getPieceOfFurnitureNormalizedModelTransformation(homeDoorOrWindow, null);
            Transform3D transform3D2 = new Transform3D();
            transform3D2.setTranslation(new Vector3f(0.0f, 0.0f, f8));
            transform3D.mul(transform3D2);
            Transform3D transform3D3 = new Transform3D();
            transform3D3.invert(transform3D);
            GeneralPath generalPath = new GeneralPath();
            Point3f point3f = new Point3f(fArray3[0], f2, fArray3[1]);
            transform3D3.transform(point3f);
            generalPath.moveTo(point3f.x, point3f.y);
            point3f = new Point3f(fArray4[0], f2, fArray4[1]);
            transform3D3.transform(point3f);
            generalPath.lineTo(point3f.x, point3f.y);
            Point3f point3f2 = new Point3f(fArray4[0], this.getWallPointElevation(fArray4[0], fArray4[1], d, d2, d3, d4), fArray4[1]);
            transform3D3.transform(point3f2);
            generalPath.lineTo(point3f2.x, point3f2.y);
            Point3f point3f3 = new Point3f(fArray3[0], this.getWallPointElevation(fArray3[0], fArray3[1], d, d2, d3, d4), fArray3[1]);
            transform3D3.transform(point3f3);
            generalPath.lineTo(point3f3.x, point3f3.y);
            generalPath.closePath();
            GeneralPath generalPath2 = new GeneralPath();
            generalPath2.moveTo(-0.5f, -0.5f);
            generalPath2.lineTo(-0.5f, 0.5f);
            generalPath2.lineTo(0.5f, 0.5f);
            generalPath2.lineTo(0.5f, -0.5f);
            generalPath2.closePath();
            Area area3 = new Area(generalPath2);
            area3.intersect(new Area(generalPath));
            area3.subtract(area);
            float f9 = 0.5f / Math.max(homeDoorOrWindow.getWidth(), homeDoorOrWindow.getHeight());
            if (!area3.isEmpty() && !(list3 = this.getAreaPoints(area3, f9, bl = f > 0.0f ^ n == 1 ^ homeDoorOrWindow.isModelMirrored())).isEmpty()) {
                ArrayList<TexCoord2f> arrayList;
                TexCoord2f[] texCoord2fArray;
                int[] nArray = new int[list3.size()];
                int n2 = 0;
                for (int i = 0; i < list3.size(); ++i) {
                    float[][] fArray5 = list3.get(i);
                    nArray[i] = fArray5.length + 1;
                    n2 += nArray[i];
                }
                float f10 = wall.getThickness() / 2.0f;
                float f11 = (float)((double)f10 * d2);
                float f12 = -((float)((double)f10 * d));
                if (n == 0) {
                    f11 *= -1.0f;
                    f12 *= -1.0f;
                }
                Point3f[] point3fArray = new Point3f[n2];
                ArrayList<Point3f> arrayList2 = new ArrayList<Point3f>(4 * n2);
                ArrayList arrayList3 = new ArrayList();
                if (homeTexture != null) {
                    texCoord2fArray = new TexCoord2f[point3fArray.length];
                    arrayList = new ArrayList<TexCoord2f>(4 * n2);
                } else {
                    texCoord2fArray = null;
                    arrayList = null;
                }
                int n3 = 0;
                for (float[][] fArray6 : list3) {
                    Point3f point3f4 = new Point3f(fArray6[0][0], fArray6[0][1], 0.0f);
                    transform3D.transform(point3f4);
                    TexCoord2f texCoord2f = null;
                    if (homeTexture != null) {
                        float f13 = (float)Point2D.distance(fArray2[0], fArray2[1], point3f4.x, point3f4.z);
                        if (n == 0 && homeTexture.isLeftToRightOriented()) {
                            f13 = -f13;
                        }
                        texCoord2f = new TexCoord2f(f13, point3f4.y);
                    }
                    double d5 = Line2D.ptLineDistSq(point3f2.x, point3f2.y, point3f3.x, point3f3.y, fArray6[0][0], fArray6[0][1]);
                    int n4 = 0;
                    while (n4 < fArray6.length) {
                        point3fArray[n3] = point3f4;
                        if (homeTexture != null) {
                            texCoord2fArray[n3] = texCoord2f;
                        }
                        int n5 = n4 < fArray6.length - 1 ? n4 + 1 : 0;
                        double d6 = Line2D.ptLineDistSq(point3f2.x, point3f2.y, point3f3.x, point3f3.y, fArray6[n5][0], fArray6[n5][1]);
                        ArrayList<Object> arrayList4 = d5 < 1.0E-10 && d6 < 1.0E-10 ? arrayList3 : arrayList2;
                        Point3f point3f5 = new Point3f(fArray6[n5][0], fArray6[n5][1], 0.0f);
                        transform3D.transform(point3f5);
                        arrayList4.add(point3f4);
                        arrayList4.add(new Point3f(point3f4.x + f11, point3f4.y, point3f4.z + f12));
                        arrayList4.add(new Point3f(point3f5.x + f11, point3f5.y, point3f5.z + f12));
                        arrayList4.add(point3f5);
                        TexCoord2f texCoord2f2 = null;
                        if (homeTexture != null) {
                            float f14 = (float)Point2D.distance(fArray2[0], fArray2[1], point3f5.x, point3f5.z);
                            if (n == 0 && homeTexture.isLeftToRightOriented()) {
                                f14 = -f14;
                            }
                            texCoord2f2 = new TexCoord2f(f14, point3f5.y);
                            if (arrayList4 == arrayList2) {
                                arrayList.add(texCoord2f);
                                arrayList.add(texCoord2f);
                                arrayList.add(texCoord2f2);
                                arrayList.add(texCoord2f2);
                            }
                        }
                        d5 = d6;
                        point3f4 = point3f5;
                        texCoord2f = texCoord2f2;
                        ++n4;
                        ++n3;
                    }
                    point3fArray[n3] = point3f4;
                    if (homeTexture != null) {
                        texCoord2fArray[n3] = texCoord2f;
                    }
                    ++n3;
                }
                GeometryInfo geometryInfo = new GeometryInfo(5);
                geometryInfo.setStripCounts(nArray);
                geometryInfo.setCoordinates(point3fArray);
                if (homeTexture != null) {
                    geometryInfo.setTextureCoordinateParams(1, 2);
                    geometryInfo.setTextureCoordinates(0, texCoord2fArray);
                }
                new NormalGenerator().generateNormals(geometryInfo);
                list.add((Geometry)geometryInfo.getIndexedGeometryArray());
                if (arrayList2.size() > 0) {
                    geometryInfo = new GeometryInfo(2);
                    geometryInfo.setCoordinates(arrayList2.toArray(new Point3f[arrayList2.size()]));
                    if (homeTexture != null) {
                        geometryInfo.setTextureCoordinateParams(1, 2);
                        geometryInfo.setTextureCoordinates(0, arrayList.toArray(new TexCoord2f[arrayList.size()]));
                    }
                    new NormalGenerator(1.5707963267948966).generateNormals(geometryInfo);
                    list.add((Geometry)geometryInfo.getIndexedGeometryArray());
                }
                if (arrayList3.size() > 0) {
                    geometryInfo = new GeometryInfo(2);
                    geometryInfo.setCoordinates(arrayList3.toArray(new Point3f[arrayList3.size()]));
                    new NormalGenerator().generateNormals(geometryInfo);
                    list2.add((Geometry)geometryInfo.getIndexedGeometryArray());
                }
            }
        }
    }

    private float getWallElevation(boolean bl) {
        Wall wall = (Wall)this.getUserData();
        Level level = wall.getLevel();
        if (level == null) {
            return 0.0f;
        }
        if (bl) {
            return level.getElevation();
        }
        float f = this.getFloorThicknessBottomWall();
        if (f > 0.0f) {
            f -= 0.1f;
        }
        return level.getElevation() - f;
    }

    private float getFloorThicknessBottomWall() {
        Wall wall = (Wall)this.getUserData();
        Level level = wall.getLevel();
        if (level == null) {
            return 0.0f;
        }
        List<Level> list = this.home.getLevels();
        if (!list.isEmpty() && list.get(0).getElevation() == level.getElevation()) {
            return 0.0f;
        }
        return level.getFloorThickness();
    }

    private float getWallTopElevationAtStart() {
        Float f = ((Wall)this.getUserData()).getHeight();
        float f2 = f != null ? f.floatValue() + this.getWallElevation(false) + this.getFloorThicknessBottomWall() : this.home.getWallHeight() + this.getWallElevation(false) + this.getFloorThicknessBottomWall();
        return f2 + this.getTopElevationShift();
    }

    private float getTopElevationShift() {
        List<Level> list;
        Level level = ((Wall)this.getUserData()).getLevel();
        if (level != null && (list = this.home.getLevels()).get(list.size() - 1) != level) {
            return 0.1f;
        }
        return 0.0f;
    }

    private float getWallTopElevationAtEnd() {
        Wall wall = (Wall)this.getUserData();
        if (wall.isTrapezoidal()) {
            return wall.getHeightAtEnd().floatValue() + this.getWallElevation(false) + this.getFloorThicknessBottomWall() + this.getTopElevationShift();
        }
        return this.getWallTopElevationAtStart();
    }

    private float getBaseboardTopElevation(Baseboard baseboard) {
        return baseboard.getHeight() + this.getWallElevation(true);
    }

    private void updateWallAppearance(boolean bl) {
        Wall wall = (Wall)this.getUserData();
        Integer n = wall.getTopColor();
        Group[] groupArray = new Group[]{(Group)this.getChild(0), (Group)this.getChild(2), (Group)this.getChild(4), (Group)this.getChild(6)};
        Group[] groupArray2 = new Group[]{(Group)this.getChild(1), (Group)this.getChild(3), (Group)this.getChild(5), (Group)this.getChild(7)};
        for (int i = 0; i < groupArray.length; ++i) {
            boolean bl2;
            boolean bl3 = bl2 = groupArray[i].numChildren() == 1;
            if (i == 1) {
                Serializable serializable;
                Serializable serializable2;
                Baseboard baseboard = wall.getLeftSideBaseboard();
                if (baseboard != null) {
                    serializable2 = baseboard.getTexture();
                    serializable = baseboard.getColor();
                    if (serializable == null && serializable2 == null) {
                        serializable2 = wall.getLeftSideTexture();
                        serializable = wall.getLeftSideColor();
                    }
                    this.updateFilledWallSideAppearance(((Shape3D)groupArray[i].getChild(0)).getAppearance(), (HomeTexture)serializable2, bl, (Integer)serializable, wall.getLeftSideShininess(), bl2);
                }
                if ((serializable2 = wall.getRightSideBaseboard()) != null) {
                    serializable = ((Baseboard)serializable2).getTexture();
                    Integer n2 = ((Baseboard)serializable2).getColor();
                    if (n2 == null && serializable == null) {
                        serializable = wall.getRightSideTexture();
                        n2 = wall.getRightSideColor();
                    }
                    this.updateFilledWallSideAppearance(((Shape3D)groupArray2[i].getChild(0)).getAppearance(), (HomeTexture)serializable, bl, n2, wall.getRightSideShininess(), bl2);
                }
            } else if (i != 3 || n == null) {
                this.updateFilledWallSideAppearance(((Shape3D)groupArray[i].getChild(0)).getAppearance(), wall.getLeftSideTexture(), bl, wall.getLeftSideColor(), wall.getLeftSideShininess(), bl2);
                this.updateFilledWallSideAppearance(((Shape3D)groupArray2[i].getChild(0)).getAppearance(), wall.getRightSideTexture(), bl, wall.getRightSideColor(), wall.getRightSideShininess(), bl2);
            } else {
                this.updateFilledWallSideAppearance(((Shape3D)groupArray[i].getChild(0)).getAppearance(), null, bl, n, 0.0f, bl2);
                this.updateFilledWallSideAppearance(((Shape3D)groupArray2[i].getChild(0)).getAppearance(), null, bl, n, 0.0f, bl2);
            }
            if (groupArray[i].numChildren() <= 1) continue;
            this.updateOutlineWallSideAppearance(((Shape3D)groupArray[i].getChild(1)).getAppearance());
            this.updateOutlineWallSideAppearance(((Shape3D)groupArray2[i].getChild(1)).getAppearance());
        }
    }

    private void updateFilledWallSideAppearance(final Appearance appearance, HomeTexture homeTexture, boolean bl, Integer n, float f, boolean bl2) {
        if (homeTexture == null) {
            appearance.setMaterial(this.getMaterial(n, n, f));
            appearance.setTexture(null);
        } else {
            appearance.setMaterial(this.getMaterial(DEFAULT_COLOR, DEFAULT_AMBIENT_COLOR, f));
            appearance.setTextureAttributes(this.getTextureAttributes(homeTexture, true));
            TextureManager textureManager = TextureManager.getInstance();
            textureManager.loadTexture(homeTexture.getImage(), bl, new TextureManager.TextureObserver(){

                @Override
                public void textureUpdated(Texture texture) {
                    appearance.setTexture(Wall3D.this.getHomeTextureClone(texture, Wall3D.this.home));
                }
            });
        }
        float f2 = this.home.getEnvironment().getWallsAlpha();
        TransparencyAttributes transparencyAttributes = appearance.getTransparencyAttributes();
        transparencyAttributes.setTransparency(f2);
        transparencyAttributes.setTransparencyMode(f2 == 0.0f ? 4 : 1);
        RenderingAttributes renderingAttributes = appearance.getRenderingAttributes();
        HomeEnvironment.DrawingMode drawingMode = this.home.getEnvironment().getDrawingMode();
        renderingAttributes.setVisible(bl2 || drawingMode == null || drawingMode == HomeEnvironment.DrawingMode.FILL || drawingMode == HomeEnvironment.DrawingMode.FILL_AND_OUTLINE);
    }

    private void updateOutlineWallSideAppearance(Appearance appearance) {
        RenderingAttributes renderingAttributes = appearance.getRenderingAttributes();
        HomeEnvironment.DrawingMode drawingMode = this.home.getEnvironment().getDrawingMode();
        renderingAttributes.setVisible(drawingMode == HomeEnvironment.DrawingMode.OUTLINE || drawingMode == HomeEnvironment.DrawingMode.FILL_AND_OUTLINE);
    }

    private static class DoorOrWindowArea {
        private final Area area;
        private final List<HomePieceOfFurniture> doorsOrWindows;

        public DoorOrWindowArea(Area area, List<HomePieceOfFurniture> list) {
            this.area = area;
            this.doorsOrWindows = list;
        }

        public Area getArea() {
            return this.area;
        }

        public List<HomePieceOfFurniture> getDoorsOrWindows() {
            return this.doorsOrWindows;
        }
    }

    private static class ModelRotationTuple {
        private final Content model;
        private final float[][] rotation;
        private final String cutOutShape;

        public ModelRotationTuple(Content content, float[][] fArray, String string) {
            this.model = content;
            this.rotation = fArray;
            this.cutOutShape = string;
        }

        public int hashCode() {
            int n = 31 * this.model.hashCode();
            for (float[] fArray : this.rotation) {
                n += Arrays.hashCode(fArray);
            }
            if (this.cutOutShape != null) {
                n += 31 * this.cutOutShape.hashCode();
            }
            return n;
        }

        public boolean equals(Object object) {
            if (this == object) {
                return true;
            }
            if (object instanceof ModelRotationTuple) {
                ModelRotationTuple modelRotationTuple = (ModelRotationTuple)object;
                return this.equals(modelRotationTuple.model, modelRotationTuple.rotation, this.cutOutShape);
            }
            return false;
        }

        public boolean equals(Content content, float[][] fArray, String string) {
            return this.model.equals(content) && Arrays.deepEquals((Object[])this.rotation, (Object[])fArray) && (this.cutOutShape == string || this.cutOutShape != null && this.cutOutShape.equals(string));
        }
    }
}

