/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.viewcontroller;

import com.eteks.sweethome3d.model.CollectionEvent;
import com.eteks.sweethome3d.model.CollectionListener;
import com.eteks.sweethome3d.model.DoorOrWindow;
import com.eteks.sweethome3d.model.Home;
import com.eteks.sweethome3d.model.HomeDoorOrWindow;
import com.eteks.sweethome3d.model.HomeFurnitureGroup;
import com.eteks.sweethome3d.model.HomeLight;
import com.eteks.sweethome3d.model.HomeObject;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.Level;
import com.eteks.sweethome3d.model.Light;
import com.eteks.sweethome3d.model.PieceOfFurniture;
import com.eteks.sweethome3d.model.Selectable;
import com.eteks.sweethome3d.model.SelectionEvent;
import com.eteks.sweethome3d.model.SelectionListener;
import com.eteks.sweethome3d.model.UserPreferences;
import com.eteks.sweethome3d.viewcontroller.ContentManager;
import com.eteks.sweethome3d.viewcontroller.Controller;
import com.eteks.sweethome3d.viewcontroller.HomeFurnitureController;
import com.eteks.sweethome3d.viewcontroller.ImportedFurnitureWizardController;
import com.eteks.sweethome3d.viewcontroller.LocalizedUndoableEdit;
import com.eteks.sweethome3d.viewcontroller.View;
import com.eteks.sweethome3d.viewcontroller.ViewFactory;
import java.awt.geom.Line2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoableEditSupport;

public class FurnitureController
implements Controller {
    private final Home home;
    private final UserPreferences preferences;
    private final ViewFactory viewFactory;
    private final ContentManager contentManager;
    private final UndoableEditSupport undoSupport;
    private View furnitureView;
    private HomePieceOfFurniture leadSelectedPieceOfFurniture;

    public FurnitureController(Home home, UserPreferences userPreferences, ViewFactory viewFactory) {
        this(home, userPreferences, viewFactory, null, null);
    }

    public FurnitureController(Home home, UserPreferences userPreferences, ViewFactory viewFactory, ContentManager contentManager, UndoableEditSupport undoableEditSupport) {
        this.home = home;
        this.preferences = userPreferences;
        this.viewFactory = viewFactory;
        this.undoSupport = undoableEditSupport;
        this.contentManager = contentManager;
        this.addModelListeners();
    }

    @Override
    public View getView() {
        if (this.furnitureView == null) {
            this.furnitureView = this.viewFactory.createFurnitureView(this.home, this.preferences, this);
        }
        return this.furnitureView;
    }

    private void addModelListeners() {
        this.home.addSelectionListener(new SelectionListener(){

            @Override
            public void selectionChanged(SelectionEvent selectionEvent) {
                List<HomePieceOfFurniture> list = Home.getFurnitureSubList(FurnitureController.this.home.getSelectedItems());
                if (list.isEmpty()) {
                    FurnitureController.this.leadSelectedPieceOfFurniture = null;
                } else if (FurnitureController.this.leadSelectedPieceOfFurniture == null || list.size() == 1 || list.indexOf(FurnitureController.this.leadSelectedPieceOfFurniture) == -1) {
                    FurnitureController.this.leadSelectedPieceOfFurniture = list.get(0);
                }
            }
        });
        final PropertyChangeListener propertyChangeListener = new PropertyChangeListener(){

            @Override
            public void propertyChange(PropertyChangeEvent propertyChangeEvent) {
                if (HomePieceOfFurniture.Property.MOVABLE.name().equals(propertyChangeEvent.getPropertyName())) {
                    List<Selectable> list;
                    HomePieceOfFurniture homePieceOfFurniture = (HomePieceOfFurniture)propertyChangeEvent.getSource();
                    if (FurnitureController.this.home.isBasePlanLocked() && FurnitureController.this.isPieceOfFurniturePartOfBasePlan(homePieceOfFurniture) && (list = FurnitureController.this.home.getSelectedItems()).contains(homePieceOfFurniture)) {
                        list = new ArrayList<Selectable>(list);
                        list.remove(homePieceOfFurniture);
                        FurnitureController.this.home.setSelectedItems(list);
                    }
                }
            }
        };
        for (HomePieceOfFurniture homePieceOfFurniture : this.home.getFurniture()) {
            homePieceOfFurniture.addPropertyChangeListener(propertyChangeListener);
            if (!(homePieceOfFurniture instanceof HomeFurnitureGroup)) continue;
            for (HomePieceOfFurniture homePieceOfFurniture2 : ((HomeFurnitureGroup)homePieceOfFurniture).getAllFurniture()) {
                homePieceOfFurniture2.addPropertyChangeListener(propertyChangeListener);
            }
        }
        this.home.addFurnitureListener(new CollectionListener<HomePieceOfFurniture>(){

            @Override
            public void collectionChanged(CollectionEvent<HomePieceOfFurniture> collectionEvent) {
                block5: {
                    HomePieceOfFurniture homePieceOfFurniture;
                    block4: {
                        homePieceOfFurniture = collectionEvent.getItem();
                        if (collectionEvent.getType() != CollectionEvent.Type.ADD) break block4;
                        homePieceOfFurniture.addPropertyChangeListener(propertyChangeListener);
                        if (!(homePieceOfFurniture instanceof HomeFurnitureGroup)) break block5;
                        for (HomePieceOfFurniture homePieceOfFurniture2 : ((HomeFurnitureGroup)homePieceOfFurniture).getAllFurniture()) {
                            homePieceOfFurniture2.addPropertyChangeListener(propertyChangeListener);
                        }
                        break block5;
                    }
                    if (collectionEvent.getType() == CollectionEvent.Type.DELETE) {
                        homePieceOfFurniture.removePropertyChangeListener(propertyChangeListener);
                        if (homePieceOfFurniture instanceof HomeFurnitureGroup) {
                            for (HomePieceOfFurniture homePieceOfFurniture3 : ((HomeFurnitureGroup)homePieceOfFurniture).getAllFurniture()) {
                                homePieceOfFurniture3.removePropertyChangeListener(propertyChangeListener);
                            }
                        }
                    }
                }
            }
        });
    }

    public void addFurniture(List<HomePieceOfFurniture> list) {
        this.addFurniture(list, null, null, null);
    }

    public void addFurniture(List<HomePieceOfFurniture> list, HomePieceOfFurniture homePieceOfFurniture) {
        this.addFurniture(list, null, null, homePieceOfFurniture);
    }

    public void addFurnitureToGroup(List<HomePieceOfFurniture> list, HomeFurnitureGroup homeFurnitureGroup) {
        if (homeFurnitureGroup == null) {
            throw new IllegalArgumentException("Group shouldn't be null");
        }
        this.addFurniture(list, null, homeFurnitureGroup, null);
    }

    private void addFurniture(List<HomePieceOfFurniture> list, Level[] levelArray, HomeFurnitureGroup homeFurnitureGroup, HomePieceOfFurniture homePieceOfFurniture) {
        List<HomePieceOfFurniture> list2;
        int n;
        boolean bl = this.home.isBasePlanLocked();
        boolean bl2 = this.home.isAllLevelsSelection();
        List<Selectable> list3 = this.home.getSelectedItems();
        HomePieceOfFurniture[] homePieceOfFurnitureArray = list.toArray(new HomePieceOfFurniture[list.size()]);
        int[] nArray = new int[list.size()];
        int n2 = n = homeFurnitureGroup == null ? this.home.getFurniture().size() : homeFurnitureGroup.getFurniture().size();
        if (homePieceOfFurniture != null) {
            list2 = this.home.getFurniture();
            homeFurnitureGroup = FurnitureController.getPieceOfFurnitureGroup(homePieceOfFurniture, null, list2);
            if (homeFurnitureGroup != null) {
                list2 = homeFurnitureGroup.getFurniture();
            }
            n = list2.indexOf(homePieceOfFurniture);
        }
        list2 = homeFurnitureGroup != null ? new HomeFurnitureGroup[list.size()] : null;
        boolean bl3 = bl;
        boolean bl4 = homeFurnitureGroup != null || levelArray == null;
        for (int i = 0; i < nArray.length; ++i) {
            nArray[i] = n++;
            bl3 &= !this.isPieceOfFurniturePartOfBasePlan(homePieceOfFurnitureArray[i]);
            if (levelArray != null) {
                bl4 |= levelArray[i] == null;
            }
            if (list2 == null) continue;
            list2[i] = homeFurnitureGroup;
        }
        Level[] levelArray2 = bl4 ? null : levelArray;
        boolean bl5 = bl3;
        Level level = homeFurnitureGroup != null ? homeFurnitureGroup.getLevel() : this.home.getSelectedLevel();
        FurnitureController.doAddFurniture(this.home, homePieceOfFurnitureArray, list2, nArray, level, levelArray2, bl5, false);
        if (this.undoSupport != null) {
            this.undoSupport.postEdit(new FurnitureAdditionUndoableEdit(this.home, this.preferences, list3.toArray(new Selectable[list3.size()]), bl, bl2, homePieceOfFurnitureArray, nArray, (HomeFurnitureGroup[])list2, levelArray2, level, bl5));
        }
    }

    private static void doAddFurniture(Home home, HomePieceOfFurniture[] homePieceOfFurnitureArray, HomeFurnitureGroup[] homeFurnitureGroupArray, int[] nArray, Level level, Level[] levelArray, boolean bl, boolean bl2) {
        for (int i = 0; i < nArray.length; ++i) {
            if (homeFurnitureGroupArray != null && homeFurnitureGroupArray[i] != null) {
                home.addPieceOfFurnitureToGroup(homePieceOfFurnitureArray[i], homeFurnitureGroupArray[i], nArray[i]);
                homePieceOfFurnitureArray[i].setVisible(homeFurnitureGroupArray[i].isVisible());
            } else {
                home.addPieceOfFurniture(homePieceOfFurnitureArray[i], nArray[i]);
            }
            homePieceOfFurnitureArray[i].setLevel(levelArray != null ? levelArray[i] : level);
        }
        home.setBasePlanLocked(bl);
        home.setSelectedItems(Arrays.asList(homePieceOfFurnitureArray));
        home.setAllLevelsSelection(bl2);
    }

    public void deleteSelection() {
        this.deleteFurniture(Home.getFurnitureSubList(this.home.getSelectedItems()));
    }

    public void deleteFurniture(List<HomePieceOfFurniture> list) {
        Object object;
        Object object2;
        Object object4;
        boolean bl;
        boolean bl2 = this.home.isBasePlanLocked();
        boolean bl3 = this.home.isAllLevelsSelection();
        List<Selectable> list2 = this.home.getSelectedItems();
        List<HomePieceOfFurniture> list3 = this.home.getFurniture();
        list = new ArrayList<HomePieceOfFurniture>(list);
        ArrayList<HomeFurnitureGroup> arrayList = new ArrayList<HomeFurnitureGroup>();
        FurnitureController.searchGroups(list3, arrayList);
        do {
            bl = false;
            for (HomeFurnitureGroup homeFurnitureGroup : arrayList) {
                object4 = homeFurnitureGroup.getFurniture();
                if (!list.containsAll((Collection<?>)object4)) continue;
                list.removeAll((Collection<?>)object4);
                list.add(homeFurnitureGroup);
                bl = true;
            }
        } while (bl);
        HashMap hashMap = new HashMap();
        int n = 0;
        for (HomePieceOfFurniture object32 : list) {
            if (!this.isPieceOfFurnitureDeletable(object32)) continue;
            object2 = FurnitureController.getPieceOfFurnitureGroup(object32, null, list3);
            object = (Map)hashMap.get(object2);
            if (object == null) {
                object = new TreeMap();
                hashMap.put(object2, object);
            }
            if (object2 == null) {
                object.put(list3.indexOf(object32), object32);
            } else {
                object.put(((HomeFurnitureGroup)object2).getFurniture().indexOf(object32), object32);
            }
            ++n;
        }
        object4 = new HomePieceOfFurniture[n];
        int[] nArray = new int[((HomePieceOfFurniture[])object4).length];
        object2 = new Level[((HomePieceOfFurniture[])object4).length];
        object = new HomeFurnitureGroup[((HomePieceOfFurniture[])object4).length];
        int n2 = 0;
        for (Map.Entry entry : hashMap.entrySet()) {
            for (Map.Entry entry2 : ((Map)entry.getValue()).entrySet()) {
                object4[n2] = (HomePieceOfFurniture)entry2.getValue();
                nArray[n2] = (Integer)entry2.getKey();
                object2[n2] = object4[n2].getLevel();
                object[n2++] = (HomeFurnitureGroup)entry.getKey();
            }
        }
        FurnitureController.doDeleteFurniture(this.home, object4, bl2, false);
        if (this.undoSupport != null) {
            this.undoSupport.postEdit(new FurnitureDeletionUndoableEdit(this.home, this.preferences, list2.toArray(new Selectable[list2.size()]), bl2, bl3, (HomePieceOfFurniture[])object4, nArray, (HomeFurnitureGroup[])object, (Level[])object2));
        }
    }

    private static void doDeleteFurniture(Home home, HomePieceOfFurniture[] homePieceOfFurnitureArray, boolean bl, boolean bl2) {
        for (HomePieceOfFurniture homePieceOfFurniture : homePieceOfFurnitureArray) {
            home.deletePieceOfFurniture(homePieceOfFurniture);
        }
        home.setBasePlanLocked(bl);
        home.setAllLevelsSelection(bl2);
    }

    private static void searchGroups(List<HomePieceOfFurniture> list, List<HomeFurnitureGroup> list2) {
        for (HomePieceOfFurniture homePieceOfFurniture : list) {
            if (!(homePieceOfFurniture instanceof HomeFurnitureGroup)) continue;
            list2.add((HomeFurnitureGroup)homePieceOfFurniture);
            FurnitureController.searchGroups(((HomeFurnitureGroup)homePieceOfFurniture).getFurniture(), list2);
        }
    }

    private static HomeFurnitureGroup getPieceOfFurnitureGroup(HomePieceOfFurniture homePieceOfFurniture, HomeFurnitureGroup homeFurnitureGroup, List<HomePieceOfFurniture> list) {
        for (HomePieceOfFurniture homePieceOfFurniture2 : list) {
            HomeFurnitureGroup homeFurnitureGroup2;
            if (homePieceOfFurniture2.equals(homePieceOfFurniture)) {
                return homeFurnitureGroup;
            }
            if (!(homePieceOfFurniture2 instanceof HomeFurnitureGroup) || (homeFurnitureGroup2 = FurnitureController.getPieceOfFurnitureGroup(homePieceOfFurniture, (HomeFurnitureGroup)homePieceOfFurniture2, ((HomeFurnitureGroup)homePieceOfFurniture2).getFurniture())) == null) continue;
            return homeFurnitureGroup2;
        }
        return null;
    }

    public void moveSelectedFurnitureBefore(HomePieceOfFurniture homePieceOfFurniture) {
        List<HomePieceOfFurniture> list = Home.getFurnitureSubList(this.home.getSelectedItems());
        if (!list.isEmpty()) {
            Level[] levelArray = new Level[list.size()];
            for (int i = 0; i < levelArray.length; ++i) {
                levelArray[i] = list.get(i).getLevel();
            }
            this.undoSupport.beginUpdate();
            this.deleteFurniture(list);
            this.addFurniture(list, levelArray, null, homePieceOfFurniture);
            this.undoSupport.postEdit(new LocalizedUndoableEdit(this.preferences, FurnitureController.class, "undoReorderName"));
            this.undoSupport.endUpdate();
        }
    }

    public void setSelectedFurniture(List<HomePieceOfFurniture> list) {
        this.setSelectedFurniture(list, true);
    }

    public void setSelectedFurniture(List<HomePieceOfFurniture> list, boolean bl) {
        if (this.home.isBasePlanLocked()) {
            list = this.getFurnitureNotPartOfBasePlan(list);
        }
        if (bl) {
            this.home.setSelectedItems(list);
            this.home.setAllLevelsSelection(false);
        } else {
            ArrayList<Selectable> arrayList = new ArrayList<Selectable>(this.home.getSelectedItems());
            list = new ArrayList<HomePieceOfFurniture>(list);
            for (int i = arrayList.size() - 1; i >= 0; --i) {
                Selectable selectable = (Selectable)arrayList.get(i);
                if (!(selectable instanceof HomePieceOfFurniture)) continue;
                int n = list.indexOf((HomePieceOfFurniture)selectable);
                if (n >= 0) {
                    list.remove(n);
                    continue;
                }
                arrayList.remove(i);
            }
            arrayList.addAll(list);
            this.home.setSelectedItems(arrayList);
        }
    }

    public void selectAll() {
        this.setSelectedFurniture(this.home.getFurniture());
    }

    protected boolean isPieceOfFurniturePartOfBasePlan(HomePieceOfFurniture homePieceOfFurniture) {
        return !homePieceOfFurniture.isMovable() || homePieceOfFurniture.isDoorOrWindow();
    }

    protected boolean isPieceOfFurnitureMovable(HomePieceOfFurniture homePieceOfFurniture) {
        return true;
    }

    protected boolean isPieceOfFurnitureDeletable(HomePieceOfFurniture homePieceOfFurniture) {
        return true;
    }

    public HomePieceOfFurniture createHomePieceOfFurniture(PieceOfFurniture pieceOfFurniture) {
        if (pieceOfFurniture instanceof DoorOrWindow) {
            return new HomeDoorOrWindow((DoorOrWindow)pieceOfFurniture);
        }
        if (pieceOfFurniture instanceof Light) {
            return new HomeLight((Light)pieceOfFurniture);
        }
        return new HomePieceOfFurniture(pieceOfFurniture);
    }

    private List<HomePieceOfFurniture> getFurnitureNotPartOfBasePlan(List<HomePieceOfFurniture> list) {
        ArrayList<HomePieceOfFurniture> arrayList = new ArrayList<HomePieceOfFurniture>();
        for (HomePieceOfFurniture homePieceOfFurniture : list) {
            if (this.isPieceOfFurniturePartOfBasePlan(homePieceOfFurniture)) continue;
            arrayList.add(homePieceOfFurniture);
        }
        return arrayList;
    }

    public void toggleFurnitureSort(HomePieceOfFurniture.SortableProperty sortableProperty) {
        if (sortableProperty.equals((Object)this.home.getFurnitureSortedProperty())) {
            this.home.setFurnitureSortedProperty(null);
        } else {
            this.home.setFurnitureSortedProperty(sortableProperty);
        }
    }

    public void toggleFurnitureSortOrder() {
        this.home.setFurnitureDescendingSorted(!this.home.isFurnitureDescendingSorted());
    }

    public void sortFurniture(HomePieceOfFurniture.SortableProperty sortableProperty) {
        HomePieceOfFurniture.SortableProperty sortableProperty2 = this.home.getFurnitureSortedProperty();
        boolean bl = this.home.isFurnitureDescendingSorted();
        boolean bl2 = false;
        if (sortableProperty.equals((Object)sortableProperty2)) {
            if (bl) {
                sortableProperty = null;
            } else {
                bl2 = true;
            }
        }
        this.home.setFurnitureSortedProperty(sortableProperty);
        this.home.setFurnitureDescendingSorted(bl2);
    }

    public void setFurnitureVisibleProperties(List<HomePieceOfFurniture.SortableProperty> list) {
        this.home.setFurnitureVisibleProperties(list);
    }

    public void toggleFurnitureVisibleProperty(HomePieceOfFurniture.SortableProperty sortableProperty) {
        ArrayList<HomePieceOfFurniture.SortableProperty> arrayList = new ArrayList<HomePieceOfFurniture.SortableProperty>(this.home.getFurnitureVisibleProperties());
        if (arrayList.contains((Object)sortableProperty)) {
            arrayList.remove((Object)sortableProperty);
            if (arrayList.isEmpty()) {
                arrayList.add(HomePieceOfFurniture.SortableProperty.NAME);
            }
        } else {
            List<HomePieceOfFurniture.SortableProperty> list = Arrays.asList(HomePieceOfFurniture.SortableProperty.CATALOG_ID, HomePieceOfFurniture.SortableProperty.NAME, HomePieceOfFurniture.SortableProperty.CREATOR, HomePieceOfFurniture.SortableProperty.WIDTH, HomePieceOfFurniture.SortableProperty.DEPTH, HomePieceOfFurniture.SortableProperty.HEIGHT, HomePieceOfFurniture.SortableProperty.X, HomePieceOfFurniture.SortableProperty.Y, HomePieceOfFurniture.SortableProperty.ELEVATION, HomePieceOfFurniture.SortableProperty.ANGLE, HomePieceOfFurniture.SortableProperty.LEVEL, HomePieceOfFurniture.SortableProperty.MODEL_SIZE, HomePieceOfFurniture.SortableProperty.COLOR, HomePieceOfFurniture.SortableProperty.TEXTURE, HomePieceOfFurniture.SortableProperty.MOVABLE, HomePieceOfFurniture.SortableProperty.DOOR_OR_WINDOW, HomePieceOfFurniture.SortableProperty.VISIBLE, HomePieceOfFurniture.SortableProperty.PRICE, HomePieceOfFurniture.SortableProperty.VALUE_ADDED_TAX_PERCENTAGE, HomePieceOfFurniture.SortableProperty.VALUE_ADDED_TAX, HomePieceOfFurniture.SortableProperty.PRICE_VALUE_ADDED_TAX_INCLUDED);
            int n = list.indexOf((Object)sortableProperty) - 1;
            if (n > 0) {
                while (n > 0) {
                    int n2 = arrayList.indexOf((Object)list.get(n));
                    if (n2 >= 0) {
                        n = n2 + 1;
                        break;
                    }
                    --n;
                }
            }
            if (n < 0) {
                n = 0;
            }
            arrayList.add(n, sortableProperty);
        }
        this.home.setFurnitureVisibleProperties(arrayList);
    }

    public void modifySelectedFurniture() {
        if (!Home.getFurnitureSubList(this.home.getSelectedItems()).isEmpty()) {
            new HomeFurnitureController(this.home, this.preferences, this.viewFactory, this.contentManager, this.undoSupport).displayView(this.getView());
        }
    }

    public void toggleSelectedFurnitureVisibility() {
        if (Home.getFurnitureSubList(this.home.getSelectedItems()).size() == 1) {
            HomeFurnitureController homeFurnitureController;
            homeFurnitureController.setVisible((homeFurnitureController = new HomeFurnitureController(this.home, this.preferences, this.viewFactory, this.contentManager, this.undoSupport)).getVisible() == false);
            homeFurnitureController.modifyFurniture();
        }
    }

    public void groupSelectedFurniture() {
        HomePieceOfFurniture[] homePieceOfFurnitureArray = this.getMovableSelectedFurniture();
        if (homePieceOfFurnitureArray.length > 0) {
            HomeObject homeObject2;
            HomeFurnitureGroup[] homeFurnitureGroupArray;
            Object object;
            boolean bl = this.home.isBasePlanLocked();
            boolean bl2 = this.home.isAllLevelsSelection();
            List<Selectable> list2 = this.home.getSelectedItems();
            List<HomePieceOfFurniture> list3 = this.home.getFurniture();
            HashMap<Object, HomeFurnitureGroup[]> hashMap = new HashMap<Object, HomeFurnitureGroup[]>();
            int n = 0;
            for (HomePieceOfFurniture object32 : homePieceOfFurnitureArray) {
                object = FurnitureController.getPieceOfFurnitureGroup(object32, null, list3);
                homeFurnitureGroupArray = (HomeFurnitureGroup[])hashMap.get(object);
                if (homeFurnitureGroupArray == null) {
                    homeFurnitureGroupArray = new TreeMap();
                    hashMap.put(object, homeFurnitureGroupArray);
                }
                if (object == null) {
                    homeFurnitureGroupArray.put(list3.indexOf(object32), object32);
                } else {
                    homeFurnitureGroupArray.put(((HomeFurnitureGroup)object).getFurniture().indexOf(object32), object32);
                }
                ++n;
            }
            HomePieceOfFurniture[] homePieceOfFurnitureArray2 = new HomePieceOfFurniture[n];
            int[] nArray = new int[homePieceOfFurnitureArray2.length];
            Level[] levelArray = new Level[homePieceOfFurnitureArray2.length];
            float[] fArray = new float[homePieceOfFurnitureArray2.length];
            object = new boolean[homePieceOfFurnitureArray2.length];
            homeFurnitureGroupArray = new HomeFurnitureGroup[homePieceOfFurnitureArray2.length];
            Level level = this.home.getSelectedLevel();
            int n2 = 0;
            for (Map.Entry entry : hashMap.entrySet()) {
                for (Map.Entry entry2 : ((TreeMap)entry.getValue()).entrySet()) {
                    HomePieceOfFurniture homePieceOfFurniture;
                    homePieceOfFurnitureArray2[n2] = homePieceOfFurniture = (HomePieceOfFurniture)entry2.getValue();
                    nArray[n2] = (Integer)entry2.getKey();
                    levelArray[n2] = homePieceOfFurniture.getLevel();
                    fArray[n2] = homePieceOfFurniture.getElevation();
                    object[n2] = homePieceOfFurniture.isVisible();
                    homeFurnitureGroupArray[n2] = (HomeFurnitureGroup)entry.getKey();
                    if (levelArray[n2] != null && (level == null || levelArray[n2].getElevation() < level.getElevation())) {
                        level = levelArray[n2];
                    }
                    ++n2;
                }
            }
            List<HomePieceOfFurniture> list = Arrays.asList(homePieceOfFurnitureArray2);
            HomeFurnitureGroup homeFurnitureGroup = list.indexOf(this.leadSelectedPieceOfFurniture) > 0 ? this.createHomeFurnitureGroup(list, this.leadSelectedPieceOfFurniture) : this.createHomeFurnitureGroup(list);
            Object object2 = new float[homePieceOfFurnitureArray2.length];
            n2 = 0;
            for (HomeObject homeObject2 : homePieceOfFurnitureArray2) {
                object2[n2++] = homeObject2.getElevation();
            }
            TreeMap treeMap = (TreeMap)hashMap.get(null);
            int n3 = treeMap != null ? (Integer)treeMap.lastKey() + 1 - homePieceOfFurnitureArray2.length : list3.size();
            int n4 = homeFurnitureGroup.isMovable() ? 1 : 0;
            homeObject2 = level;
            FurnitureController.doGroupFurniture(this.home, homePieceOfFurnitureArray2, new HomeFurnitureGroup[]{homeFurnitureGroup}, null, new int[]{n3}, new Level[]{homeObject2}, bl, false);
            if (this.undoSupport != null) {
                this.undoSupport.postEdit(new FurnitureGroupingUndoableEdit(this.home, this.preferences, list2.toArray(new Selectable[list2.size()]), bl, bl2, homePieceOfFurnitureArray2, nArray, homeFurnitureGroupArray, levelArray, fArray, (boolean[])object, homeFurnitureGroup, n3, (Level)homeObject2, (float[])object2, n4 != 0));
            }
        }
    }

    protected HomeFurnitureGroup createHomeFurnitureGroup(List<HomePieceOfFurniture> list) {
        return this.createHomeFurnitureGroup(list, list.get(0));
    }

    protected HomeFurnitureGroup createHomeFurnitureGroup(List<HomePieceOfFurniture> list, HomePieceOfFurniture homePieceOfFurniture) {
        String string = this.preferences.getLocalizedString(FurnitureController.class, "groupName", FurnitureController.getFurnitureGroupCount(this.home.getFurniture()) + 1);
        HomeFurnitureGroup homeFurnitureGroup = new HomeFurnitureGroup(list, homePieceOfFurniture, string);
        return homeFurnitureGroup;
    }

    private static int getFurnitureGroupCount(List<HomePieceOfFurniture> list) {
        int n = 0;
        for (HomePieceOfFurniture homePieceOfFurniture : list) {
            if (!(homePieceOfFurniture instanceof HomeFurnitureGroup)) continue;
            n += 1 + FurnitureController.getFurnitureGroupCount(((HomeFurnitureGroup)homePieceOfFurniture).getFurniture());
        }
        return n;
    }

    private static void doGroupFurniture(Home home, HomePieceOfFurniture[] homePieceOfFurnitureArray, HomeFurnitureGroup[] homeFurnitureGroupArray, HomeFurnitureGroup[] homeFurnitureGroupArray2, int[] nArray, Level[] levelArray, boolean bl, boolean bl2) {
        FurnitureController.doDeleteFurniture(home, homePieceOfFurnitureArray, bl, bl2);
        FurnitureController.doAddFurniture(home, homeFurnitureGroupArray, homeFurnitureGroupArray2, nArray, null, levelArray, bl, bl2);
    }

    private static void doUngroupFurniture(Home home, HomeFurnitureGroup[] homeFurnitureGroupArray, HomePieceOfFurniture[] homePieceOfFurnitureArray, HomeFurnitureGroup[] homeFurnitureGroupArray2, int[] nArray, Level[] levelArray, boolean bl, boolean bl2) {
        FurnitureController.doDeleteFurniture(home, homeFurnitureGroupArray, bl, bl2);
        FurnitureController.doAddFurniture(home, homePieceOfFurnitureArray, homeFurnitureGroupArray2, nArray, null, levelArray, bl, bl2);
    }

    public void ungroupSelectedFurniture() {
        ArrayList<HomeFurnitureGroup> arrayList = new ArrayList<HomeFurnitureGroup>();
        for (Selectable selectable : this.home.getSelectedItems()) {
            HomeFurnitureGroup homeFurnitureGroup;
            if (!(selectable instanceof HomeFurnitureGroup) || !this.isPieceOfFurnitureMovable(homeFurnitureGroup = (HomeFurnitureGroup)selectable)) continue;
            arrayList.add(homeFurnitureGroup);
        }
        if (!arrayList.isEmpty()) {
            Object object;
            Level[] levelArray;
            Object object2;
            List<HomePieceOfFurniture> list = this.home.getFurniture();
            boolean bl = this.home.isBasePlanLocked();
            boolean bl2 = this.home.isAllLevelsSelection();
            List<Selectable> list2 = this.home.getSelectedItems();
            HashMap<Object, Level[]> hashMap = new HashMap<Object, Level[]>();
            int n = 0;
            for (HomeFurnitureGroup homeFurnitureGroupArray22 : arrayList) {
                object2 = FurnitureController.getPieceOfFurnitureGroup(homeFurnitureGroupArray22, null, list);
                levelArray = (Level[])hashMap.get(object2);
                if (levelArray == null) {
                    levelArray = new TreeMap();
                    hashMap.put(object2, levelArray);
                }
                if (object2 == null) {
                    levelArray.put(list.indexOf(homeFurnitureGroupArray22), homeFurnitureGroupArray22);
                } else {
                    levelArray.put(((HomeFurnitureGroup)object2).getFurniture().indexOf(homeFurnitureGroupArray22), homeFurnitureGroupArray22);
                }
                ++n;
            }
            HomeFurnitureGroup[] homeFurnitureGroupArray3 = new HomeFurnitureGroup[n];
            HomeFurnitureGroup[] homeFurnitureGroupArray = new HomeFurnitureGroup[homeFurnitureGroupArray3.length];
            object2 = new int[homeFurnitureGroupArray3.length];
            levelArray = new Level[homeFurnitureGroupArray3.length];
            int n2 = 0;
            ArrayList<HomePieceOfFurniture> arrayList2 = new ArrayList<HomePieceOfFurniture>();
            ArrayList<Integer> arrayList3 = new ArrayList<Integer>();
            ArrayList arrayList4 = new ArrayList();
            for (Map.Entry entry : hashMap.entrySet()) {
                object = (TreeMap)entry.getValue();
                int n3 = (Integer)((TreeMap)object).lastKey() + 1 - ((TreeMap)object).size();
                for (Map.Entry entry2 : ((TreeMap)object).entrySet()) {
                    HomeFurnitureGroup homeFurnitureGroup;
                    homeFurnitureGroupArray3[n2] = homeFurnitureGroup = (HomeFurnitureGroup)entry2.getValue();
                    homeFurnitureGroupArray[n2] = (HomeFurnitureGroup)entry.getKey();
                    object2[n2] = (Integer)entry2.getKey();
                    levelArray[n2++] = homeFurnitureGroup.getLevel();
                    for (HomePieceOfFurniture homePieceOfFurniture : homeFurnitureGroup.getFurniture()) {
                        arrayList2.add(homePieceOfFurniture);
                        arrayList4.add(entry.getKey());
                        arrayList3.add(n3++);
                    }
                }
            }
            HomePieceOfFurniture[] homePieceOfFurnitureArray = arrayList2.toArray(new HomePieceOfFurniture[arrayList2.size()]);
            HomeFurnitureGroup[] homeFurnitureGroupArray2 = arrayList4.toArray(new HomeFurnitureGroup[arrayList4.size()]);
            object = new int[homePieceOfFurnitureArray.length];
            Level[] levelArray2 = new Level[homePieceOfFurnitureArray.length];
            boolean bl3 = bl;
            for (n2 = 0; n2 < homePieceOfFurnitureArray.length; ++n2) {
                object[n2] = (Integer)arrayList3.get(n2);
                levelArray2[n2] = homePieceOfFurnitureArray[n2].getLevel();
                bl3 &= !this.isPieceOfFurniturePartOfBasePlan(homePieceOfFurnitureArray[n2]);
            }
            boolean bl4 = bl3;
            FurnitureController.doUngroupFurniture(this.home, homeFurnitureGroupArray3, homePieceOfFurnitureArray, homeFurnitureGroupArray2, (int[])object, levelArray2, bl4, false);
            if (this.undoSupport != null) {
                this.undoSupport.postEdit(new FurnitureUngroupingUndoableEdit(this.home, this.preferences, list2.toArray(new Selectable[list2.size()]), bl, bl2, homeFurnitureGroupArray3, (int[])object2, homeFurnitureGroupArray, levelArray, homePieceOfFurnitureArray, (int[])object, homeFurnitureGroupArray2, levelArray2, bl4));
            }
        }
    }

    public void importFurniture() {
        new ImportedFurnitureWizardController(this.home, this.preferences, this, this.viewFactory, this.contentManager, this.undoSupport).displayView(this.getView());
    }

    public void importFurniture(String string) {
        new ImportedFurnitureWizardController(this.home, string, this.preferences, this, this.viewFactory, this.contentManager, this.undoSupport).displayView(this.getView());
    }

    public void alignSelectedFurnitureOnTop() {
        List<Selectable> list = this.home.getSelectedItems();
        this.alignSelectedFurniture(new FurnitureTopAlignmentUndoableEdit(this.home, this.preferences, list.toArray(new Selectable[list.size()]), this.getMovableSelectedFurniture(), this.leadSelectedPieceOfFurniture));
    }

    public void alignSelectedFurnitureOnBottom() {
        List<Selectable> list = this.home.getSelectedItems();
        this.alignSelectedFurniture(new FurnitureBottomAlignmentUndoableEdit(this.home, this.preferences, list.toArray(new Selectable[list.size()]), this.getMovableSelectedFurniture(), this.leadSelectedPieceOfFurniture));
    }

    public void alignSelectedFurnitureOnLeft() {
        List<Selectable> list = this.home.getSelectedItems();
        this.alignSelectedFurniture(new FurnitureLeftAlignmentUndoableEdit(this.home, this.preferences, list.toArray(new Selectable[list.size()]), this.getMovableSelectedFurniture(), this.leadSelectedPieceOfFurniture));
    }

    public void alignSelectedFurnitureOnRight() {
        List<Selectable> list = this.home.getSelectedItems();
        this.alignSelectedFurniture(new FurnitureRightAlignmentUndoableEdit(this.home, this.preferences, list.toArray(new Selectable[list.size()]), this.getMovableSelectedFurniture(), this.leadSelectedPieceOfFurniture));
    }

    public void alignSelectedFurnitureOnFrontSide() {
        List<Selectable> list = this.home.getSelectedItems();
        this.alignSelectedFurniture(new FurnitureFrontSideAlignmentUndoableEdit(this.home, this.preferences, list.toArray(new Selectable[list.size()]), this.getMovableSelectedFurniture(), this.leadSelectedPieceOfFurniture));
    }

    public void alignSelectedFurnitureOnBackSide() {
        List<Selectable> list = this.home.getSelectedItems();
        this.alignSelectedFurniture(new FurnitureBackSideAlignmentUndoableEdit(this.home, this.preferences, list.toArray(new Selectable[list.size()]), this.getMovableSelectedFurniture(), this.leadSelectedPieceOfFurniture));
    }

    public void alignSelectedFurnitureOnLeftSide() {
        List<Selectable> list = this.home.getSelectedItems();
        this.alignSelectedFurniture(new FurnitureLeftSideAlignmentUndoableEdit(this.home, this.preferences, list.toArray(new Selectable[list.size()]), this.getMovableSelectedFurniture(), this.leadSelectedPieceOfFurniture));
    }

    public void alignSelectedFurnitureOnRightSide() {
        List<Selectable> list = this.home.getSelectedItems();
        this.alignSelectedFurniture(new FurnitureRightSideAlignmentUndoableEdit(this.home, this.preferences, list.toArray(new Selectable[list.size()]), this.getMovableSelectedFurniture(), this.leadSelectedPieceOfFurniture));
    }

    public void alignSelectedFurnitureSideBySide() {
        List<Selectable> list = this.home.getSelectedItems();
        this.alignSelectedFurniture(new FurnitureSideBySideAlignmentUndoableEdit(this.home, this.preferences, list.toArray(new Selectable[list.size()]), this.getMovableSelectedFurniture(), this.leadSelectedPieceOfFurniture));
    }

    private static List<HomePieceOfFurniture> sortFurniture(HomePieceOfFurniture[] homePieceOfFurnitureArray, HomePieceOfFurniture homePieceOfFurniture, final Line2D line2D) {
        ArrayList<HomePieceOfFurniture> arrayList = new ArrayList<HomePieceOfFurniture>(homePieceOfFurnitureArray.length + 1);
        if (homePieceOfFurniture != null) {
            arrayList.add(homePieceOfFurniture);
        }
        arrayList.addAll(Arrays.asList(homePieceOfFurnitureArray));
        Collections.sort(arrayList, new Comparator<HomePieceOfFurniture>(){

            @Override
            public int compare(HomePieceOfFurniture homePieceOfFurniture, HomePieceOfFurniture homePieceOfFurniture2) {
                return Double.compare(line2D.ptLineDistSq(homePieceOfFurniture2.getX(), homePieceOfFurniture2.getY()) * (double)line2D.relativeCCW(homePieceOfFurniture2.getX(), homePieceOfFurniture2.getY()), line2D.ptLineDistSq(homePieceOfFurniture.getX(), homePieceOfFurniture.getY()) * (double)line2D.relativeCCW(homePieceOfFurniture.getX(), homePieceOfFurniture.getY()));
            }
        });
        return arrayList;
    }

    private static double alignPieceOfFurnitureAlongSides(HomePieceOfFurniture homePieceOfFurniture, HomePieceOfFurniture homePieceOfFurniture2, Line2D line2D, boolean bl, Line2D line2D2, float f) {
        double d = (double)line2D.relativeCCW(homePieceOfFurniture.getX(), homePieceOfFurniture.getY()) * line2D.ptLineDist(homePieceOfFurniture.getX(), homePieceOfFurniture.getY()) + FurnitureController.getPieceBoundingRectangleHeight(homePieceOfFurniture, -homePieceOfFurniture2.getAngle()) / 2.0;
        if (bl) {
            d = -d;
        }
        double d2 = Math.sin(homePieceOfFurniture2.getAngle());
        double d3 = Math.cos(homePieceOfFurniture2.getAngle());
        float f2 = (float)(-d * d2);
        float f3 = (float)(d * d3);
        double d4 = FurnitureController.getPieceBoundingRectangleWidth(homePieceOfFurniture, -homePieceOfFurniture2.getAngle());
        if (line2D2 != null) {
            int n = line2D2.relativeCCW(homePieceOfFurniture.getX(), homePieceOfFurniture.getY());
            if (n == 0) {
                n = bl ? 1 : -1;
            }
            d = (double)f + (double)n * (line2D2.ptLineDist(homePieceOfFurniture.getX(), homePieceOfFurniture.getY()) - d4 / 2.0);
            f2 += (float)(d * d3);
            f3 += (float)(d * d2);
        }
        homePieceOfFurniture.move(f2, f3);
        return d4;
    }

    private static void alignPieceOfFurnitureAlongLeftOrRightSides(HomePieceOfFurniture homePieceOfFurniture, HomePieceOfFurniture homePieceOfFurniture2, Line2D line2D, boolean bl) {
        double d = (double)line2D.relativeCCW(homePieceOfFurniture.getX(), homePieceOfFurniture.getY()) * line2D.ptLineDist(homePieceOfFurniture.getX(), homePieceOfFurniture.getY()) + FurnitureController.getPieceBoundingRectangleWidth(homePieceOfFurniture, -homePieceOfFurniture2.getAngle()) / 2.0;
        if (bl) {
            d = -d;
        }
        homePieceOfFurniture.move((float)(d * Math.cos(homePieceOfFurniture2.getAngle())), (float)(d * Math.sin(homePieceOfFurniture2.getAngle())));
    }

    private static double getPieceBoundingRectangleWidth(HomePieceOfFurniture homePieceOfFurniture, float f) {
        return Math.abs((double)homePieceOfFurniture.getWidthInPlan() * Math.cos(f + homePieceOfFurniture.getAngle())) + Math.abs((double)homePieceOfFurniture.getDepthInPlan() * Math.sin(f + homePieceOfFurniture.getAngle()));
    }

    private static double getPieceBoundingRectangleHeight(HomePieceOfFurniture homePieceOfFurniture, float f) {
        return Math.abs((double)homePieceOfFurniture.getWidthInPlan() * Math.sin(f + homePieceOfFurniture.getAngle())) + Math.abs((double)homePieceOfFurniture.getDepthInPlan() * Math.cos(f + homePieceOfFurniture.getAngle()));
    }

    private void alignSelectedFurniture(FurnitureAlignmentUndoableEdit furnitureAlignmentUndoableEdit) {
        HomePieceOfFurniture[] homePieceOfFurnitureArray = this.getMovableSelectedFurniture();
        if (homePieceOfFurnitureArray.length >= 2) {
            this.home.setSelectedItems(Arrays.asList(homePieceOfFurnitureArray));
            furnitureAlignmentUndoableEdit.alignFurniture();
            if (this.undoSupport != null) {
                this.undoSupport.postEdit(furnitureAlignmentUndoableEdit);
            }
        }
    }

    private HomePieceOfFurniture[] getMovableSelectedFurniture() {
        ArrayList<HomePieceOfFurniture> arrayList = new ArrayList<HomePieceOfFurniture>();
        for (Selectable selectable : this.home.getSelectedItems()) {
            HomePieceOfFurniture homePieceOfFurniture;
            if (!(selectable instanceof HomePieceOfFurniture) || !this.isPieceOfFurnitureMovable(homePieceOfFurniture = (HomePieceOfFurniture)selectable)) continue;
            arrayList.add(homePieceOfFurniture);
        }
        return arrayList.toArray(new HomePieceOfFurniture[arrayList.size()]);
    }

    private static void undoAlignFurniture(HomePieceOfFurniture[] homePieceOfFurnitureArray, float[] fArray, float[] fArray2) {
        for (int i = 0; i < homePieceOfFurnitureArray.length; ++i) {
            HomePieceOfFurniture homePieceOfFurniture = homePieceOfFurnitureArray[i];
            homePieceOfFurniture.setX(fArray[i]);
            homePieceOfFurniture.setY(fArray2[i]);
        }
    }

    private static float getMinX(HomePieceOfFurniture homePieceOfFurniture) {
        float[][] fArray = homePieceOfFurniture.getPoints();
        float f = Float.POSITIVE_INFINITY;
        for (float[] fArray2 : fArray) {
            f = Math.min(f, fArray2[0]);
        }
        return f;
    }

    private static float getMaxX(HomePieceOfFurniture homePieceOfFurniture) {
        float[][] fArray = homePieceOfFurniture.getPoints();
        float f = Float.NEGATIVE_INFINITY;
        for (float[] fArray2 : fArray) {
            f = Math.max(f, fArray2[0]);
        }
        return f;
    }

    private static float getMinY(HomePieceOfFurniture homePieceOfFurniture) {
        float[][] fArray = homePieceOfFurniture.getPoints();
        float f = Float.POSITIVE_INFINITY;
        for (float[] fArray2 : fArray) {
            f = Math.min(f, fArray2[1]);
        }
        return f;
    }

    private static float getMaxY(HomePieceOfFurniture homePieceOfFurniture) {
        float[][] fArray = homePieceOfFurniture.getPoints();
        float f = Float.NEGATIVE_INFINITY;
        for (float[] fArray2 : fArray) {
            f = Math.max(f, fArray2[1]);
        }
        return f;
    }

    public void distributeSelectedFurnitureHorizontally() {
        this.distributeSelectedFurniture(true);
    }

    public void distributeSelectedFurnitureVertically() {
        this.distributeSelectedFurniture(false);
    }

    public void distributeSelectedFurniture(boolean bl) {
        HomePieceOfFurniture[] homePieceOfFurnitureArray = this.getMovableSelectedFurniture();
        if (homePieceOfFurnitureArray.length >= 3) {
            List<Selectable> list = this.home.getSelectedItems();
            float[] fArray = new float[homePieceOfFurnitureArray.length];
            float[] fArray2 = new float[homePieceOfFurnitureArray.length];
            for (int i = 0; i < homePieceOfFurnitureArray.length; ++i) {
                fArray[i] = homePieceOfFurnitureArray[i].getX();
                fArray2[i] = homePieceOfFurnitureArray[i].getY();
            }
            this.home.setSelectedItems(Arrays.asList(homePieceOfFurnitureArray));
            FurnitureController.doDistributeFurnitureAlongAxis(homePieceOfFurnitureArray, bl);
            if (this.undoSupport != null) {
                this.undoSupport.postEdit(new FurnitureDistributionUndoableEdit(this.home, this.preferences, list.toArray(new Selectable[list.size()]), fArray, fArray2, homePieceOfFurnitureArray, bl));
            }
        }
    }

    private static void doDistributeFurnitureAlongAxis(HomePieceOfFurniture[] homePieceOfFurnitureArray, boolean bl) {
        Line2D.Float float_ = bl ? new Line2D.Float(0.0f, 0.0f, 0.0f, -1.0f) : new Line2D.Float(0.0f, 0.0f, 1.0f, 0.0f);
        List<HomePieceOfFurniture> list = FurnitureController.sortFurniture(homePieceOfFurnitureArray, null, float_);
        float f = (float)(bl ? 0.0 : 1.5707963267948966);
        HomePieceOfFurniture homePieceOfFurniture = list.get(0);
        double d = FurnitureController.getPieceBoundingRectangleWidth(homePieceOfFurniture, f) / 2.0;
        HomePieceOfFurniture homePieceOfFurniture2 = list.get(list.size() - 1);
        double d2 = FurnitureController.getPieceBoundingRectangleWidth(homePieceOfFurniture2, f) / 2.0;
        double d3 = Math.abs(float_.ptLineDist(homePieceOfFurniture2.getX(), homePieceOfFurniture2.getY()) * (double)float_.relativeCCW(homePieceOfFurniture2.getX(), homePieceOfFurniture2.getY()) - float_.ptLineDist(homePieceOfFurniture.getX(), homePieceOfFurniture.getY()) * (double)float_.relativeCCW(homePieceOfFurniture.getX(), homePieceOfFurniture.getY())) - d2 - d;
        double[] dArray = new double[list.size() - 2];
        for (int i = 1; i < list.size() - 1; ++i) {
            HomePieceOfFurniture homePieceOfFurniture3 = list.get(i);
            dArray[i - 1] = FurnitureController.getPieceBoundingRectangleWidth(homePieceOfFurniture3, f);
            d3 -= dArray[i - 1];
        }
        float f2 = (bl ? homePieceOfFurniture.getX() : homePieceOfFurniture.getY()) + (float)(d + (d3 /= (double)(list.size() - 1)));
        for (int i = 1; i < list.size() - 1; ++i) {
            HomePieceOfFurniture homePieceOfFurniture4 = list.get(i);
            if (bl) {
                homePieceOfFurniture4.setX((float)((double)f2 + dArray[i - 1] / 2.0));
            } else {
                homePieceOfFurniture4.setY((float)((double)f2 + dArray[i - 1] / 2.0));
            }
            f2 = (float)((double)f2 + (d3 + dArray[i - 1]));
        }
    }

    public void resetFurnitureElevation() {
        HomePieceOfFurniture[] homePieceOfFurnitureArray = this.getMovableSelectedFurniture();
        if (homePieceOfFurnitureArray.length >= 1) {
            List<Selectable> list = this.home.getSelectedItems();
            float[] fArray = new float[homePieceOfFurnitureArray.length];
            float[] fArray2 = new float[homePieceOfFurnitureArray.length];
            for (int i = 0; i < homePieceOfFurnitureArray.length; ++i) {
                HomePieceOfFurniture homePieceOfFurniture = homePieceOfFurnitureArray[i];
                fArray[i] = homePieceOfFurniture.getElevation();
                HomePieceOfFurniture homePieceOfFurniture2 = this.getHighestSurroundingPieceOfFurniture(homePieceOfFurniture, Arrays.asList(homePieceOfFurnitureArray));
                if (homePieceOfFurniture2 != null) {
                    float f = homePieceOfFurniture2.getElevation() + homePieceOfFurniture2.getHeightInPlan() * homePieceOfFurniture2.getDropOnTopElevation();
                    if (homePieceOfFurniture2.getLevel() != null) {
                        f += homePieceOfFurniture2.getLevel().getElevation() - homePieceOfFurniture.getLevel().getElevation();
                    }
                    fArray2[i] = Math.max(0.0f, f);
                    continue;
                }
                fArray2[i] = 0.0f;
            }
            this.home.setSelectedItems(Arrays.asList(homePieceOfFurnitureArray));
            FurnitureController.doSetFurnitureElevation(homePieceOfFurnitureArray, fArray2);
            if (this.undoSupport != null) {
                this.undoSupport.postEdit(new FurnitureElevationResetUndoableEdit(this.home, this.preferences, list.toArray(new Selectable[list.size()]), fArray, homePieceOfFurnitureArray, fArray2));
            }
        }
    }

    private static void doSetFurnitureElevation(HomePieceOfFurniture[] homePieceOfFurnitureArray, float[] fArray) {
        for (int i = 0; i < homePieceOfFurnitureArray.length; ++i) {
            homePieceOfFurnitureArray[i].setElevation(fArray[i]);
        }
    }

    protected HomePieceOfFurniture getHighestSurroundingPieceOfFurniture(HomePieceOfFurniture homePieceOfFurniture) {
        List<HomePieceOfFurniture> list = Collections.emptyList();
        return this.getHighestSurroundingPieceOfFurniture(homePieceOfFurniture, list);
    }

    private HomePieceOfFurniture getHighestSurroundingPieceOfFurniture(HomePieceOfFurniture homePieceOfFurniture, List<HomePieceOfFurniture> list) {
        float[][] fArray = homePieceOfFurniture.getPoints();
        float f = Math.min(homePieceOfFurniture.getWidthInPlan(), homePieceOfFurniture.getDepthInPlan()) * 0.05f;
        HomePieceOfFurniture homePieceOfFurniture2 = null;
        float f2 = Float.MIN_VALUE;
        for (HomePieceOfFurniture homePieceOfFurniture3 : this.getFurnitureInSameGroup(homePieceOfFurniture)) {
            float f3;
            if (homePieceOfFurniture3 == homePieceOfFurniture || list.contains(homePieceOfFurniture3) || !this.isPieceOfFurnitureVisibleAtSelectedLevel(homePieceOfFurniture3) || !(homePieceOfFurniture3.getDropOnTopElevation() >= 0.0f)) continue;
            boolean bl = true;
            for (float[] fArray2 : fArray) {
                if (homePieceOfFurniture3.containsPoint(fArray2[0], fArray2[1], f)) continue;
                bl = false;
                break;
            }
            if (!bl || !((f3 = homePieceOfFurniture3.getElevation() + homePieceOfFurniture3.getHeightInPlan() * homePieceOfFurniture3.getDropOnTopElevation()) > f2)) continue;
            f2 = f3;
            homePieceOfFurniture2 = homePieceOfFurniture3;
        }
        return homePieceOfFurniture2;
    }

    protected List<HomePieceOfFurniture> getFurnitureInSameGroup(HomePieceOfFurniture homePieceOfFurniture) {
        List<HomePieceOfFurniture> list = this.home.getFurniture();
        List<HomePieceOfFurniture> list2 = FurnitureController.getFurnitureInSameGroup(homePieceOfFurniture, list);
        if (list2 != null) {
            return list2;
        }
        return list;
    }

    private static List<HomePieceOfFurniture> getFurnitureInSameGroup(HomePieceOfFurniture homePieceOfFurniture, List<HomePieceOfFurniture> list) {
        for (HomePieceOfFurniture homePieceOfFurniture2 : list) {
            List<HomePieceOfFurniture> list2;
            if (homePieceOfFurniture2 == homePieceOfFurniture) {
                return list;
            }
            if (!(homePieceOfFurniture2 instanceof HomeFurnitureGroup) || (list2 = FurnitureController.getFurnitureInSameGroup(homePieceOfFurniture, ((HomeFurnitureGroup)homePieceOfFurniture2).getFurniture())) == null) continue;
            return list2;
        }
        return null;
    }

    protected boolean isPieceOfFurnitureVisibleAtSelectedLevel(HomePieceOfFurniture homePieceOfFurniture) {
        Level level = this.home.getSelectedLevel();
        return !(!homePieceOfFurniture.isVisible() || homePieceOfFurniture.getLevel() != null && !homePieceOfFurniture.getLevel().isViewable() || homePieceOfFurniture.getLevel() != level && !homePieceOfFurniture.isAtLevel(level));
    }

    public void setVisualProperty(String string, Object object) {
        this.home.setVisualProperty(string, object);
    }

    public void setHomeProperty(String string, String string2) {
        this.home.setProperty(string, string2);
    }

    private static class FurnitureAdditionUndoableEdit
    extends LocalizedUndoableEdit {
        private final Home home;
        private final boolean allLevelsSelection;
        private final Selectable[] oldSelection;
        private final boolean oldBasePlanLocked;
        private final HomePieceOfFurniture[] newFurniture;
        private final int[] newFurnitureIndex;
        private final HomeFurnitureGroup[] newFurnitureGroups;
        private final Level[] newFurnitureLevels;
        private final Level furnitureLevel;
        private final boolean newBasePlanLocked;

        public FurnitureAdditionUndoableEdit(Home home, UserPreferences userPreferences, Selectable[] selectableArray, boolean bl, boolean bl2, HomePieceOfFurniture[] homePieceOfFurnitureArray, int[] nArray, HomeFurnitureGroup[] homeFurnitureGroupArray, Level[] levelArray, Level level, boolean bl3) {
            super(userPreferences, FurnitureController.class, "undoAddFurnitureName");
            this.home = home;
            this.oldSelection = selectableArray;
            this.oldBasePlanLocked = bl;
            this.allLevelsSelection = bl2;
            this.newFurniture = homePieceOfFurnitureArray;
            this.newFurnitureIndex = nArray;
            this.newFurnitureGroups = homeFurnitureGroupArray;
            this.newFurnitureLevels = levelArray;
            this.furnitureLevel = level;
            this.newBasePlanLocked = bl3;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            FurnitureController.doDeleteFurniture(this.home, this.newFurniture, this.oldBasePlanLocked, this.allLevelsSelection);
            this.home.setSelectedItems(Arrays.asList(this.oldSelection));
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            FurnitureController.doAddFurniture(this.home, this.newFurniture, this.newFurnitureGroups, this.newFurnitureIndex, this.furnitureLevel, this.newFurnitureLevels, this.newBasePlanLocked, false);
        }
    }

    private static class FurnitureDeletionUndoableEdit
    extends LocalizedUndoableEdit {
        private final Home home;
        private final Selectable[] oldSelection;
        private final boolean basePlanLocked;
        private final boolean allLevelsSelection;
        private final HomePieceOfFurniture[] furniture;
        private final int[] furnitureIndex;
        private final HomeFurnitureGroup[] furnitureGroups;
        private final Level[] furnitureLevels;

        public FurnitureDeletionUndoableEdit(Home home, UserPreferences userPreferences, Selectable[] selectableArray, boolean bl, boolean bl2, HomePieceOfFurniture[] homePieceOfFurnitureArray, int[] nArray, HomeFurnitureGroup[] homeFurnitureGroupArray, Level[] levelArray) {
            super(userPreferences, FurnitureController.class, "undoDeleteSelectionName");
            this.home = home;
            this.oldSelection = selectableArray;
            this.basePlanLocked = bl;
            this.allLevelsSelection = bl2;
            this.furniture = homePieceOfFurnitureArray;
            this.furnitureIndex = nArray;
            this.furnitureGroups = homeFurnitureGroupArray;
            this.furnitureLevels = levelArray;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            FurnitureController.doAddFurniture(this.home, this.furniture, this.furnitureGroups, this.furnitureIndex, null, this.furnitureLevels, this.basePlanLocked, this.allLevelsSelection);
            this.home.setSelectedItems(Arrays.asList(this.oldSelection));
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.home.setSelectedItems(Arrays.asList(this.furniture));
            FurnitureController.doDeleteFurniture(this.home, this.furniture, this.basePlanLocked, false);
        }
    }

    private static class FurnitureGroupingUndoableEdit
    extends LocalizedUndoableEdit {
        private final Home home;
        private final Selectable[] oldSelection;
        private final boolean basePlanLocked;
        private final boolean allLevelsSelection;
        private final HomePieceOfFurniture[] groupedPieces;
        private final int[] groupedPiecesIndex;
        private final HomeFurnitureGroup[] groupedPiecesGroups;
        private final Level[] groupedPiecesLevel;
        private final float[] groupedPiecesElevation;
        private final boolean[] groupedPiecesVisible;
        private final HomeFurnitureGroup newGroup;
        private final int groupIndex;
        private final Level groupLevel;
        private final float[] groupPiecesNewElevation;
        private final boolean movable;

        public FurnitureGroupingUndoableEdit(Home home, UserPreferences userPreferences, Selectable[] selectableArray, boolean bl, boolean bl2, HomePieceOfFurniture[] homePieceOfFurnitureArray, int[] nArray, HomeFurnitureGroup[] homeFurnitureGroupArray, Level[] levelArray, float[] fArray, boolean[] blArray, HomeFurnitureGroup homeFurnitureGroup, int n, Level level, float[] fArray2, boolean bl3) {
            super(userPreferences, FurnitureController.class, "undoGroupName");
            this.home = home;
            this.basePlanLocked = bl;
            this.oldSelection = selectableArray;
            this.allLevelsSelection = bl2;
            this.groupedPieces = homePieceOfFurnitureArray;
            this.groupedPiecesIndex = nArray;
            this.groupedPiecesGroups = homeFurnitureGroupArray;
            this.groupedPiecesLevel = levelArray;
            this.groupedPiecesElevation = fArray;
            this.groupedPiecesVisible = blArray;
            this.newGroup = homeFurnitureGroup;
            this.groupIndex = n;
            this.groupLevel = level;
            this.groupPiecesNewElevation = fArray2;
            this.movable = bl3;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            FurnitureController.doUngroupFurniture(this.home, new HomeFurnitureGroup[]{this.newGroup}, this.groupedPieces, this.groupedPiecesGroups, this.groupedPiecesIndex, this.groupedPiecesLevel, this.basePlanLocked, this.allLevelsSelection);
            for (int i = 0; i < this.groupedPieces.length; ++i) {
                this.groupedPieces[i].setElevation(this.groupedPiecesElevation[i]);
                this.groupedPieces[i].setVisible(this.groupedPiecesVisible[i]);
            }
            this.home.setSelectedItems(Arrays.asList(this.oldSelection));
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            for (int i = 0; i < this.groupedPieces.length; ++i) {
                this.groupedPieces[i].setElevation(this.groupPiecesNewElevation[i]);
                this.groupedPieces[i].setLevel(null);
            }
            this.newGroup.setMovable(this.movable);
            this.newGroup.setVisible(true);
            FurnitureController.doGroupFurniture(this.home, this.groupedPieces, new HomeFurnitureGroup[]{this.newGroup}, null, new int[]{this.groupIndex}, new Level[]{this.groupLevel}, this.basePlanLocked, false);
        }
    }

    private static class FurnitureUngroupingUndoableEdit
    extends LocalizedUndoableEdit {
        private final Home home;
        private final boolean oldBasePlanLocked;
        private final Selectable[] oldSelection;
        private final boolean allLevelsSelection;
        private final HomeFurnitureGroup[] groups;
        private final int[] groupsIndex;
        private final HomeFurnitureGroup[] groupsGroups;
        private final Level[] groupsLevels;
        private final HomePieceOfFurniture[] ungroupedPieces;
        private final int[] ungroupedPiecesIndex;
        private final HomeFurnitureGroup[] ungroupedPiecesGroups;
        private final Level[] ungroupedPiecesLevels;
        private final boolean newBasePlanLocked;

        public FurnitureUngroupingUndoableEdit(Home home, UserPreferences userPreferences, Selectable[] selectableArray, boolean bl, boolean bl2, HomeFurnitureGroup[] homeFurnitureGroupArray, int[] nArray, HomeFurnitureGroup[] homeFurnitureGroupArray2, Level[] levelArray, HomePieceOfFurniture[] homePieceOfFurnitureArray, int[] nArray2, HomeFurnitureGroup[] homeFurnitureGroupArray3, Level[] levelArray2, boolean bl3) {
            super(userPreferences, FurnitureController.class, "undoUngroupName");
            this.home = home;
            this.oldSelection = selectableArray;
            this.oldBasePlanLocked = bl;
            this.allLevelsSelection = bl2;
            this.groups = homeFurnitureGroupArray;
            this.groupsIndex = nArray;
            this.groupsGroups = homeFurnitureGroupArray2;
            this.groupsLevels = levelArray;
            this.ungroupedPieces = homePieceOfFurnitureArray;
            this.ungroupedPiecesIndex = nArray2;
            this.ungroupedPiecesGroups = homeFurnitureGroupArray3;
            this.ungroupedPiecesLevels = levelArray2;
            this.newBasePlanLocked = bl3;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            FurnitureController.doGroupFurniture(this.home, this.ungroupedPieces, this.groups, this.groupsGroups, this.groupsIndex, this.groupsLevels, this.oldBasePlanLocked, this.allLevelsSelection);
            this.home.setSelectedItems(Arrays.asList(this.oldSelection));
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            FurnitureController.doUngroupFurniture(this.home, this.groups, this.ungroupedPieces, this.ungroupedPiecesGroups, this.ungroupedPiecesIndex, this.ungroupedPiecesLevels, this.newBasePlanLocked, false);
        }
    }

    private static class FurnitureTopAlignmentUndoableEdit
    extends FurnitureAlignmentUndoableEdit {
        public FurnitureTopAlignmentUndoableEdit(Home home, UserPreferences userPreferences, Selectable[] selectableArray, HomePieceOfFurniture[] homePieceOfFurnitureArray, HomePieceOfFurniture homePieceOfFurniture) {
            super(home, userPreferences, selectableArray, homePieceOfFurnitureArray, homePieceOfFurniture);
        }

        @Override
        void alignFurniture(HomePieceOfFurniture[] homePieceOfFurnitureArray, HomePieceOfFurniture homePieceOfFurniture) {
            float f = FurnitureController.getMinY(homePieceOfFurniture);
            for (HomePieceOfFurniture homePieceOfFurniture2 : homePieceOfFurnitureArray) {
                float f2 = FurnitureController.getMinY(homePieceOfFurniture2);
                homePieceOfFurniture2.setY(homePieceOfFurniture2.getY() + f - f2);
            }
        }
    }

    private static abstract class FurnitureAlignmentUndoableEdit
    extends LocalizedUndoableEdit {
        private final Home home;
        private final Selectable[] oldSelection;
        private final HomePieceOfFurniture[] selectedFurniture;
        private final HomePieceOfFurniture leadPiece;
        private final HomePieceOfFurniture[] alignedFurniture;
        private final float[] oldX;
        private final float[] oldY;

        public FurnitureAlignmentUndoableEdit(Home home, UserPreferences userPreferences, Selectable[] selectableArray, HomePieceOfFurniture[] homePieceOfFurnitureArray, HomePieceOfFurniture homePieceOfFurniture) {
            super(userPreferences, FurnitureController.class, "undoAlignName");
            this.home = home;
            this.oldSelection = selectableArray;
            this.selectedFurniture = homePieceOfFurnitureArray;
            this.leadPiece = homePieceOfFurniture;
            this.alignedFurniture = new HomePieceOfFurniture[homePieceOfFurniture == null ? homePieceOfFurnitureArray.length : homePieceOfFurnitureArray.length - 1];
            this.oldX = new float[this.alignedFurniture.length];
            this.oldY = new float[this.alignedFurniture.length];
            int n = 0;
            for (HomePieceOfFurniture homePieceOfFurniture2 : homePieceOfFurnitureArray) {
                if (homePieceOfFurniture2 == homePieceOfFurniture) continue;
                this.alignedFurniture[n] = homePieceOfFurniture2;
                this.oldX[n] = homePieceOfFurniture2.getX();
                this.oldY[n] = homePieceOfFurniture2.getY();
                ++n;
            }
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            FurnitureController.undoAlignFurniture(this.alignedFurniture, this.oldX, this.oldY);
            this.home.setSelectedItems(Arrays.asList(this.oldSelection));
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.home.setSelectedItems(Arrays.asList(this.selectedFurniture));
            this.alignFurniture();
        }

        public void alignFurniture() {
            this.alignFurniture(this.alignedFurniture, this.leadPiece);
        }

        abstract void alignFurniture(HomePieceOfFurniture[] var1, HomePieceOfFurniture var2);
    }

    private static class FurnitureBottomAlignmentUndoableEdit
    extends FurnitureAlignmentUndoableEdit {
        public FurnitureBottomAlignmentUndoableEdit(Home home, UserPreferences userPreferences, Selectable[] selectableArray, HomePieceOfFurniture[] homePieceOfFurnitureArray, HomePieceOfFurniture homePieceOfFurniture) {
            super(home, userPreferences, selectableArray, homePieceOfFurnitureArray, homePieceOfFurniture);
        }

        @Override
        void alignFurniture(HomePieceOfFurniture[] homePieceOfFurnitureArray, HomePieceOfFurniture homePieceOfFurniture) {
            float f = FurnitureController.getMaxY(homePieceOfFurniture);
            for (HomePieceOfFurniture homePieceOfFurniture2 : homePieceOfFurnitureArray) {
                float f2 = FurnitureController.getMaxY(homePieceOfFurniture2);
                homePieceOfFurniture2.setY(homePieceOfFurniture2.getY() + f - f2);
            }
        }
    }

    private static class FurnitureLeftAlignmentUndoableEdit
    extends FurnitureAlignmentUndoableEdit {
        public FurnitureLeftAlignmentUndoableEdit(Home home, UserPreferences userPreferences, Selectable[] selectableArray, HomePieceOfFurniture[] homePieceOfFurnitureArray, HomePieceOfFurniture homePieceOfFurniture) {
            super(home, userPreferences, selectableArray, homePieceOfFurnitureArray, homePieceOfFurniture);
        }

        @Override
        void alignFurniture(HomePieceOfFurniture[] homePieceOfFurnitureArray, HomePieceOfFurniture homePieceOfFurniture) {
            float f = FurnitureController.getMinX(homePieceOfFurniture);
            for (HomePieceOfFurniture homePieceOfFurniture2 : homePieceOfFurnitureArray) {
                float f2 = FurnitureController.getMinX(homePieceOfFurniture2);
                homePieceOfFurniture2.setX(homePieceOfFurniture2.getX() + f - f2);
            }
        }
    }

    private static class FurnitureRightAlignmentUndoableEdit
    extends FurnitureAlignmentUndoableEdit {
        public FurnitureRightAlignmentUndoableEdit(Home home, UserPreferences userPreferences, Selectable[] selectableArray, HomePieceOfFurniture[] homePieceOfFurnitureArray, HomePieceOfFurniture homePieceOfFurniture) {
            super(home, userPreferences, selectableArray, homePieceOfFurnitureArray, homePieceOfFurniture);
        }

        @Override
        void alignFurniture(HomePieceOfFurniture[] homePieceOfFurnitureArray, HomePieceOfFurniture homePieceOfFurniture) {
            float f = FurnitureController.getMaxX(homePieceOfFurniture);
            for (HomePieceOfFurniture homePieceOfFurniture2 : homePieceOfFurnitureArray) {
                float f2 = FurnitureController.getMaxX(homePieceOfFurniture2);
                homePieceOfFurniture2.setX(homePieceOfFurniture2.getX() + f - f2);
            }
        }
    }

    private static class FurnitureFrontSideAlignmentUndoableEdit
    extends FurnitureAlignmentUndoableEdit {
        public FurnitureFrontSideAlignmentUndoableEdit(Home home, UserPreferences userPreferences, Selectable[] selectableArray, HomePieceOfFurniture[] homePieceOfFurnitureArray, HomePieceOfFurniture homePieceOfFurniture) {
            super(home, userPreferences, selectableArray, homePieceOfFurnitureArray, homePieceOfFurniture);
        }

        @Override
        void alignFurniture(HomePieceOfFurniture[] homePieceOfFurnitureArray, HomePieceOfFurniture homePieceOfFurniture) {
            float[][] fArray = homePieceOfFurniture.getPoints();
            Line2D.Float float_ = new Line2D.Float(fArray[2][0], fArray[2][1], fArray[3][0], fArray[3][1]);
            for (HomePieceOfFurniture homePieceOfFurniture2 : homePieceOfFurnitureArray) {
                FurnitureController.alignPieceOfFurnitureAlongSides(homePieceOfFurniture2, homePieceOfFurniture, float_, true, null, 0.0f);
            }
        }
    }

    private static class FurnitureBackSideAlignmentUndoableEdit
    extends FurnitureAlignmentUndoableEdit {
        public FurnitureBackSideAlignmentUndoableEdit(Home home, UserPreferences userPreferences, Selectable[] selectableArray, HomePieceOfFurniture[] homePieceOfFurnitureArray, HomePieceOfFurniture homePieceOfFurniture) {
            super(home, userPreferences, selectableArray, homePieceOfFurnitureArray, homePieceOfFurniture);
        }

        @Override
        void alignFurniture(HomePieceOfFurniture[] homePieceOfFurnitureArray, HomePieceOfFurniture homePieceOfFurniture) {
            float[][] fArray = homePieceOfFurniture.getPoints();
            Line2D.Float float_ = new Line2D.Float(fArray[0][0], fArray[0][1], fArray[1][0], fArray[1][1]);
            for (HomePieceOfFurniture homePieceOfFurniture2 : homePieceOfFurnitureArray) {
                FurnitureController.alignPieceOfFurnitureAlongSides(homePieceOfFurniture2, homePieceOfFurniture, float_, false, null, 0.0f);
            }
        }
    }

    private static class FurnitureLeftSideAlignmentUndoableEdit
    extends FurnitureAlignmentUndoableEdit {
        public FurnitureLeftSideAlignmentUndoableEdit(Home home, UserPreferences userPreferences, Selectable[] selectableArray, HomePieceOfFurniture[] homePieceOfFurnitureArray, HomePieceOfFurniture homePieceOfFurniture) {
            super(home, userPreferences, selectableArray, homePieceOfFurnitureArray, homePieceOfFurniture);
        }

        @Override
        void alignFurniture(HomePieceOfFurniture[] homePieceOfFurnitureArray, HomePieceOfFurniture homePieceOfFurniture) {
            float[][] fArray = homePieceOfFurniture.getPoints();
            Line2D.Float float_ = new Line2D.Float(fArray[3][0], fArray[3][1], fArray[0][0], fArray[0][1]);
            for (HomePieceOfFurniture homePieceOfFurniture2 : homePieceOfFurnitureArray) {
                FurnitureController.alignPieceOfFurnitureAlongLeftOrRightSides(homePieceOfFurniture2, homePieceOfFurniture, float_, false);
            }
        }
    }

    private static class FurnitureRightSideAlignmentUndoableEdit
    extends FurnitureAlignmentUndoableEdit {
        public FurnitureRightSideAlignmentUndoableEdit(Home home, UserPreferences userPreferences, Selectable[] selectableArray, HomePieceOfFurniture[] homePieceOfFurnitureArray, HomePieceOfFurniture homePieceOfFurniture) {
            super(home, userPreferences, selectableArray, homePieceOfFurnitureArray, homePieceOfFurniture);
        }

        @Override
        void alignFurniture(HomePieceOfFurniture[] homePieceOfFurnitureArray, HomePieceOfFurniture homePieceOfFurniture) {
            float[][] fArray = homePieceOfFurniture.getPoints();
            Line2D.Float float_ = new Line2D.Float(fArray[1][0], fArray[1][1], fArray[2][0], fArray[2][1]);
            for (HomePieceOfFurniture homePieceOfFurniture2 : homePieceOfFurnitureArray) {
                FurnitureController.alignPieceOfFurnitureAlongLeftOrRightSides(homePieceOfFurniture2, homePieceOfFurniture, float_, true);
            }
        }
    }

    private static class FurnitureSideBySideAlignmentUndoableEdit
    extends FurnitureAlignmentUndoableEdit {
        public FurnitureSideBySideAlignmentUndoableEdit(Home home, UserPreferences userPreferences, Selectable[] selectableArray, HomePieceOfFurniture[] homePieceOfFurnitureArray, HomePieceOfFurniture homePieceOfFurniture) {
            super(home, userPreferences, selectableArray, homePieceOfFurnitureArray, homePieceOfFurniture);
        }

        @Override
        void alignFurniture(HomePieceOfFurniture[] homePieceOfFurnitureArray, HomePieceOfFurniture homePieceOfFurniture) {
            int n;
            float[][] fArray = homePieceOfFurniture.getPoints();
            Line2D.Float float_ = new Line2D.Float(homePieceOfFurniture.getX(), homePieceOfFurniture.getY(), (fArray[0][0] + fArray[1][0]) / 2.0f, (fArray[0][1] + fArray[1][1]) / 2.0f);
            List list = FurnitureController.sortFurniture(homePieceOfFurnitureArray, homePieceOfFurniture, float_);
            int n2 = list.indexOf(homePieceOfFurniture);
            Line2D.Float float_2 = new Line2D.Float(fArray[0][0], fArray[0][1], fArray[1][0], fArray[1][1]);
            float f = homePieceOfFurniture.getWidthInPlan() / 2.0f;
            for (n = n2 + 1; n < list.size(); ++n) {
                f = (float)((double)f + FurnitureController.alignPieceOfFurnitureAlongSides((HomePieceOfFurniture)list.get(n), homePieceOfFurniture, float_2, false, float_, f));
            }
            f = -homePieceOfFurniture.getWidthInPlan() / 2.0f;
            for (n = n2 - 1; n >= 0; --n) {
                f = (float)((double)f - FurnitureController.alignPieceOfFurnitureAlongSides((HomePieceOfFurniture)list.get(n), homePieceOfFurniture, float_2, false, float_, f));
            }
        }
    }

    private static class FurnitureDistributionUndoableEdit
    extends LocalizedUndoableEdit {
        private final Home home;
        private final Selectable[] oldSelection;
        private float[] oldX;
        private float[] oldY;
        private final HomePieceOfFurniture[] alignedFurniture;
        private final boolean horizontal;

        public FurnitureDistributionUndoableEdit(Home home, UserPreferences userPreferences, Selectable[] selectableArray, float[] fArray, float[] fArray2, HomePieceOfFurniture[] homePieceOfFurnitureArray, boolean bl) {
            super(userPreferences, FurnitureController.class, "undoDistributeName");
            this.home = home;
            this.oldSelection = selectableArray;
            this.oldX = fArray;
            this.oldY = fArray2;
            this.alignedFurniture = homePieceOfFurnitureArray;
            this.horizontal = bl;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            FurnitureController.undoAlignFurniture(this.alignedFurniture, this.oldX, this.oldY);
            this.home.setSelectedItems(Arrays.asList(this.oldSelection));
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.home.setSelectedItems(Arrays.asList(this.alignedFurniture));
            FurnitureController.doDistributeFurnitureAlongAxis(this.alignedFurniture, this.horizontal);
        }
    }

    private static class FurnitureElevationResetUndoableEdit
    extends LocalizedUndoableEdit {
        private final Home home;
        private final Selectable[] oldSelection;
        private final float[] furnitureOldElevation;
        private final HomePieceOfFurniture[] selectedFurniture;
        private float[] furnitureNewElevation;

        public FurnitureElevationResetUndoableEdit(Home home, UserPreferences userPreferences, Selectable[] selectableArray, float[] fArray, HomePieceOfFurniture[] homePieceOfFurnitureArray, float[] fArray2) {
            super(userPreferences, FurnitureController.class, "undoResetElevation");
            this.home = home;
            this.oldSelection = selectableArray;
            this.furnitureOldElevation = fArray;
            this.selectedFurniture = homePieceOfFurnitureArray;
            this.furnitureNewElevation = fArray2;
        }

        @Override
        public void undo() throws CannotUndoException {
            super.undo();
            FurnitureController.doSetFurnitureElevation(this.selectedFurniture, this.furnitureOldElevation);
            this.home.setSelectedItems(Arrays.asList(this.oldSelection));
        }

        @Override
        public void redo() throws CannotRedoException {
            super.redo();
            this.home.setSelectedItems(Arrays.asList(this.selectedFurniture));
            FurnitureController.doSetFurnitureElevation(this.selectedFurniture, this.furnitureNewElevation);
        }
    }
}

