/*
 * Decompiled with CFR 0.152.
 */
package javax.media.j3d;

import javax.media.j3d.BehaviorRetained;
import javax.media.j3d.BehaviorStructure;
import javax.media.j3d.Bounds;
import javax.media.j3d.J3dI18N;
import javax.media.j3d.Sensor;
import javax.media.j3d.WakeupCriterion;
import javax.media.j3d.WakeupIndexedList;

public final class WakeupOnSensorEntry
extends WakeupCriterion {
    static final int COND_IN_BS_LIST = 0;
    static final int SENSORENTRY_IN_BS_LIST = 1;
    static final int TOTAL_INDEXED_UNORDER_SET_TYPES = 2;
    Bounds region;
    Bounds transformedRegion;
    Sensor armingSensor;

    public WakeupOnSensorEntry(Bounds bounds) {
        this.region = (Bounds)bounds.clone();
        WakeupIndexedList.init(this, 2);
    }

    public Bounds getBounds() {
        return (Bounds)this.region.clone();
    }

    void updateTransformRegion() {
        if (this.transformedRegion != null) {
            this.transformedRegion.set(this.region);
        } else {
            this.transformedRegion = (Bounds)this.region.clone();
        }
        this.transformedRegion.transform(this.behav.getCurrentLocalToVworld(null));
    }

    @Override
    void addBehaviorCondition(BehaviorStructure behaviorStructure) {
        behaviorStructure.addSensorEntryCondition(this);
        if (this.behav != null && this.behav.enable) {
            ++behaviorStructure.activeWakeupOnSensorCount;
        }
    }

    @Override
    void removeBehaviorCondition(BehaviorStructure behaviorStructure) {
        behaviorStructure.removeSensorEntryCondition(this);
        if (this.behav != null && this.behav.enable) {
            --behaviorStructure.activeWakeupOnSensorCount;
        }
    }

    void setTarget(Sensor sensor) {
        this.armingSensor = sensor;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Sensor getTriggeringSensor() {
        if (this.behav == null) {
            throw new IllegalStateException(J3dI18N.getString("WakeupOnSensorEntry0"));
        }
        BehaviorRetained behaviorRetained = this.behav;
        synchronized (behaviorRetained) {
            if (!this.behav.inCallback) {
                throw new IllegalStateException(J3dI18N.getString("WakeupOnSensorEntry0"));
            }
        }
        return this.armingSensor;
    }

    @Override
    void resetBehaviorCondition(BehaviorStructure behaviorStructure) {
    }
}

