/*
 * Decompiled with CFR 0.152.
 */
package org.netbeans;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.logging.Level;
import org.netbeans.InvalidException;
import org.netbeans.Module;
import org.netbeans.ProxyClassLoader;
import org.netbeans.Util;
import org.openide.util.Exceptions;
import org.openide.util.Mutex;

final class NetigsoLoader
extends ClassLoader {
    private final Module mi;

    public NetigsoLoader(Module module) {
        this.mi = module;
    }

    @Override
    public Class<?> loadClass(String string) throws ClassNotFoundException {
        ClassLoader classLoader = this.getDelegate(10000L);
        if (classLoader == null) {
            Util.err.log(Level.WARNING, "Time out waiting to enabled {0}. Cannot load {1}", new Object[]{this.mi.getCodeNameBase(), string});
            throw new ClassNotFoundException(string);
        }
        return classLoader.loadClass(string);
    }

    @Override
    protected Class<?> loadClass(String string, boolean bl) throws ClassNotFoundException {
        ClassLoader classLoader = this.getDelegate();
        if (classLoader instanceof ProxyClassLoader) {
            return ((ProxyClassLoader)classLoader).loadClass(string, bl);
        }
        return classLoader.loadClass(string);
    }

    @Override
    public Enumeration<URL> getResources(String string) throws IOException {
        return this.getDelegate().getResources(string);
    }

    @Override
    public InputStream getResourceAsStream(String string) {
        return this.getDelegate().getResourceAsStream(string);
    }

    @Override
    public URL getResource(String string) {
        return this.getDelegate().getResource(string);
    }

    private ClassLoader getDelegate() {
        return this.getDelegate(0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ClassLoader getDelegate(long l) {
        if (!this.mi.isEnabled()) {
            Util.err.log(Level.INFO, "OSGi is requesting adhoc start of {0}. This is inefficient. It is suggested turn the module on by default", this.mi.getCodeNameBase());
            Mutex.Privileged privileged = this.mi.getManager().mutexPrivileged();
            if (!privileged.tryWriteAccess(l)) {
                return null;
            }
            try {
                this.mi.getManager().enable(this.mi, false);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                Exceptions.printStackTrace((Throwable)illegalArgumentException);
            }
            catch (InvalidException invalidException) {
                Exceptions.printStackTrace((Throwable)invalidException);
            }
            finally {
                privileged.exitWriteAccess();
            }
        }
        return this.mi.getClassLoader();
    }
}

