/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.profiling.presets;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.UIManager;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import org.graalvm.visualvm.core.ui.components.Spacer;
import org.graalvm.visualvm.lib.common.ProfilingSettings;
import org.graalvm.visualvm.lib.jfluid.client.ClientUtils;
import org.graalvm.visualvm.lib.jfluid.filters.GenericFilter;
import org.graalvm.visualvm.lib.jfluid.filters.TextFilter;
import org.graalvm.visualvm.lib.jfluid.results.jdbc.JdbcCCTProvider;
import org.graalvm.visualvm.lib.profiler.api.ProfilerIDESettings;
import org.graalvm.visualvm.profiling.presets.PresetsUtils;
import org.graalvm.visualvm.profiling.presets.ProfilerCPUSettings;
import org.graalvm.visualvm.profiling.presets.ProfilerPreset;
import org.openide.awt.Mnemonics;
import org.openide.util.NbBundle;

public abstract class ProfilerJDBCPanel
extends JPanel {
    private static final String[] JDBC_MARKER_CLASSES = new String[]{JdbcCCTProvider.DRIVER_INTERFACE, JdbcCCTProvider.CONNECTION_INTERFACE, JdbcCCTProvider.STATEMENT_INTERFACE, JdbcCCTProvider.PREPARED_STATEMENT_INTERFACE, JdbcCCTProvider.CALLABLE_STATEMENT_INTERFACE};
    private JLabel filterLabel;
    private TextAreaComponent filterArea;
    private boolean internalChange;

    public ProfilerJDBCPanel() {
        this(false);
    }

    ProfilerJDBCPanel(boolean mnemonics) {
        this.initComponents(mnemonics);
    }

    public ProfilingSettings getSettings() {
        ProfilingSettings settings = ProfilerIDESettings.getInstance().createDefaultProfilingSettings();
        settings.setProfilingType(256);
        settings.setCPUProfilingType(0);
        ClientUtils.SourceCodeSelection[] roots = new ClientUtils.SourceCodeSelection[JDBC_MARKER_CLASSES.length];
        for (int i = 0; i < JDBC_MARKER_CLASSES.length; ++i) {
            roots[i] = new ClientUtils.SourceCodeSelection(JDBC_MARKER_CLASSES[i], "*", null);
            roots[i].setMarkerMethod(true);
        }
        settings.addRootMethods(roots);
        String filter = PresetsUtils.normalizeValue(this.getFilterValue());
        settings.setInstrumentationFilter((GenericFilter)new TextFilter(filter, 10, false));
        return settings;
    }

    public boolean settingsValid() {
        return true;
    }

    public void loadFromPreset(ProfilerPreset preset) {
        if (preset == null) {
            return;
        }
        this.internalChange = true;
        this.filterArea.getTextArea().setText(preset.getJDBCFilterP().trim());
        this.internalChange = false;
    }

    public void saveToPreset(ProfilerPreset preset) {
        if (preset == null) {
            return;
        }
        preset.setJDBCFilterP(this.getFilterValue());
    }

    public abstract void settingsChanged();

    private void syncUI() {
        if (this.internalChange) {
            return;
        }
        this.settingsChanged();
    }

    private String getFilterValue() {
        return this.filterArea.getTextArea().getText().trim();
    }

    @Override
    public void setEnabled(boolean enabled) {
        super.setEnabled(enabled);
        for (Component c : this.getComponents()) {
            c.setEnabled(enabled);
        }
    }

    private void initComponents(boolean mnemonics) {
        this.setOpaque(false);
        this.setLayout(new GridBagLayout());
        this.filterLabel = new JLabel();
        ProfilerJDBCPanel.setText(this.filterLabel, NbBundle.getMessage(ProfilerCPUSettings.class, (String)"LBL_Query_Filter"), mnemonics);
        Dimension d = this.filterLabel.getPreferredSize();
        JRadioButton refRadion = new JRadioButton(NbBundle.getMessage(ProfilerCPUSettings.class, (String)"LBL_Root_Classes"));
        refRadion.setBorder(this.filterLabel.getBorder());
        d.height = Math.max(d.height, refRadion.getPreferredSize().height);
        this.filterLabel.setPreferredSize(d);
        this.filterLabel.setToolTipText(NbBundle.getMessage(ProfilerCPUSettings.class, (String)"TOOLTIP_Query_Filter"));
        this.filterLabel.setOpaque(false);
        GridBagConstraints constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 1;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(10, 10, 5, 10);
        this.add((Component)this.filterLabel, constraints);
        this.filterArea = ProfilerJDBCPanel.createTextArea(2);
        this.filterLabel.setLabelFor(this.filterArea.getTextArea());
        this.filterArea.getTextArea().setToolTipText(NbBundle.getMessage(ProfilerCPUSettings.class, (String)"TOOLTIP_Query_Filter"));
        this.filterArea.getTextArea().getDocument().addDocumentListener(new DocumentListener(){

            @Override
            public void insertUpdate(DocumentEvent e) {
                ProfilerJDBCPanel.this.syncUI();
            }

            @Override
            public void removeUpdate(DocumentEvent e) {
                ProfilerJDBCPanel.this.syncUI();
            }

            @Override
            public void changedUpdate(DocumentEvent e) {
                ProfilerJDBCPanel.this.syncUI();
            }
        });
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 2;
        constraints.weightx = 1.0;
        constraints.weighty = 0.65;
        constraints.gridwidth = 0;
        constraints.anchor = 18;
        constraints.fill = 1;
        constraints.insets = new Insets(0, 10, 5, 10);
        this.add((Component)this.filterArea, constraints);
        JLabel hintLabel = new JLabel(NbBundle.getMessage(ProfilerCPUSettings.class, (String)"LBL_Query_Hint")){
            {
                super.setEnabled(false);
            }

            @Override
            public void setEnabled(boolean b) {
                super.setEnabled(false);
            }
        };
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 3;
        constraints.gridwidth = 0;
        constraints.anchor = 17;
        constraints.fill = 0;
        constraints.insets = new Insets(0, 10, 5, 10);
        this.add((Component)hintLabel, constraints);
        constraints = new GridBagConstraints();
        constraints.gridx = 0;
        constraints.gridy = 4;
        constraints.weightx = 1.0;
        constraints.weighty = 0.35;
        constraints.gridwidth = 0;
        constraints.anchor = 18;
        constraints.fill = 1;
        constraints.insets = new Insets(0, 0, 0, 0);
        this.add((Component)Spacer.create(), constraints);
    }

    private static void setText(JLabel l, String text, boolean mnemonics) {
        if (mnemonics) {
            Mnemonics.setLocalizedText((JLabel)l, (String)text);
        } else {
            l.setText(text.replace("&", ""));
        }
    }

    private static TextAreaComponent createTextArea(int rows) {
        final JTextArea rootsArea = new JTextArea();
        rootsArea.setFont(new Font("Monospaced", 0, UIManager.getFont("Label.font").getSize()));
        TextAreaComponent rootsAreaScrollPane = new TextAreaComponent(rootsArea, 20, 30){

            @Override
            public Dimension getMinimumSize() {
                return this.getPreferredSize();
            }

            @Override
            public void setEnabled(boolean enabled) {
                super.setEnabled(enabled);
                rootsArea.setEnabled(enabled);
            }
        };
        rootsAreaScrollPane.setBorder(BorderFactory.createLineBorder(Color.GRAY));
        JTextArea referenceArea = new JTextArea("X");
        referenceArea.setFont(rootsArea.getFont());
        referenceArea.setRows(rows);
        Insets insets = rootsAreaScrollPane.getInsets();
        rootsAreaScrollPane.setPreferredSize(new Dimension(1, referenceArea.getPreferredSize().height + (insets != null ? insets.top + insets.bottom : 0)));
        return rootsAreaScrollPane;
    }

    private static class TextAreaComponent
    extends JScrollPane {
        TextAreaComponent(JTextArea textArea, int vPolicy, int hPolicy) {
            super(textArea, vPolicy, hPolicy);
        }

        public JTextArea getTextArea() {
            return (JTextArea)this.getViewport().getView();
        }
    }
}

