/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.shared.utils.cli.javatool;

import java.io.File;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.Map;
import org.apache.maven.shared.utils.Os;
import org.apache.maven.shared.utils.StringUtils;
import org.apache.maven.shared.utils.cli.CommandLineException;
import org.apache.maven.shared.utils.cli.CommandLineUtils;
import org.apache.maven.shared.utils.cli.Commandline;
import org.apache.maven.shared.utils.cli.StreamConsumer;
import org.apache.maven.shared.utils.cli.javatool.JavaTool;
import org.apache.maven.shared.utils.cli.javatool.JavaToolException;
import org.apache.maven.shared.utils.cli.javatool.JavaToolRequest;
import org.apache.maven.shared.utils.cli.javatool.JavaToolResult;
import org.codehaus.plexus.logging.AbstractLogEnabled;

public abstract class AbstractJavaTool<Request extends JavaToolRequest>
extends AbstractLogEnabled
implements JavaTool<Request> {
    private final String javaToolName;
    private String javaToolFile;
    private Object toolchain;

    protected AbstractJavaTool(String javaToolName) {
        this.javaToolName = javaToolName;
    }

    protected abstract Commandline createCommandLine(Request var1, String var2) throws JavaToolException;

    @Override
    public String getJavaToolName() {
        return this.javaToolName;
    }

    @Override
    public void setToolchain(Object toolchain) {
        this.toolchain = toolchain;
    }

    @Override
    public JavaToolResult execute(Request request) throws JavaToolException {
        if (this.javaToolFile == null) {
            try {
                this.javaToolFile = this.findJavaToolExecutable();
            }
            catch (Exception e2) {
                throw new JavaToolException("Error finding " + this.javaToolName + " executable. Reason: " + e2.getMessage(), e2);
            }
        }
        Commandline cli2 = this.createCommandLine(request, this.javaToolFile);
        JavaToolResult result = this.executeCommandLine(cli2, request);
        return result;
    }

    protected InputStream createSystemInputStream() {
        InputStream systemIn = new InputStream(){

            @Override
            public int read() {
                return -1;
            }
        };
        return systemIn;
    }

    protected JavaToolResult executeCommandLine(Commandline cli2, Request request) {
        if (this.getLogger().isDebugEnabled()) {
            this.getLogger().debug("Executing: " + cli2);
        }
        JavaToolResult result = this.createResult();
        result.setCommandline(cli2);
        InputStream systemIn = this.createSystemInputStream();
        StreamConsumer systemOut = this.createSystemOutStreamConsumer(request);
        StreamConsumer systemErr = this.createSystemErrorStreamConsumer(request);
        try {
            int resultCode = CommandLineUtils.executeCommandLine(cli2, systemIn, systemOut, systemErr);
            result.setExitCode(resultCode);
        }
        catch (CommandLineException e2) {
            result.setExecutionException(e2);
        }
        return result;
    }

    protected StreamConsumer createSystemErrorStreamConsumer(Request request) {
        StreamConsumer systemErr = request.getSystemErrorStreamConsumer();
        if (systemErr == null) {
            systemErr = new StreamConsumer(){

                @Override
                public void consumeLine(String line) {
                    AbstractJavaTool.this.getLogger().warn(line);
                }
            };
        }
        return systemErr;
    }

    protected StreamConsumer createSystemOutStreamConsumer(Request request) {
        StreamConsumer systemOut = request.getSystemOutStreamConsumer();
        if (systemOut == null) {
            systemOut = new StreamConsumer(){

                @Override
                public void consumeLine(String line) {
                    AbstractJavaTool.this.getLogger().info(line);
                }
            };
        }
        return systemOut;
    }

    protected JavaToolResult createResult() {
        return new JavaToolResult();
    }

    protected String findJavaToolExecutable() {
        String executable = null;
        if (this.toolchain != null) {
            executable = this.findToolchainExecutable();
        }
        String command = this.javaToolName + (Os.isFamily("windows") ? ".exe" : "");
        if (executable == null) {
            executable = this.findExecutable(command, System.getProperty("java.home"), "../bin", "bin", "../sh");
        }
        if (executable == null) {
            String variable;
            String[] variables;
            Map<String, String> env = System.getenv();
            String[] stringArray = variables = new String[]{"JDK_HOME", "JAVA_HOME"};
            int n = stringArray.length;
            for (int i = 0; i < n && (executable = this.findExecutable(command, env.get(variable = stringArray[i]), "bin", "sh")) == null; ++i) {
            }
        }
        if (executable == null) {
            executable = command;
        }
        return executable;
    }

    private String findToolchainExecutable() {
        try {
            Method m3 = this.toolchain.getClass().getMethod("findTool", String.class);
            return (String)m3.invoke(this.toolchain, this.javaToolName);
        }
        catch (NoSuchMethodException e2) {
            this.getLogger().warn("unexpected NoSuchMethodException", e2);
        }
        catch (SecurityException e3) {
            this.getLogger().warn("unexpected SecurityException", e3);
        }
        catch (IllegalAccessException e4) {
            this.getLogger().warn("unexpected IllegalAccessException", e4);
        }
        catch (IllegalArgumentException e5) {
            this.getLogger().warn("unexpected IllegalArgumentException", e5);
        }
        catch (InvocationTargetException e6) {
            this.getLogger().warn("unexpected InvocationTargetException", e6);
        }
        return null;
    }

    private String findExecutable(String command, String homeDir, String ... subDirs) {
        String result = null;
        if (StringUtils.isNotEmpty(homeDir)) {
            for (String subDir : subDirs) {
                File file2 = new File(new File(homeDir, subDir), command);
                if (!file2.isFile()) continue;
                result = file2.getAbsolutePath();
                break;
            }
        }
        return result;
    }
}

