# This file has been autogenerated by the pywayland scanner

# Copyright © 2017 Red Hat Inc.
#
# Permission is hereby granted, free of charge, to any person obtaining a
# copy of this software and associated documentation files (the "Software"),
# to deal in the Software without restriction, including without limitation
# the rights to use, copy, modify, merge, publish, distribute, sublicense,
# and/or sell copies of the Software, and to permit persons to whom the
# Software is furnished to do so, subject to the following conditions:
#
# The above copyright notice and this permission notice (including the next
# paragraph) shall be included in all copies or substantial portions of the
# Software.
#
# THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR
# IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY,
# FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL
# THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER
# LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING
# FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER
# DEALINGS IN THE SOFTWARE.

from pywayland.protocol_core import Argument, ArgumentType, Global, Interface, Proxy, Resource
from ..wayland import WlOutput
from .zxdg_output_v1 import ZxdgOutputV1


class ZxdgOutputManagerV1(Interface):
    """Manage xdg_output objects

    A global factory interface for xdg_output objects.
    """

    name = "zxdg_output_manager_v1"
    version = 3


class ZxdgOutputManagerV1Proxy(Proxy):
    interface = ZxdgOutputManagerV1

    @ZxdgOutputManagerV1.request()
    def destroy(self):
        """Destroy the xdg_output_manager object

        Using this request a client can tell the server that it is not going to
        use the xdg_output_manager object anymore.

        Any objects already created through this instance are not affected.
        """
        self._marshal(0)
        self._destroy()

    @ZxdgOutputManagerV1.request(
        Argument(ArgumentType.NewId, interface=ZxdgOutputV1),
        Argument(ArgumentType.Object, interface=WlOutput),
    )
    def get_xdg_output(self, output):
        """Create an xdg output from a :class:`~pywayland.protocol.wayland.WlOutput`

        This creates a new xdg_output object for the given
        :class:`~pywayland.protocol.wayland.WlOutput`.

        :param output:
        :type output:
            :class:`~pywayland.protocol.wayland.WlOutput`
        :returns:
            :class:`~pywayland.protocol.xdg_output_unstable_v1.ZxdgOutputV1`
        """
        id = self._marshal_constructor(1, ZxdgOutputV1, output)
        return id


class ZxdgOutputManagerV1Resource(Resource):
    interface = ZxdgOutputManagerV1


class ZxdgOutputManagerV1Global(Global):
    interface = ZxdgOutputManagerV1


ZxdgOutputManagerV1._gen_c()
ZxdgOutputManagerV1.proxy_class = ZxdgOutputManagerV1Proxy
ZxdgOutputManagerV1.resource_class = ZxdgOutputManagerV1Resource
ZxdgOutputManagerV1.global_class = ZxdgOutputManagerV1Global
