/*
 * Decompiled with CFR 0.152.
 */
package ca.odell.glazedlists;

import ca.odell.glazedlists.EventList;
import ca.odell.glazedlists.GlazedLists;
import ca.odell.glazedlists.SortedList;
import ca.odell.glazedlists.TransformedList;
import ca.odell.glazedlists.event.ListEvent;
import ca.odell.glazedlists.impl.Grouper;
import ca.odell.glazedlists.impl.adt.BarcodeIterator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public final class UniqueList<E>
extends TransformedList<E, E> {
    private final Grouper<E> grouper;

    public static <E extends Comparable<? super E>> UniqueList<E> create(EventList<E> source2) {
        return new UniqueList<E>(source2);
    }

    public UniqueList(EventList<E> source2) {
        this(source2, GlazedLists.comparableComparator());
    }

    public UniqueList(EventList<E> source2, Comparator<? super E> comparator) {
        this(new SortedList<E>(source2, comparator), (Void)null);
    }

    private UniqueList(SortedList<E> source2, Void dummyParameter) {
        super(source2);
        this.grouper = new Grouper<E>(source2, new GrouperClient());
        source2.addListEventListener(this);
    }

    public void setComparator(Comparator<? super E> comparator) {
        if (comparator == null) {
            comparator = GlazedLists.comparableComparator();
        }
        ((SortedList)this.source).setComparator(comparator);
    }

    @Override
    public int size() {
        return this.grouper.getBarcode().colourSize(Grouper.UNIQUE);
    }

    @Override
    protected int getSourceIndex(int index) {
        if (index == this.size()) {
            return this.source.size();
        }
        return this.grouper.getBarcode().getIndex(index, Grouper.UNIQUE);
    }

    private int getEndIndex(int index) {
        if (index == this.size() - 1) {
            return this.source.size();
        }
        return this.getSourceIndex(index + 1);
    }

    @Override
    public E remove(int index) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Cannot remove at " + index + " on list of size " + this.size());
        }
        this.updates.beginEvent(true);
        Object result = this.get(index);
        int startIndex = this.getSourceIndex(index);
        int endIndex = this.getEndIndex(index);
        ((SortedList)this.source).subList(startIndex, endIndex).clear();
        this.updates.commitEvent();
        return result;
    }

    @Override
    public E set(int index, E value) {
        if (index < 0 || index >= this.size()) {
            throw new IndexOutOfBoundsException("Cannot set at " + index + " on list of size " + this.size());
        }
        this.updates.beginEvent(true);
        int startIndex = this.getSourceIndex(index) + 1;
        int endIndex = this.getEndIndex(index);
        if (endIndex > startIndex) {
            ((SortedList)this.source).subList(startIndex, endIndex).clear();
        }
        E result = super.set(index, value);
        this.updates.commitEvent();
        return result;
    }

    @Override
    public int indexOf(Object element) {
        int index = Collections.binarySearch(this, element, ((SortedList)this.source).getComparator());
        return index < 0 ? -1 : index;
    }

    @Override
    protected boolean isWritable() {
        return true;
    }

    @Override
    public void listChanged(ListEvent<E> listChanges) {
        this.updates.beginEvent(true);
        SortedList sortedSource = (SortedList)this.source;
        Comparator sourceComparator = sortedSource.getComparator();
        if (sourceComparator != this.grouper.getComparator()) {
            if (!listChanges.isReordering()) {
                throw new IllegalStateException("source comparator changed without reordering!");
            }
            int[] reorderingMap = listChanges.getReorderMap();
            int[] reverseReorderingMap = new int[reorderingMap.length];
            for (int r = 0; r < reorderingMap.length; ++r) {
                reverseReorderingMap[reorderingMap[r]] = r;
            }
            BarcodeIterator b = this.grouper.getBarcode().iterator();
            while (b.hasNextBlack()) {
                b.nextBlack();
                int sourceIndex = b.getIndex();
                this.updates.elementDeleted(0, sortedSource.get(reverseReorderingMap[sourceIndex]));
            }
            this.grouper.getBarcode().clear();
            this.grouper.setComparator(sourceComparator);
            int uniqueIndex = 0;
            BarcodeIterator b2 = this.grouper.getBarcode().iterator();
            while (b2.hasNextBlack()) {
                b2.nextBlack();
                int sourceIndex = b2.getIndex();
                this.updates.elementInserted(uniqueIndex, sortedSource.get(sourceIndex));
                ++uniqueIndex;
            }
        } else {
            this.grouper.listChanged(listChanges);
        }
        this.updates.commitEvent();
    }

    public int getCount(int index) {
        int startIndex = this.getSourceIndex(index);
        int endIndex = this.getEndIndex(index);
        return endIndex - startIndex;
    }

    public int getCount(E value) {
        int index = this.indexOf(value);
        if (index == -1) {
            return 0;
        }
        return this.getCount(index);
    }

    public List<E> getAll(int index) {
        int startIndex = this.getSourceIndex(index);
        int endIndex = this.getEndIndex(index);
        return new ArrayList(this.source.subList(startIndex, endIndex));
    }

    public List<E> getAll(E value) {
        int index = this.indexOf(value);
        return index == -1 ? Collections.emptyList() : this.getAll((E)index);
    }

    @Override
    public void dispose() {
        ((SortedList)this.source).dispose();
        super.dispose();
    }

    private class GrouperClient
    implements Grouper.Client<E> {
        private GrouperClient() {
        }

        @Override
        public void groupChanged(int index, int groupIndex, int groupChangeType, boolean primary, int elementChangeType, E oldValue, E newValue, boolean updateNextSeparator, boolean joinRight) {
            switch (groupChangeType) {
                case 2: {
                    UniqueList.this.updates.elementInserted(groupIndex, newValue);
                    break;
                }
                case 1: {
                    UniqueList.this.updates.elementUpdated(groupIndex, oldValue, newValue);
                    break;
                }
                case 0: {
                    UniqueList.this.updates.elementDeleted(groupIndex, oldValue);
                    break;
                }
                default: {
                    throw new IllegalStateException("Unrecognized groupChangeType: " + groupChangeType);
                }
            }
        }
    }
}

