/*
 * Decompiled with CFR 0.152.
 */
package mediathek.gui.dialog;

import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import mediathek.config.Icons;
import mediathek.tool.EscapeKeyHandler;
import mediathek.tool.GuiFunktionen;
import mediathek.tool.MVMessageDialog;
import org.apache.commons.lang3.SystemUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class DialogProgrammOrdnerOeffnen
extends JDialog {
    public boolean ok = false;
    public String ziel;
    private final Frame parentComponent;
    private static final Logger logger = LogManager.getLogger();
    private JButton jButtonAbbrechen;
    private JButton jButtonOk;
    private JButton jButtonZiel;
    private JTextArea jTextArea1;
    private JTextField jTextFieldProgramm;

    public DialogProgrammOrdnerOeffnen(Frame parent, boolean modal, String zziel, String titel, String text) {
        super(parent, modal);
        this.parentComponent = parent;
        this.initComponents();
        this.jButtonZiel.setIcon(Icons.ICON_BUTTON_FILE_OPEN);
        this.setTitle(titel);
        this.jTextArea1.setText(text);
        this.jButtonOk.addActionListener(l -> {
            if (this.check()) {
                this.ok = true;
                this.beenden();
            }
        });
        this.jButtonAbbrechen.addActionListener(l -> {
            this.ok = false;
            this.beenden();
        });
        this.jButtonZiel.addActionListener(new ZielBeobachter());
        this.jTextFieldProgramm.setText(zziel);
        this.ziel = zziel;
        if (parent != null) {
            this.setLocationRelativeTo(parent);
        }
        EscapeKeyHandler.installHandler(this, () -> {
            this.ok = false;
            this.dispose();
        });
    }

    private boolean check() {
        boolean ret = false;
        String programm = this.jTextFieldProgramm.getText();
        if (!programm.equals("")) {
            try {
                if (!new File(programm).exists()) {
                    MVMessageDialog.showMessageDialog(this.parentComponent, "Das Programm:  \"" + programm + "\"  existiert nicht!", "Fehler", 0);
                } else if (!new File(programm).canExecute()) {
                    MVMessageDialog.showMessageDialog(this.parentComponent, "Das Programm:  \"" + programm + "\"  kann nicht ausgef\u00fchrt werden!", "Fehler", 0);
                } else {
                    this.ziel = programm;
                    ret = true;
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        return ret;
    }

    private void beenden() {
        this.dispose();
    }

    private void initComponents() {
        JPanel jPanel1 = new JPanel();
        this.jButtonZiel = new JButton();
        this.jTextFieldProgramm = new JTextField();
        JLabel jLabel1 = new JLabel();
        this.jButtonAbbrechen = new JButton();
        this.jButtonOk = new JButton();
        JScrollPane jScrollPane1 = new JScrollPane();
        this.jTextArea1 = new JTextArea();
        this.setDefaultCloseOperation(2);
        jPanel1.setBorder(BorderFactory.createEtchedBorder());
        this.jButtonZiel.setIcon(new ImageIcon(this.getClass().getResource("/mediathek/res/muster/button-file-open.png")));
        this.jButtonZiel.setToolTipText("Programm ausw\u00e4hlen");
        jLabel1.setText("Programm:");
        GroupLayout jPanel1Layout = new GroupLayout(jPanel1);
        jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addComponent(jLabel1).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jTextFieldProgramm, -1, 409, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonZiel).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.CENTER).addComponent(jLabel1).addComponent(this.jTextFieldProgramm, -2, -1, -2).addComponent(this.jButtonZiel)).addContainerGap(-1, Short.MAX_VALUE)));
        jPanel1Layout.linkSize(1, this.jButtonZiel, this.jTextFieldProgramm);
        this.jButtonAbbrechen.setText("Abbrechen");
        this.jButtonOk.setText("Ok");
        this.jTextArea1.setEditable(false);
        this.jTextArea1.setColumns(20);
        this.jTextArea1.setRows(4);
        this.jTextArea1.setText("\n Der Dateimanager zum Anzeigen des Speicherordners wird nicht gefunden.\n Dateimanager selbst ausw\u00e4hlen.\n");
        jScrollPane1.setViewportView(this.jTextArea1);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addComponent(jPanel1, -1, -1, Short.MAX_VALUE).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGap(0, 0, Short.MAX_VALUE).addComponent(this.jButtonOk).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jButtonAbbrechen)).addComponent(jScrollPane1)).addContainerGap()));
        layout.linkSize(0, this.jButtonAbbrechen, this.jButtonOk);
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(jScrollPane1, -1, 126, Short.MAX_VALUE).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addComponent(jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.UNRELATED).addGroup(layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jButtonAbbrechen).addComponent(this.jButtonOk)).addContainerGap()));
        this.pack();
    }

    private class ZielBeobachter
    implements ActionListener {
        private ZielBeobachter() {
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            if (SystemUtils.IS_OS_MAC_OSX) {
                FileDialog chooser = new FileDialog(DialogProgrammOrdnerOeffnen.this.parentComponent, "Dateimanager suchen");
                chooser.setMode(0);
                chooser.setVisible(true);
                if (chooser.getFile() != null) {
                    try {
                        File destination = new File(chooser.getDirectory() + chooser.getFile());
                        DialogProgrammOrdnerOeffnen.this.jTextFieldProgramm.setText(destination.getAbsolutePath());
                    }
                    catch (Exception ex) {
                        logger.error(ex);
                    }
                }
            } else {
                JFileChooser chooser = new JFileChooser();
                if (!DialogProgrammOrdnerOeffnen.this.jTextFieldProgramm.getText().equals("")) {
                    chooser.setCurrentDirectory(new File(DialogProgrammOrdnerOeffnen.this.jTextFieldProgramm.getText()));
                } else {
                    chooser.setCurrentDirectory(new File(GuiFunktionen.getHomePath()));
                }
                chooser.setFileSelectionMode(0);
                int returnVal = chooser.showOpenDialog(null);
                if (returnVal == 0) {
                    try {
                        DialogProgrammOrdnerOeffnen.this.jTextFieldProgramm.setText(chooser.getSelectedFile().getAbsolutePath());
                    }
                    catch (Exception ex) {
                        logger.error(ex);
                    }
                }
            }
        }
    }
}

