/// <reference types="node" />
import { Service } from './index';
export declare function createEsmHooks(tsNodeService: Service): {
    resolve: (specifier: string, context: {
        parentURL: string;
    }, defaultResolve: any) => Promise<{
        url: string;
    }>;
    getFormat: ((url: string, context: {}, defaultGetFormat: any) => Promise<{
        format: "module" | "builtin" | "commonjs" | "dynamic" | "json" | "wasm";
    }>) | undefined;
    transformSource: ((source: string | Buffer, context: {
        url: string;
        format: "module" | "builtin" | "commonjs" | "dynamic" | "json" | "wasm";
    }, defaultTransformSource: any) => Promise<{
        source: string | Buffer;
    }>) | undefined;
    load: ((url: string, context: {
        format: ("module" | "builtin" | "commonjs" | "dynamic" | "json" | "wasm") | null | undefined;
    }, defaultLoad: any) => Promise<{
        format: "module" | "builtin" | "commonjs" | "dynamic" | "json" | "wasm";
        source: string | Buffer | undefined;
    }>) | undefined;
};
