/*
 * Decompiled with CFR 0.152.
 */
package org.graalvm.visualvm.lib.jfluid.heap;

import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;

class LongHashMap {
    private static final int DEFAULT_CAPACITY = 32;
    private static final int MINIMUM_CAPACITY = 4;
    private static final int MAXIMUM_CAPACITY = 0x20000000;
    private transient long[] table;
    private int size;
    private transient int modCount;
    private transient int threshold;

    LongHashMap() {
        this.init(32);
    }

    LongHashMap(int expectedMaxSize) {
        if (expectedMaxSize < 0) {
            throw new IllegalArgumentException("expectedMaxSize is negative: " + expectedMaxSize);
        }
        this.init(this.capacity(expectedMaxSize));
    }

    private int capacity(int expectedMaxSize) {
        int result;
        int minCapacity = 4 * expectedMaxSize / 3;
        if (minCapacity > 0x20000000 || minCapacity < 0) {
            result = 0x20000000;
        } else {
            for (result = 4; result < minCapacity; result <<= 1) {
            }
        }
        return result;
    }

    private void init(int initCapacity) {
        assert ((initCapacity & -initCapacity) == initCapacity);
        assert (initCapacity >= 4);
        assert (initCapacity <= 0x20000000);
        this.threshold = initCapacity * 3 / 4;
        this.table = new long[2 * initCapacity];
    }

    int size() {
        return this.size;
    }

    boolean isEmpty() {
        return this.size == 0;
    }

    private static int hash(long x, int length) {
        int h = (int)(x ^ x >>> 32);
        h ^= h >>> 20 ^ h >>> 12;
        h ^= h >>> 7 ^ h >>> 4;
        return h & length - 2;
    }

    private static int nextKeyIndex(int i, int len) {
        return i + 2 < len ? i + 2 : 0;
    }

    long get(long key) {
        long k = key;
        long[] tab = this.table;
        int len = tab.length;
        int i = LongHashMap.hash(k, len);
        long item;
        while ((item = tab[i]) != k) {
            if (item == 0L) {
                return -1L;
            }
            i = LongHashMap.nextKeyIndex(i, len);
        }
        return tab[i + 1];
    }

    boolean containsKey(long key) {
        long k = key;
        long[] tab = this.table;
        int len = tab.length;
        int i = LongHashMap.hash(k, len);
        long item;
        while ((item = tab[i]) != k) {
            if (item == 0L) {
                return false;
            }
            i = LongHashMap.nextKeyIndex(i, len);
        }
        return true;
    }

    boolean containsValue(long value) {
        long[] tab = this.table;
        for (int i = 1; i < tab.length; i += 2) {
            if (tab[i] != value || tab[i - 1] == 0L) continue;
            return true;
        }
        return false;
    }

    private boolean containsMapping(long key, long value) {
        long k = key;
        long[] tab = this.table;
        int len = tab.length;
        int i = LongHashMap.hash(k, len);
        long item;
        while ((item = tab[i]) != k) {
            if (item == 0L) {
                return false;
            }
            i = LongHashMap.nextKeyIndex(i, len);
        }
        return tab[i + 1] == value;
    }

    long put(long key, long value) {
        long item;
        assert (key != 0L);
        assert (value != -1L);
        long k = key;
        long[] tab = this.table;
        int len = tab.length;
        int i = LongHashMap.hash(k, len);
        while ((item = tab[i]) != 0L) {
            if (item == k) {
                long oldValue = tab[i + 1];
                tab[i + 1] = value;
                return oldValue;
            }
            i = LongHashMap.nextKeyIndex(i, len);
        }
        ++this.modCount;
        tab[i] = k;
        tab[i + 1] = value;
        if (++this.size >= this.threshold) {
            this.resize(len);
        }
        return -1L;
    }

    private void resize(int newCapacity) {
        int newLength = newCapacity * 2;
        long[] oldTable = this.table;
        int oldLength = oldTable.length;
        if (oldLength == 0x40000000) {
            if (this.threshold == 0x1FFFFFFF) {
                throw new IllegalStateException("Capacity exhausted.");
            }
            this.threshold = 0x1FFFFFFF;
            return;
        }
        if (oldLength >= newLength) {
            return;
        }
        long[] newTable = new long[newLength];
        this.threshold = newCapacity * 3 / 4;
        for (int j = 0; j < oldLength; j += 2) {
            long key = oldTable[j];
            if (key == 0L) continue;
            long value = oldTable[j + 1];
            int i = LongHashMap.hash(key, newLength);
            while (newTable[i] != 0L) {
                i = LongHashMap.nextKeyIndex(i, newLength);
            }
            newTable[i] = key;
            newTable[i + 1] = value;
        }
        this.table = newTable;
    }

    void putAll(Map<Long, Long> m) {
        int n = m.size();
        if (n == 0) {
            return;
        }
        if (n > this.threshold) {
            this.resize(this.capacity(n));
        }
        for (Map.Entry<Long, Long> e : m.entrySet()) {
            this.put(e.getKey(), e.getValue());
        }
    }

    long remove(long key) {
        long k = key;
        long[] tab = this.table;
        int len = tab.length;
        int i = LongHashMap.hash(k, len);
        while (true) {
            long item;
            if ((item = tab[i]) == k) {
                ++this.modCount;
                --this.size;
                long oldValue = tab[i + 1];
                tab[i + 1] = 0L;
                tab[i] = 0L;
                this.closeDeletion(i);
                return oldValue;
            }
            if (item == 0L) {
                return -1L;
            }
            i = LongHashMap.nextKeyIndex(i, len);
        }
    }

    private boolean removeMapping(long key, long value) {
        long k = key;
        long[] tab = this.table;
        int len = tab.length;
        int i = LongHashMap.hash(k, len);
        while (true) {
            long item;
            if ((item = tab[i]) == k) {
                if (tab[i + 1] != value) {
                    return false;
                }
                ++this.modCount;
                --this.size;
                tab[i] = 0L;
                tab[i + 1] = 0L;
                this.closeDeletion(i);
                return true;
            }
            if (item == 0L) {
                return false;
            }
            i = LongHashMap.nextKeyIndex(i, len);
        }
    }

    private void closeDeletion(int d) {
        long item;
        long[] tab = this.table;
        int len = tab.length;
        int i = LongHashMap.nextKeyIndex(d, len);
        while ((item = tab[i]) != 0L) {
            int r = LongHashMap.hash(item, len);
            if (i < r && (r <= d || d <= i) || r <= d && d <= i) {
                tab[d] = item;
                tab[d + 1] = tab[i + 1];
                tab[i] = 0L;
                tab[i + 1] = 0L;
                d = i;
            }
            i = LongHashMap.nextKeyIndex(i, len);
        }
    }

    void clear() {
        ++this.modCount;
        long[] tab = this.table;
        Arrays.fill(tab, 0L);
        this.size = 0;
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof LongHashMap) {
            LongHashMap m = (LongHashMap)o;
            if (m.size() != this.size) {
                return false;
            }
            long[] tab = m.table;
            for (int i = 0; i < tab.length; i += 2) {
                long k = tab[i];
                if (k == 0L || this.containsMapping(k, tab[i + 1])) continue;
                return false;
            }
            return true;
        }
        return false;
    }

    public int hashCode() {
        int result = 0;
        long[] tab = this.table;
        for (int i = 0; i < tab.length; i += 2) {
            long key = tab[i];
            if (key == 0L) continue;
            long k = key;
            result += LongHashMap.hash(k, tab.length) ^ LongHashMap.hash(tab[i + 1], tab.length);
        }
        return result;
    }

    void writeToStream(DataOutputStream out) throws IOException {
        out.writeInt(this.modCount);
        out.writeInt(this.size);
        out.writeInt(this.threshold);
        out.writeInt(this.table.length);
        for (int i = 0; i < this.table.length; ++i) {
            out.writeLong(this.table[i]);
        }
    }

    LongHashMap(DataInputStream dis) throws IOException {
        this.modCount = dis.readInt();
        this.size = dis.readInt();
        this.threshold = dis.readInt();
        this.table = new long[dis.readInt()];
        for (int i = 0; i < this.table.length; ++i) {
            this.table[i] = dis.readLong();
        }
    }
}

