// -*- c++ -*-
// Generated by gtkmmproc -- DO NOT MODIFY!
#ifndef _GDLMM_DOCK_H
#define _GDLMM_DOCK_H


#include <glibmm/ustring.h>
#include <sigc++/sigc++.h>

/* Copyright (c) 2009  Fabien Parent <parent.f@gmail.com>
 *
 * This file is part of gdlmm.
 *
 * gdlmm is free software: you can redistribute it and/or modify it
 * under the terms of the GNU Lesser General Public License as published
 * by the Free Software Foundation, either version 2.1 of the License,
 * or (at your option) any later version.
 *
 * gdlmm is distributed in the hope that it will be useful, but
 * WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.
 * See the GNU Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program.  If not, see <http://www.gnu.org/licenses/>.
 */


#include "dockobject.h"
#include "dockitem.h"
#include "dockplaceholder.h"

#include <vector>

typedef _GdlDockItem GdlDockItem;


#ifndef DOXYGEN_SHOULD_SKIP_THIS
typedef struct _GdlDock GdlDock;
typedef struct _GdlDockClass GdlDockClass;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */


namespace Gdl
{ class Dock_Class; } // namespace Gdl
namespace Gdl
{


class Dock : public DockObject
{
  public:
#ifndef DOXYGEN_SHOULD_SKIP_THIS
  typedef Dock CppObjectType;
  typedef Dock_Class CppClassType;
  typedef GdlDock BaseObjectType;
  typedef GdlDockClass BaseClassType;
#endif /* DOXYGEN_SHOULD_SKIP_THIS */

  virtual ~Dock();

#ifndef DOXYGEN_SHOULD_SKIP_THIS

private:
  friend class Dock_Class;
  static CppClassType dock_class_;

  // noncopyable
  Dock(const Dock&);
  Dock& operator=(const Dock&);

protected:
  explicit Dock(const Glib::ConstructParams& construct_params);
  explicit Dock(GdlDock* castitem);

#endif /* DOXYGEN_SHOULD_SKIP_THIS */

public:

  /** Get the GType for this class, for use with the underlying GObject type system.
   */
  static GType get_type()      G_GNUC_CONST;

#ifndef DOXYGEN_SHOULD_SKIP_THIS


  static GType get_base_type() G_GNUC_CONST;
#endif

  ///Provides access to the underlying C GtkObject.
  GdlDock*       gobj()       { return reinterpret_cast<GdlDock*>(gobject_); }

  ///Provides access to the underlying C GtkObject.
  const GdlDock* gobj() const { return reinterpret_cast<GdlDock*>(gobject_); }


public:
  //C++ methods used to invoke GTK+ virtual functions:

protected:
  //GTK+ Virtual Functions (override these to change behaviour):

  //Default Signal Handlers::
  /// This is a default handler for the signal signal_layout_changed().
  virtual void on_layout_changed();


private:


public:
    explicit Dock();

    explicit Dock(Dock& original, bool floating =  false);

  
  void add_item(DockItem& item, DockPlacement place);
  
  
  void add_floating_item(DockItem& item, int x, int y, int width, int height);
  
  
  DockItem* get_item_by_name(const Glib::ustring& name) const;
  
  
  DockPlaceholder* get_placeholder_by_name(const Glib::ustring& name) const;
  
 
  std::vector<DockItem*> get_named_items() const;
  
  Dock* get_toplevel() const;
  
  //_WRAP_METHOD(void xor_rect(GdkRectangle *rect), gdl_dock_xor_rect)
  
  
  void hide_preview();
  
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Default title for the newly created floating docks.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< Glib::ustring > property_default_title() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Default title for the newly created floating docks.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< Glib::ustring > property_default_title() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Whether the dock is floating in its own window.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< bool > property_floating() const;
#endif //#GLIBMM_PROPERTIES_ENABLED


  #ifdef GLIBMM_PROPERTIES_ENABLED
/** X coordinate for a floating dock.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< int > property_floatx() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** X coordinate for a floating dock.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_floatx() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Y coordinate for a floating dock.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< int > property_floaty() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Y coordinate for a floating dock.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_floaty() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Height for the dock when it's of floating type.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< int > property_height() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Height for the dock when it's of floating type.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_height() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  
  #ifdef GLIBMM_PROPERTIES_ENABLED
/** Width for the dock when it's of floating type.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy< int > property_width() ;
#endif //#GLIBMM_PROPERTIES_ENABLED

#ifdef GLIBMM_PROPERTIES_ENABLED
/** Width for the dock when it's of floating type.
   *
   * You rarely need to use properties because there are get_ and set_ methods for almost all of them.
   * @return A PropertyProxy that allows you to get or set the property of the value, or receive notification when
   * the value of the property changes.
   */
  Glib::PropertyProxy_ReadOnly< int > property_width() const;
#endif //#GLIBMM_PROPERTIES_ENABLED

  
/**
   * @par Slot Prototype:
   * <tt>void on_my_%layout_changed()</tt>
   *
   */

  Glib::SignalProxy0< void > signal_layout_changed();


};

} // namespace Gdl


namespace Glib
{
  /** A Glib::wrap() method for this object.
   * 
   * @param object The C instance.
   * @param take_copy False if the result should take ownership of the C instance. True if it should take a new copy or ref.
   * @result A C++ instance that wraps this C instance.
   *
   * @relates Gdl::Dock
   */
  Gdl::Dock* wrap(GdlDock* object, bool take_copy = false);
} //namespace Glib


#endif /* _GDLMM_DOCK_H */

