/*
 * Decompiled with CFR 0.152.
 */
package com.lizardworks.tiff;

import com.lizardworks.util.MemoryFileInputFilter;
import com.lizardworks.util.MotorolaIntelInputFilter;
import java.io.IOException;

class DataType {
    public int type;
    public static final int MINIMUM = 0;
    public static final int NOTYPE = 0;
    public static final int BYTE = 1;
    public static final int ASCII = 2;
    public static final int SHORT = 3;
    public static final int LONG = 4;
    public static final int RATIONAL = 5;
    public static final int SBYTE = 6;
    public static final int UNDEFINED = 7;
    public static final int SSHORT = 8;
    public static final int SLONG = 9;
    public static final int SRATIONAL = 10;
    public static final int FLOAT = 11;
    public static final int DOUBLE = 12;
    public static final int MAXIMUM = 12;

    public DataType() {
        this.type = 0;
    }

    public DataType(int n) {
        this.type = n;
        if (n >= 0) {
            // empty if block
        }
    }

    public int size() {
        return this.size(this.type);
    }

    public int size(int n) {
        int size = 0;
        switch (n) {
            case 1: 
            case 2: 
            case 6: 
            case 7: {
                size = 1;
                break;
            }
            case 3: 
            case 8: {
                size = 2;
                break;
            }
            case 4: 
            case 9: 
            case 11: {
                size = 4;
                break;
            }
            case 5: 
            case 10: 
            case 12: {
                size = 8;
            }
        }
        return size;
    }

    public boolean isAscii() {
        return this.type == 2;
    }

    public boolean isRational() {
        return this.type == 5 || this.type == 10;
    }

    public boolean isShort() {
        return this.type == 3 || this.type == 8;
    }

    public boolean isLong() {
        return this.type == 4 || this.type == 9;
    }

    public boolean equals(int n) {
        return this.type == n;
    }

    public void write(MotorolaIntelInputFilter out) throws IOException {
        out.writeShort((short)this.type);
    }

    public void read(MemoryFileInputFilter in) {
        this.type = in.readUnsignedShort();
    }

    public String toString() {
        return this.toString(this.type);
    }

    public String toString(int n) {
        String s = "...";
        switch (n) {
            case 0: {
                s = "NOTYPE ";
                break;
            }
            case 1: {
                s = "BYTE   ";
                break;
            }
            case 2: {
                s = "ASCII  ";
                break;
            }
            case 6: {
                s = "SBYTE  ";
                break;
            }
            case 7: {
                s = "UNDEFINED ";
                break;
            }
            case 3: {
                s = "SHORT  ";
                break;
            }
            case 8: {
                s = "SSHORT ";
                break;
            }
            case 4: {
                s = "LONG   ";
                break;
            }
            case 9: {
                s = "SLONG  ";
                break;
            }
            case 11: {
                s = "FLOAT  ";
                break;
            }
            case 5: {
                s = "RATIONAL ";
                break;
            }
            case 10: {
                s = "SRATIONAL ";
                break;
            }
            case 12: {
                s = "DOUBLE ";
            }
        }
        return s;
    }
}

