/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import java.util.List;
import tim.prune.UpdateMessageBroker;
import tim.prune.data.Altitude;
import tim.prune.data.DataPoint;
import tim.prune.data.DoubleRange;
import tim.prune.data.Field;
import tim.prune.data.FieldList;
import tim.prune.data.Latitude;
import tim.prune.data.Longitude;
import tim.prune.data.MediaObject;
import tim.prune.data.PointCreateOptions;
import tim.prune.data.Unit;
import tim.prune.function.edit.FieldEdit;
import tim.prune.function.edit.FieldEditList;
import tim.prune.gui.map.MapUtils;

public class Track {
    private DataPoint[] _dataPoints = null;
    private double[] _xValues = null;
    private double[] _yValues = null;
    private boolean _scaled = false;
    private int _numPoints = 0;
    private boolean _hasTrackpoint = false;
    private boolean _hasWaypoint = false;
    private FieldList _masterFieldList = null;
    private DoubleRange _latRange = null;
    private DoubleRange _longRange = null;
    private DoubleRange _xRange = null;
    private DoubleRange _yRange = null;

    public Track() {
        this._masterFieldList = new FieldList(null);
        this._dataPoints = new DataPoint[0];
        this._numPoints = 0;
        this._scaled = false;
    }

    public Track(FieldList fieldList, DataPoint[] dataPointArray) {
        this._masterFieldList = fieldList;
        this._dataPoints = dataPointArray;
        if (this._dataPoints == null) {
            this._dataPoints = new DataPoint[0];
        }
        this._numPoints = this._dataPoints.length;
        this._scaled = false;
    }

    public void load(Field[] fieldArray, Object[][] objectArray, PointCreateOptions pointCreateOptions) {
        if (fieldArray == null || objectArray == null) {
            this._numPoints = 0;
            return;
        }
        this._masterFieldList = new FieldList(fieldArray);
        this._dataPoints = new DataPoint[objectArray.length];
        String[] stringArray = null;
        int n = 0;
        int n2 = 0;
        while (n2 < objectArray.length) {
            stringArray = (String[])objectArray[n2];
            DataPoint dataPoint = new DataPoint(stringArray, this._masterFieldList, pointCreateOptions);
            if (dataPoint.isValid()) {
                this._dataPoints[n] = dataPoint;
                ++n;
            }
            ++n2;
        }
        this._numPoints = n;
        DataPoint dataPoint = this.getNextTrackPoint(0);
        if (dataPoint != null) {
            dataPoint.setSegmentStart(true);
        }
        this._scaled = false;
    }

    public void load(Track track) {
        this._numPoints = track._numPoints;
        this._masterFieldList = track._masterFieldList;
        this._dataPoints = track._dataPoints;
        this._scaled = false;
    }

    public void requestRescale() {
        this._scaled = false;
    }

    public void extendFieldList(FieldList fieldList) {
        this._masterFieldList = this._masterFieldList.merge(fieldList);
    }

    public void combine(Track track) {
        this._masterFieldList = this._masterFieldList.merge(track._masterFieldList);
        int n = this.getNumPoints() + track.getNumPoints();
        DataPoint[] dataPointArray = new DataPoint[n];
        System.arraycopy(this._dataPoints, 0, dataPointArray, 0, this.getNumPoints());
        System.arraycopy(track._dataPoints, 0, dataPointArray, this.getNumPoints(), track.getNumPoints());
        this._dataPoints = dataPointArray;
        this._numPoints = n;
        this._scaled = false;
        UpdateMessageBroker.informSubscribers();
    }

    public void cropTo(int n) {
        if (n >= 0 && n < this.getNumPoints()) {
            this._numPoints = n;
            this._scaled = false;
            UpdateMessageBroker.informSubscribers();
        }
    }

    public int deleteMarkedPoints(boolean bl) {
        int n = 0;
        DataPoint[] dataPointArray = new DataPoint[this._numPoints];
        boolean bl2 = false;
        int n2 = 0;
        while (n2 < this._numPoints) {
            DataPoint dataPoint = this._dataPoints[n2];
            if (dataPoint.hasMedia() || !dataPoint.getDeleteFlag()) {
                if (bl2 && bl) {
                    dataPoint.setSegmentStart(true);
                }
                dataPointArray[n] = dataPoint;
                ++n;
                bl2 = false;
            } else {
                bl2 = true;
            }
            ++n2;
        }
        n2 = this._numPoints - n;
        if (n2 > 0) {
            this._dataPoints = new DataPoint[n];
            System.arraycopy(dataPointArray, 0, this._dataPoints, 0, n);
            this._numPoints = this._dataPoints.length;
            this._scaled = false;
        }
        return n2;
    }

    public boolean deletePoint(int n) {
        boolean bl = this.deleteRange(n, n);
        return bl;
    }

    public boolean deleteRange(int n, int n2) {
        int n3;
        if (n < 0 || n2 < 0 || n2 < n) {
            return false;
        }
        boolean bl = false;
        DataPoint dataPoint = this.getNextTrackPoint(n2 + 1);
        if (dataPoint != null) {
            n3 = n;
            while (n3 <= n2 && !bl) {
                bl |= this._dataPoints[n3].getSegmentStart();
                ++n3;
            }
            if (bl) {
                dataPoint.setSegmentStart(true);
            }
        }
        n3 = n2 - n + 1;
        DataPoint[] dataPointArray = new DataPoint[this._numPoints - n3];
        if (n > 0) {
            System.arraycopy(this._dataPoints, 0, dataPointArray, 0, n);
        }
        if (n2 < this._numPoints - 1) {
            System.arraycopy(this._dataPoints, n2 + 1, dataPointArray, n, this._numPoints - n2 - 1);
        }
        this._dataPoints = dataPointArray;
        this._numPoints -= n3;
        this._scaled = false;
        return true;
    }

    public boolean reverseRange(int n, int n2) {
        DataPoint dataPoint;
        if (n < 0 || n2 < 0 || n >= n2 || n2 >= this._numPoints) {
            return false;
        }
        int n3 = (n2 - n + 1) / 2;
        DataPoint dataPoint2 = null;
        int n4 = 0;
        while (n4 < n3) {
            dataPoint2 = this._dataPoints[n + n4];
            this._dataPoints[n + n4] = this._dataPoints[n2 - n4];
            this._dataPoints[n2 - n4] = dataPoint2;
            ++n4;
        }
        this.shiftSegmentStarts(n, n2);
        DataPoint dataPoint3 = this.getNextTrackPoint(n);
        if (dataPoint3 != null) {
            dataPoint3.setSegmentStart(true);
        }
        if ((dataPoint = this.getNextTrackPoint(n2 + 1)) != null) {
            dataPoint.setSegmentStart(true);
        }
        this._scaled = false;
        UpdateMessageBroker.informSubscribers();
        return true;
    }

    public boolean addTimeOffsetSeconds(int n, int n2, long l, boolean bl) {
        if (n < 0 || n2 < 0 || n >= n2 || n2 >= this._numPoints) {
            return false;
        }
        boolean bl2 = false;
        int n3 = n;
        while (n3 <= n2) {
            DataPoint dataPoint = this._dataPoints[n3];
            if (dataPoint != null && dataPoint.hasTimestamp()) {
                bl2 = true;
                dataPoint.addTimeOffsetSeconds(l);
                dataPoint.setModified(bl);
            }
            ++n3;
        }
        return bl2;
    }

    public boolean addAltitudeOffset(int n, int n2, double d, Unit unit, int n3) {
        if (n < 0 || n2 < 0 || n >= n2 || n2 >= this._numPoints) {
            return false;
        }
        boolean bl = false;
        int n4 = n;
        while (n4 <= n2) {
            DataPoint dataPoint = this._dataPoints[n4];
            if (dataPoint != null && dataPoint.hasAltitude()) {
                bl = true;
                dataPoint.addAltitudeOffset(d, unit, n3);
                dataPoint.setModified(false);
            }
            ++n4;
        }
        this._scaled = false;
        return bl;
    }

    public boolean interleaveWaypoints() {
        int n = 0;
        DataPoint[] dataPointArray = new DataPoint[this._numPoints];
        int[] nArray = new int[this._numPoints];
        DataPoint dataPoint = null;
        int n2 = 0;
        n2 = 0;
        while (n2 < this._numPoints) {
            dataPoint = this._dataPoints[n2];
            if (dataPoint.isWaypoint()) {
                dataPointArray[n] = dataPoint;
                nArray[n] = this.getNearestPointIndex(this._xValues[n2], this._yValues[n2], -1.0, true);
                ++n;
            }
            ++n2;
        }
        if (n == 0 || n == this._numPoints) {
            return false;
        }
        DataPoint[] dataPointArray2 = new DataPoint[this._numPoints];
        int n3 = 0;
        n2 = 0;
        while (n2 < this._numPoints) {
            dataPoint = this._dataPoints[n2];
            if (!dataPoint.isWaypoint()) {
                dataPointArray2[n3] = dataPoint;
                ++n3;
            }
            int n4 = 0;
            while (n4 < n) {
                if (nArray[n4] == n2) {
                    dataPointArray2[n3] = dataPointArray[n4];
                    ++n3;
                }
                ++n4;
            }
            ++n2;
        }
        this._dataPoints = dataPointArray2;
        this._scaled = false;
        UpdateMessageBroker.informSubscribers();
        return true;
    }

    public boolean cutAndMoveSection(int n, int n2, int n3) {
        if (n >= 0 && n2 > n && n3 >= 0 && (n3 < n || n3 > n2 + 1)) {
            DataPoint[] dataPointArray = new DataPoint[this._numPoints];
            if (n > n3) {
                int n4 = n2 - n + 1;
                if (n3 > 0) {
                    System.arraycopy(this._dataPoints, 0, dataPointArray, 0, n3);
                }
                System.arraycopy(this._dataPoints, n, dataPointArray, n3, n4);
                System.arraycopy(this._dataPoints, n3, dataPointArray, n3 + n4, n - n3);
                if (n2 < this._numPoints - 1) {
                    System.arraycopy(this._dataPoints, n2 + 1, dataPointArray, n2 + 1, this._numPoints - n2 - 1);
                }
            } else {
                if (n > 0) {
                    System.arraycopy(this._dataPoints, 0, dataPointArray, 0, n);
                }
                if (n3 > n2 + 1) {
                    System.arraycopy(this._dataPoints, n2 + 1, dataPointArray, n, n3 - n2 - 1);
                }
                System.arraycopy(this._dataPoints, n, dataPointArray, n + n3 - n2 - 1, n2 - n + 1);
                if (n2 < this._numPoints - 1) {
                    System.arraycopy(this._dataPoints, n3, dataPointArray, n3, this._numPoints - n3);
                }
            }
            this._dataPoints = dataPointArray;
            this._scaled = false;
            return true;
        }
        return false;
    }

    public boolean interpolate(int n, int n2) {
        if (n < 0 || n >= this._numPoints || n2 <= 0) {
            return false;
        }
        DataPoint dataPoint = this.getPoint(n);
        DataPoint dataPoint2 = this.getPoint(n + 1);
        DataPoint[] dataPointArray = dataPoint.interpolate(dataPoint2, n2);
        return this.insertRange(dataPointArray, n + 1);
    }

    public boolean average(int n, int n2) {
        if (n < 0 || n >= this._numPoints || n2 <= n) {
            return false;
        }
        DataPoint dataPoint = this.getPoint(n);
        double d = dataPoint.getLatitude().getDouble();
        double d2 = dataPoint.getLongitude().getDouble();
        double d3 = 0.0;
        double d4 = 0.0;
        double d5 = 0.0;
        int n3 = 0;
        Unit unit = null;
        int n4 = n;
        while (n4 <= n2) {
            DataPoint dataPoint2 = this.getPoint(n4);
            d3 += dataPoint2.getLatitude().getDouble() - d;
            d4 += dataPoint2.getLongitude().getDouble() - d2;
            if (dataPoint2.hasAltitude()) {
                d5 += (double)dataPoint2.getAltitude().getValue(unit);
                if (unit == null) {
                    unit = dataPoint2.getAltitude().getUnit();
                }
                ++n3;
            }
            ++n4;
        }
        n4 = n2 - n + 1;
        double d6 = d + d3 / (double)n4;
        double d7 = d2 + d4 / (double)n4;
        Altitude altitude = null;
        if (n3 > 0) {
            altitude = new Altitude((int)(d5 / (double)n3), unit);
        }
        DataPoint dataPoint3 = new DataPoint(new Latitude(d6, 17), new Longitude(d7, 17), altitude);
        dataPoint3.setSegmentStart(true);
        DataPoint dataPoint4 = this.getNextTrackPoint(n2 + 1);
        if (dataPoint4 != null) {
            dataPoint4.setSegmentStart(true);
        }
        return this.insertRange(new DataPoint[]{dataPoint3}, n2 + 1);
    }

    public void appendPoints(DataPoint[] dataPointArray) {
        if (dataPointArray != null && dataPointArray.length > 0) {
            this.insertRange(dataPointArray, this._numPoints);
        }
        this._scaled = false;
        UpdateMessageBroker.informSubscribers();
    }

    public DataPoint getPoint(int n) {
        if (n > -1 && n < this.getNumPoints()) {
            return this._dataPoints[n];
        }
        return null;
    }

    public int getNumPoints() {
        return this._numPoints;
    }

    public DoubleRange getXRange() {
        if (!this._scaled) {
            this.scalePoints();
        }
        return this._xRange;
    }

    public DoubleRange getYRange() {
        if (!this._scaled) {
            this.scalePoints();
        }
        return this._yRange;
    }

    public DoubleRange getLatRange() {
        if (!this._scaled) {
            this.scalePoints();
        }
        return this._latRange;
    }

    public DoubleRange getLonRange() {
        if (!this._scaled) {
            this.scalePoints();
        }
        return this._longRange;
    }

    public double getX(int n) {
        if (!this._scaled) {
            this.scalePoints();
        }
        return this._xValues[n];
    }

    public double getY(int n) {
        if (!this._scaled) {
            this.scalePoints();
        }
        return this._yValues[n];
    }

    public FieldList getFieldList() {
        return this._masterFieldList;
    }

    public boolean hasData(Field field) {
        if (field.equals(Field.ALTITUDE)) {
            return this.hasAltitudeData();
        }
        return this.hasData(field, 0, this._numPoints - 1);
    }

    public boolean hasData(Field field, int n, int n2) {
        int n3 = n;
        while (n3 <= n2) {
            if (this._dataPoints[n3].getFieldValue(field) != null && (field != Field.ALTITUDE || this._dataPoints[n3].getAltitude().isValid()) && (field != Field.TIMESTAMP || this._dataPoints[n3].getTimestamp().isValid())) {
                return true;
            }
            ++n3;
        }
        return false;
    }

    public boolean hasAltitudeData() {
        int n = 0;
        while (n < this._numPoints) {
            if (this._dataPoints[n].hasAltitude()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public boolean hasTrackPoints() {
        if (!this._scaled) {
            this.scalePoints();
        }
        return this._hasTrackpoint;
    }

    public boolean hasWaypoints() {
        if (!this._scaled) {
            this.scalePoints();
        }
        return this._hasWaypoint;
    }

    public boolean hasMarkedPoints() {
        if (this._numPoints < 1) {
            return false;
        }
        int n = 0;
        while (n <= this._numPoints - 1) {
            if (this._dataPoints[n] != null && this._dataPoints[n].getDeleteFlag()) {
                return true;
            }
            ++n;
        }
        return false;
    }

    public void clearDeletionMarkers() {
        int n = 0;
        while (n < this._numPoints) {
            this._dataPoints[n].setMarkedForDeletion(false);
            ++n;
        }
    }

    public void getWaypoints(List<DataPoint> list) {
        list.clear();
        int n = 0;
        while (n <= this._numPoints - 1) {
            if (this._dataPoints[n] != null && this._dataPoints[n].isWaypoint()) {
                list.add(this._dataPoints[n]);
            }
            ++n;
        }
    }

    public int getPointIndex(DataPoint dataPoint) {
        if (dataPoint != null) {
            int n = 0;
            while (n <= this._numPoints - 1) {
                if (this._dataPoints[n] == dataPoint) {
                    return n;
                }
                ++n;
            }
        }
        return -1;
    }

    private synchronized void scalePoints() {
        DataPoint dataPoint;
        this._longRange = new DoubleRange();
        this._latRange = new DoubleRange();
        this._hasWaypoint = false;
        this._hasTrackpoint = false;
        int n = 0;
        while (n < this.getNumPoints()) {
            dataPoint = this.getPoint(n);
            if (dataPoint != null && dataPoint.isValid()) {
                this._longRange.addValue(dataPoint.getLongitude().getDouble());
                this._latRange.addValue(dataPoint.getLatitude().getDouble());
                if (dataPoint.isWaypoint()) {
                    this._hasWaypoint = true;
                } else {
                    this._hasTrackpoint = true;
                }
            }
            ++n;
        }
        this._xValues = new double[this.getNumPoints()];
        this._yValues = new double[this.getNumPoints()];
        this._xRange = new DoubleRange();
        this._yRange = new DoubleRange();
        n = 0;
        while (n < this.getNumPoints()) {
            dataPoint = this.getPoint(n);
            if (dataPoint != null) {
                this._xValues[n] = MapUtils.getXFromLongitude(dataPoint.getLongitude().getDouble());
                this._xRange.addValue(this._xValues[n]);
                this._yValues[n] = MapUtils.getYFromLatitude(dataPoint.getLatitude().getDouble());
                this._yRange.addValue(this._yValues[n]);
            }
            ++n;
        }
        this._scaled = true;
    }

    public int getNearestPointIndex(double d, double d2, double d3, boolean bl) {
        int n = 0;
        double d4 = -1.0;
        int n2 = 0;
        while (n2 < this.getNumPoints()) {
            double d5;
            double d6;
            if (!(bl && this._dataPoints[n2].isWaypoint() || !((d6 = Math.abs(this._yValues[n2] - d2)) < d4) && !(d4 < 0.0) || !((d5 = d6 + Track.getMinXDist(this._xValues[n2] - d)) < d4) && !(d4 < 0.0))) {
                n = n2;
                d4 = d5;
            }
            ++n2;
        }
        if (d4 > d3 && d3 > 0.0) {
            return -1;
        }
        return n;
    }

    private static final double getMinXDist(double d) {
        return Math.min(Math.min(Math.abs(d), Math.abs(d - 1.0)), Math.abs(d + 1.0));
    }

    public DataPoint getNextTrackPoint(int n) {
        return this.getNextTrackPoint(n, this._numPoints, true);
    }

    public DataPoint getNextTrackPoint(int n, int n2) {
        return this.getNextTrackPoint(n, n2, true);
    }

    public DataPoint getPreviousTrackPoint(int n) {
        return this.getNextTrackPoint(n, this._numPoints, false);
    }

    private DataPoint getNextTrackPoint(int n, int n2, boolean bl) {
        int n3 = bl ? 1 : -1;
        int n4 = n;
        while (n4 <= n2) {
            DataPoint dataPoint = this.getPoint(n4);
            if (dataPoint == null) {
                return null;
            }
            if (dataPoint.isValid() && !dataPoint.isWaypoint()) {
                return dataPoint;
            }
            n4 += n3;
        }
        return null;
    }

    public void shiftSegmentStarts(int n, int n2) {
        boolean bl = true;
        boolean bl2 = true;
        int n3 = n;
        while (n3 <= n2) {
            DataPoint dataPoint = this.getPoint(n3);
            if (dataPoint != null && !dataPoint.isWaypoint()) {
                bl2 = dataPoint.getSegmentStart();
                dataPoint.setSegmentStart(bl);
                bl = bl2;
            }
            ++n3;
        }
    }

    public DataPoint[] cloneContents() {
        DataPoint[] dataPointArray = new DataPoint[this.getNumPoints()];
        System.arraycopy(this._dataPoints, 0, dataPointArray, 0, this.getNumPoints());
        return dataPointArray;
    }

    public DataPoint[] cloneRange(int n, int n2) {
        int n3 = 0;
        if (n2 >= 0 && n2 >= n) {
            n3 = n2 - n + 1;
        }
        DataPoint[] dataPointArray = new DataPoint[n3 > 0 ? n3 : 0];
        if (n3 > 0) {
            System.arraycopy(this._dataPoints, n, dataPointArray, 0, n3);
        }
        return dataPointArray;
    }

    public boolean insertPoint(DataPoint dataPoint, int n) {
        if (n > this._numPoints || dataPoint == null) {
            return false;
        }
        DataPoint[] dataPointArray = new DataPoint[this._numPoints + 1];
        if (n > 0) {
            System.arraycopy(this._dataPoints, 0, dataPointArray, 0, n);
        }
        dataPointArray[n] = dataPoint;
        if (n < this._numPoints) {
            System.arraycopy(this._dataPoints, n, dataPointArray, n + 1, this._numPoints - n);
        }
        this._dataPoints = dataPointArray;
        ++this._numPoints;
        this._scaled = false;
        UpdateMessageBroker.informSubscribers();
        return true;
    }

    public boolean insertRange(DataPoint[] dataPointArray, int n) {
        if (n > this._numPoints || dataPointArray == null) {
            return false;
        }
        DataPoint[] dataPointArray2 = new DataPoint[this._numPoints + dataPointArray.length];
        if (n > 0) {
            System.arraycopy(this._dataPoints, 0, dataPointArray2, 0, n);
        }
        System.arraycopy(dataPointArray, 0, dataPointArray2, n, dataPointArray.length);
        if (n < this._numPoints) {
            System.arraycopy(this._dataPoints, n, dataPointArray2, n + dataPointArray.length, this._numPoints - n);
        }
        this._dataPoints = dataPointArray2;
        this._numPoints += dataPointArray.length;
        this._scaled = false;
        UpdateMessageBroker.informSubscribers();
        return true;
    }

    public boolean replaceContents(DataPoint[] dataPointArray) {
        this._dataPoints = dataPointArray;
        this._numPoints = this._dataPoints.length;
        this._scaled = false;
        UpdateMessageBroker.informSubscribers();
        return true;
    }

    public boolean editPoint(DataPoint dataPoint, FieldEditList fieldEditList, boolean bl) {
        if (dataPoint != null && fieldEditList != null && fieldEditList.getNumEdits() > 0) {
            boolean bl2 = false;
            int n = fieldEditList.getNumEdits();
            int n2 = 0;
            while (n2 < n) {
                FieldEdit fieldEdit = fieldEditList.getEdit(n2);
                Field field = fieldEdit.getField();
                dataPoint.setFieldValue(field, fieldEdit.getValue(), bl);
                if (!this._masterFieldList.contains(field)) {
                    this._masterFieldList.extendList(field);
                }
                bl2 |= field.equals(Field.LATITUDE) || field.equals(Field.LONGITUDE) || field.equals(Field.ALTITUDE);
                ++n2;
            }
            if (dataPoint.getPhoto() != null && bl2) {
                dataPoint.getPhoto().setCurrentStatus(MediaObject.Status.CONNECTED);
            }
            this._scaled = false;
            UpdateMessageBroker.informSubscribers();
            return true;
        }
        return false;
    }

    public boolean containsPoint(DataPoint dataPoint) {
        if (dataPoint == null) {
            return false;
        }
        int n = 0;
        while (n < this.getNumPoints()) {
            if (this.getPoint(n) == dataPoint) {
                return true;
            }
            ++n;
        }
        return false;
    }
}

