/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.josm.gui.layer.gpx;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.util.Arrays;
import javax.swing.JOptionPane;
import org.openstreetmap.josm.actions.ExtensionFileFilter;
import org.openstreetmap.josm.data.gpx.GpxData;
import org.openstreetmap.josm.gui.MainApplication;
import org.openstreetmap.josm.gui.io.importexport.GpxImporter;
import org.openstreetmap.josm.gui.io.importexport.NMEAImporter;
import org.openstreetmap.josm.gui.io.importexport.RtkLibImporter;
import org.openstreetmap.josm.gui.widgets.AbstractFileChooser;
import org.openstreetmap.josm.gui.widgets.FileChooserManager;
import org.openstreetmap.josm.io.Compression;
import org.openstreetmap.josm.io.GpxReader;
import org.openstreetmap.josm.io.nmea.NmeaReader;
import org.openstreetmap.josm.io.rtklib.RtkLibPosReader;
import org.openstreetmap.josm.tools.I18n;
import org.openstreetmap.josm.tools.Logging;
import org.xml.sax.SAXException;

public final class GpxDataHelper {
    private GpxDataHelper() {
    }

    public static File chooseGpxDataFile() {
        ExtensionFileFilter gpxFilter = GpxImporter.getFileFilter();
        AbstractFileChooser fc = new FileChooserManager(true, null).createFileChooser(false, null, Arrays.asList(gpxFilter, NMEAImporter.FILE_FILTER, RtkLibImporter.FILE_FILTER), gpxFilter, 0).openFileChooser();
        return fc != null ? fc.getSelectedFile() : null;
    }

    public static GpxData loadGpxData(File file) {
        GpxData data = null;
        try (InputStream iStream = Compression.getUncompressedFileInputStream(file);){
            GpxReader reader = GpxImporter.getFileFilter().accept(file) ? new GpxReader(iStream) : (NMEAImporter.FILE_FILTER.accept(file) ? new NmeaReader(iStream) : new RtkLibPosReader(iStream));
            reader.parse(false);
            data = reader.getGpxData();
            data.storageFile = file;
        }
        catch (SAXException ex) {
            Logging.error(ex);
            JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("Error while parsing {0}", file.getName()) + ": " + ex.getMessage(), I18n.tr("Error", new Object[0]), 0);
        }
        catch (IOException | UnsupportedOperationException ex) {
            Logging.error(ex);
            JOptionPane.showMessageDialog(MainApplication.getMainFrame(), I18n.tr("Could not read \"{0}\"", file.getName()) + '\n' + ex.getMessage(), I18n.tr("Error", new Object[0]), 0);
        }
        return data;
    }
}

