/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.resolve.checkers;

import java.util.Iterator;
import kotlin.Metadata;
import kotlin.jvm.internal.Intrinsics;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.kotlin.descriptors.DeclarationDescriptor;
import org.jetbrains.kotlin.descriptors.MemberDescriptor;
import org.jetbrains.kotlin.descriptors.PackageFragmentDescriptor;
import org.jetbrains.kotlin.descriptors.annotations.AnnotationDescriptor;
import org.jetbrains.kotlin.diagnostics.Errors;
import org.jetbrains.kotlin.psi.KtAnnotationEntry;
import org.jetbrains.kotlin.psi.KtDeclaration;
import org.jetbrains.kotlin.resolve.BindingContext;
import org.jetbrains.kotlin.resolve.BindingTrace;
import org.jetbrains.kotlin.resolve.DescriptorUtils;
import org.jetbrains.kotlin.resolve.multiplatform.OptionalAnnotationUtil;

@Metadata(mv={1, 5, 1}, k=1, xi=48, d1={"\u0000*\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0002\b\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\b\u00c6\u0002\u0018\u00002\u00020\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0002J\u001e\u0010\u0003\u001a\u00020\u00042\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\u0007\u001a\u00020\b2\u0006\u0010\t\u001a\u00020\nJ\u001a\u0010\u000b\u001a\u0004\u0018\u00010\f2\u0006\u0010\u0005\u001a\u00020\u00062\u0006\u0010\t\u001a\u00020\nH\u0002\u00a8\u0006\r"}, d2={"Lorg/jetbrains/kotlin/resolve/checkers/OptionalExpectationChecker;", "", "()V", "check", "", "declaration", "Lorg/jetbrains/kotlin/psi/KtDeclaration;", "descriptor", "Lorg/jetbrains/kotlin/descriptors/DeclarationDescriptor;", "trace", "Lorg/jetbrains/kotlin/resolve/BindingTrace;", "getOptionalExpectationEntry", "Lorg/jetbrains/kotlin/psi/KtAnnotationEntry;", "frontend"})
public final class OptionalExpectationChecker {
    @NotNull
    public static final OptionalExpectationChecker INSTANCE = new OptionalExpectationChecker();

    private OptionalExpectationChecker() {
    }

    public final void check(@NotNull KtDeclaration declaration2, @NotNull DeclarationDescriptor descriptor2, @NotNull BindingTrace trace) {
        boolean isExpect;
        Intrinsics.checkNotNullParameter(declaration2, "declaration");
        Intrinsics.checkNotNullParameter(descriptor2, "descriptor");
        Intrinsics.checkNotNullParameter(trace, "trace");
        boolean bl = isExpect = descriptor2 instanceof MemberDescriptor && ((MemberDescriptor)descriptor2).isExpect();
        if (isExpect) {
            KtAnnotationEntry ktAnnotationEntry;
            if (DescriptorUtils.isAnnotationClass(descriptor2) && !(descriptor2.getContainingDeclaration() instanceof PackageFragmentDescriptor) && (ktAnnotationEntry = this.getOptionalExpectationEntry(declaration2, trace)) != null) {
                KtAnnotationEntry ktAnnotationEntry2 = ktAnnotationEntry;
                boolean bl2 = false;
                boolean bl3 = false;
                KtAnnotationEntry it = ktAnnotationEntry2;
                boolean bl4 = false;
                trace.report(Errors.NESTED_OPTIONAL_EXPECTATION.on(it));
            }
        } else {
            KtAnnotationEntry ktAnnotationEntry = this.getOptionalExpectationEntry(declaration2, trace);
            if (ktAnnotationEntry != null) {
                KtAnnotationEntry ktAnnotationEntry3 = ktAnnotationEntry;
                boolean bl5 = false;
                boolean bl6 = false;
                KtAnnotationEntry it = ktAnnotationEntry3;
                boolean bl7 = false;
                trace.report(Errors.OPTIONAL_EXPECTATION_NOT_ON_EXPECTED.on(it));
            }
        }
    }

    private final KtAnnotationEntry getOptionalExpectationEntry(KtDeclaration declaration2, BindingTrace trace) {
        KtAnnotationEntry ktAnnotationEntry;
        block1: {
            Iterable<KtAnnotationEntry> iterable = declaration2.getAnnotationEntries();
            Intrinsics.checkNotNullExpressionValue(iterable, "declaration.annotationEntries");
            iterable = iterable;
            boolean bl = false;
            Iterable<KtAnnotationEntry> iterable2 = iterable;
            boolean bl2 = false;
            Iterator<KtAnnotationEntry> iterator2 = iterable2.iterator();
            while (iterator2.hasNext()) {
                KtAnnotationEntry ktAnnotationEntry2;
                KtAnnotationEntry entry = ktAnnotationEntry2 = iterator2.next();
                boolean bl3 = false;
                AnnotationDescriptor annotationDescriptor = (AnnotationDescriptor)trace.get(BindingContext.ANNOTATION, entry);
                AnnotationDescriptor annotationDescriptor2 = annotationDescriptor;
                if (!Intrinsics.areEqual(annotationDescriptor2 == null ? null : annotationDescriptor2.getFqName(), OptionalAnnotationUtil.INSTANCE.getOPTIONAL_EXPECTATION_FQ_NAME())) continue;
                ktAnnotationEntry = ktAnnotationEntry2;
                break block1;
            }
            ktAnnotationEntry = null;
        }
        return ktAnnotationEntry;
    }
}

