"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.decodeUnpaddedUrlSafeBase64 = exports.decodeUnpaddedBase64 = exports.decodeBase64 = exports.encodeUnpaddedUrlSafeBase64 = exports.encodeUnpaddedBase64 = exports.encodeBase64 = void 0;
/**
 * Encodes Base64.
 * @category Utilities
 * @param {ArrayBuffer | Uint8Array} b The buffer to encode.
 * @returns {string} The Base64 string.
 */
function encodeBase64(b) {
    return Buffer.from(b).toString('base64');
}
exports.encodeBase64 = encodeBase64;
/**
 * Encodes Unpadded Base64.
 * @category Utilities
 * @param {ArrayBuffer | Uint8Array} b The buffer to encode.
 * @returns {string} The Base64 string.
 */
function encodeUnpaddedBase64(b) {
    return encodeBase64(b).replace(/=+/g, '');
}
exports.encodeUnpaddedBase64 = encodeUnpaddedBase64;
/**
 * Encodes URL-Safe Unpadded Base64.
 * @category Utilities
 * @param {ArrayBuffer | Uint8Array} b The buffer to encode.
 * @returns {string} The Base64 string.
 */
function encodeUnpaddedUrlSafeBase64(b) {
    return encodeUnpaddedBase64(b).replace(/\+/g, '-').replace(/\//g, '_');
}
exports.encodeUnpaddedUrlSafeBase64 = encodeUnpaddedUrlSafeBase64;
/**
 * Decodes Base64.
 * @category Utilities
 * @param {string} s The Base64 string.
 * @returns {Uint8Array} The encoded data as a buffer.
 */
function decodeBase64(s) {
    return Buffer.from(s, 'base64');
}
exports.decodeBase64 = decodeBase64;
/**
 * Decodes Unpadded Base64.
 * @category Utilities
 * @param {string} s The Base64 string.
 * @returns {Uint8Array} The encoded data as a buffer.
 */
function decodeUnpaddedBase64(s) {
    return decodeBase64(s); // yay, it's the same
}
exports.decodeUnpaddedBase64 = decodeUnpaddedBase64;
/**
 * Decodes URL-Safe Unpadded Base64.
 * @category Utilities
 * @param {string} s The Base64 string.
 * @returns {Uint8Array} The encoded data as a buffer.
 */
function decodeUnpaddedUrlSafeBase64(s) {
    return decodeUnpaddedBase64(s.replace(/-/g, '+').replace(/_/g, '/'));
}
exports.decodeUnpaddedUrlSafeBase64 = decodeUnpaddedUrlSafeBase64;
