/*
 * Decompiled with CFR 0.152.
 */
package mediathek.controller.history;

import mediathek.tool.Functions;
import org.apache.commons.lang3.StringUtils;
import org.apache.logging.log4j.LogManager;
import org.apache.logging.log4j.Logger;

public class MVUsedUrl {
    public static final int MAX_TITLE_LENGTH = 40;
    public static final int MAX_THEMA_LENGTH = 25;
    private static final Logger logger = LogManager.getLogger(MVUsedUrl.class);
    private static final String TRENNER = "  |###|  ";
    private static final String PAUSE = " |#| ";
    private final String datum;
    private final String thema;
    private final String titel;
    private final String url;

    public MVUsedUrl(String date, String thema, String title, String url) {
        this.datum = date;
        this.thema = thema;
        this.titel = title;
        this.url = url;
    }

    public static MVUsedUrl getUrlAusZeile(String zeile) {
        String url = "";
        String thema = "";
        String titel = "";
        String datum = "";
        try {
            if (zeile.contains(TRENNER)) {
                int a1 = zeile.lastIndexOf(TRENNER);
                url = zeile.substring(a1 += TRENNER.length()).trim();
                titel = zeile.substring(zeile.lastIndexOf(PAUSE) + PAUSE.length(), zeile.lastIndexOf(TRENNER)).trim();
                datum = zeile.substring(0, zeile.indexOf(PAUSE)).trim();
                thema = zeile.substring(zeile.indexOf(PAUSE) + PAUSE.length(), zeile.lastIndexOf(PAUSE)).trim();
            } else {
                url = zeile;
            }
        }
        catch (Exception ex) {
            logger.error("getUrlAusZeile", (Throwable)ex);
        }
        return new MVUsedUrl(datum, thema, titel, url);
    }

    private String putzen(String s2) {
        s2 = StringUtils.replace(s2, "\n", "");
        s2 = StringUtils.replace(s2, "|", "");
        s2 = StringUtils.replace(s2, TRENNER, "");
        return s2;
    }

    public String getDatum() {
        return this.datum;
    }

    public String getThema() {
        return this.thema;
    }

    public String getTitel() {
        return this.titel;
    }

    public String getUsedUrl() {
        return this.datum + PAUSE + Functions.textLaenge(25, this.putzen(this.thema), false, false) + PAUSE + Functions.textLaenge(40, this.putzen(this.titel), false, false) + TRENNER + this.url + "\n";
    }

    public String getUrl() {
        return this.url;
    }
}

