/*
 * Decompiled with CFR 0.152.
 */
package net.posick.mDNS;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import net.posick.mDNS.MulticastDNSLookupBase;
import net.posick.mDNS.ServiceInstance;
import net.posick.mDNS.utils.Wait;
import org.xbill.DNS.Message;
import org.xbill.DNS.MulticastDNSUtils;
import org.xbill.DNS.Name;
import org.xbill.DNS.PTRRecord;
import org.xbill.DNS.Record;
import org.xbill.DNS.ResolverListener;
import org.xbill.DNS.TextParseException;

public class Lookup
extends MulticastDNSLookupBase {
    public Lookup(Name ... names) throws IOException {
        super(names);
    }

    public Lookup(Name[] names, int type) throws IOException {
        super(names, type);
    }

    public Lookup(Name name, int type) throws IOException {
        super(new Name[]{name}, type);
    }

    public Lookup(Name[] names, int type, int dclass) throws IOException {
        super(names, type, dclass);
    }

    public Lookup(Name name, int type, int dclass) throws IOException {
        super(new Name[]{name}, type, dclass);
    }

    public Lookup(String ... names) throws IOException {
        super(names);
    }

    public Lookup(String name, int type) throws IOException {
        super(name, type);
    }

    public Lookup(String name, int type, int dclass) throws IOException {
        super(name, type, dclass);
    }

    public Lookup(String[] names, int type) throws IOException {
        super(names, type);
    }

    public Lookup(String[] names, int type, int dclass) throws IOException {
        super(names, type, dclass);
    }

    protected Lookup() throws IOException {
    }

    protected Lookup(Message message) throws IOException {
        super(message);
    }

    public void close() throws IOException {
    }

    public Domain[] lookupDomains() throws IOException {
        final Set<Domain> domains = Collections.synchronizedSet(new HashSet());
        final List exceptions = Collections.synchronizedList(new LinkedList());
        if (this.queries != null && this.queries.length > 0) {
            this.lookupRecordsAsync(new RecordListener(){

                public void handleException(Object id, Exception e) {
                    exceptions.add(e);
                }

                public void receiveRecord(Object id, Record record) {
                    if (record.getTTL() > 0L && record.getType() == 12) {
                        String value = ((PTRRecord)record).getTarget().toString();
                        if (!value.endsWith(".")) {
                            value = value + ".";
                        }
                        try {
                            domains.add(new Domain(new Name(value)));
                        }
                        catch (TextParseException e) {
                            e.printStackTrace(System.err);
                        }
                    }
                }
            });
            Wait.forResponse(domains);
        }
        for (Name name : this.searchPath) {
            domains.add(new Domain(name));
        }
        return domains.toArray(new Domain[domains.size()]);
    }

    public Record[] lookupRecords() throws IOException {
        final ConcurrentLinkedQueue messages = new ConcurrentLinkedQueue();
        final ConcurrentLinkedQueue exceptions = new ConcurrentLinkedQueue();
        this.lookupRecordsAsync(new ResolverListener(){

            public void handleException(Object id, Exception e) {
                exceptions.add(e);
            }

            public void receiveMessage(Object id, Message m3) {
                messages.add(m3);
            }
        });
        Wait.forResponse(messages);
        ArrayList<Record> records = new ArrayList<Record>();
        for (Object o : messages) {
            Message m3 = (Message)o;
            switch (m3.getRcode()) {
                case 0: {
                    records.addAll(Arrays.asList(MulticastDNSUtils.extractRecords(m3, 1, 2, 3)));
                    break;
                }
            }
        }
        return records.toArray(new Record[records.size()]);
    }

    public Object[] lookupRecordsAsync(final RecordListener listener) throws IOException {
        return this.lookupRecordsAsync(new ResolverListener(){

            public void handleException(Object id, Exception e) {
                listener.handleException(id, e);
            }

            public void receiveMessage(Object id, Message m3) {
                Record[] records;
                for (Record r : records = MulticastDNSUtils.extractRecords(m3, 1, 3, 2)) {
                    listener.receiveRecord(id, r);
                }
            }
        });
    }

    public Object[] lookupRecordsAsync(ResolverListener listener) throws IOException {
        ArrayList results = new ArrayList(this.queries.length);
        for (Message query : this.queries) {
            this.getQuerier().sendAsync(query, listener);
        }
        return results.toArray();
    }

    public ServiceInstance[] lookupServices() throws IOException {
        ArrayList<ServiceInstance> results = new ArrayList<ServiceInstance>();
        results.addAll(Arrays.asList(Lookup.extractServiceInstances(this.lookupRecords())));
        return results.toArray(new ServiceInstance[results.size()]);
    }

    public static Record[] lookupRecords(Name name) throws IOException {
        return Lookup.lookupRecords(new Name[]{name}, 255, 255);
    }

    public static Record[] lookupRecords(Name[] names) throws IOException {
        return Lookup.lookupRecords(names, 255, 255);
    }

    public static Record[] lookupRecords(Name name, int type) throws IOException {
        return Lookup.lookupRecords(new Name[]{name}, type, 255);
    }

    public static Record[] lookupRecords(Name[] names, int type) throws IOException {
        return Lookup.lookupRecords(names, type, 255);
    }

    public static Record[] lookupRecords(Name name, int type, int dclass) throws IOException {
        return Lookup.lookupRecords(new Name[]{name}, type, dclass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Record[] lookupRecords(Name[] names, int type, int dclass) throws IOException {
        Lookup lookup2 = new Lookup(names, type, dclass);
        try {
            Record[] recordArray = lookup2.lookupRecords();
            return recordArray;
        }
        finally {
            lookup2.close();
        }
    }

    public static ServiceInstance[] lookupServices(Name name) throws IOException {
        return Lookup.lookupServices(new Name[]{name}, 255, 255);
    }

    public static ServiceInstance[] lookupServices(Name[] names) throws IOException {
        return Lookup.lookupServices(names, 255, 255);
    }

    public static ServiceInstance[] lookupServices(Name name, int type) throws IOException {
        return Lookup.lookupServices(new Name[]{name}, type, 255);
    }

    public static ServiceInstance[] lookupServices(Name[] names, int type) throws IOException {
        return Lookup.lookupServices(names, type, 255);
    }

    public static ServiceInstance[] lookupServices(Name name, int type, int dclass) throws IOException {
        return Lookup.lookupServices(new Name[]{name}, type, dclass);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ServiceInstance[] lookupServices(Name[] names, int type, int dclass) throws IOException {
        Lookup lookup2 = new Lookup(names, type, dclass);
        try {
            ServiceInstance[] serviceInstanceArray = lookup2.lookupServices();
            return serviceInstanceArray;
        }
        finally {
            lookup2.close();
        }
    }

    public static interface RecordListener {
        public void handleException(Object var1, Exception var2);

        public void receiveRecord(Object var1, Record var2);
    }

    public static class Domain {
        private final Name name;
        private boolean isDefault;
        private boolean isLegacy;

        protected Domain(Name name) {
            this.name = name;
            byte[] label = name.getLabel(0);
            if (label != null) {
                switch ((char)label[0]) {
                    case 'd': {
                        this.isDefault = true;
                        break;
                    }
                    case 'l': {
                        this.isLegacy = true;
                    }
                }
            }
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (this.name == obj) {
                return true;
            }
            if (obj instanceof Domain) {
                return this.name.equals(((Domain)obj).name);
            }
            return false;
        }

        public Name getName() {
            return this.name;
        }

        public int hashCode() {
            return this.name.hashCode();
        }

        public boolean isDefault() {
            return this.isDefault;
        }

        public boolean isLegacy() {
            return this.isLegacy;
        }

        public String toString() {
            return this.name + (this.isDefault ? "  [default]" : "") + (this.isLegacy ? "  [legacy]" : "");
        }
    }
}

