/*
 * Decompiled with CFR 0.152.
 */
package net.posick.mDNS;

import java.io.IOException;
import java.net.InetAddress;
import java.net.NetworkInterface;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.concurrent.TimeUnit;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.posick.mDNS.Constants;
import net.posick.mDNS.MulticastDNSCache;
import net.posick.mDNS.Querier;
import net.posick.mDNS.net.DatagramProcessor;
import net.posick.mDNS.net.Packet;
import net.posick.mDNS.net.PacketListener;
import net.posick.mDNS.utils.Executors;
import net.posick.mDNS.utils.ListenerProcessor;
import net.posick.mDNS.utils.Misc;
import net.posick.mDNS.utils.Wait;
import org.xbill.DNS.Cache;
import org.xbill.DNS.Header;
import org.xbill.DNS.Message;
import org.xbill.DNS.MulticastDNSUtils;
import org.xbill.DNS.Name;
import org.xbill.DNS.OPTRecord;
import org.xbill.DNS.Opcode;
import org.xbill.DNS.Options;
import org.xbill.DNS.RRset;
import org.xbill.DNS.Rcode;
import org.xbill.DNS.Record;
import org.xbill.DNS.ResolverListener;
import org.xbill.DNS.SetResponse;
import org.xbill.DNS.TSIG;
import org.xbill.DNS.WireParseException;

public class MulticastDNSMulticastOnlyQuerier
implements Querier,
PacketListener {
    private static final Logger logger = Misc.getLogger(MulticastDNSMulticastOnlyQuerier.class, true);
    public static final int DEFAULT_EDNS_PAYLOADSIZE = 1280;
    protected boolean mdnsVerbose = false;
    protected boolean cacheVerbose = false;
    protected ListenerProcessor<ResolverListener> resolverListenerProcessor = new ListenerProcessor<ResolverListener>(ResolverListener.class);
    protected ResolverListener resolverListenerDispatcher = this.resolverListenerProcessor.getDispatcher();
    protected MulticastDNSCache cache;
    protected Cacher cacher;
    protected MulticastDNSResponder responder;
    protected InetAddress multicastAddress;
    protected int port = 5353;
    protected OPTRecord queryOPT;
    protected TSIG tsig;
    protected boolean ignoreTruncation = false;
    protected long timeoutValue = 6000L;
    protected long responseWaitTime = 500L;
    protected long retryInterval = 1000L;
    protected List<DatagramProcessor> multicastProcessors = new ArrayList<DatagramProcessor>();
    protected Executors executors = Executors.newInstance();
    private final MulticastDNSCache.CacheMonitor cacheMonitor = new MulticastDNSCache.CacheMonitor(){
        private final List authRecords = new ArrayList();
        private final List nonauthRecords = new ArrayList();
        private long lastPoll = System.currentTimeMillis();

        public void begin() {
            if (MulticastDNSMulticastOnlyQuerier.this.mdnsVerbose || MulticastDNSMulticastOnlyQuerier.this.cacheVerbose) {
                StringBuilder builder = new StringBuilder();
                if (this.lastPoll > 0L) {
                    builder.append("Last Poll " + (double)(System.nanoTime() - this.lastPoll) / 1.0E9 + " seconds ago. ");
                }
                builder.append(" Cache Monitor Check ");
                logger.logp(Level.INFO, this.getClass().getName(), "begin", builder.toString());
            }
            this.lastPoll = System.currentTimeMillis();
            this.authRecords.clear();
            this.nonauthRecords.clear();
        }

        public void check(RRset rrs, int credibility, int expiresIn) {
            if (MulticastDNSMulticastOnlyQuerier.this.mdnsVerbose || MulticastDNSMulticastOnlyQuerier.this.cacheVerbose) {
                logger.logp(Level.INFO, this.getClass().getName(), "check", "CacheMonitor check RRset: expires in: " + expiresIn + " seconds : " + rrs);
            }
            long ttl = rrs.getTTL();
            if (credibility >= 4 && this.isAboutToExpire(ttl, expiresIn)) {
                Record[] records;
                for (Record record : records = MulticastDNSUtils.extractRecords(rrs)) {
                    try {
                        MulticastDNSUtils.setTLLForRecord(record, ttl);
                        this.authRecords.add(record);
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, e.getMessage(), e);
                    }
                }
            }
        }

        public void end() {
            try {
                int index;
                Header h2;
                Message m3;
                if (this.authRecords.size() > 0) {
                    m3 = new Message();
                    h2 = m3.getHeader();
                    h2.setOpcode(5);
                    for (index = 0; index < this.authRecords.size(); ++index) {
                        m3.addRecord((Record)this.authRecords.get(index), 2);
                    }
                    if (MulticastDNSMulticastOnlyQuerier.this.mdnsVerbose || MulticastDNSMulticastOnlyQuerier.this.cacheVerbose) {
                        logger.logp(Level.INFO, this.getClass().getName(), "end", "CacheMonitor Broadcasting update for Authoritative Records:\n" + m3);
                    }
                    MulticastDNSMulticastOnlyQuerier.this.broadcast(m3, false);
                }
                if (this.nonauthRecords.size() > 0) {
                    m3 = new Message();
                    h2 = m3.getHeader();
                    h2.setOpcode(0);
                    h2.setFlag(0);
                    for (index = 0; index < this.nonauthRecords.size(); ++index) {
                        m3.addRecord((Record)this.nonauthRecords.get(index), 2);
                    }
                    if (MulticastDNSMulticastOnlyQuerier.this.mdnsVerbose || MulticastDNSMulticastOnlyQuerier.this.cacheVerbose) {
                        logger.logp(Level.INFO, this.getClass().getName(), "end", "CacheMonitor Locally Broadcasting Non-Authoritative Records:\n" + m3);
                    }
                    MulticastDNSMulticastOnlyQuerier.this.resolverListenerProcessor.getDispatcher().receiveMessage(h2.getID(), m3);
                }
            }
            catch (IOException e) {
                IOException ioe = new IOException("Exception \"" + e.getMessage() + "\" occured while refreshing cached entries.");
                ioe.setStackTrace(e.getStackTrace());
                MulticastDNSMulticastOnlyQuerier.this.resolverListenerDispatcher.handleException("", ioe);
                if (MulticastDNSMulticastOnlyQuerier.this.mdnsVerbose) {
                    logger.log(Level.WARNING, e.getMessage(), e);
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, e.getMessage(), e);
            }
            this.authRecords.clear();
            this.nonauthRecords.clear();
        }

        public void expired(RRset rrs, int credibility) {
            if (MulticastDNSMulticastOnlyQuerier.this.mdnsVerbose || MulticastDNSMulticastOnlyQuerier.this.cacheVerbose) {
                logger.logp(Level.INFO, this.getClass().getName(), "expired", "CacheMonitor RRset expired : " + rrs);
            }
            List list = credibility >= 4 ? this.authRecords : this.nonauthRecords;
            Record[] records = MulticastDNSUtils.extractRecords(rrs);
            if (records != null && records.length > 0) {
                for (int i = 0; i < records.length; ++i) {
                    try {
                        MulticastDNSUtils.setTLLForRecord(records[i], 0L);
                        list.add(records[i]);
                        continue;
                    }
                    catch (Exception e) {
                        logger.log(Level.WARNING, e.getMessage(), e);
                    }
                }
            }
        }

        public boolean isOperational() {
            return System.currentTimeMillis() < this.lastPoll + 10000L;
        }

        protected boolean isAboutToExpire(long ttl, int expiresIn) {
            double percentage = (double)expiresIn / (double)ttl;
            return percentage <= (double)0.07f || percentage >= (double)0.1f && percentage <= (double)0.12f || percentage >= (double)0.15f && percentage <= (double)0.17f || percentage >= (double)0.2f && percentage <= (double)0.22f;
        }
    };

    public MulticastDNSMulticastOnlyQuerier() throws IOException {
        this(false);
    }

    public MulticastDNSMulticastOnlyQuerier(boolean ipv6) throws IOException {
        this(null, InetAddress.getByName(ipv6 ? "FF02::FB" : "224.0.0.251"));
    }

    public MulticastDNSMulticastOnlyQuerier(InetAddress ifaceAddress, InetAddress address) throws IOException {
        this.mdnsVerbose = Options.check("mdns_verbose") || Options.check("verbose");
        this.cacheVerbose = Options.check("mdns_cache_verbose") || Options.check("cache_verbose");
        this.executors.scheduleAtFixedRate(new Runnable(){

            public void run() {
                MulticastDNSMulticastOnlyQuerier.this.mdnsVerbose = Options.check("mdns_verbose") || Options.check("verbose");
                MulticastDNSMulticastOnlyQuerier.this.cacheVerbose = Options.check("mdns_cache_verbose") || Options.check("cache_verbose");
            }
        }, 1L, 1L, TimeUnit.MINUTES);
        this.cache = MulticastDNSCache.DEFAULT_MDNS_CACHE;
        if (this.cache.getCacheMonitor() == null) {
            this.cache.setCacheMonitor(this.cacheMonitor);
        }
        this.setAddress(address);
        if (ifaceAddress != null) {
            this.multicastProcessors.add(new DatagramProcessor(ifaceAddress, address, this.port, this));
        } else {
            HashSet<InetAddress> addresses = new HashSet<InetAddress>();
            HashSet<String> MACs = new HashSet<String>();
            Enumeration<NetworkInterface> netIfaces = NetworkInterface.getNetworkInterfaces();
            while (netIfaces.hasMoreElements()) {
                String mac;
                byte[] hwAddr;
                NetworkInterface netIface = netIfaces.nextElement();
                if (!netIface.isUp() || netIface.isVirtual() || netIface.isLoopback() || (hwAddr = netIface.getHardwareAddress()) == null) continue;
                StringBuilder builder = new StringBuilder();
                for (byte octet : hwAddr) {
                    builder.append(Integer.toHexString(octet & 0xFF)).append(":");
                }
                if (builder.length() > 1) {
                    builder.setLength(builder.length() - 1);
                }
                if (MACs.contains(mac = builder.toString())) continue;
                MACs.add(mac);
                Enumeration<InetAddress> ifaceAddrs = netIface.getInetAddresses();
                while (ifaceAddrs.hasMoreElements()) {
                    InetAddress addr = ifaceAddrs.nextElement();
                    if (address.getAddress().length != addr.getAddress().length) continue;
                    addresses.add(addr);
                }
            }
            for (InetAddress ifaceAddr : addresses) {
                if (ifaceAddr.getAddress().length != address.getAddress().length) continue;
                try {
                    DatagramProcessor multicastProcessor = new DatagramProcessor(ifaceAddr, address, this.port, this);
                    this.multicastProcessors.add(multicastProcessor);
                }
                catch (Exception e) {
                    logger.log(Level.WARNING, "Could not bind to address \"" + ifaceAddr + "\" - " + e.getMessage(), e);
                }
            }
        }
        Runtime.getRuntime().addShutdownHook(new Thread(new Runnable(){

            public void run() {
                try {
                    MulticastDNSMulticastOnlyQuerier.this.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }, this.getClass().getSimpleName() + " Shutdown Hook"));
        this.cacher = new Cacher();
        this.registerListener(this.cacher);
        for (DatagramProcessor multicastProcessor : this.multicastProcessors) {
            multicastProcessor.start();
        }
        this.responder = new MulticastDNSResponder();
        this.registerListener(this.responder);
    }

    public void broadcast(Message message, boolean addKnownAnswers) throws IOException {
        Header header;
        boolean isUpdate;
        if (this.mdnsVerbose) {
            logger.logp(Level.INFO, this.getClass().getName(), "broadcast", "Broadcasting Query to " + this.multicastAddress.getHostAddress() + ":" + this.port);
        }
        boolean bl = isUpdate = (header = message.getHeader()).getOpcode() == 5;
        if (isUpdate) {
            this.updateCache(MulticastDNSUtils.extractRecords(message, 0, 1, 2, 3), 4);
            this.writeMessageToWire(this.convertUpdateToQueryResponse(message));
        } else if (addKnownAnswers) {
            Message knownAnswer = this.cache.queryCache(message, 1);
            for (Integer section : new Integer[]{1, 3, 2}) {
                Record[] records = knownAnswer.getSectionArray(section);
                if (records == null || records.length <= 0) continue;
                for (Record record : records) {
                    if (message.findRecord(record)) continue;
                    message.addRecord(record, section);
                }
            }
            this.writeMessageToWire(message);
        } else {
            this.writeMessageToWire(message);
        }
    }

    public void close() throws IOException {
        block5: {
            try {
                this.cache.close();
            }
            catch (Exception e) {
                if (!this.mdnsVerbose) break block5;
                logger.log(Level.WARNING, "Error closing Cache - " + e.getMessage(), e);
            }
        }
        for (DatagramProcessor multicastProcessor : this.multicastProcessors) {
            try {
                multicastProcessor.close();
            }
            catch (Exception e) {
                if (!this.mdnsVerbose) continue;
                logger.log(Level.WARNING, "Error closing multicastProcessor - " + e.getMessage(), e);
            }
        }
        this.resolverListenerProcessor.close();
    }

    public Cache getCache() {
        return this.cache;
    }

    public Name[] getMulticastDomains() {
        boolean ipv4 = this.isIPv4();
        boolean ipv6 = this.isIPv6();
        if (ipv4 && ipv6) {
            return Constants.ALL_MULTICAST_DNS_DOMAINS;
        }
        if (ipv4) {
            return Constants.IPv4_MULTICAST_DOMAINS;
        }
        if (ipv6) {
            return Constants.IPv6_MULTICAST_DOMAINS;
        }
        return new Name[0];
    }

    public boolean isIPv4() {
        for (DatagramProcessor multicastProcessor : this.multicastProcessors) {
            if (!multicastProcessor.isIPv4()) continue;
            return true;
        }
        return false;
    }

    public boolean isIPv6() {
        for (DatagramProcessor multicastProcessor : this.multicastProcessors) {
            if (!multicastProcessor.isIPv6()) continue;
            return true;
        }
        return false;
    }

    public boolean isOperational() {
        for (DatagramProcessor multicastProcessor : this.multicastProcessors) {
            if (multicastProcessor.isOperational()) continue;
            return false;
        }
        return this.cacheMonitor.isOperational() && this.executors.isScheduledExecutorOperational() && this.executors.isExecutorOperational();
    }

    public void packetReceived(Packet packet) {
        byte[] data;
        if (this.mdnsVerbose) {
            logger.logp(Level.INFO, this.getClass().getName(), "packetReceived", "mDNS Datagram Received!");
        }
        if ((data = packet.getData()).length > 0) {
            if (data.length < 12) {
                if (this.mdnsVerbose) {
                    logger.logp(Level.INFO, this.getClass().getName(), "packetReceived", "Error parsing mDNS Response - Invalid DNS header - too short");
                }
                return;
            }
            try {
                Message message = this.parseMessage(data);
                this.resolverListenerDispatcher.receiveMessage(message.getHeader().getID(), message);
            }
            catch (IOException e) {
                logger.log(Level.WARNING, "Error parsing mDNS Packet - " + e.getMessage() + "\nPacket Data [" + Arrays.toString(data) + "]", e);
            }
        }
    }

    public ResolverListener registerListener(ResolverListener listener) {
        return this.resolverListenerProcessor.registerListener(listener);
    }

    public Message send(Message request) throws IOException {
        if (request == null) {
            throw new IOException("Query is null");
        }
        Message query = (Message)request.clone();
        int opcode = query.getHeader().getOpcode();
        switch (opcode) {
            case 0: 
            case 1: {
                Message message = this.cache.queryCache(query, 1);
                if (MulticastDNSUtils.answersAll(query, message)) {
                    return message;
                }
                final ArrayList results = new ArrayList();
                final ArrayList exceptions = new ArrayList();
                this.sendAsync(query, new ResolverListener(){

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void handleException(Object id, Exception e) {
                        List list = results;
                        synchronized (list) {
                            exceptions.add(e);
                            results.notifyAll();
                        }
                    }

                    /*
                     * WARNING - Removed try catching itself - possible behaviour change.
                     */
                    public void receiveMessage(Object id, Message m3) {
                        List list = results;
                        synchronized (list) {
                            results.add(m3);
                            results.notifyAll();
                        }
                    }
                });
                Wait.forResponse(results);
                if (exceptions.size() <= 0) break;
                Exception e = (Exception)exceptions.get(0);
                IOException ioe = new IOException(e.getMessage());
                ioe.setStackTrace(e.getStackTrace());
                throw ioe;
            }
            case 5: {
                this.broadcast(query, false);
                break;
            }
            default: {
                throw new IOException("Don't know what to do with Opcode: " + Opcode.string(opcode) + " queries.");
            }
        }
        return this.cache.queryCache(query, 1);
    }

    public Object sendAsync(Message m3, final ResolverListener listener) {
        Message query = (Message)m3.clone();
        final Integer id = query.getHeader().getID();
        int opcode = query.getHeader().getOpcode();
        final ListenerWrapper wrapper = new ListenerWrapper(id, query, listener);
        this.registerListener(wrapper);
        switch (opcode) {
            case 0: 
            case 1: {
                try {
                    final Message message = this.cache.queryCache(query, 1);
                    if (message != null && message.getRcode() == 0 && MulticastDNSUtils.answersAll(query, message)) {
                        this.executors.execute(new Runnable(){

                            public void run() {
                                listener.receiveMessage(id, message);
                            }
                        });
                    }
                    try {
                        this.broadcast(query, false);
                    }
                    catch (IOException e) {
                        this.unregisterListener(wrapper);
                        listener.handleException(id, e);
                    }
                    int wait = Options.intValue("mdns_resolve_wait");
                    long timeOut = System.currentTimeMillis() + (long)(wait > 0 ? wait : 500);
                    this.executors.schedule(new Runnable(){

                        public void run() {
                            MulticastDNSMulticastOnlyQuerier.this.unregisterListener(wrapper);
                        }
                    }, timeOut, TimeUnit.MILLISECONDS);
                }
                catch (Exception e) {
                    listener.handleException(id, e);
                }
                break;
            }
            case 5: {
                try {
                    this.broadcast(query, false);
                }
                catch (Exception e) {
                    listener.handleException(id, e);
                    this.unregisterListener(wrapper);
                }
                break;
            }
            default: {
                listener.handleException(id, new IOException("Don't know what to do with Opcode: " + Opcode.string(opcode) + " queries."));
                this.unregisterListener(wrapper);
            }
        }
        return id;
    }

    public void setAddress(InetAddress address) {
        this.multicastAddress = address;
    }

    public void setCache(Cache cache) {
        if (cache instanceof MulticastDNSCache) {
            this.cache = (MulticastDNSCache)cache;
            if (this.cache.getCacheMonitor() == null) {
                this.cache.setCacheMonitor(this.cacheMonitor);
            }
        } else {
            try {
                this.cache = new MulticastDNSCache(cache);
                if (this.cache.getCacheMonitor() == null) {
                    this.cache.setCacheMonitor(this.cacheMonitor);
                }
            }
            catch (Exception e) {
                if (this.mdnsVerbose) {
                    logger.log(Level.WARNING, e.getMessage(), e);
                }
                throw new IllegalArgumentException("Could not set Cache - " + e.getMessage());
            }
        }
    }

    public void setEDNS(int level) {
        this.setEDNS(level, 0, 0, null);
    }

    public void setEDNS(int level, int payloadSize, int flags, List options) {
        if (level != 0 && level != -1) {
            throw new IllegalArgumentException("invalid EDNS level - must be 0 or -1");
        }
        if (payloadSize == 0) {
            payloadSize = 1280;
        }
        this.queryOPT = new OPTRecord(payloadSize, 0, level, flags, options);
    }

    public void setIgnoreTruncation(boolean ignoreTruncation) {
        this.ignoreTruncation = ignoreTruncation;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void setRetryWaitTime(int secs) {
        this.setRetryWaitTime(secs, 0);
    }

    public void setRetryWaitTime(int secs, int msecs) {
        this.responseWaitTime = (long)secs * 1000L + (long)msecs;
    }

    public void setTCP(boolean flag) {
    }

    public void setTimeout(int secs) {
        this.setTimeout(secs, 0);
    }

    public void setTimeout(int secs, int msecs) {
        this.timeoutValue = (long)secs * 1000L + (long)msecs;
    }

    public void setTSIGKey(TSIG key) {
        this.tsig = key;
    }

    public ResolverListener unregisterListener(ResolverListener listener) {
        return this.resolverListenerProcessor.unregisterListener(listener);
    }

    protected void applyEDNS(Message query) {
        if (this.queryOPT == null || query.getOPT() != null) {
            return;
        }
        query.addRecord(this.queryOPT, 3);
    }

    protected Message convertUpdateToQueryResponse(Message update2) {
        int index;
        Message m3 = new Message();
        Header h2 = m3.getHeader();
        h2.setOpcode(0);
        h2.setFlag(5);
        h2.setFlag(0);
        Record[] records = update2.getSectionArray(2);
        for (index = 0; index < records.length; ++index) {
            m3.addRecord(records[index], 1);
        }
        records = update2.getSectionArray(3);
        for (index = 0; index < records.length; ++index) {
            m3.addRecord(records[index], 3);
        }
        return m3;
    }

    protected void finalize() throws Throwable {
        this.close();
        super.finalize();
    }

    protected Message parseMessage(byte[] b) throws WireParseException {
        try {
            return new Message(b);
        }
        catch (IOException e) {
            WireParseException we;
            if (this.mdnsVerbose) {
                e.printStackTrace(System.err);
            }
            if (!(e instanceof WireParseException)) {
                we = new WireParseException("Error parsing message - " + e.getMessage());
                we.setStackTrace(e.getStackTrace());
            } else {
                we = (WireParseException)e;
            }
            throw we;
        }
    }

    protected int verifyTSIG(Message query, Message response, byte[] b, TSIG tsig) {
        if (tsig == null) {
            return 0;
        }
        int error = tsig.verify(response, b, query.getTSIG());
        if (this.mdnsVerbose) {
            logger.logp(Level.INFO, this.getClass().getName(), "verifyTSIG", "TSIG verify: " + Rcode.TSIGstring(error));
        }
        return error;
    }

    protected void writeMessageToWire(Message message) throws IOException {
        Header header = message.getHeader();
        header.setID(0);
        this.applyEDNS(message);
        if (this.tsig != null) {
            this.tsig.apply(message, null);
        }
        byte[] out = message.toWire(65535);
        for (DatagramProcessor multicastProcessor : this.multicastProcessors) {
            OPTRecord opt = message.getOPT();
            int maxUDPSize = opt != null ? opt.getPayloadSize() : multicastProcessor.getMaxPayloadSize();
            if (out.length > maxUDPSize) {
                if (header.getFlag(0)) {
                    throw new IOException("DNS Message too large! - " + out.length + " bytes in size.");
                }
                Message[] messages = MulticastDNSUtils.splitMessage(message);
                for (int index = 0; index < messages.length; ++index) {
                    this.writeMessageToWire(messages[index]);
                }
                return;
            }
            try {
                multicastProcessor.send(out);
            }
            catch (Exception e) {
                this.resolverListenerDispatcher.handleException(message.getHeader().getID(), e);
            }
        }
    }

    protected void writeResponse(Message message) throws IOException {
        if (this.mdnsVerbose) {
            logger.logp(Level.INFO, this.getClass().getName(), "writeResponse", "Writing Response to " + this.multicastAddress.getHostAddress() + ":" + this.port);
        }
        Header header = message.getHeader();
        header.setFlag(5);
        header.setFlag(0);
        header.setRcode(0);
        this.writeMessageToWire(message);
    }

    private void updateCache(Record[] records, int credibility) {
        if (records != null && records.length > 0) {
            for (int index = 0; index < records.length; ++index) {
                Record record = records[index];
                try {
                    Record cacheRecord = MulticastDNSUtils.clone(record);
                    MulticastDNSUtils.setDClassForRecord(cacheRecord, cacheRecord.getDClass() & Short.MAX_VALUE);
                    if (cacheRecord.getTTL() > 0L) {
                        SetResponse response = this.cache.lookupRecords(cacheRecord.getName(), cacheRecord.getType(), 1);
                        RRset[] rrs = response.answers();
                        if (rrs != null && rrs.length > 0) {
                            Record[] cachedRecords = MulticastDNSUtils.extractRecords(rrs);
                            if (cachedRecords == null || cachedRecords.length <= 0) continue;
                            if (this.mdnsVerbose) {
                                logger.logp(Level.INFO, this.getClass().getName(), "updateCache", "Updating Cached Record: " + cacheRecord);
                            }
                            this.cache.updateRRset(cacheRecord, credibility);
                            continue;
                        }
                        if (this.mdnsVerbose) {
                            logger.logp(Level.INFO, this.getClass().getName(), "updateCache", "Caching Record: " + cacheRecord);
                        }
                        this.cache.addRecord(cacheRecord, credibility, null);
                        continue;
                    }
                    this.cache.removeElementCopy(cacheRecord.getName(), cacheRecord.getType());
                    continue;
                }
                catch (Exception e) {
                    if (!this.mdnsVerbose) continue;
                    logger.log(Level.INFO, "Error caching record - " + e.getMessage() + ": " + record, e);
                }
            }
        }
    }

    protected class Cacher
    implements ResolverListener {
        protected Cacher() {
        }

        public void handleException(Object id, Exception e) {
        }

        public void receiveMessage(Object id, Message message) {
            Header header = message.getHeader();
            int rcode = message.getRcode();
            int opcode = header.getOpcode();
            if (MulticastDNSMulticastOnlyQuerier.this.ignoreTruncation && header.getFlag(6)) {
                logger.logp(Level.WARNING, this.getClass().getName(), "receiveMessage", "Truncated Message Ignored : RCode: " + Rcode.string(rcode) + "; Opcode: " + Opcode.string(opcode));
                return;
            }
            switch (opcode) {
                case 0: 
                case 1: 
                case 2: 
                case 4: {
                    if (header.getFlag(0) || header.getFlag(5)) {
                        MulticastDNSMulticastOnlyQuerier.this.updateCache(MulticastDNSUtils.extractRecords(message, 1, 2, 3), 3);
                        break;
                    }
                    return;
                }
                case 5: {
                    logger.logp(Level.SEVERE, this.getClass().getName(), "receiveMessage", "Updates from the network are not allowed!");
                    return;
                }
            }
            if (MulticastDNSMulticastOnlyQuerier.this.mdnsVerbose) {
                logger.logp(Level.INFO, this.getClass().getName(), "receiveMessage", "RCode: " + Rcode.string(rcode));
                logger.logp(Level.INFO, this.getClass().getName(), "receiveMessage", "Opcode: " + Opcode.string(opcode));
            }
        }
    }

    public class MulticastDNSResponder
    implements ResolverListener {
        public void handleException(Object id, Exception e) {
        }

        public void receiveMessage(Object id, Message message) {
            int rcode = message.getRcode();
            Header header = message.getHeader();
            int opcode = header.getOpcode();
            if (header.getFlag(0) || header.getFlag(5)) {
                return;
            }
            if (header.getFlag(6) && MulticastDNSMulticastOnlyQuerier.this.ignoreTruncation) {
                logger.logp(Level.WARNING, this.getClass().getName(), "receiveMessage", "Truncated Message : RCode: " + Rcode.string(rcode) + "; Opcode: " + Opcode.string(opcode) + " - Ignoring subsequent known answer records.");
                return;
            }
            if (MulticastDNSMulticastOnlyQuerier.this.mdnsVerbose) {
                logger.logp(Level.INFO, this.getClass().getName(), "receiveMessage", "RCode: " + Rcode.string(rcode));
                logger.logp(Level.INFO, this.getClass().getName(), "receiveMessage", "Opcode: " + Opcode.string(opcode));
            }
            try {
                switch (opcode) {
                    case 0: 
                    case 1: {
                        Message response = MulticastDNSMulticastOnlyQuerier.this.cache.queryCache(message, 4);
                        if (response == null) break;
                        Header responseHeader = response.getHeader();
                        if (responseHeader.getCount(1) > 0 || responseHeader.getCount(2) > 0 || responseHeader.getCount(3) > 0) {
                            if (MulticastDNSMulticastOnlyQuerier.this.mdnsVerbose) {
                                logger.logp(Level.INFO, this.getClass().getName(), "receiveMessage", "Query Reply ID: " + id + "\n" + response);
                            }
                            responseHeader.setFlag(5);
                            responseHeader.setFlag(0);
                            MulticastDNSMulticastOnlyQuerier.this.writeResponse(response);
                            break;
                        }
                        if (MulticastDNSMulticastOnlyQuerier.this.mdnsVerbose) {
                            logger.logp(Level.INFO, this.getClass().getName(), "receiveMessage", "No response, client knows answer.");
                        }
                        break;
                    }
                    case 2: 
                    case 4: 
                    case 5: {
                        logger.logp(Level.WARNING, this.getClass().getName(), "receiveMessage", "Received Invalid Request - Opcode: " + Opcode.string(opcode));
                    }
                }
            }
            catch (Exception e) {
                logger.log(Level.WARNING, "Error replying to query - " + e.getMessage(), e);
            }
        }
    }

    public class ListenerWrapper
    implements ResolverListener {
        private final Object id;
        private final Message query;
        private final ResolverListener listener;

        public ListenerWrapper(Object id, Message query, ResolverListener listener) {
            this.id = id;
            this.query = query;
            this.listener = listener;
        }

        public boolean equals(Object o) {
            if (this == o || this.listener == o) {
                return true;
            }
            if (o instanceof ListenerWrapper) {
                return this.listener == ((ListenerWrapper)o).listener;
            }
            return false;
        }

        public void handleException(Object id, Exception e) {
            if (this.id == null || this.id.equals(id)) {
                this.listener.handleException(this.id, e);
                MulticastDNSMulticastOnlyQuerier.this.unregisterListener(this);
            }
        }

        public int hashCode() {
            return this.listener.hashCode();
        }

        public void receiveMessage(Object id, Message m3) {
            Header h2 = m3.getHeader();
            if (h2.getFlag(0) || h2.getFlag(5) || h2.getFlag(10)) {
                if (MulticastDNSUtils.answersAny(this.query, m3)) {
                    this.listener.receiveMessage(this.id, m3);
                    MulticastDNSMulticastOnlyQuerier.this.unregisterListener(this);
                }
            } else {
                return;
            }
        }
    }
}

