/*
 * Decompiled with CFR 0.152.
 */
package net.posick.mDNS;

import java.io.IOException;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.posick.mDNS.Constants;
import net.posick.mDNS.MulticastDNSMulticastOnlyQuerier;
import net.posick.mDNS.MulticastDNSService;
import net.posick.mDNS.Querier;
import net.posick.mDNS.utils.ListenerProcessor;
import net.posick.mDNS.utils.Misc;
import org.xbill.DNS.ExtendedResolver;
import org.xbill.DNS.Header;
import org.xbill.DNS.Message;
import org.xbill.DNS.MulticastDNSUtils;
import org.xbill.DNS.Name;
import org.xbill.DNS.Options;
import org.xbill.DNS.Record;
import org.xbill.DNS.Resolver;
import org.xbill.DNS.ResolverListener;
import org.xbill.DNS.TSIG;

public class MulticastDNSQuerier
implements Querier {
    private static final Logger logger = Misc.getLogger(MulticastDNSQuerier.class, Options.check("mds_verbose") || Options.check("verbose"));
    protected ListenerProcessor<ResolverListener> resolverListenerProcessor;
    protected ResolverListener resolverListenerDispatcher;
    protected boolean ipv4;
    protected boolean ipv6;
    protected Querier[] multicastResponders;
    protected Resolver[] unicastResolvers;
    private final boolean mdnsVerbose;
    protected ResolverListener resolverDispatch;

    public MulticastDNSQuerier() throws IOException {
        this(true, false, new Resolver[]{new ExtendedResolver()});
    }

    public MulticastDNSQuerier(boolean ipv4, boolean ipv6) throws IOException {
        this(ipv4, ipv6, (Resolver[])null);
    }

    public MulticastDNSQuerier(boolean ipv4, boolean ipv6, Resolver unicastResolver) throws IOException {
        this(ipv4, ipv6, new Resolver[]{unicastResolver});
    }

    public MulticastDNSQuerier(boolean ipv4, boolean ipv6, Resolver[] unicastResolvers) throws IOException {
        IOException ipv6_exception;
        IOException ipv4_exception;
        MulticastDNSMulticastOnlyQuerier ipv6Responder;
        MulticastDNSMulticastOnlyQuerier ipv4Responder;
        block15: {
            block14: {
                this.resolverListenerProcessor = new ListenerProcessor<ResolverListener>(ResolverListener.class);
                this.resolverListenerDispatcher = this.resolverListenerProcessor.getDispatcher();
                this.ipv4 = false;
                this.ipv6 = false;
                this.resolverDispatch = new ResolverListener(){

                    public void handleException(Object id, Exception e) {
                        MulticastDNSQuerier.this.resolverListenerDispatcher.handleException(id, e);
                    }

                    public void receiveMessage(Object id, Message m3) {
                        MulticastDNSQuerier.this.resolverListenerDispatcher.receiveMessage(id, m3);
                    }
                };
                this.mdnsVerbose = Options.check("mdns_verbose");
                this.unicastResolvers = unicastResolvers == null || unicastResolvers.length == 0 ? new Resolver[]{new ExtendedResolver()} : unicastResolvers;
                ipv4Responder = null;
                ipv6Responder = null;
                ipv4_exception = null;
                ipv6_exception = null;
                if (ipv4) {
                    try {
                        ipv4Responder = new MulticastDNSMulticastOnlyQuerier(false);
                        this.ipv4 = true;
                    }
                    catch (IOException e) {
                        ipv4Responder = null;
                        ipv4_exception = e;
                        if (!this.mdnsVerbose) break block14;
                        logger.log(Level.WARNING, "Error constructing IPv4 mDNS Responder - " + e.getMessage(), e);
                    }
                }
            }
            if (ipv6) {
                try {
                    ipv6Responder = new MulticastDNSMulticastOnlyQuerier(true);
                    this.ipv6 = true;
                }
                catch (IOException e) {
                    ipv6Responder = null;
                    ipv6_exception = e;
                    if (!this.mdnsVerbose) break block15;
                    logger.log(Level.WARNING, "Error constructing IPv6 mDNS Responder - " + e.getMessage(), e);
                }
            }
        }
        if (ipv4Responder != null && ipv6Responder != null) {
            this.multicastResponders = new Querier[]{ipv4Responder, ipv6Responder};
            ipv4Responder.registerListener(this.resolverDispatch);
            ipv6Responder.registerListener(this.resolverDispatch);
        } else if (ipv4Responder != null) {
            this.multicastResponders = new Querier[]{ipv4Responder};
            ipv4Responder.registerListener(this.resolverDispatch);
        } else if (ipv6Responder != null) {
            this.multicastResponders = new Querier[]{ipv6Responder};
            ipv6Responder.registerListener(this.resolverDispatch);
        } else {
            if (ipv4_exception != null) {
                throw ipv4_exception;
            }
            if (ipv6_exception != null) {
                throw ipv6_exception;
            }
        }
    }

    public void broadcast(Message message, boolean addKnown) throws IOException {
        boolean success = false;
        IOException ex = null;
        for (Querier responder : this.multicastResponders) {
            try {
                responder.broadcast(message, addKnown);
                success = true;
            }
            catch (IOException e) {
                ex = e;
            }
        }
        for (Resolver resolver : this.unicastResolvers) {
            resolver.sendAsync(message, new ResolverListener(){

                public void handleException(Object id, Exception e) {
                    MulticastDNSQuerier.this.resolverListenerDispatcher.handleException(id, e);
                }

                public void receiveMessage(Object id, Message m3) {
                    MulticastDNSQuerier.this.resolverListenerDispatcher.receiveMessage(id, m3);
                }
            });
        }
        if (!success && ex != null) {
            throw ex;
        }
    }

    public void close() throws IOException {
        for (Querier querier : this.multicastResponders) {
            try {
                querier.close();
            }
            catch (Exception e) {
                if (!this.mdnsVerbose) continue;
                logger.log(Level.WARNING, "Error closing Responder: " + e.getMessage(), e);
            }
        }
    }

    public Name[] getMulticastDomains() {
        if (this.ipv4 && this.ipv6) {
            return Constants.ALL_MULTICAST_DNS_DOMAINS;
        }
        if (this.ipv4) {
            return Constants.IPv4_MULTICAST_DOMAINS;
        }
        if (this.ipv6) {
            return Constants.IPv6_MULTICAST_DOMAINS;
        }
        return new Name[0];
    }

    public Resolver[] getUnicastResolvers() {
        return this.unicastResolvers;
    }

    public boolean isIPv4() {
        return this.ipv4;
    }

    public boolean isIPv6() {
        return this.ipv6;
    }

    public boolean isOperational() {
        for (Querier querier : this.multicastResponders) {
            if (querier.isOperational()) continue;
            return false;
        }
        return true;
    }

    public ResolverListener registerListener(ResolverListener listener) {
        for (Querier querier : this.multicastResponders) {
            querier.registerListener(listener);
        }
        return listener;
    }

    public Message send(Message query) throws IOException {
        Resolution res = new Resolution(this, query, null);
        res.start();
        return res.getResponse(6000);
    }

    public Object sendAsync(Message query, ResolverListener listener) {
        Resolution res = new Resolution(this, query, listener);
        res.start();
        return res;
    }

    public void setEDNS(int level) {
        for (Querier querier : this.multicastResponders) {
            querier.setEDNS(level);
        }
        for (Resolver resolver : this.unicastResolvers) {
            resolver.setEDNS(level);
        }
    }

    public void setEDNS(int level, int payloadSize, int flags, List options) {
        for (Querier querier : this.multicastResponders) {
            querier.setEDNS(level, payloadSize, flags, options);
        }
        for (Resolver resolver : this.unicastResolvers) {
            resolver.setEDNS(level, payloadSize, flags, options);
        }
    }

    public void setIgnoreTruncation(boolean flag) {
        for (Querier querier : this.multicastResponders) {
            querier.setIgnoreTruncation(flag);
        }
        for (Resolver resolver : this.unicastResolvers) {
            resolver.setIgnoreTruncation(flag);
        }
    }

    public void setPort(int port) {
        for (Querier querier : this.multicastResponders) {
            querier.setPort(port);
        }
    }

    public void setRetryWaitTime(int secs) {
        for (Querier querier : this.multicastResponders) {
            querier.setTimeout(secs);
        }
    }

    public void setRetryWaitTime(int secs, int msecs) {
        for (Querier querier : this.multicastResponders) {
            querier.setTimeout(secs, msecs);
        }
    }

    public void setTCP(boolean flag) {
        for (Resolver resolver : this.unicastResolvers) {
            resolver.setTCP(flag);
        }
    }

    public void setTimeout(int secs) {
        for (Querier querier : this.multicastResponders) {
            querier.setTimeout(secs);
        }
        for (Resolver resolver : this.unicastResolvers) {
            resolver.setTimeout(secs);
        }
    }

    public void setTimeout(int secs, int msecs) {
        for (Querier querier : this.multicastResponders) {
            querier.setTimeout(secs, msecs);
        }
        for (Resolver resolver : this.unicastResolvers) {
            resolver.setTimeout(secs, msecs);
        }
    }

    public void setTSIGKey(TSIG key) {
        for (Querier querier : this.multicastResponders) {
            querier.setTSIGKey(key);
        }
        for (Resolver resolver : this.unicastResolvers) {
            resolver.setTSIGKey(key);
        }
    }

    public ResolverListener unregisterListener(ResolverListener listener) {
        for (Querier querier : this.multicastResponders) {
            querier.unregisterListener(listener);
        }
        return listener;
    }

    protected static class Response {
        private Object id = null;
        private Message message = null;
        private Exception exception = null;

        protected Response(Object id, Exception exception) {
            this.id = id;
            this.exception = exception;
        }

        protected Response(Object id, Message message) {
            this.id = id;
            this.message = message;
        }

        public Exception getException() {
            return this.exception;
        }

        public Object getID() {
            return this.id;
        }

        public Message getMessage() {
            return this.message;
        }

        public boolean inError() {
            return this.exception != null;
        }
    }

    protected static class Resolution
    implements ResolverListener {
        private MulticastDNSQuerier querier = null;
        private Message query = null;
        private ResolverListener listener = null;
        private final LinkedList responses = new LinkedList();
        private int requestsSent;
        private final List requestIDs = new ArrayList();
        private boolean mdnsVerbose = false;

        public Resolution(MulticastDNSQuerier querier, Message query, ResolverListener listener) {
            this.querier = querier;
            this.query = query;
            this.listener = listener;
            this.mdnsVerbose = Options.check("mdns_verbose");
        }

        public Message getResponse(int timeout2) throws IOException {
            Message response = (Message)this.query.clone();
            Header header = response.getHeader();
            try {
                Message[] messages = this.getResults(true, timeout2);
                boolean found = false;
                if (messages != null && messages.length > 0) {
                    header.setRcode(0);
                    header.setOpcode(0);
                    header.setFlag(0);
                    for (Message message : messages) {
                        Header h2 = message.getHeader();
                        if (h2.getRcode() != 0) continue;
                        if (h2.getFlag(5)) {
                            header.setFlag(5);
                        }
                        if (h2.getFlag(10)) {
                            header.setFlag(10);
                        }
                        for (int section : new int[]{1, 3, 2}) {
                            Record[] records = message.getSectionArray(section);
                            if (records == null || records.length <= 0) continue;
                            for (Record record : records) {
                                if (response.findRecord(record)) continue;
                                response.addRecord(record, section);
                                found = true;
                            }
                        }
                    }
                }
                if (!found) {
                    header.setRcode(3);
                }
                return response;
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                IOException ioe = new IOException(e.getMessage());
                ioe.setStackTrace(e.getStackTrace());
                throw ioe;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Message[] getResults(boolean waitForResults, int timeoutValue) throws Exception {
            if (waitForResults) {
                long now = System.currentTimeMillis();
                long timeout2 = now + (long)timeoutValue;
                while (!this.hasResults() && (now = System.currentTimeMillis()) < timeout2) {
                    LinkedList linkedList = this.responses;
                    synchronized (linkedList) {
                        if (!this.hasResults()) {
                            try {
                                this.responses.wait(timeout2 - now);
                            }
                            catch (InterruptedException interruptedException) {
                                // empty catch block
                            }
                        }
                    }
                }
            }
            if (this.responses.size() > 0) {
                LinkedList<Message> messages = new LinkedList<Message>();
                LinkedList<Exception> exceptions = new LinkedList<Exception>();
                for (Object o : this.responses) {
                    Response response = (Response)o;
                    if (response.inError()) {
                        exceptions.add(response.getException());
                        continue;
                    }
                    messages.add(response.getMessage());
                }
                if (messages.size() > 0) {
                    return messages.toArray(new Message[messages.size()]);
                }
                if (exceptions.size() > 0) {
                    throw (Exception)exceptions.get(0);
                }
            }
            return null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleException(Object id, Exception exception) {
            if (!(this.requestIDs.size() == 0 || this.requestIDs.contains(id) && this == id && this.equals(id))) {
                logger.logp(Level.FINE, this.getClass().getName(), "handleException", "!!!!! Exception Received for ID - " + id + ".");
                LinkedList linkedList = this.responses;
                synchronized (linkedList) {
                    this.responses.add(new Response(id, exception));
                    this.responses.notifyAll();
                }
                if (this.listener != null) {
                    this.listener.handleException(this, exception);
                }
            } else if (this.mdnsVerbose) {
                String msg = "!!!!! Exception Disgarded ";
                if (this.requestIDs.size() == 0 || this.requestIDs.contains(id) && this == id && this.equals(id)) {
                    msg = msg + "[Request ID does not match Response ID - " + id + " ] ";
                }
                logger.logp(Level.FINE, this.getClass().getName(), "handleException", msg, exception);
            }
        }

        public boolean hasResults() {
            return this.responses.size() >= this.requestsSent;
        }

        public boolean inError() {
            for (Object o : this.responses) {
                Response response = (Response)o;
                if (response.inError()) continue;
                return false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void receiveMessage(Object id, Message message) {
            if (this.requestIDs.size() == 0 || this.requestIDs.contains(id) || this == id || this.equals(id) || MulticastDNSUtils.answersAny(this.query, message)) {
                logger.logp(Level.FINE, this.getClass().getName(), "receiveMessage", "!!!! Message Received - " + id + " - " + this.query.getQuestion());
                LinkedList linkedList = this.responses;
                synchronized (linkedList) {
                    this.responses.add(new Response((Object)this, message));
                    this.responses.notifyAll();
                }
                if (this.listener != null) {
                    this.listener.receiveMessage(this, message);
                }
            } else if (this.mdnsVerbose) {
                String msg = "!!!!! Message Disgarded ";
                if (!(this.requestIDs.size() == 0 || this.requestIDs.contains(id) && this == id && this.equals(id))) {
                    msg = msg + "[Request ID does not match Response ID] ";
                }
                if (!MulticastDNSUtils.answersAny(this.query, message)) {
                    msg = msg + "[Response does not answer Query]";
                }
                logger.logp(Level.FINE, this.getClass().getName(), "receiveMessage", msg + "\n" + message);
            }
        }

        public Object start() {
            this.requestsSent = 0;
            this.requestIDs.clear();
            boolean unicast = false;
            boolean multicast = false;
            if (MulticastDNSService.hasUnicastDomains(this.query) && this.querier.unicastResolvers != null && this.querier.unicastResolvers.length > 0) {
                for (Resolver resolver : this.querier.unicastResolvers) {
                    unicast = true;
                    this.requestIDs.add(resolver.sendAsync(this.query, this));
                    ++this.requestsSent;
                }
            }
            if (MulticastDNSService.hasMulticastDomains(this.query) && this.querier.multicastResponders != null && this.querier.multicastResponders.length > 0) {
                for (Resolver resolver : this.querier.multicastResponders) {
                    multicast = true;
                    this.requestIDs.add(resolver.sendAsync(this.query, this));
                    ++this.requestsSent;
                }
            }
            if (!unicast && !multicast) {
                logger.logp(Level.SEVERE, this.getClass().getName(), "start", "Could not execute query, no Unicast Resolvers or Multicast Queriers were available\n" + this.query);
            }
            return this;
        }
    }
}

