/*
 * Decompiled with CFR 0.152.
 */
package net.posick.mDNS.utils;

import java.util.EmptyStackException;
import java.util.Stack;
import java.util.concurrent.TimeUnit;

public class ExecutionTimer {
    private static ExecutionTimer timer = new ExecutionTimer();
    private final Stack stack = new Stack();

    public long start() {
        return this.stack.push(new Long(System.nanoTime()));
    }

    public double took(TimeUnit unit) {
        try {
            long start = (Long)this.stack.pop();
            long took = System.nanoTime() - start;
            switch (unit) {
                case DAYS: {
                    return (double)took / 8.64E13;
                }
                case HOURS: {
                    return (double)took / 3.6E12;
                }
                case MICROSECONDS: {
                    return (double)took / 1000.0;
                }
                case MILLISECONDS: {
                    return (double)took / 1000000.0;
                }
                case MINUTES: {
                    return (double)took / 6.0E10;
                }
                case NANOSECONDS: {
                    return took;
                }
                case SECONDS: {
                    return (double)took / 1.0E9;
                }
            }
        }
        catch (EmptyStackException emptyStackException) {
            // empty catch block
        }
        return 0.0;
    }

    public static long _start() {
        return timer.start();
    }

    public static double _took(TimeUnit unit) {
        return timer.took(unit);
    }
}

