// SDB-CGEN V1.8.2
// gcc -DMAIN=1 java.c ; ./a.out > java.h
#include <ctype.h>
#include <stdio.h>
#include <string.h>

struct kv { const char *name; const char *value; };
static struct kv kvs[] = {
  {"aaload","load onto the stack a reference from an array"}, 
  {"aastore","store into a reference in an array"}, 
  {"aconst_null","push a "}, 
  {"aload","load a reference onto the stack from a local variable "}, 
  {"aload_0","load a reference onto the stack from local variable 0"}, 
  {"aload_1","load a reference onto the stack from local variable 1"}, 
  {"aload_2","load a reference onto the stack from local variable 2"}, 
  {"aload_3","load a reference onto the stack from local variable 3"}, 
  {"anewarray","create a new array of references of length "}, 
  {"areturn","return a reference from a method"}, 
  {"arraylength","get the length of an array"}, 
  {"astore","store a reference into a local variable "}, 
  {"astore_0","store a reference into local variable 0"}, 
  {"astore_1","store a reference into local variable 1"}, 
  {"astore_2","store a reference into local variable 2"}, 
  {"astore_3","store a reference into local variable 3"}, 
  {"athrow","throws an error or exception (notice that the rest of the stack is cleared, leaving only a reference to the Throwable)"}, 
  {"baload","load a byte or Boolean value from an array"}, 
  {"bastore","store a byte or Boolean value into an array"}, 
  {"bipush","push a "}, 
  {"breakpoint","reserved for breakpoints in Java debuggers; should not appear in any class file"}, 
  {"caload","load a char from an array"}, 
  {"castore","store a char into an array"}, 
  {"checkcast","checks whether an "}, 
  {"d2f","convert a double to a float"}, 
  {"d2i","convert a double to an int"}, 
  {"d2l","convert a double to a long"}, 
  {"dadd","add two doubles"}, 
  {"daload","load a double from an array"}, 
  {"dastore","store a double into an array"}, 
  {"dcmpg","compare two doubles"}, 
  {"dcmpl","compare two doubles"}, 
  {"dconst_0","push the constant "}, 
  {"dconst_1","push the constant "}, 
  {"ddiv","divide two doubles"}, 
  {"dload","load a double "}, 
  {"dload_0","load a double from local variable 0"}, 
  {"dload_1","load a double from local variable 1"}, 
  {"dload_2","load a double from local variable 2"}, 
  {"dload_3","load a double from local variable 3"}, 
  {"dmul","multiply two doubles"}, 
  {"dneg","negate a double"}, 
  {"drem","get the remainder from a division between two doubles"}, 
  {"dreturn","return a double from a method"}, 
  {"dstore","store a double "}, 
  {"dstore_0","store a double into local variable 0"}, 
  {"dstore_1","store a double into local variable 1"}, 
  {"dstore_2","store a double into local variable 2"}, 
  {"dstore_3","store a double into local variable 3"}, 
  {"dsub","subtract a double from another"}, 
  {"dup","duplicate the value on top of the stack"}, 
  {"dup2","duplicate top two stack words (two values, if value1 is not double nor long; a single value, if value1 is double or long)"}, 
  {"dup2_x1","duplicate two words and insert beneath third word (see explanation above)"}, 
  {"dup2_x2","duplicate two words and insert beneath fourth word"}, 
  {"dup_x1","insert a copy of the top value into the stack two values from the top. value1 and value2 must not be of the type double or long."}, 
  {"dup_x2","insert a copy of the top value into the stack two (if value2 is double or long it takes up the entry of value3, too) or three values (if value2 is neither double nor long) from the top"}, 
  {"f2d","convert a float to a double"}, 
  {"f2i","convert a float to an int"}, 
  {"f2l","convert a float to a long"}, 
  {"fadd","add two floats"}, 
  {"faload","load a float from an array"}, 
  {"fastore","store a float in an array"}, 
  {"fcmpg","compare two floats"}, 
  {"fcmpl","compare two floats"}, 
  {"fconst_0","push "}, 
  {"fconst_1","push "}, 
  {"fconst_2","push "}, 
  {"fdiv","divide two floats"}, 
  {"fload","load a float "}, 
  {"fload_0","load a float "}, 
  {"fload_1","load a float "}, 
  {"fload_2","load a float "}, 
  {"fload_3","load a float "}, 
  {"fmul","multiply two floats"}, 
  {"fneg","negate a float"}, 
  {"frem","get the remainder from a division between two floats"}, 
  {"freturn","return a float"}, 
  {"fstore","store a float "}, 
  {"fstore_0","store a float "}, 
  {"fstore_1","store a float "}, 
  {"fstore_2","store a float "}, 
  {"fstore_3","store a float "}, 
  {"fsub","subtract two floats"}, 
  {"getfield","get a field "}, 
  {"getstatic","get a static field "}, 
  {"goto","goes to another instruction at "}, 
  {"goto_w","goes to another instruction at "}, 
  {"i2b","convert an int into a byte"}, 
  {"i2c","convert an int into a character"}, 
  {"i2d","convert an int into a double"}, 
  {"i2f","convert an int into a float"}, 
  {"i2l","convert an int into a long"}, 
  {"i2s","convert an int into a short"}, 
  {"iadd","add two ints"}, 
  {"iaload","load an int from an array"}, 
  {"iand","perform a bitwise and on two integers"}, 
  {"iastore","store an int into an array"}, 
  {"iconst_0","load the int value 0 onto the stack"}, 
  {"iconst_1","load the int value 1 onto the stack"}, 
  {"iconst_2","load the int value 2 onto the stack"}, 
  {"iconst_3","load the int value 3 onto the stack"}, 
  {"iconst_4","load the int value 4 onto the stack"}, 
  {"iconst_5","load the int value 5 onto the stack"}, 
  {"iconst_m1","load the int value −1 onto the stack"}, 
  {"idiv","divide two integers"}, 
  {"if_acmpeq","if references are equal, branch to instruction at "}, 
  {"if_acmpne","if references are not equal, branch to instruction at "}, 
  {"if_icmpeq","if ints are equal, branch to instruction at "}, 
  {"if_icmpge","if "}, 
  {"if_icmpgt","if "}, 
  {"if_icmple","if "}, 
  {"if_icmplt","if "}, 
  {"if_icmpne","if ints are not equal, branch to instruction at "}, 
  {"ifeq","if "}, 
  {"ifge","if "}, 
  {"ifgt","if "}, 
  {"ifle","if "}, 
  {"iflt","if "}, 
  {"ifne","if "}, 
  {"ifnonnull","if "}, 
  {"ifnull","if "}, 
  {"iinc","increment local variable "}, 
  {"iload","load an int "}, 
  {"iload_0","load an int "}, 
  {"iload_1","load an int "}, 
  {"iload_2","load an int "}, 
  {"iload_3","load an int "}, 
  {"impdep1","reserved for implementation-dependent operations within debuggers; should not appear in any class file"}, 
  {"impdep2","reserved for implementation-dependent operations within debuggers; should not appear in any class file"}, 
  {"imul","multiply two integers"}, 
  {"ineg","negate int"}, 
  {"instanceof","determines if an object "}, 
  {"invokedynamic","invokes a dynamic method and puts the result on the stack (might be void); the method is identified by method reference "}, 
  {"invokeinterface","invokes an interface method on object "}, 
  {"invokespecial","invoke instance method on object "}, 
  {"invokestatic","invoke a static method and puts the result on the stack (might be void); the method is identified by method reference "}, 
  {"invokevirtual","invoke virtual method on object "}, 
  {"ior","bitwise int or"}, 
  {"irem","logical int remainder"}, 
  {"ireturn","return an integer from a method"}, 
  {"ishl","int shift left"}, 
  {"ishr","int arithmetic shift right"}, 
  {"istore","store int "}, 
  {"istore_0","store int "}, 
  {"istore_1","store int "}, 
  {"istore_2","store int "}, 
  {"istore_3","store int "}, 
  {"isub","int subtract"}, 
  {"iushr","int logical shift right"}, 
  {"ixor","int xor"}, 
  {"jsr","jump to subroutine at "}, 
  {"jsr_w","jump to subroutine at "}, 
  {"l2d","convert a long to a double"}, 
  {"l2f","convert a long to a float"}, 
  {"l2i","convert a long to a int"}, 
  {"ladd","add two longs"}, 
  {"laload","load a long from an array"}, 
  {"land","bitwise and of two longs"}, 
  {"lastore","store a long to an array"}, 
  {"lcmp","push 0 if the two longs are the same, 1 if value1 is greater than value2, -1 otherwise"}, 
  {"lconst_0","push the long 0 onto the stack"}, 
  {"lconst_1","push the long 1 onto the stack"}, 
  {"ldc","push a constant "}, 
  {"ldc2_w","push a constant "}, 
  {"ldc_w","push a constant "}, 
  {"ldiv","divide two longs"}, 
  {"lload","load a long value from a local variable "}, 
  {"lload_0","load a long value from a local variable 0"}, 
  {"lload_1","load a long value from a local variable 1"}, 
  {"lload_2","load a long value from a local variable 2"}, 
  {"lload_3","load a long value from a local variable 3"}, 
  {"lmul","multiply two longs"}, 
  {"lneg","negate a long"}, 
  {"lookupswitch","a target address is looked up from a table using a key and execution continues from the instruction at that address"}, 
  {"lor","bitwise or of two longs"}, 
  {"lrem","remainder of division of two longs"}, 
  {"lreturn","return a long value"}, 
  {"lshl","bitwise shift left of a long "}, 
  {"lshr","bitwise shift right of a long "}, 
  {"lstore","store a long "}, 
  {"lstore_0","store a long "}, 
  {"lstore_1","store a long "}, 
  {"lstore_2","store a long "}, 
  {"lstore_3","store a long "}, 
  {"lsub","subtract two longs"}, 
  {"lushr","bitwise shift right of a long "}, 
  {"lxor","bitwise exclusive or of two longs"}, 
  {"monitorenter","enter monitor for object (\""}, 
  {"monitorexit","exit monitor for object (\""}, 
  {"multianewarray","create a new array of "}, 
  {"new","create new object of type identified by class reference in constant pool "}, 
  {"newarray","create new array with "}, 
  {"nop","perform no operation"}, 
  {"pop","discard the top value on the stack"}, 
  {"pop2","discard the top two values on the stack (or one value, if it is a double or long)"}, 
  {"putfield","set field to "}, 
  {"putstatic","set static field to "}, 
  {"ret","continue execution from address taken from a local variable "}, 
  {"return","return void from method"}, 
  {"saload","load short from array"}, 
  {"sastore","store short to array"}, 
  {"sipush","push a short onto the stack"}, 
  {"swap","swaps two top words on the stack (note that value1 and value2 must not be double or long)"}, 
  {"tableswitch","continue execution from an address in the table at offset "}, 
  {"wide","execute"}, 
  {NULL, NULL}
};
// 0x4e9150
// TODO
typedef int (*GperfForeachCallback)(void *user, const char *k, const char *v);
int gperf_java_foreach(GperfForeachCallback cb, void *user) {
  int i = 0; while (kvs[i].name) {
  cb (user, kvs[i].name, kvs[i].value);
  i++;}
  return 0;
}
const char *gperf_java_get(const char *s) {
  int i = 0; while (kvs[i].name) {
  if (!strcmp (s, kvs[i].name)) return kvs[i].value;
  i++;}
  return NULL;
}
#define sdb_hash_c_java(x,y) gperf_java_hash(x)
const unsigned int gperf_java_hash(const char *s) {
  int sum = strlen (s);
  while (*s) { sum += *s; s++; }
  return sum;
}
struct {const char *name;void *get;void *hash;void *foreach;} gperf_java = {
  .name = "java",
  .get = &gperf_java_get,
  .hash = &gperf_java_hash,
  .foreach = &gperf_java_foreach
};

#if MAIN
int main () {
	const char *s = ((char*(*)(char*))gperf_java.get)("foo");
	printf ("%s\n", s);
}
#endif
