/*
 * Decompiled with CFR 0.152.
 */
package org.apache.ivy.core.resolve;

import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import org.apache.ivy.core.module.descriptor.DependencyArtifactDescriptor;
import org.apache.ivy.core.module.descriptor.DependencyDescriptor;
import org.apache.ivy.core.module.descriptor.IncludeRule;
import org.apache.ivy.core.resolve.IvyNode;
import org.apache.ivy.core.resolve.IvyNodeBlacklist;

public class IvyNodeUsage {
    private IvyNode node;
    private Map rootModuleConfs = new HashMap();
    private Map requiredConfs = new HashMap();
    private Map dependers = new HashMap();
    private Map blacklisted = new HashMap();

    public IvyNodeUsage(IvyNode ivyNode) {
        this.node = ivyNode;
    }

    protected Collection getRequiredConfigurations(IvyNode ivyNode, String string) {
        return (Collection)this.requiredConfs.get(new NodeConf(ivyNode, string));
    }

    protected void setRequiredConfs(IvyNode ivyNode, String string, Collection collection) {
        this.requiredConfs.put(new NodeConf(ivyNode, string), new HashSet(collection));
    }

    protected Set getConfigurations(String string) {
        return (Set)this.rootModuleConfs.get(string);
    }

    protected Set addAndGetConfigurations(String string) {
        HashSet hashSet = (HashSet)this.rootModuleConfs.get(string);
        if (hashSet == null) {
            hashSet = new HashSet();
            this.rootModuleConfs.put(string, hashSet);
        }
        return hashSet;
    }

    protected Set getRootModuleConfigurations() {
        return this.rootModuleConfs.keySet();
    }

    public void updateDataFrom(Collection object, String string) {
        object = object.iterator();
        while (object.hasNext()) {
            IvyNodeUsage ivyNodeUsage = (IvyNodeUsage)object.next();
            this.updateDataFrom(ivyNodeUsage, string);
        }
    }

    private void updateDataFrom(IvyNodeUsage ivyNodeUsage, String string) {
        this.updateMapOfSet(ivyNodeUsage.requiredConfs, this.requiredConfs);
        this.updateMapOfSetForKey(ivyNodeUsage.rootModuleConfs, this.rootModuleConfs, string);
        this.updateMapOfSetForKey(ivyNodeUsage.dependers, this.dependers, string);
    }

    private void updateMapOfSet(Map map, Map map2) {
        for (Object k : map.keySet()) {
            this.updateMapOfSetForKey(map, map2, k);
        }
    }

    private void updateMapOfSetForKey(Map object, Map map, Object object2) {
        if ((object = (Set)object.get(object2)) != null) {
            Set set = (Set)map.get(object2);
            if (set != null) {
                set.addAll(object);
                return;
            }
            map.put(object2, new HashSet(object));
        }
    }

    private void addObjectsForConf(String string, Object object, Map map) {
        HashSet<Object> hashSet = (HashSet<Object>)map.get(string);
        if (hashSet == null) {
            hashSet = new HashSet<Object>();
            map.put(string, hashSet);
        }
        hashSet.add(object);
    }

    public void addUsage(String string, DependencyDescriptor dependencyDescriptor, String string2) {
        this.addObjectsForConf(string, new Depender(dependencyDescriptor, string2), this.dependers);
    }

    protected Set getDependencyArtifactsSet(String iterator) {
        if ((iterator = (Collection)this.dependers.get(iterator)) == null) {
            return null;
        }
        HashSet<DependencyArtifactDescriptor> hashSet = new HashSet<DependencyArtifactDescriptor>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            DependencyArtifactDescriptor[] dependencyArtifactDescriptorArray = (DependencyArtifactDescriptor[])iterator.next();
            dependencyArtifactDescriptorArray = ((Depender)dependencyArtifactDescriptorArray).dd.getDependencyArtifacts(((Depender)dependencyArtifactDescriptorArray).dependerConf);
            hashSet.addAll(Arrays.asList(dependencyArtifactDescriptorArray));
        }
        return hashSet;
    }

    protected Set getDependencyIncludesSet(String iterator) {
        if ((iterator = (Collection)this.dependers.get(iterator)) == null) {
            return null;
        }
        HashSet<IncludeRule> hashSet = new HashSet<IncludeRule>();
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            IncludeRule[] includeRuleArray = (IncludeRule[])iterator.next();
            if ((includeRuleArray = ((Depender)includeRuleArray).dd.getIncludeRules(((Depender)includeRuleArray).dependerConf)) == null || includeRuleArray.length == 0) {
                return null;
            }
            hashSet.addAll(Arrays.asList(includeRuleArray));
        }
        return hashSet;
    }

    protected void blacklist(IvyNodeBlacklist ivyNodeBlacklist) {
        this.blacklisted.put(ivyNodeBlacklist.getRootModuleConf(), ivyNodeBlacklist);
    }

    protected boolean isBlacklisted(String string) {
        return this.blacklisted.containsKey(string);
    }

    protected IvyNodeBlacklist getBlacklistData(String string) {
        return (IvyNodeBlacklist)this.blacklisted.get(string);
    }

    protected IvyNode getNode() {
        return this.node;
    }

    public boolean hasTransitiveDepender(String iterator) {
        if ((iterator = (Set)this.dependers.get(iterator)) == null) {
            return false;
        }
        iterator = iterator.iterator();
        while (iterator.hasNext()) {
            Depender depender = (Depender)iterator.next();
            if (!depender.dd.isTransitive()) continue;
            return true;
        }
        return false;
    }

    private static final class Depender {
        private DependencyDescriptor dd;
        private String dependerConf;

        public Depender(DependencyDescriptor dependencyDescriptor, String string) {
            this.dd = dependencyDescriptor;
            this.dependerConf = string;
        }

        public final String toString() {
            return this.dd + " [" + this.dependerConf + "]";
        }

        public final boolean equals(Object object) {
            if (!(object instanceof Depender)) {
                return false;
            }
            object = (Depender)object;
            return ((Depender)object).dd == this.dd && ((Depender)object).dependerConf.equals(this.dependerConf);
        }

        public final int hashCode() {
            int n = 33 + this.dd.hashCode() * 13;
            return n += this.dependerConf.hashCode() * 13;
        }
    }

    private static final class NodeConf {
        private IvyNode node;
        private String conf;

        public NodeConf(IvyNode ivyNode, String string) {
            if (ivyNode == null) {
                throw new NullPointerException("node must not null");
            }
            if (string == null) {
                throw new NullPointerException("conf must not null");
            }
            this.node = ivyNode;
            this.conf = string;
        }

        public final String getConf() {
            return this.conf;
        }

        public final IvyNode getNode() {
            return this.node;
        }

        public final boolean equals(Object object) {
            if (!(object instanceof NodeConf)) {
                return false;
            }
            return this.getNode().equals(((NodeConf)object).getNode()) && this.getConf().equals(((NodeConf)object).getConf());
        }

        public final int hashCode() {
            int n = 33 + this.getNode().hashCode() * 17;
            return n += this.getConf().hashCode() * 17;
        }

        public final String toString() {
            return "NodeConf(" + this.conf + ")";
        }
    }
}

