/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.ui.impl;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.io.StringReader;
import java.util.LinkedList;
import java.util.List;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.SwingUtilities;
import javax.swing.Timer;
import javax.swing.event.CaretEvent;
import javax.swing.event.CaretListener;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import net.sf.sdedit.Constants;
import net.sf.sdedit.config.Configuration;
import net.sf.sdedit.config.ConfigurationManager;
import net.sf.sdedit.config.GlobalConfiguration;
import net.sf.sdedit.diagram.Diagram;
import net.sf.sdedit.drawable.Arrow;
import net.sf.sdedit.drawable.Drawable;
import net.sf.sdedit.drawable.Figure;
import net.sf.sdedit.drawable.LabeledBox;
import net.sf.sdedit.editor.Editor;
import net.sf.sdedit.editor.plugin.FileActionProvider;
import net.sf.sdedit.editor.plugin.FileHandler;
import net.sf.sdedit.error.DiagramError;
import net.sf.sdedit.error.FatalError;
import net.sf.sdedit.icons.Icons;
import net.sf.sdedit.text.AbstractTextHandler;
import net.sf.sdedit.ui.components.AutoCompletion;
import net.sf.sdedit.ui.components.TextArea;
import net.sf.sdedit.ui.components.buttons.ActionManager;
import net.sf.sdedit.ui.components.buttons.Activator;
import net.sf.sdedit.ui.components.configuration.Bean;
import net.sf.sdedit.ui.impl.DiagramTab;
import net.sf.sdedit.ui.impl.DiagramTextInteraction;
import net.sf.sdedit.ui.impl.FilterCommandField;
import net.sf.sdedit.ui.impl.UserInterfaceImpl;
import net.sf.sdedit.util.Pair;
import net.sf.sdedit.util.PopupActions;
import net.sf.sdedit.util.Ref;

public abstract class DiagramTextTab
extends DiagramTab
implements DocumentListener,
AutoCompletion.SuggestionProvider,
PropertyChangeListener,
ActionListener,
PopupActions.ContextHandler {
    private static final long serialVersionUID = -4105088603920744983L;
    private final JLabel errorLabel;
    private final JLabel statusLabel;
    private final JPanel bottomPanel;
    private final TextArea textArea;
    private final FilterCommandField filterField;
    private final JPanel statusPanel;
    private String code;
    private int errorCharIndex;
    private JSplitPane splitter;
    private JScrollPane textScroller;
    private boolean filterMode;
    private Bean<? extends Configuration> oldConfiguration;
    private GlobalConfiguration globalConf;
    private boolean changed;
    private Timer changeTimer;
    private boolean mustScroll;
    private Timer scrollTimer;
    private boolean ignoreChanges;
    private boolean reloadChangedFiles;
    protected PopupActions.Action scrollToAction = new PopupActions.Action(){
        private static final long serialVersionUID = 1L;
        private Drawable drawable;
        {
            this.putValue("Name", "Scroll to");
        }

        @Override
        protected boolean beforePopup(Object context) {
            if (context == null) {
                return false;
            }
            this.drawable = (Drawable)context;
            if (context instanceof LabeledBox) {
                this.putValue("Name", "Scroll to lifeline");
            } else if (context instanceof Arrow) {
                this.putValue("Name", "Scroll to message");
            } else if (context instanceof Figure) {
                this.putValue("Name", "Scroll to figure");
            } else {
                this.putValue("Name", "Scroll to");
            }
            return true;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            DiagramTextTab.this.scrollToDrawable(this.drawable, true);
        }
    };

    public DiagramTextTab(UserInterfaceImpl ui, Font codeFont, Bean<? extends Configuration> configuration) {
        super(ui);
        this.textArea = new TextArea();
        this.globalConf = ConfigurationManager.getGlobalConfigurationBean().getDataObject();
        ConfigurationManager.getGlobalConfigurationBean().addPropertyChangeListener(this);
        this.textArea.setFont(codeFont);
        this.textArea.getDocument().addDocumentListener(this);
        this.textArea.setMinimumSize(new Dimension(100, 100));
        this.textArea.addCaretListener(new CaretListener(){

            @Override
            public void caretUpdate(CaretEvent e) {
                if (DiagramTextTab.this.globalConf.isAutoScroll()) {
                    DiagramTextTab.this.mustScroll = true;
                    DiagramTextTab.this.scrollTimer.restart();
                }
            }
        });
        new AutoCompletion(this.textArea, this, '=', ':', '>');
        this.filterField = new FilterCommandField(this);
        this.filterMode = false;
        this.textScroller = new JScrollPane();
        this.textScroller.getVerticalScrollBar().setUnitIncrement(30);
        this.textScroller.getHorizontalScrollBar().setUnitIncrement(30);
        this.setLineWrap(configuration.getDataObject().isLineWrap());
        this.splitter = new JSplitPane(0, this.getZoomPane(), this.textScroller);
        this.splitter.setOneTouchExpandable(true);
        this.splitter.setResizeWeight(0.8);
        this.getContentPanel().setLayout(new BorderLayout());
        this.getContentPanel().add((Component)this.splitter, "Center");
        this.errorCharIndex = -1;
        this.code = "";
        this.errorLabel = new JLabel("");
        this.statusLabel = new JLabel("");
        this.errorLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseEntered(MouseEvent e) {
                if (DiagramTextTab.this.errorCharIndex > -1) {
                    DiagramTextTab.this.errorLabel.setCursor(Constants.HAND_CURSOR);
                }
            }

            @Override
            public void mouseExited(MouseEvent e) {
                DiagramTextTab.this.errorLabel.setCursor(Cursor.getDefaultCursor());
            }

            @Override
            public void mouseClicked(MouseEvent e) {
                if (DiagramTextTab.this.errorCharIndex > -1) {
                    DiagramTextTab.this.moveCursorToPosition(DiagramTextTab.this.errorCharIndex);
                }
            }
        });
        this.changeTimer = new Timer(20 * ConfigurationManager.getGlobalConfiguration().getAutodrawLatency(), this);
        this.changeTimer.start();
        this.changed = false;
        this.scrollTimer = new Timer(20 * ConfigurationManager.getGlobalConfiguration().getAutodrawLatency(), this);
        this.scrollTimer.start();
        this.mustScroll = false;
        this.statusPanel = this.getStatusPanel();
        this.statusPanel.setLayout(new BorderLayout());
        this.bottomPanel = new JPanel();
        this.bottomPanel.setLayout(new BorderLayout());
        this.bottomPanel.add((Component)this.errorLabel, "Center");
        this.bottomPanel.add((Component)this.statusLabel, "East");
        this.bottomPanel.setPreferredSize(new Dimension(Integer.MAX_VALUE, 20));
        this.statusPanel.add((Component)this.bottomPanel, "Center");
        this.setConfiguration(configuration);
        this.setInteraction(new DiagramTextInteraction(this));
        this.textArea.getPopupActions(this).addAction(this.scrollToAction);
    }

    @Override
    public Icon getIcon() {
        return Icons.getIcon("text");
    }

    private void setLineWrap(boolean on) {
        if (on) {
            this.textScroller.setViewportView(this.textArea);
        } else {
            JPanel noWrapPanel = new JPanel(new BorderLayout());
            noWrapPanel.add(this.textArea);
            this.textScroller.setViewportView(noWrapPanel);
        }
    }

    private void somethingChanged() {
        if (!this.ignoreChanges) {
            this.changed = true;
            this.changeTimer.restart();
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    boolean isStained = DiagramTextTab.this.textArea.getText().length() != DiagramTextTab.this.code.length() || !DiagramTextTab.this.textArea.getText().equals(DiagramTextTab.this.code) || !DiagramTextTab.this.oldConfiguration.equals(DiagramTextTab.this.getConfiguration());
                    DiagramTextTab.this.setClean(!isStained);
                }
            });
        }
    }

    public void layout(int layout) {
        this.remove(this.splitter);
        switch (layout) {
            case 0: {
                this.splitter = new JSplitPane(1, this.textScroller, this.getZoomPane());
                this.splitter.setResizeWeight(0.2);
                break;
            }
            case 1: {
                this.splitter = new JSplitPane(0, this.getZoomPane(), this.textScroller);
                this.splitter.setOneTouchExpandable(true);
                this.splitter.setResizeWeight(0.8);
                break;
            }
            default: {
                throw new IllegalArgumentException("layout " + layout + " not supported");
            }
        }
        this.splitter.setOneTouchExpandable(true);
        this.add((Component)this.splitter, "Center");
        this.revalidate();
        this.getConfiguration().getDataObject().setVerticallySplit(layout == 1);
    }

    public TextArea getTextArea() {
        return this.textArea;
    }

    @Override
    public boolean isReadyToBeClosed(Ref<Boolean> noToAll) {
        boolean ready = super.isReadyToBeClosed(noToAll);
        return ready;
    }

    @Override
    public boolean close(boolean check) {
        boolean close = super.close(check);
        if (close) {
            ConfigurationManager.getGlobalConfigurationBean().removePropertyChangeListener(this);
            this.changeTimer.stop();
            this.scrollTimer.stop();
        }
        return close;
    }

    @Override
    public void setClean(boolean clean) {
        super.setClean(clean);
        if (clean) {
            this.code = this.textArea.getText();
            this.oldConfiguration = this.getConfiguration().copy();
        }
    }

    public String getCode() {
        return this.textArea.getText();
    }

    public void setCode(final String code) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.textArea.setText(code);
            this.setClean(true);
            this.goHome();
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DiagramTextTab.this.textArea.setText(code);
                DiagramTextTab.this.setClean(true);
                DiagramTextTab.this.goHome();
            }
        });
    }

    @Override
    public void goHome() {
        super.goHome();
        this.textArea.setCaretPosition(0);
        this.textArea.requestFocusInWindow();
    }

    public int getCursorPosition() {
        return this.textArea.getCaretPosition();
    }

    public void moveCursorToPosition(int position) {
        this.textArea.requestFocusInWindow();
        this.textArea.setCaretPosition(0);
        this.textArea.setCaretPosition(position);
        Point p = this.textArea.getCaret().getMagicCaretPosition();
        if (p != null) {
            this.textArea.scrollRectToVisible(new Rectangle(p));
        }
    }

    public void undo() {
        this.textArea.undo();
    }

    public void redo() {
        this.textArea.redo();
    }

    void enterFilterMode() {
        if (this.filterMode) {
            return;
        }
        this.filterMode = true;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DiagramTextTab.this.filterField.reset();
                DiagramTextTab.this.statusPanel.remove(DiagramTextTab.this.bottomPanel);
                DiagramTextTab.this.statusPanel.add((Component)DiagramTextTab.this.filterField, "Center");
                DiagramTextTab.this.statusPanel.revalidate();
                DiagramTextTab.this.filterField.requestFocus();
            }
        });
    }

    public void toggleFilterMode() {
        if (this.filterMode) {
            this.leaveFilterMode();
        } else {
            this.enterFilterMode();
        }
    }

    void leaveFilterMode() {
        if (!this.filterMode) {
            return;
        }
        this.filterMode = false;
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DiagramTextTab.this.filterField.reset();
                DiagramTextTab.this.statusPanel.remove(DiagramTextTab.this.filterField);
                DiagramTextTab.this.statusPanel.add((Component)DiagramTextTab.this.bottomPanel, "Center");
                DiagramTextTab.this.statusPanel.revalidate();
            }
        });
    }

    protected void scrollToCurrentDrawable() {
        this.scrollToCurrentDrawable(true);
    }

    protected void scrollToCurrentDrawable(boolean highlight) {
        int begin = this.textArea.getCurrentLineBegin();
        Diagram diagram = this.getDiagram();
        if (diagram != null) {
            Drawable drawable = diagram.getDrawableForState(begin);
            if (drawable != null) {
                this.scrollToDrawable(drawable, highlight && this.globalConf.isHighlightCurrent());
            } else {
                int caret = this.textArea.getCaretPosition();
                if (this.textArea.getText().substring(caret).trim().length() == 0) {
                    this.getZoomPane().scrollToBottom();
                }
            }
        }
    }

    @Override
    public void clear() {
        if (SwingUtilities.isEventDispatchThread()) {
            this.textArea.setText("");
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DiagramTextTab.this.textArea.setText("");
                }
            });
        }
    }

    public void append(final String text) {
        if (SwingUtilities.isEventDispatchThread()) {
            this.textArea.setText(this.textArea.getText() + text);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                @Override
                public void run() {
                    DiagramTextTab.this.textArea.setText(DiagramTextTab.this.textArea.getText() + text);
                }
            });
        }
    }

    void setStatus(final String status) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DiagramTextTab.this.statusLabel.setText(status + "    ");
            }
        });
    }

    protected void setError(final boolean warning, final String error, final int begin, final int end) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                if (warning) {
                    DiagramTextTab.this.errorLabel.setForeground(Color.ORANGE);
                } else {
                    DiagramTextTab.this.errorLabel.setForeground(Color.RED);
                }
                DiagramTextTab.this.errorLabel.setText(error);
                DiagramTextTab.this.errorCharIndex = begin;
                DiagramTextTab.this.textArea.markError(begin, end);
            }
        });
    }

    @Override
    public List<String> getSuggestions(String prefix) {
        Diagram diag = this.getDiagram();
        if (diag != null) {
            return diag.getSuggestions(prefix);
        }
        return new LinkedList<String>();
    }

    @Override
    public void setConfiguration(Bean<? extends Configuration> configuration) {
        super.setConfiguration(configuration);
        this.oldConfiguration = configuration.copy();
        this.layout(configuration.getDataObject().isVerticallySplit() ? 1 : 0);
    }

    @Override
    public void propertyChange(PropertyChangeEvent evt) {
        super.propertyChange(evt);
        if (evt.getPropertyName().toLowerCase().equals("linewrap")) {
            boolean wrap = (Boolean)evt.getNewValue();
            this.setLineWrap(wrap);
        } else if (evt.getPropertyName().toLowerCase().equals("autodrawlatency")) {
            this.changeTimer.stop();
            this.changeTimer.setDelay((Integer)evt.getNewValue());
            this.changeTimer.start();
        } else if (evt.getPropertyName().toLowerCase().equals("verticallysplit")) {
            this.layout((Boolean)evt.getNewValue() != false ? 1 : 0);
        }
        this.somethingChanged();
    }

    @Override
    public void changedUpdate(DocumentEvent e) {
        this.somethingChanged();
    }

    @Override
    public void insertUpdate(DocumentEvent e) {
        this.somethingChanged();
    }

    @Override
    public void removeUpdate(DocumentEvent e) {
        this.somethingChanged();
    }

    @Override
    protected List<Pair<Action, Activator>> getOverloadedActions() {
        return null;
    }

    @Override
    public FileHandler getFileHandler() {
        return Editor.getEditor().getDefaultFileHandler();
    }

    @Override
    public void activate(ActionManager actionManager, FileActionProvider faProvider) {
        super.activate(actionManager, faProvider);
        this.changed = false;
        this.changeTimer.restart();
        this.leaveFilterMode();
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                DiagramTextTab.this.getTextArea().requestFocusInWindow();
            }
        });
    }

    @Override
    public void deactivate(ActionManager actionManager, FileActionProvider faProvider) {
        super.deactivate(actionManager, faProvider);
        this.changeTimer.stop();
    }

    protected void handleBug(Diagram diagram, Throwable ex) {
        String name = "sdedit-errorlog-" + System.currentTimeMillis();
        File errorLogFile = new File(name);
        try {
            errorLogFile.createNewFile();
        }
        catch (IOException e0) {
            try {
                errorLogFile = new File(System.getProperty("user.home"), name);
                errorLogFile.createNewFile();
            }
            catch (IOException e1) {
                errorLogFile = new File(System.getProperty("java.io.tmpdir", name));
            }
        }
        try {
            this.saveLog(errorLogFile, ex, (AbstractTextHandler)((Object)diagram.getDataProvider()));
        }
        catch (IOException e) {
            this.get_UI().errorMessage(e, null, "An error log file could not be saved.");
        }
    }

    private static final String getFatalErrorDescription(Throwable ex) {
        return "A FATAL ERROR has occurred: " + ex.getClass().getSimpleName();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void saveLog(File logFile, Throwable exception, AbstractTextHandler textHandler) throws IOException {
        FileOutputStream stream = new FileOutputStream(logFile);
        try {
            PrintWriter printWriter = new PrintWriter(new OutputStreamWriter((OutputStream)stream, ConfigurationManager.getGlobalConfiguration().getFileEncoding()));
            BufferedReader bufferedReader = new BufferedReader(new StringReader(textHandler.getText()));
            int error = textHandler.getLineNumber();
            printWriter.println(exception.getClass().getSimpleName() + " has occurred in line " + error + "\n");
            int i = 0;
            while (true) {
                String line;
                if ((line = bufferedReader.readLine()) == null) break;
                line = line.trim();
                if (i == error - 1) {
                    line = ">>>>>>>>>>>>>> " + line;
                }
                printWriter.println(line);
                ++i;
            }
            bufferedReader.close();
            printWriter.println("\n\n:::::::::::::::::::::::::::::\n\n");
            exception.printStackTrace(printWriter);
            printWriter.flush();
            printWriter.close();
            this.get_UI().errorMessage(null, "FATAL ERROR", DiagramTextTab.getFatalErrorDescription(exception) + "\n\nAn error log file has been saved under \n" + logFile.getAbsolutePath() + "\n\nPlease send an e-mail with this file as an attachment to:\nsdedit@users.sourceforge.net");
        }
        finally {
            stream.close();
        }
    }

    @Override
    protected void handleDiagramError(DiagramError error) {
        this.setStatus("");
        boolean handled = this._handleDiagramError(error);
        if (!handled && error instanceof FatalError) {
            FatalError fatal = (FatalError)error;
            System.err.println("********************************************************");
            System.err.println("*                                                      *");
            System.err.println("*            A FATAL ERROR HAS OCCURED.                *");
            System.err.println("*                                                      *");
            System.err.println("********************************************************");
            error.getCause().printStackTrace();
            try {
                this.handleBug(this.getDiagram(), fatal.getCause());
            }
            catch (Throwable t) {
                t.printStackTrace();
            }
        }
    }

    protected abstract boolean _handleDiagramError(DiagramError var1);

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.changeTimer) {
            if (this.changed) {
                this.refresh(false);
            }
            this.changed = false;
        } else if (e.getSource() == this.scrollTimer) {
            if (this.mustScroll) {
                this.scrollToCurrentDrawable(true);
            }
            this.mustScroll = false;
        }
    }

    @Override
    protected void _getContextActions(List<Action> actionList) {
    }

    @Override
    public boolean canClose() {
        return true;
    }

    @Override
    public Object getObjectForCurrentContext(JComponent comp) {
        int begin = this.textArea.getCurrentLineBegin();
        Diagram diagram = this.getDiagram();
        if (diagram != null) {
            Drawable drawable = diagram.getDrawableForState(begin);
            return drawable;
        }
        return null;
    }

    public void setIgnoreChanges(boolean ignoreChanges) {
        this.ignoreChanges = ignoreChanges;
    }

    public boolean isIgnoreChanges() {
        return this.ignoreChanges;
    }

    @Override
    protected void fileChanged(String text, Bean<? extends Configuration> conf) {
        if (!text.equals(this.code) || !conf.equals(this.getConfiguration())) {
            if (!this.reloadChangedFiles) {
                String opt = this.get_UI().getOption("The file has changed. Do you want to reload it?", "No", "Always in this tab", "Yes");
                if ("No".equals(opt)) {
                    return;
                }
                if ("Always in this tab".equals(opt)) {
                    this.reloadChangedFiles = true;
                }
            }
            this.setConfiguration(conf);
            this.textArea.setText(text);
            this.code = text;
            this.setClean(true);
        }
    }
}

