/*
 * Decompiled with CFR 0.152.
 */
package net.sf.sdedit.util;

import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.util.LinkedList;
import java.util.List;
import javax.swing.AbstractAction;
import javax.swing.JComponent;
import javax.swing.JPopupMenu;
import javax.swing.SwingUtilities;

public class PopupActions
implements MouseListener {
    private JComponent component;
    private ContextHandler contextHandler;
    private List<Action> actions;

    public PopupActions(JComponent component, ContextHandler contextHandler) {
        this.component = component;
        this.contextHandler = contextHandler;
        this.actions = new LinkedList<Action>();
        component.addMouseListener(this);
    }

    public void addAction(Action action) {
        this.actions.add(action);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
        if (this.component.isEnabled() && SwingUtilities.isRightMouseButton(e) && e.getClickCount() == 1) {
            Object context = this.contextHandler.getObjectForCurrentContext(this.component);
            boolean show = false;
            JPopupMenu menu = new JPopupMenu();
            for (Action action : this.actions) {
                if (!action.beforePopup(context)) continue;
                show = true;
                menu.add(action);
            }
            if (show) {
                menu.show(this.component, e.getX(), e.getY());
            }
        }
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    public static abstract class Action
    extends AbstractAction {
        protected abstract boolean beforePopup(Object var1);
    }

    public static interface Provider {
        public PopupActions getPopupActions(ContextHandler var1);
    }

    public static interface ContextHandler {
        public Object getObjectForCurrentContext(JComponent var1);
    }
}

