/*
 * Decompiled with CFR 0.152.
 */
package org.mockito.internal.stubbing.defaultanswers;

import java.io.Serializable;
import java.lang.reflect.Array;
import org.mockito.internal.stubbing.defaultanswers.ReturnsEmptyValues;
import org.mockito.invocation.InvocationOnMock;
import org.mockito.stubbing.Answer;

public class ReturnsMoreEmptyValues
implements Answer<Object>,
Serializable {
    private static final long serialVersionUID = -2816745041482698471L;
    private final Answer<Object> delegate = new ReturnsEmptyValues();

    @Override
    public Object answer(InvocationOnMock invocation) throws Throwable {
        Object ret = this.delegate.answer(invocation);
        if (ret != null) {
            return ret;
        }
        Class<?> returnType = invocation.getMethod().getReturnType();
        return this.returnValueFor(returnType);
    }

    Object returnValueFor(Class<?> type) {
        if (type == String.class) {
            return "";
        }
        if (type.isArray()) {
            Class<?> componentType = type.getComponentType();
            return Array.newInstance(componentType, 0);
        }
        return null;
    }
}

