/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.project;

import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import org.apache.maven.RepositoryUtils;
import org.apache.maven.model.Dependency;
import org.apache.maven.model.DependencyManagement;
import org.apache.maven.model.Exclusion;
import org.apache.maven.project.DefaultDependencyResolutionResult;
import org.apache.maven.project.DependencyResolutionException;
import org.apache.maven.project.DependencyResolutionRequest;
import org.apache.maven.project.DependencyResolutionResult;
import org.apache.maven.project.MavenProject;
import org.apache.maven.project.ProjectDependenciesResolver;
import org.apache.maven.project.RepositorySessionDecorator;
import org.codehaus.plexus.component.annotations.Component;
import org.codehaus.plexus.component.annotations.Requirement;
import org.codehaus.plexus.logging.Logger;
import org.codehaus.plexus.util.StringUtils;
import org.eclipse.aether.DefaultRepositorySystemSession;
import org.eclipse.aether.RepositorySystem;
import org.eclipse.aether.RepositorySystemSession;
import org.eclipse.aether.RequestTrace;
import org.eclipse.aether.artifact.Artifact;
import org.eclipse.aether.artifact.ArtifactType;
import org.eclipse.aether.artifact.ArtifactTypeRegistry;
import org.eclipse.aether.collection.CollectRequest;
import org.eclipse.aether.collection.DependencyCollectionException;
import org.eclipse.aether.graph.DependencyFilter;
import org.eclipse.aether.graph.DependencyNode;
import org.eclipse.aether.graph.DependencyVisitor;
import org.eclipse.aether.resolution.ArtifactResult;
import org.eclipse.aether.resolution.DependencyRequest;
import org.eclipse.aether.util.artifact.ArtifactIdUtils;
import org.eclipse.aether.util.graph.manager.DependencyManagerUtils;

@Component(role=ProjectDependenciesResolver.class)
public class DefaultProjectDependenciesResolver
implements ProjectDependenciesResolver {
    @Requirement
    private Logger logger;
    @Requirement
    private RepositorySystem repoSystem;
    @Requirement
    private List<RepositorySessionDecorator> decorators;

    /*
     * WARNING - void declaration
     */
    @Override
    public DependencyResolutionResult resolve(DependencyResolutionRequest request) throws DependencyResolutionException {
        void node2;
        DependencyManagement dependencyManagement;
        RequestTrace trace = RequestTrace.newChild(null, request);
        DefaultDependencyResolutionResult result = new DefaultDependencyResolutionResult();
        MavenProject project2 = request.getMavenProject();
        DependencyFilter filter2 = request.getResolutionFilter();
        Object session2 = request.getRepositorySession();
        ArtifactTypeRegistry stereotypes = session2.getArtifactTypeRegistry();
        if (this.logger.isDebugEnabled() && session2.getConfigProperties().get("aether.dependencyManager.verbose") == null) {
            DefaultRepositorySystemSession verbose = new DefaultRepositorySystemSession((RepositorySystemSession)session2);
            verbose.setConfigProperty("aether.dependencyManager.verbose", Boolean.TRUE);
            session2 = verbose;
        }
        for (RepositorySessionDecorator repositorySessionDecorator : this.decorators) {
            RepositorySystemSession repositorySystemSession = repositorySessionDecorator.decorate(project2, (RepositorySystemSession)session2);
            if (repositorySystemSession == null) continue;
            session2 = repositorySystemSession;
        }
        CollectRequest collect = new CollectRequest();
        collect.setRootArtifact(RepositoryUtils.toArtifact(project2.getArtifact()));
        collect.setRequestContext("project");
        collect.setRepositories(project2.getRemoteProjectRepositories());
        if (project2.getDependencyArtifacts() == null) {
            for (Dependency dependency : project2.getDependencies()) {
                if (StringUtils.isEmpty(dependency.getGroupId()) || StringUtils.isEmpty(dependency.getArtifactId()) || StringUtils.isEmpty(dependency.getVersion())) continue;
                collect.addDependency(RepositoryUtils.toDependency(dependency, stereotypes));
            }
        } else {
            HashMap<String, Dependency> hashMap = new HashMap<String, Dependency>();
            for (Dependency dependency2 : project2.getDependencies()) {
                ArtifactType type2;
                String classifier = dependency2.getClassifier();
                if (classifier == null && (type2 = stereotypes.get(dependency2.getType())) != null) {
                    classifier = type2.getClassifier();
                }
                String key2 = ArtifactIdUtils.toVersionlessId(dependency2.getGroupId(), dependency2.getArtifactId(), dependency2.getType(), classifier);
                hashMap.put(key2, dependency2);
            }
            Iterator<org.apache.maven.artifact.Artifact> iterator = project2.getDependencyArtifacts().iterator();
            while (iterator.hasNext()) {
                org.apache.maven.artifact.Artifact artifact;
                String key3 = (artifact = iterator.next()).getDependencyConflictId();
                Dependency dependency3 = (Dependency)hashMap.get(key3);
                List<Exclusion> exclusions = dependency3 != null ? dependency3.getExclusions() : null;
                org.eclipse.aether.graph.Dependency dep = RepositoryUtils.toDependency(artifact, exclusions);
                if (!"system".equals(dep.getScope()) && dep.getArtifact().getFile() != null) {
                    Artifact art = dep.getArtifact();
                    art = art.setFile(null).setVersion(art.getBaseVersion());
                    dep = dep.setArtifact(art);
                }
                collect.addDependency(dep);
            }
        }
        if ((dependencyManagement = project2.getDependencyManagement()) != null) {
            for (Dependency dependency : dependencyManagement.getDependencies()) {
                collect.addManagedDependency(RepositoryUtils.toDependency(dependency, stereotypes));
            }
        }
        DependencyRequest dependencyRequest = new DependencyRequest(collect, filter2);
        dependencyRequest.setTrace(trace);
        try {
            collect.setTrace(RequestTrace.newChild(trace, dependencyRequest));
            DependencyNode node22 = this.repoSystem.collectDependencies((RepositorySystemSession)session2, collect).getRoot();
            result.setDependencyGraph(node22);
        }
        catch (DependencyCollectionException e2) {
            result.setDependencyGraph(e2.getResult().getRoot());
            result.setCollectionErrors(e2.getResult().getExceptions());
            throw new DependencyResolutionException(result, "Could not resolve dependencies for project " + project2.getId() + ": " + e2.getMessage(), e2);
        }
        dependencyRequest.setRoot((DependencyNode)node2);
        if (this.logger.isWarnEnabled()) {
            for (DependencyNode child : node2.getChildren()) {
                if (child.getRelocations().isEmpty()) continue;
                this.logger.warn("The artifact " + child.getRelocations().get(0) + " has been relocated to " + child.getDependency().getArtifact());
            }
        }
        if (this.logger.isDebugEnabled()) {
            node2.accept(new GraphLogger(project2));
        }
        try {
            this.process(result, this.repoSystem.resolveDependencies((RepositorySystemSession)session2, dependencyRequest).getArtifactResults());
        }
        catch (org.eclipse.aether.resolution.DependencyResolutionException e3) {
            this.process(result, e3.getResult().getArtifactResults());
            throw new DependencyResolutionException(result, "Could not resolve dependencies for project " + project2.getId() + ": " + e3.getMessage(), e3);
        }
        return result;
    }

    private void process(DefaultDependencyResolutionResult result, Collection<ArtifactResult> results) {
        for (ArtifactResult ar : results) {
            DependencyNode node2 = ar.getRequest().getDependencyNode();
            if (ar.isResolved()) {
                result.addResolvedDependency(node2.getDependency());
                continue;
            }
            result.setResolutionErrors(node2.getDependency(), ar.getExceptions());
        }
    }

    class GraphLogger
    implements DependencyVisitor {
        private final MavenProject project;
        private String indent = "";

        GraphLogger(MavenProject project2) {
            this.project = project2;
        }

        @Override
        public boolean visitEnter(DependencyNode node2) {
            StringBuilder buffer = new StringBuilder(128);
            buffer.append(this.indent);
            org.eclipse.aether.graph.Dependency dep = node2.getDependency();
            if (dep != null) {
                Artifact art = dep.getArtifact();
                buffer.append(art);
                if (StringUtils.isNotEmpty(dep.getScope())) {
                    buffer.append(':').append(dep.getScope());
                }
                if (dep.isOptional()) {
                    buffer.append(" (optional)");
                }
                if ((node2.getManagedBits() & 2) == 2) {
                    String premanagedScope = DependencyManagerUtils.getPremanagedScope(node2);
                    buffer.append(" (scope managed from ");
                    buffer.append(Objects.toString(premanagedScope, "default"));
                    buffer.append(')');
                }
                if ((node2.getManagedBits() & 1) == 1) {
                    String premanagedVersion = DependencyManagerUtils.getPremanagedVersion(node2);
                    buffer.append(" (version managed from ");
                    buffer.append(Objects.toString(premanagedVersion, "default"));
                    buffer.append(')');
                }
                if ((node2.getManagedBits() & 4) == 4) {
                    Boolean premanagedOptional = DependencyManagerUtils.getPremanagedOptional(node2);
                    buffer.append(" (optionality managed from ");
                    buffer.append(Objects.toString(premanagedOptional, "default"));
                    buffer.append(')');
                }
                if ((node2.getManagedBits() & 0x10) == 16) {
                    Collection<org.eclipse.aether.graph.Exclusion> premanagedExclusions = DependencyManagerUtils.getPremanagedExclusions(node2);
                    buffer.append(" (exclusions managed from ");
                    buffer.append(Objects.toString(premanagedExclusions, "default"));
                    buffer.append(')');
                }
                if ((node2.getManagedBits() & 8) == 8) {
                    Map<String, String> premanagedProperties = DependencyManagerUtils.getPremanagedProperties(node2);
                    buffer.append(" (properties managed from ");
                    buffer.append(Objects.toString(premanagedProperties, "default"));
                    buffer.append(')');
                }
            } else {
                buffer.append(this.project.getGroupId());
                buffer.append(':').append(this.project.getArtifactId());
                buffer.append(':').append(this.project.getPackaging());
                buffer.append(':').append(this.project.getVersion());
            }
            DefaultProjectDependenciesResolver.this.logger.debug(buffer.toString());
            this.indent = this.indent + "   ";
            return true;
        }

        @Override
        public boolean visitLeave(DependencyNode node2) {
            this.indent = this.indent.substring(0, this.indent.length() - 3);
            return true;
        }
    }
}

