/*
 * Decompiled with CFR 0.152.
 */
package com.ericsson.otp.erlang;

import com.ericsson.otp.erlang.OtpErlangDecodeException;
import com.ericsson.otp.erlang.OtpErlangObject;
import com.ericsson.otp.erlang.OtpInputStream;
import com.ericsson.otp.erlang.OtpLocalNode;
import com.ericsson.otp.erlang.OtpOutputStream;

public class OtpErlangPid
extends OtpErlangObject
implements Comparable<Object> {
    private static final long serialVersionUID = 1664394142301803659L;
    private final String node;
    private final int id;
    private final int serial;
    private final int creation;

    @Deprecated
    public OtpErlangPid(OtpLocalNode otpLocalNode) {
        OtpErlangPid otpErlangPid = otpLocalNode.createPid();
        this.id = otpErlangPid.id;
        this.serial = otpErlangPid.serial;
        this.creation = otpErlangPid.creation;
        this.node = otpErlangPid.node;
    }

    public OtpErlangPid(OtpInputStream otpInputStream) throws OtpErlangDecodeException {
        OtpErlangPid otpErlangPid = otpInputStream.read_pid();
        this.node = otpErlangPid.node();
        this.id = otpErlangPid.id();
        this.serial = otpErlangPid.serial();
        this.creation = otpErlangPid.creation();
    }

    public OtpErlangPid(String string, int n, int n2, int n3) {
        this(103, string, n, n2, n3);
    }

    protected OtpErlangPid(int n, String string, int n2, int n3, int n4) {
        this.node = string;
        if (n == 103) {
            this.id = n2 & Short.MAX_VALUE;
            this.serial = n3 & 0x1FFF;
            this.creation = n4 & 3;
        } else {
            this.id = n2;
            this.serial = n3;
            this.creation = n4;
        }
    }

    protected int tag() {
        return 88;
    }

    public int serial() {
        return this.serial;
    }

    public int id() {
        return this.id;
    }

    public int creation() {
        return this.creation;
    }

    public String node() {
        return this.node;
    }

    @Override
    public String toString() {
        return "#Pid<" + this.node.toString() + "." + this.id + "." + this.serial + ">";
    }

    @Override
    public void encode(OtpOutputStream otpOutputStream) {
        otpOutputStream.write_pid(this);
    }

    @Override
    public boolean equals(Object object) {
        if (!(object instanceof OtpErlangPid)) {
            return false;
        }
        OtpErlangPid otpErlangPid = (OtpErlangPid)object;
        return this.creation == otpErlangPid.creation && this.serial == otpErlangPid.serial && this.id == otpErlangPid.id && this.node.compareTo(otpErlangPid.node) == 0;
    }

    @Override
    protected int doHashCode() {
        OtpErlangObject.Hash hash = new OtpErlangObject.Hash(5);
        hash.combine(this.creation, this.serial);
        hash.combine(this.id, this.node.hashCode());
        return hash.valueOf();
    }

    @Override
    public int compareTo(Object object) {
        if (!(object instanceof OtpErlangPid)) {
            return -1;
        }
        OtpErlangPid otpErlangPid = (OtpErlangPid)object;
        if (this.creation == otpErlangPid.creation) {
            if (this.serial == otpErlangPid.serial) {
                if (this.id == otpErlangPid.id) {
                    return this.node.compareTo(otpErlangPid.node);
                }
                return this.id - otpErlangPid.id;
            }
            return this.serial - otpErlangPid.serial;
        }
        return this.creation - otpErlangPid.creation;
    }
}

