/*
 * Decompiled with CFR 0.152.
 */
package org.openstreetmap.gui.jmapviewer;

import java.io.IOException;
import java.io.InputStream;
import java.net.HttpURLConnection;
import java.net.URL;
import java.net.URLConnection;
import java.util.HashMap;
import java.util.Map;
import org.openstreetmap.gui.jmapviewer.Tile;
import org.openstreetmap.gui.jmapviewer.interfaces.TileJob;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoader;
import org.openstreetmap.gui.jmapviewer.interfaces.TileLoaderListener;

public class OsmTileLoader
implements TileLoader {
    public Map<String, String> headers = new HashMap<String, String>();
    public int timeoutConnect = 0;
    public int timeoutRead = 0;
    protected TileLoaderListener listener;

    public OsmTileLoader(TileLoaderListener listener) {
        this.headers.put("Accept", "text/html, image/png, image/jpeg, image/gif, */*");
        this.listener = listener;
    }

    @Override
    public TileJob createTileLoaderJob(final Tile tile) {
        return new TileJob(){
            InputStream input = null;

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                Tile tile2 = tile;
                synchronized (tile2) {
                    if (tile.isLoaded() && !tile.hasError() || tile.isLoading()) {
                        return;
                    }
                    tile.loaded = false;
                    tile.error = false;
                    tile.loading = true;
                }
                try {
                    URLConnection conn = OsmTileLoader.this.loadTileFromOsm(tile);
                    OsmTileLoader.this.loadTileMetadata(tile, conn);
                    if ("no-tile".equals(tile.getValue("tile-info"))) {
                        tile.setError("No tile at this zoom level");
                    } else {
                        this.input = conn.getInputStream();
                        tile.loadImage(this.input);
                        this.input.close();
                        this.input = null;
                    }
                    tile.setLoaded(true);
                    OsmTileLoader.this.listener.tileLoadingFinished(tile, true);
                }
                catch (Exception e) {
                    tile.setError(e.getMessage());
                    OsmTileLoader.this.listener.tileLoadingFinished(tile, false);
                    if (this.input == null) {
                        try {
                            System.err.println("Failed loading " + tile.getUrl() + ": " + e.getMessage());
                        }
                        catch (IOException iOException) {
                            // empty catch block
                        }
                    }
                }
                finally {
                    tile.loading = false;
                    tile.setLoaded(true);
                }
            }

            @Override
            public Tile getTile() {
                return tile;
            }
        };
    }

    protected URLConnection loadTileFromOsm(Tile tile) throws IOException {
        URL url = new URL(tile.getUrl());
        URLConnection urlConn = url.openConnection();
        if (urlConn instanceof HttpURLConnection) {
            this.prepareHttpUrlConnection((HttpURLConnection)urlConn);
        }
        urlConn.setReadTimeout(30000);
        return urlConn;
    }

    protected void loadTileMetadata(Tile tile, URLConnection urlConn) {
        String str = urlConn.getHeaderField("X-VE-TILEMETA-CaptureDatesRange");
        if (str != null) {
            tile.putValue("capture-date", str);
        }
        if ((str = urlConn.getHeaderField("X-VE-Tile-Info")) != null) {
            tile.putValue("tile-info", str);
        }
    }

    protected void prepareHttpUrlConnection(HttpURLConnection urlConn) {
        for (Map.Entry<String, String> e : this.headers.entrySet()) {
            urlConn.setRequestProperty(e.getKey(), e.getValue());
        }
        if (this.timeoutConnect != 0) {
            urlConn.setConnectTimeout(this.timeoutConnect);
        }
        if (this.timeoutRead != 0) {
            urlConn.setReadTimeout(this.timeoutRead);
        }
    }

    public String toString() {
        return this.getClass().getSimpleName();
    }
}

