/*
 * Decompiled with CFR 0.152.
 */
package tim.prune.data;

import java.text.DateFormat;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.TimeZone;

public abstract class Timestamp {
    private static final DateFormat DEFAULT_DATE_FORMAT = DateFormat.getDateInstance();
    private static final DateFormat DEFAULT_TIME_FORMAT = DateFormat.getTimeInstance();
    protected static final DateFormat DEFAULT_DATETIME_FORMAT = DateFormat.getDateTimeInstance();
    protected static final DateFormat ISO_8601_FORMAT = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss'Z'");
    protected static final DateFormat ISO_8601_FORMAT_WITH_MILLIS = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss.SSS'Z'");
    private static boolean _millisAddedToTimeFormat = false;

    static {
        TimeZone timeZone = TimeZone.getTimeZone("GMT");
        ISO_8601_FORMAT.setTimeZone(timeZone);
        ISO_8601_FORMAT_WITH_MILLIS.setTimeZone(timeZone);
        DEFAULT_DATETIME_FORMAT.setTimeZone(timeZone);
    }

    public abstract boolean isValid();

    public abstract Calendar getCalendar(TimeZone var1);

    public abstract long getMilliseconds(TimeZone var1);

    public boolean isAfter(Timestamp timestamp) {
        return this.getMillisecondsSince(timestamp) > 0L;
    }

    public boolean isBefore(Timestamp timestamp) {
        return this.getMillisecondsSince(timestamp) < 0L;
    }

    public boolean isEqual(Timestamp timestamp) {
        return this.getMillisecondsSince(timestamp) == 0L;
    }

    public long getSecondsSince(Timestamp timestamp) {
        return this.getMillisecondsSince(timestamp) / 1000L;
    }

    public long getMillisecondsSince(Timestamp timestamp) {
        return this.getMilliseconds(null) - timestamp.getMilliseconds(null);
    }

    public long getSecondsSince(Timestamp timestamp, TimeZone timeZone) {
        return (this.getMilliseconds(timeZone) - timestamp.getMilliseconds(timeZone)) / 1000L;
    }

    public abstract void addOffsetSeconds(long var1);

    protected abstract boolean hasMilliseconds();

    public String getDateText(TimeZone timeZone) {
        if (!this.isValid()) {
            return "";
        }
        return this.format(DEFAULT_DATE_FORMAT, timeZone);
    }

    public String getTimeText(TimeZone timeZone) {
        if (!this.isValid()) {
            return "";
        }
        if (this.hasMilliseconds() && !_millisAddedToTimeFormat) {
            try {
                SimpleDateFormat simpleDateFormat = (SimpleDateFormat)DEFAULT_TIME_FORMAT;
                String string = simpleDateFormat.toPattern();
                if (string.indexOf("ss") > 0 && string.indexOf("SS") < 0) {
                    simpleDateFormat.applyPattern(string.replaceFirst("s+", "$0.SSS"));
                    _millisAddedToTimeFormat = true;
                }
            }
            catch (ClassCastException classCastException) {}
        }
        return this.format(DEFAULT_TIME_FORMAT, timeZone);
    }

    protected abstract String format(DateFormat var1, TimeZone var2);

    public String getText(TimeZone timeZone) {
        return this.getText(Format.LOCALE, timeZone);
    }

    public String getText(Format format, TimeZone timeZone) {
        if (!this.isValid()) {
            return "";
        }
        switch (format) {
            default: {
                return this.format(DEFAULT_DATETIME_FORMAT, timeZone);
            }
            case ISO8601: 
        }
        return this.format(this.hasMilliseconds() ? ISO_8601_FORMAT_WITH_MILLIS : ISO_8601_FORMAT, timeZone);
    }

    public static enum Format {
        ORIGINAL,
        LOCALE,
        ISO8601;

    }
}

