/*
 * Decompiled with CFR 0.152.
 */
package org.jruby.javasupport;

import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Member;
import org.jruby.Ruby;
import org.jruby.RubyBoolean;
import org.jruby.RubyClass;
import org.jruby.RubyFixnum;
import org.jruby.RubyString;
import org.jruby.anno.JRubyMethod;
import org.jruby.javasupport.Java;
import org.jruby.javasupport.JavaClass;
import org.jruby.runtime.ThreadContext;
import org.jruby.runtime.builtin.IRubyObject;

public abstract class JavaAccessibleObject {
    protected JavaAccessibleObject(Ruby runtime2, RubyClass rubyClass) {
        this(runtime2, rubyClass, false);
    }

    JavaAccessibleObject(Ruby runtime2, RubyClass rubyClass, boolean objectSpace) {
    }

    public static void registerRubyMethods(Ruby runtime2, RubyClass result2) {
        result2.defineAnnotatedMethods(JavaAccessibleObject.class);
    }

    public abstract AccessibleObject accessibleObject();

    public boolean equals(Object other) {
        if (this == other) {
            return true;
        }
        return other instanceof JavaAccessibleObject && this.accessibleObject().equals(((JavaAccessibleObject)other).accessibleObject());
    }

    boolean same(JavaAccessibleObject that) {
        if (this == that) {
            return true;
        }
        return this.accessibleObject() == that.accessibleObject();
    }

    public int hashCode() {
        return this.accessibleObject().hashCode();
    }

    @JRubyMethod
    public RubyFixnum hash(ThreadContext context) {
        return context.runtime.newFixnum(this.hashCode());
    }

    @JRubyMethod(name={"==", "eql?"})
    public RubyBoolean op_equal(ThreadContext context, IRubyObject other) {
        return RubyBoolean.newBoolean(context.runtime, this.equals(other));
    }

    @JRubyMethod(name={"equal?"})
    public RubyBoolean same(ThreadContext context, IRubyObject other) {
        boolean same2 = other instanceof JavaAccessibleObject && this.same((JavaAccessibleObject)((Object)other));
        return same2 ? context.runtime.getTrue() : context.runtime.getFalse();
    }

    @JRubyMethod(name={"accessible?"})
    @Deprecated
    public RubyBoolean isAccessible(ThreadContext context) {
        return RubyBoolean.newBoolean(context.runtime, this.accessibleObject().isAccessible());
    }

    @JRubyMethod(name={"accessible="})
    public IRubyObject setAccessible(IRubyObject object) {
        this.accessibleObject().setAccessible(object.isTrue());
        return object;
    }

    @JRubyMethod
    public IRubyObject annotation(ThreadContext context, IRubyObject annoClass) {
        Class annotation2;
        if (annoClass instanceof RubyClass && ((RubyClass)annoClass).getJavaProxy()) {
            annotation2 = ((RubyClass)annoClass).getJavaClass();
        } else if (annoClass instanceof JavaClass) {
            annotation2 = ((JavaClass)annoClass).javaClass();
        } else {
            throw context.runtime.newTypeError("expected a Java (proxy) class, got: " + annoClass);
        }
        return Java.getInstance(context.runtime, this.accessibleObject().getAnnotation(annotation2));
    }

    @JRubyMethod
    public IRubyObject annotations(ThreadContext context) {
        return Java.getInstance(context.runtime, this.accessibleObject().getAnnotations());
    }

    @JRubyMethod(name={"annotations?"})
    public RubyBoolean annotations_p(ThreadContext context) {
        return context.runtime.newBoolean(this.accessibleObject().getAnnotations().length > 0);
    }

    @JRubyMethod
    public IRubyObject declared_annotations(ThreadContext context) {
        return Java.getInstance(context.runtime, this.accessibleObject().getDeclaredAnnotations());
    }

    @JRubyMethod(name={"declared_annotations?"})
    public RubyBoolean declared_annotations_p(ThreadContext context) {
        return context.runtime.newBoolean(this.accessibleObject().getDeclaredAnnotations().length > 0);
    }

    @JRubyMethod(name={"annotation_present?"})
    public IRubyObject annotation_present_p(ThreadContext context, IRubyObject annoClass) {
        Class annotation2;
        if (annoClass instanceof RubyClass && ((RubyClass)annoClass).getJavaProxy()) {
            annotation2 = ((RubyClass)annoClass).getJavaClass();
        } else if (annoClass instanceof JavaClass) {
            annotation2 = ((JavaClass)annoClass).javaClass();
        } else {
            throw context.runtime.newTypeError("expected a Java (proxy) class, got: " + annoClass);
        }
        return context.runtime.newBoolean(this.accessibleObject().isAnnotationPresent(annotation2));
    }

    @JRubyMethod
    public IRubyObject declaring_class(ThreadContext context) {
        Class<?> clazz = ((Member)((Object)this.accessibleObject())).getDeclaringClass();
        if (clazz != null) {
            return Java.getProxyClass(context.runtime, clazz);
        }
        return context.runtime.getNil();
    }

    @JRubyMethod
    public IRubyObject modifiers(ThreadContext context) {
        return context.runtime.newFixnum(((Member)((Object)this.accessibleObject())).getModifiers());
    }

    @JRubyMethod
    public IRubyObject name(ThreadContext context) {
        return context.runtime.newString(((Member)((Object)this.accessibleObject())).getName());
    }

    @JRubyMethod(name={"synthetic?"})
    public IRubyObject synthetic_p(ThreadContext context) {
        return context.runtime.newBoolean(((Member)((Object)this.accessibleObject())).isSynthetic());
    }

    @JRubyMethod(name={"to_s", "to_string"})
    public RubyString to_string(ThreadContext context) {
        return context.runtime.newString(this.toString());
    }

    public String toString() {
        return this.accessibleObject().toString();
    }
}

