/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.mock;

import com.intellij.openapi.Disposable;
import com.intellij.openapi.components.ComponentManager;
import com.intellij.openapi.extensions.impl.ExtensionsAreaImpl;
import com.intellij.openapi.util.Condition;
import com.intellij.openapi.util.Conditions;
import com.intellij.openapi.util.Disposer;
import com.intellij.openapi.util.UserDataHolderBase;
import com.intellij.util.messages.ListenerDescriptor;
import com.intellij.util.messages.MessageBus;
import com.intellij.util.messages.MessageBusOwner;
import com.intellij.util.messages.impl.MessageBusFactoryImpl;
import com.intellij.util.pico.DefaultPicoContainer;
import gnu.trove.THashMap;
import java.util.Collections;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.picocontainer.MutablePicoContainer;
import org.picocontainer.PicoContainer;

public class MockComponentManager
extends UserDataHolderBase
implements ComponentManager,
MessageBusOwner {
    private final MessageBus myMessageBus;
    private final DefaultPicoContainer myPicoContainer;
    private final ExtensionsAreaImpl myExtensionArea;
    private final Map<Class<?>, Object> myComponents;
    private final Set<Object> myDisposableComponents;
    private boolean myDisposed;

    public MockComponentManager(@Nullable PicoContainer parent2, @NotNull Disposable parentDisposable) {
        if (parentDisposable == null) {
            MockComponentManager.$$$reportNull$$$0(0);
        }
        this.myMessageBus = MessageBusFactoryImpl.createRootBus(this);
        this.myComponents = new THashMap();
        this.myDisposableComponents = Collections.newSetFromMap(new ConcurrentHashMap());
        this.myPicoContainer = new DefaultPicoContainer((DefaultPicoContainer)parent2){

            @Override
            @Nullable
            public Object getComponentInstance(@NotNull Object componentKey) {
                if (componentKey == null) {
                    1.$$$reportNull$$$0(0);
                }
                if (MockComponentManager.this.myDisposed) {
                    throw new IllegalStateException("Cannot get " + componentKey + " from already disposed " + this);
                }
                Object o = super.getComponentInstance(componentKey);
                MockComponentManager.this.registerComponentInDisposer(o);
                return o;
            }

            private static /* synthetic */ void $$$reportNull$$$0(int n) {
                throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", "componentKey", "com/intellij/mock/MockComponentManager$1", "getComponentInstance"));
            }
        };
        this.myPicoContainer.registerComponentInstance(this);
        this.myExtensionArea = new ExtensionsAreaImpl(this);
        Disposer.register(parentDisposable, this);
    }

    @Override
    @NotNull
    public ExtensionsAreaImpl getExtensionArea() {
        ExtensionsAreaImpl extensionsAreaImpl = this.myExtensionArea;
        if (extensionsAreaImpl == null) {
            MockComponentManager.$$$reportNull$$$0(1);
        }
        return extensionsAreaImpl;
    }

    protected void registerComponentInDisposer(@Nullable Object o) {
        if (o instanceof Disposable && o != this && !(o instanceof MessageBus) && this.myDisposableComponents.add(o)) {
            Disposer.register(this, (Disposable)o);
        }
    }

    public <T> void registerService(@NotNull Class<T> serviceInterface, @NotNull Class<? extends T> serviceImplementation) {
        if (serviceInterface == null) {
            MockComponentManager.$$$reportNull$$$0(2);
        }
        if (serviceImplementation == null) {
            MockComponentManager.$$$reportNull$$$0(3);
        }
        this.myPicoContainer.unregisterComponent(serviceInterface.getName());
        this.myPicoContainer.registerComponentImplementation(serviceInterface.getName(), serviceImplementation);
    }

    public <T> void registerService(@NotNull Class<T> serviceInterface, @NotNull T serviceImplementation) {
        if (serviceInterface == null) {
            MockComponentManager.$$$reportNull$$$0(5);
        }
        if (serviceImplementation == null) {
            MockComponentManager.$$$reportNull$$$0(6);
        }
        this.myPicoContainer.registerComponentInstance(serviceInterface.getName(), serviceImplementation);
        this.registerComponentInDisposer(serviceImplementation);
    }

    @Override
    @Nullable
    public <T> T getComponent(@NotNull Class<T> interfaceClass) {
        Object o;
        if (interfaceClass == null) {
            MockComponentManager.$$$reportNull$$$0(12);
        }
        return (T)((o = this.myPicoContainer.getComponentInstance(interfaceClass)) != null ? o : this.myComponents.get(interfaceClass));
    }

    @Override
    public <T> T getService(@NotNull Class<T> serviceClass) {
        if (serviceClass == null) {
            MockComponentManager.$$$reportNull$$$0(13);
        }
        T result2 = this.myPicoContainer.getService(serviceClass);
        this.registerComponentInDisposer(result2);
        return result2;
    }

    @Override
    @NotNull
    public final MutablePicoContainer getPicoContainer() {
        DefaultPicoContainer defaultPicoContainer = this.myPicoContainer;
        if (defaultPicoContainer == null) {
            MockComponentManager.$$$reportNull$$$0(14);
        }
        return defaultPicoContainer;
    }

    @Override
    @NotNull
    public MessageBus getMessageBus() {
        MessageBus messageBus = this.myMessageBus;
        if (messageBus == null) {
            MockComponentManager.$$$reportNull$$$0(15);
        }
        return messageBus;
    }

    @Override
    public boolean isDisposed() {
        return this.myDisposed;
    }

    @Override
    public void dispose() {
        Disposer.dispose(this.myMessageBus);
        this.myDisposed = true;
    }

    @Override
    @NotNull
    public Condition<?> getDisposed() {
        Condition condition = Conditions.alwaysFalse();
        if (condition == null) {
            MockComponentManager.$$$reportNull$$$0(16);
        }
        return condition;
    }

    @Override
    @NotNull
    public Object createListener(@NotNull ListenerDescriptor descriptor2) {
        if (descriptor2 == null) {
            MockComponentManager.$$$reportNull$$$0(17);
        }
        throw new UnsupportedOperationException();
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        RuntimeException runtimeException;
        Object[] objectArray;
        Object[] objectArray2;
        int n2;
        String string2;
        switch (n) {
            default: {
                string2 = "Argument for @NotNull parameter '%s' of %s.%s must not be null";
                break;
            }
            case 1: 
            case 14: 
            case 15: 
            case 16: {
                string2 = "@NotNull method %s.%s must not return null";
                break;
            }
        }
        switch (n) {
            default: {
                n2 = 3;
                break;
            }
            case 1: 
            case 14: 
            case 15: 
            case 16: {
                n2 = 2;
                break;
            }
        }
        Object[] objectArray3 = new Object[n2];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "parentDisposable";
                break;
            }
            case 1: 
            case 14: 
            case 15: 
            case 16: {
                objectArray2 = objectArray3;
                objectArray3[0] = "com/intellij/mock/MockComponentManager";
                break;
            }
            case 2: 
            case 5: 
            case 7: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceInterface";
                break;
            }
            case 3: 
            case 4: 
            case 6: 
            case 8: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceImplementation";
                break;
            }
            case 10: 
            case 12: {
                objectArray2 = objectArray3;
                objectArray3[0] = "interfaceClass";
                break;
            }
            case 11: {
                objectArray2 = objectArray3;
                objectArray3[0] = "instance";
                break;
            }
            case 13: {
                objectArray2 = objectArray3;
                objectArray3[0] = "serviceClass";
                break;
            }
            case 17: {
                objectArray2 = objectArray3;
                objectArray3[0] = "descriptor";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[1] = "com/intellij/mock/MockComponentManager";
                break;
            }
            case 1: {
                objectArray = objectArray2;
                objectArray2[1] = "getExtensionArea";
                break;
            }
            case 14: {
                objectArray = objectArray2;
                objectArray2[1] = "getPicoContainer";
                break;
            }
            case 15: {
                objectArray = objectArray2;
                objectArray2[1] = "getMessageBus";
                break;
            }
            case 16: {
                objectArray = objectArray2;
                objectArray2[1] = "getDisposed";
                break;
            }
        }
        switch (n) {
            default: {
                objectArray = objectArray;
                objectArray[2] = "<init>";
                break;
            }
            case 1: 
            case 14: 
            case 15: 
            case 16: {
                break;
            }
            case 2: 
            case 3: 
            case 4: 
            case 5: 
            case 6: 
            case 7: 
            case 8: 
            case 9: {
                objectArray = objectArray;
                objectArray[2] = "registerService";
                break;
            }
            case 10: 
            case 11: {
                objectArray = objectArray;
                objectArray[2] = "addComponent";
                break;
            }
            case 12: {
                objectArray = objectArray;
                objectArray[2] = "getComponent";
                break;
            }
            case 13: {
                objectArray = objectArray;
                objectArray[2] = "getService";
                break;
            }
            case 17: {
                objectArray = objectArray;
                objectArray[2] = "createListener";
                break;
            }
        }
        String string3 = String.format(string2, objectArray);
        switch (n) {
            default: {
                runtimeException = new IllegalArgumentException(string3);
                break;
            }
            case 1: 
            case 14: 
            case 15: 
            case 16: {
                runtimeException = new IllegalStateException(string3);
                break;
            }
        }
        throw runtimeException;
    }
}

