/*
 * Decompiled with CFR 0.152.
 */
package com.intellij.psi.impl.source.resolve;

import com.intellij.openapi.components.ServiceManager;
import com.intellij.openapi.project.Project;
import com.intellij.openapi.util.Key;
import com.intellij.openapi.util.NotNullLazyKey;
import com.intellij.psi.PsiExpression;
import com.intellij.psi.PsiType;
import com.intellij.psi.PsiVariable;
import com.intellij.psi.impl.AnyPsiChangeListener;
import com.intellij.psi.impl.PsiManagerImpl;
import com.intellij.psi.impl.source.resolve.graphInference.PsiPolyExpressionUtil;
import com.intellij.psi.infos.MethodCandidateInfo;
import com.intellij.psi.util.CachedValuesManager;
import com.intellij.util.ConcurrencyUtil;
import com.intellij.util.Function;
import com.intellij.util.containers.ContainerUtil;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class JavaResolveCache {
    private static final NotNullLazyKey<JavaResolveCache, Project> INSTANCE_KEY = ServiceManager.createLazyKey(JavaResolveCache.class);
    private final AtomicReference<Map<PsiVariable, Object>> myVarToConstValueMapPhysical;
    private final AtomicReference<Map<PsiVariable, Object>> myVarToConstValueMapNonPhysical;
    private static final Object NULL = Key.create("NULL");

    public static JavaResolveCache getInstance(Project project) {
        return INSTANCE_KEY.getValue(project);
    }

    public JavaResolveCache(@NotNull Project project) {
        if (project == null) {
            JavaResolveCache.$$$reportNull$$$0(0);
        }
        this.myVarToConstValueMapPhysical = new AtomicReference();
        this.myVarToConstValueMapNonPhysical = new AtomicReference();
        project.getMessageBus().connect().subscribe(PsiManagerImpl.ANY_PSI_CHANGE_TOPIC, new AnyPsiChangeListener(){

            @Override
            public void beforePsiChanged(boolean isPhysical) {
                JavaResolveCache.this.clearCaches(isPhysical);
            }
        });
    }

    private void clearCaches(boolean isPhysical) {
        if (isPhysical) {
            this.myVarToConstValueMapPhysical.set(null);
        }
        this.myVarToConstValueMapNonPhysical.set(null);
    }

    @Nullable
    public <T extends PsiExpression> PsiType getType(@NotNull T expr, @NotNull Function<? super T, ? extends PsiType> f) {
        boolean prohibitCaching;
        if (expr == null) {
            JavaResolveCache.$$$reportNull$$$0(1);
        }
        if (f == null) {
            JavaResolveCache.$$$reportNull$$$0(2);
        }
        boolean bl = prohibitCaching = MethodCandidateInfo.isOverloadCheck() && PsiPolyExpressionUtil.isPolyExpression(expr);
        if (prohibitCaching) {
            return f.fun(expr);
        }
        return CachedValuesManager.getProjectPsiDependentCache(expr, param -> (PsiType)f.fun(param));
    }

    @Nullable
    public Object computeConstantValueWithCaching(@NotNull PsiVariable variable2, @NotNull ConstValueComputer computer, Set<PsiVariable> visitedVars) {
        Object cached2;
        boolean physical;
        AtomicReference<Map<PsiVariable, Object>> ref;
        Map map;
        if (variable2 == null) {
            JavaResolveCache.$$$reportNull$$$0(3);
        }
        if (computer == null) {
            JavaResolveCache.$$$reportNull$$$0(4);
        }
        if ((map = (ref = (physical = variable2.isPhysical()) ? this.myVarToConstValueMapPhysical : this.myVarToConstValueMapNonPhysical).get()) == null) {
            map = ConcurrencyUtil.cacheOrGet(ref, ContainerUtil.createConcurrentWeakMap());
        }
        if ((cached2 = map.get(variable2)) == NULL) {
            return null;
        }
        if (cached2 != null) {
            return cached2;
        }
        Object result2 = computer.execute(variable2, visitedVars);
        map.put(variable2, result2 == null ? NULL : result2);
        return result2;
    }

    private static /* synthetic */ void $$$reportNull$$$0(int n) {
        Object[] objectArray;
        Object[] objectArray2;
        Object[] objectArray3 = new Object[3];
        switch (n) {
            default: {
                objectArray2 = objectArray3;
                objectArray3[0] = "project";
                break;
            }
            case 1: {
                objectArray2 = objectArray3;
                objectArray3[0] = "expr";
                break;
            }
            case 2: {
                objectArray2 = objectArray3;
                objectArray3[0] = "f";
                break;
            }
            case 3: {
                objectArray2 = objectArray3;
                objectArray3[0] = "variable";
                break;
            }
            case 4: {
                objectArray2 = objectArray3;
                objectArray3[0] = "computer";
                break;
            }
        }
        objectArray2[1] = "com/intellij/psi/impl/source/resolve/JavaResolveCache";
        switch (n) {
            default: {
                objectArray = objectArray2;
                objectArray2[2] = "<init>";
                break;
            }
            case 1: 
            case 2: {
                objectArray = objectArray2;
                objectArray2[2] = "getType";
                break;
            }
            case 3: 
            case 4: {
                objectArray = objectArray2;
                objectArray2[2] = "computeConstantValueWithCaching";
                break;
            }
        }
        throw new IllegalArgumentException(String.format("Argument for @NotNull parameter '%s' of %s.%s must not be null", objectArray));
    }

    @FunctionalInterface
    public static interface ConstValueComputer {
        public Object execute(@NotNull PsiVariable var1, Set<PsiVariable> var2);
    }
}

