/*
 * Decompiled with CFR 0.152.
 */
package org.jetbrains.kotlin.fir.resolve.calls;

import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import kotlin.Metadata;
import kotlin.Pair;
import kotlin.collections.CollectionsKt;
import kotlin.jvm.functions.Function1;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.Reflection;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;
import org.jetbrains.kotlin.fir.FirElement;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponent;
import org.jetbrains.kotlin.fir.FirLookupTrackerComponentKt;
import org.jetbrains.kotlin.fir.FirRendererKt;
import org.jetbrains.kotlin.fir.FirSession;
import org.jetbrains.kotlin.fir.SessionUtilsKt;
import org.jetbrains.kotlin.fir.UtilsKt;
import org.jetbrains.kotlin.fir.declarations.FirAnonymousFunction;
import org.jetbrains.kotlin.fir.declarations.FirFunction;
import org.jetbrains.kotlin.fir.declarations.FirTypeParameter;
import org.jetbrains.kotlin.fir.declarations.FirTypedDeclaration;
import org.jetbrains.kotlin.fir.declarations.FirValueParameter;
import org.jetbrains.kotlin.fir.expressions.FirBlock;
import org.jetbrains.kotlin.fir.expressions.FirCallableReferenceAccess;
import org.jetbrains.kotlin.fir.expressions.FirCheckNotNullCall;
import org.jetbrains.kotlin.fir.expressions.FirConstExpression;
import org.jetbrains.kotlin.fir.expressions.FirElvisExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpression;
import org.jetbrains.kotlin.fir.expressions.FirExpressionUtilKt;
import org.jetbrains.kotlin.fir.expressions.FirExpressionWithSmartcast;
import org.jetbrains.kotlin.fir.expressions.FirFunctionCall;
import org.jetbrains.kotlin.fir.expressions.FirNamedArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirQualifiedAccess;
import org.jetbrains.kotlin.fir.expressions.FirResolvable;
import org.jetbrains.kotlin.fir.expressions.FirSafeCallExpression;
import org.jetbrains.kotlin.fir.expressions.FirSpreadArgumentExpression;
import org.jetbrains.kotlin.fir.expressions.FirTryExpression;
import org.jetbrains.kotlin.fir.expressions.FirWhenExpression;
import org.jetbrains.kotlin.fir.expressions.FirWrappedArgumentExpression;
import org.jetbrains.kotlin.fir.references.FirResolvedNamedReference;
import org.jetbrains.kotlin.fir.resolve.ResolveUtilsKt;
import org.jetbrains.kotlin.fir.resolve.ScopeSession;
import org.jetbrains.kotlin.fir.resolve.TypeExpansionUtilsKt;
import org.jetbrains.kotlin.fir.resolve.calls.ArgumentTypeMismatch;
import org.jetbrains.kotlin.fir.resolve.calls.CallInfo;
import org.jetbrains.kotlin.fir.resolve.calls.Candidate;
import org.jetbrains.kotlin.fir.resolve.calls.CandidateFactoryKt;
import org.jetbrains.kotlin.fir.resolve.calls.CheckerSink;
import org.jetbrains.kotlin.fir.resolve.calls.CheckerSinkKt;
import org.jetbrains.kotlin.fir.resolve.calls.InapplicableWrongReceiver;
import org.jetbrains.kotlin.fir.resolve.calls.NullForNotNullType;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionContext;
import org.jetbrains.kotlin.fir.resolve.calls.ResolutionDiagnostic;
import org.jetbrains.kotlin.fir.resolve.calls.UnsafeCall;
import org.jetbrains.kotlin.fir.resolve.calls.UnstableSmartCast;
import org.jetbrains.kotlin.fir.resolve.inference.InferenceComponentsKt;
import org.jetbrains.kotlin.fir.resolve.inference.InferenceUtilsKt;
import org.jetbrains.kotlin.fir.resolve.inference.PostponedArgumentsKt;
import org.jetbrains.kotlin.fir.resolve.transformers.PhaseUtilsKt;
import org.jetbrains.kotlin.fir.symbols.ConeClassLikeLookupTag;
import org.jetbrains.kotlin.fir.symbols.ConeClassifierLookupTag;
import org.jetbrains.kotlin.fir.symbols.ConeTypeParameterLookupTag;
import org.jetbrains.kotlin.fir.symbols.FirBasedSymbol;
import org.jetbrains.kotlin.fir.symbols.impl.FirFunctionSymbol;
import org.jetbrains.kotlin.fir.types.ArrayUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeClassLikeType;
import org.jetbrains.kotlin.fir.types.ConeDefinitelyNotNullType;
import org.jetbrains.kotlin.fir.types.ConeFlexibleType;
import org.jetbrains.kotlin.fir.types.ConeInferenceContext;
import org.jetbrains.kotlin.fir.types.ConeIntegerLiteralType;
import org.jetbrains.kotlin.fir.types.ConeKotlinType;
import org.jetbrains.kotlin.fir.types.ConeLookupTagBasedType;
import org.jetbrains.kotlin.fir.types.ConeNullability;
import org.jetbrains.kotlin.fir.types.ConeTypeContext;
import org.jetbrains.kotlin.fir.types.ConeTypeParameterType;
import org.jetbrains.kotlin.fir.types.ConeTypeProjection;
import org.jetbrains.kotlin.fir.types.ConeTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.ConeTypeVariableType;
import org.jetbrains.kotlin.fir.types.ConeTypeVariableTypeConstructor;
import org.jetbrains.kotlin.fir.types.ConeTypesKt;
import org.jetbrains.kotlin.fir.types.FirResolvedTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeRef;
import org.jetbrains.kotlin.fir.types.FirTypeUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeConstructionUtilsKt;
import org.jetbrains.kotlin.fir.types.TypeUtilsKt;
import org.jetbrains.kotlin.fir.types.impl.ConeTypeParameterTypeImpl;
import org.jetbrains.kotlin.name.ClassId;
import org.jetbrains.kotlin.name.Name;
import org.jetbrains.kotlin.name.StandardClassIds;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilder;
import org.jetbrains.kotlin.resolve.calls.inference.ConstraintSystemBuilderKt;
import org.jetbrains.kotlin.resolve.calls.inference.model.SimpleConstraintSystemConstraintPosition;
import org.jetbrains.kotlin.types.AbstractTypeChecker;
import org.jetbrains.kotlin.types.SmartcastStability;
import org.jetbrains.kotlin.types.model.CaptureStatus;
import org.jetbrains.kotlin.types.model.KotlinTypeMarker;
import org.jetbrains.kotlin.types.model.SimpleTypeMarker;
import org.jetbrains.kotlin.types.model.TypeConstructorMarker;
import org.jetbrains.kotlin.types.model.TypeParameterMarker;
import org.jetbrains.kotlin.types.model.TypeSystemCommonSuperTypesContext;

@Metadata(mv={1, 5, 1}, k=2, xi=48, d1={"\u0000\u008e\u0001\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0002\b\u0003\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\b\u0004\n\u0002\u0018\u0002\n\u0002\b\u0002\u001a*\u0010\u0004\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u0005H\u0002\u001a \u0010\f\u001a\u00020\u00052\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\n\u001a\u00020\u00052\u0006\u0010\u0006\u001a\u00020\u0007H\u0000\u001aR\u0010\r\u001a\u00020\u000e2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0013\u001a\u00020\u00142\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u001a\u001e\u0010\u001c\u001a\u00020\u00162\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u001d\u001a\u00020\u00052\u0006\u0010\u001e\u001a\u00020\u001f\u001a\u001e\u0010 \u001a\u0004\u0018\u00010\u0005*\u00020!2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u001a\u0012\u0010\"\u001a\u00020\u0005*\u00020\u00122\u0006\u0010#\u001a\u00020$\u001a6\u0010%\u001a\u0004\u0018\u00010\u0005*\u00020!2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010&\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u001a\u001c\u0010'\u001a\u00020\u0016*\u00020\u00052\u0006\u0010(\u001a\u00020)2\u0006\u0010\u001a\u001a\u00020*H\u0002\u001a$\u0010+\u001a\u00020\u0016*\u00020\u00122\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\b\u0010,\u001a\u0004\u0018\u00010\u0005\u001a\u001a\u0010-\u001a\u00020\u0005*\u00020!2\u0006\u0010\u000b\u001a\u00020\u00052\u0006\u0010\u001a\u001a\u00020\u001b\u001a@\u0010.\u001a\u0004\u0018\u00010\u0005*\u00020!2\u0006\u0010\u0006\u001a\u00020\u00072\u0006\u0010\b\u001a\u00020\t2\u0006\u0010/\u001a\u0002002\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u001a\u001a\u00020\u001bH\u0002\u001a>\u00101\u001a\u00020\u000e*\u00020!2\u0006\u0010/\u001a\u0002002\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010#\u001a\u0004\u0018\u00010$2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001bH\u0000\u001aN\u00102\u001a\u00020\u000e*\u00020!2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\n\u001a\u0004\u0018\u00010\u00052\b\u00103\u001a\u0004\u0018\u0001042\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016\u001aP\u00105\u001a\u00020\u000e*\u00020!2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u00106\u001a\u0002072\b\u0010\n\u001a\u0004\u0018\u00010\u00052\b\u00103\u001a\u0004\u0018\u0001042\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u0016H\u0002\u001aV\u00108\u001a\u00020\u000e*\u00020!2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\u0006\u0010\u000b\u001a\u00020\u00052\b\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\b\b\u0002\u00109\u001a\u00020\u0016\u001aN\u0010:\u001a\u00020\u000e*\u00020!2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020\u00122\b\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\b\b\u0002\u00109\u001a\u00020\u0016\u001aN\u0010;\u001a\u00020\u000e*\u00020!2\u0006\u0010\u000f\u001a\u00020\u00102\u0006\u0010\u0011\u001a\u00020<2\b\u0010\n\u001a\u0004\u0018\u00010\u00052\u0006\u0010\u0018\u001a\u00020\u00192\u0006\u0010\u001a\u001a\u00020\u001b2\u0006\u0010\u0015\u001a\u00020\u00162\u0006\u0010\u0017\u001a\u00020\u00162\b\b\u0002\u00109\u001a\u00020\u0016\u001a\n\u0010=\u001a\u00020\u0005*\u00020\u0005\"\u0011\u0010\u0000\u001a\u00020\u0001\u00a2\u0006\b\n\u0000\u001a\u0004\b\u0002\u0010\u0003\u00a8\u0006>"}, d2={"SAM_LOOKUP_NAME", "Lorg/jetbrains/kotlin/name/Name;", "getSAM_LOOKUP_NAME", "()Lorg/jetbrains/kotlin/name/Name;", "argumentTypeWithSuspendConversion", "Lorg/jetbrains/kotlin/fir/types/ConeKotlinType;", "session", "Lorg/jetbrains/kotlin/fir/FirSession;", "scopeSession", "Lorg/jetbrains/kotlin/fir/resolve/ScopeSession;", "expectedType", "argumentType", "captureFromTypeParameterUpperBoundIfNeeded", "checkApplicabilityForArgumentType", "", "csBuilder", "Lorg/jetbrains/kotlin/resolve/calls/inference/ConstraintSystemBuilder;", "argument", "Lorg/jetbrains/kotlin/fir/expressions/FirExpression;", "position", "Lorg/jetbrains/kotlin/resolve/calls/inference/model/SimpleConstraintSystemConstraintPosition;", "isReceiver", "", "isDispatch", "sink", "Lorg/jetbrains/kotlin/fir/resolve/calls/CheckerSink;", "context", "Lorg/jetbrains/kotlin/fir/resolve/calls/ResolutionContext;", "isArgumentTypeMismatchDueToNullability", "actualExpectedType", "typeContext", "Lorg/jetbrains/kotlin/fir/types/ConeTypeContext;", "captureTypeFromExpressionOrNull", "Lorg/jetbrains/kotlin/fir/resolve/calls/Candidate;", "getExpectedTypeForSAMConversion", "parameter", "Lorg/jetbrains/kotlin/fir/declarations/FirValueParameter;", "getExpectedTypeWithSAMConversion", "candidateExpectedType", "hasSupertypeWithGivenClassId", "classId", "Lorg/jetbrains/kotlin/name/ClassId;", "Lorg/jetbrains/kotlin/types/model/TypeSystemCommonSuperTypesContext;", "isFunctional", "expectedFunctionType", "prepareCapturedType", "prepareExpectedType", "callInfo", "Lorg/jetbrains/kotlin/fir/resolve/calls/CallInfo;", "resolveArgument", "resolveArgumentExpression", "expectedTypeRef", "Lorg/jetbrains/kotlin/fir/types/FirTypeRef;", "resolveBlockArgument", "block", "Lorg/jetbrains/kotlin/fir/expressions/FirBlock;", "resolvePlainArgumentType", "useNullableArgumentType", "resolvePlainExpressionArgument", "resolveSubCallArgument", "Lorg/jetbrains/kotlin/fir/expressions/FirResolvable;", "varargElementType", "resolve"})
public final class ArgumentsKt {
    @NotNull
    private static final Name SAM_LOOKUP_NAME;

    @NotNull
    public static final Name getSAM_LOOKUP_NAME() {
        return SAM_LOOKUP_NAME;
    }

    public static final void resolveArgumentExpression(@NotNull Candidate $this$resolveArgumentExpression, @NotNull ConstraintSystemBuilder csBuilder, @NotNull FirExpression argument2, @Nullable ConeKotlinType expectedType2, @Nullable FirTypeRef expectedTypeRef, @NotNull CheckerSink sink, @NotNull ResolutionContext context2, boolean isReceiver, boolean isDispatch) {
        Intrinsics.checkNotNullParameter($this$resolveArgumentExpression, "<this>");
        Intrinsics.checkNotNullParameter(csBuilder, "csBuilder");
        Intrinsics.checkNotNullParameter(argument2, "argument");
        Intrinsics.checkNotNullParameter(sink, "sink");
        Intrinsics.checkNotNullParameter(context2, "context");
        FirExpression firExpression2 = argument2;
        if ((((firExpression2 instanceof FirFunctionCall ? true : firExpression2 instanceof FirWhenExpression) ? true : firExpression2 instanceof FirTryExpression) ? true : firExpression2 instanceof FirCheckNotNullCall) ? true : firExpression2 instanceof FirElvisExpression) {
            ArgumentsKt.resolveSubCallArgument$default($this$resolveArgumentExpression, csBuilder, (FirResolvable)((Object)argument2), expectedType2, sink, context2, isReceiver, isDispatch, false, 128, null);
        } else if (firExpression2 instanceof FirSafeCallExpression) {
            FirQualifiedAccess nestedQualifier = ((FirSafeCallExpression)argument2).getRegularQualifiedAccess();
            if (nestedQualifier instanceof FirExpression) {
                ArgumentsKt.resolveSubCallArgument($this$resolveArgumentExpression, csBuilder, nestedQualifier, expectedType2, sink, context2, isReceiver, isDispatch, true);
            } else {
                ConeKotlinType coneKotlinType;
                boolean $i$f$emptyArray = false;
                ArgumentsKt.checkApplicabilityForArgumentType(csBuilder, argument2, TypeConstructionUtilsKt.constructClassLikeType$default(StandardClassIds.INSTANCE.getUnit(), (ConeTypeProjection[])((Object[])new ConeTypeProjection[0]), false, null, 4, null), (coneKotlinType = expectedType2) == null ? null : coneKotlinType.getType(), SimpleConstraintSystemConstraintPosition.INSTANCE, false, false, sink, context2);
            }
        } else if (firExpression2 instanceof FirCallableReferenceAccess) {
            if (((FirCallableReferenceAccess)argument2).getCalleeReference() instanceof FirResolvedNamedReference) {
                ArgumentsKt.resolvePlainExpressionArgument$default($this$resolveArgumentExpression, csBuilder, argument2, expectedType2, sink, context2, isReceiver, isDispatch, false, 128, null);
            } else {
                PostponedArgumentsKt.preprocessCallableReference($this$resolveArgumentExpression, (FirCallableReferenceAccess)argument2, expectedType2, context2);
            }
        } else if (firExpression2 instanceof FirAnonymousFunction) {
            PostponedArgumentsKt.preprocessLambdaArgument$default($this$resolveArgumentExpression, csBuilder, (FirAnonymousFunction)argument2, expectedType2, expectedTypeRef, context2, sink, false, null, 192, null);
        } else if (firExpression2 instanceof FirWrappedArgumentExpression) {
            ArgumentsKt.resolveArgumentExpression($this$resolveArgumentExpression, csBuilder, ((FirWrappedArgumentExpression)argument2).getExpression(), expectedType2, expectedTypeRef, sink, context2, isReceiver, isDispatch);
        } else if (firExpression2 instanceof FirBlock) {
            ArgumentsKt.resolveBlockArgument($this$resolveArgumentExpression, csBuilder, (FirBlock)argument2, expectedType2, expectedTypeRef, sink, context2, isReceiver, isDispatch);
        } else {
            ArgumentsKt.resolvePlainExpressionArgument$default($this$resolveArgumentExpression, csBuilder, argument2, expectedType2, sink, context2, isReceiver, isDispatch, false, 128, null);
        }
    }

    private static final void resolveBlockArgument(Candidate $this$resolveBlockArgument, ConstraintSystemBuilder csBuilder, FirBlock block, ConeKotlinType expectedType2, FirTypeRef expectedTypeRef, CheckerSink sink, ResolutionContext context2, boolean isReceiver, boolean isDispatch) {
        List<FirExpression> returnArguments = UtilsKt.returnExpressions(block);
        if (returnArguments.isEmpty()) {
            ConeKotlinType coneKotlinType;
            ArgumentsKt.checkApplicabilityForArgumentType(csBuilder, block, FirTypeUtilsKt.getConeType(block.getTypeRef()), (coneKotlinType = expectedType2) == null ? null : coneKotlinType.getType(), SimpleConstraintSystemConstraintPosition.INSTANCE, false, false, sink, context2);
            return;
        }
        for (FirExpression argument2 : returnArguments) {
            ArgumentsKt.resolveArgumentExpression($this$resolveBlockArgument, csBuilder, argument2, expectedType2, expectedTypeRef, sink, context2, isReceiver, isDispatch);
        }
    }

    public static final void resolveSubCallArgument(@NotNull Candidate $this$resolveSubCallArgument, @NotNull ConstraintSystemBuilder csBuilder, @NotNull FirResolvable argument2, @Nullable ConeKotlinType expectedType2, @NotNull CheckerSink sink, @NotNull ResolutionContext context2, boolean isReceiver, boolean isDispatch, boolean useNullableArgumentType) {
        Intrinsics.checkNotNullParameter($this$resolveSubCallArgument, "<this>");
        Intrinsics.checkNotNullParameter(csBuilder, "csBuilder");
        Intrinsics.checkNotNullParameter(argument2, "argument");
        Intrinsics.checkNotNullParameter(sink, "sink");
        Intrinsics.checkNotNullParameter(context2, "context");
        boolean bl = argument2 instanceof FirExpression;
        boolean bl2 = false;
        boolean bl3 = false;
        bl3 = false;
        boolean bl4 = false;
        if (!bl) {
            boolean bl5 = false;
            String string2 = "Failed requirement.";
            throw (Throwable)new IllegalArgumentException(string2.toString());
        }
        Candidate candidate2 = CandidateFactoryKt.candidate(argument2);
        if (candidate2 == null) {
            ArgumentsKt.resolvePlainExpressionArgument($this$resolveSubCallArgument, csBuilder, (FirExpression)((Object)argument2), expectedType2, sink, context2, isReceiver, isDispatch, useNullableArgumentType);
            return;
        }
        Candidate candidate3 = candidate2;
        FirBasedSymbol $this$firUnsafe$iv = candidate3.getSymbol();
        boolean $i$f$firUnsafe = false;
        Object fir$iv = $this$firUnsafe$iv.getFir();
        boolean bl6 = fir$iv instanceof FirTypedDeclaration;
        boolean bl7 = false;
        boolean bl8 = false;
        if (!bl6) {
            boolean bl9 = false;
            String string3 = "Not an expected fir element type = " + Reflection.getOrCreateKotlinClass(FirTypedDeclaration.class) + ", symbol = " + $this$firUnsafe$iv + ", fir = " + FirRendererKt.renderWithType$default((FirElement)fir$iv, null, 1, null);
            throw (Throwable)new IllegalArgumentException(string3.toString());
        }
        ConeKotlinType type2 = context2.getReturnTypeCalculator().tryCalculateReturnType((FirTypedDeclaration)((FirElement)fir$iv)).getType();
        ConeKotlinType argumentType = candidate3.getSubstitutor().substituteOrSelf(type2);
        ArgumentsKt.resolvePlainArgumentType($this$resolveSubCallArgument, csBuilder, (FirExpression)((Object)argument2), argumentType, expectedType2, sink, context2, isReceiver, isDispatch, useNullableArgumentType);
    }

    public static /* synthetic */ void resolveSubCallArgument$default(Candidate candidate2, ConstraintSystemBuilder constraintSystemBuilder, FirResolvable firResolvable, ConeKotlinType coneKotlinType, CheckerSink checkerSink, ResolutionContext resolutionContext, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 0x80) != 0) {
            bl3 = false;
        }
        ArgumentsKt.resolveSubCallArgument(candidate2, constraintSystemBuilder, firResolvable, coneKotlinType, checkerSink, resolutionContext, bl, bl2, bl3);
    }

    public static final void resolvePlainExpressionArgument(@NotNull Candidate $this$resolvePlainExpressionArgument, @NotNull ConstraintSystemBuilder csBuilder, @NotNull FirExpression argument2, @Nullable ConeKotlinType expectedType2, @NotNull CheckerSink sink, @NotNull ResolutionContext context2, boolean isReceiver, boolean isDispatch, boolean useNullableArgumentType) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter($this$resolvePlainExpressionArgument, "<this>");
        Intrinsics.checkNotNullParameter(csBuilder, "csBuilder");
        Intrinsics.checkNotNullParameter(argument2, "argument");
        Intrinsics.checkNotNullParameter(sink, "sink");
        Intrinsics.checkNotNullParameter(context2, "context");
        if (expectedType2 == null) {
            return;
        }
        FirTypeRef $this$coneTypeSafe$iv = argument2.getTypeRef();
        boolean $i$f$coneTypeSafe = false;
        boolean bl = false;
        FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
        ConeKotlinType coneKotlinType2 = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
        if (!(coneKotlinType2 instanceof ConeKotlinType)) {
            coneKotlinType2 = null;
        }
        if ((coneKotlinType = coneKotlinType2) == null) {
            return;
        }
        ConeKotlinType argumentType = coneKotlinType;
        ArgumentsKt.resolvePlainArgumentType($this$resolvePlainExpressionArgument, csBuilder, argument2, argumentType, expectedType2, sink, context2, isReceiver, isDispatch, useNullableArgumentType);
    }

    public static /* synthetic */ void resolvePlainExpressionArgument$default(Candidate candidate2, ConstraintSystemBuilder constraintSystemBuilder, FirExpression firExpression2, ConeKotlinType coneKotlinType, CheckerSink checkerSink, ResolutionContext resolutionContext, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 0x80) != 0) {
            bl3 = false;
        }
        ArgumentsKt.resolvePlainExpressionArgument(candidate2, constraintSystemBuilder, firExpression2, coneKotlinType, checkerSink, resolutionContext, bl, bl2, bl3);
    }

    public static final void resolvePlainArgumentType(@NotNull Candidate $this$resolvePlainArgumentType, @NotNull ConstraintSystemBuilder csBuilder, @NotNull FirExpression argument2, @NotNull ConeKotlinType argumentType, @Nullable ConeKotlinType expectedType2, @NotNull CheckerSink sink, @NotNull ResolutionContext context2, boolean isReceiver, boolean isDispatch, boolean useNullableArgumentType) {
        ConeKotlinType coneKotlinType;
        Intrinsics.checkNotNullParameter($this$resolvePlainArgumentType, "<this>");
        Intrinsics.checkNotNullParameter(csBuilder, "csBuilder");
        Intrinsics.checkNotNullParameter(argument2, "argument");
        Intrinsics.checkNotNullParameter(argumentType, "argumentType");
        Intrinsics.checkNotNullParameter(sink, "sink");
        Intrinsics.checkNotNullParameter(context2, "context");
        SimpleConstraintSystemConstraintPosition position = SimpleConstraintSystemConstraintPosition.INSTANCE;
        FirSession session2 = context2.getSession();
        ConeKotlinType capturedType = ArgumentsKt.prepareCapturedType($this$resolvePlainArgumentType, argumentType, context2);
        ConeKotlinType argumentTypeForApplicabilityCheck = null;
        ConeKotlinType coneKotlinType2 = argumentTypeForApplicabilityCheck = useNullableArgumentType ? TypeUtilsKt.withNullability$default(capturedType, ConeNullability.NULLABLE, SessionUtilsKt.getTypeContext(session2), null, 4, null) : capturedType;
        if (expectedType2 != null && (coneKotlinType = ArgumentsKt.argumentTypeWithSuspendConversion(session2, context2.getBodyResolveComponents().getScopeSession(), expectedType2, argumentTypeForApplicabilityCheck)) != null) {
            ConeKotlinType coneKotlinType3 = coneKotlinType;
            boolean bl = false;
            boolean bl2 = false;
            ConeKotlinType it = coneKotlinType3;
            boolean bl3 = false;
            argumentTypeForApplicabilityCheck = it;
            $this$resolvePlainArgumentType.getSubstitutor().substituteOrSelf(argumentTypeForApplicabilityCheck);
            $this$resolvePlainArgumentType.setUsesSuspendConversion(true);
        }
        ArgumentsKt.checkApplicabilityForArgumentType(csBuilder, argument2, argumentTypeForApplicabilityCheck, expectedType2, position, isReceiver, isDispatch, sink, context2);
    }

    public static /* synthetic */ void resolvePlainArgumentType$default(Candidate candidate2, ConstraintSystemBuilder constraintSystemBuilder, FirExpression firExpression2, ConeKotlinType coneKotlinType, ConeKotlinType coneKotlinType2, CheckerSink checkerSink, ResolutionContext resolutionContext, boolean bl, boolean bl2, boolean bl3, int n, Object object) {
        if ((n & 0x100) != 0) {
            bl3 = false;
        }
        ArgumentsKt.resolvePlainArgumentType(candidate2, constraintSystemBuilder, firExpression2, coneKotlinType, coneKotlinType2, checkerSink, resolutionContext, bl, bl2, bl3);
    }

    /*
     * WARNING - void declaration
     */
    private static final ConeKotlinType argumentTypeWithSuspendConversion(FirSession session2, ScopeSession scopeSession, ConeKotlinType expectedType2, ConeKotlinType argumentType) {
        ConeLookupTagBasedType coneLookupTagBasedType;
        if (!InferenceUtilsKt.isSuspendFunctionType(expectedType2, session2)) {
            return null;
        }
        ConeClassLikeType expectedFunctionalType = InferenceUtilsKt.suspendFunctionTypeToFunctionType(expectedType2, session2);
        ConeKotlinType argumentTypeWithInvoke = InferenceUtilsKt.findSubtypeOfNonSuspendFunctionalType(argumentType, session2, expectedFunctionalType);
        ConeKotlinType coneKotlinType = argumentTypeWithInvoke;
        if (coneKotlinType == null) {
            coneLookupTagBasedType = null;
        } else {
            FirFunctionSymbol<?> firFunctionSymbol = InferenceUtilsKt.findContributedInvokeSymbol(coneKotlinType, session2, scopeSession, expectedFunctionalType, false);
            if (firFunctionSymbol == null) {
                coneLookupTagBasedType = null;
            } else {
                void $this$mapTo$iv$iv;
                FirFunctionSymbol<?> firFunctionSymbol2 = firFunctionSymbol;
                boolean bl = false;
                boolean bl2 = false;
                FirFunctionSymbol<?> invokeSymbol2 = firFunctionSymbol2;
                boolean bl3 = false;
                Iterable $this$map$iv = ((FirFunction)invokeSymbol2.getFir()).getValueParameters();
                boolean $i$f$map = false;
                Iterable iterable = $this$map$iv;
                Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
                boolean $i$f$mapTo = false;
                for (Object item$iv$iv : $this$mapTo$iv$iv) {
                    void it;
                    FirValueParameter firValueParameter = (FirValueParameter)item$iv$iv;
                    Collection collection = destination$iv$iv;
                    boolean bl4 = false;
                    ConeKotlinType coneKotlinType2 = FirTypeUtilsKt.getConeType(it.getReturnTypeRef());
                    collection.add(coneKotlinType2);
                }
                coneLookupTagBasedType = ResolveUtilsKt.createFunctionalType((List)destination$iv$iv, null, FirTypeUtilsKt.getConeType(((FirFunction)invokeSymbol2.getFir()).getReturnTypeRef()), true, InferenceUtilsKt.isKFunctionType(argumentType, session2));
            }
        }
        return coneLookupTagBasedType;
    }

    @NotNull
    public static final ConeKotlinType prepareCapturedType(@NotNull Candidate $this$prepareCapturedType, @NotNull ConeKotlinType argumentType, @NotNull ResolutionContext context2) {
        Intrinsics.checkNotNullParameter($this$prepareCapturedType, "<this>");
        Intrinsics.checkNotNullParameter(argumentType, "argumentType");
        Intrinsics.checkNotNullParameter(context2, "context");
        ConeKotlinType coneKotlinType = ArgumentsKt.captureTypeFromExpressionOrNull($this$prepareCapturedType, argumentType, context2);
        return coneKotlinType == null ? argumentType : coneKotlinType;
    }

    private static final ConeKotlinType captureTypeFromExpressionOrNull(Candidate $this$captureTypeFromExpressionOrNull, ConeKotlinType argumentType, ResolutionContext context2) {
        if (argumentType instanceof ConeFlexibleType) {
            return ArgumentsKt.captureTypeFromExpressionOrNull($this$captureTypeFromExpressionOrNull, ((ConeFlexibleType)argumentType).getLowerBound(), context2);
        }
        if (!(argumentType instanceof ConeClassLikeType)) {
            return null;
        }
        Object object = TypeExpansionUtilsKt.fullyExpandedType$default((ConeClassLikeType)argumentType, context2.getSession(), null, 2, null);
        boolean bl = false;
        boolean bl2 = false;
        ConeTypeProjection[] it = object;
        boolean bl3 = false;
        if (it != argumentType) {
            return ArgumentsKt.captureTypeFromExpressionOrNull($this$captureTypeFromExpressionOrNull, (ConeKotlinType)it, context2);
        }
        object = argumentType.getTypeArguments();
        bl = false;
        if (((ConeTypeProjection[])object).length == 0) {
            return null;
        }
        object = context2.getInferenceComponents().getCtx().captureFromArguments((SimpleTypeMarker)((Object)argumentType), CaptureStatus.FROM_EXPRESSION);
        return object instanceof ConeKotlinType ? (ConeKotlinType)object : null;
    }

    public static final boolean isArgumentTypeMismatchDueToNullability(@NotNull ConeKotlinType argumentType, @NotNull ConeKotlinType actualExpectedType, @NotNull ConeTypeContext typeContext2) {
        Intrinsics.checkNotNullParameter(argumentType, "argumentType");
        Intrinsics.checkNotNullParameter(actualExpectedType, "actualExpectedType");
        Intrinsics.checkNotNullParameter(typeContext2, "typeContext");
        return AbstractTypeChecker.isSubtypeOf$default(AbstractTypeChecker.INSTANCE, typeContext2, (KotlinTypeMarker)argumentType, (KotlinTypeMarker)TypeUtilsKt.withNullability$default(actualExpectedType, ConeNullability.NULLABLE, typeContext2, null, 4, null), false, 8, null);
    }

    private static final void checkApplicabilityForArgumentType(ConstraintSystemBuilder csBuilder, FirExpression argument2, ConeKotlinType argumentType, ConeKotlinType expectedType2, SimpleConstraintSystemConstraintPosition position, boolean isReceiver, boolean isDispatch, CheckerSink sink, ResolutionContext context2) {
        if (expectedType2 == null) {
            return;
        }
        if (isReceiver && isDispatch) {
            if (!ConeTypeUtilsKt.isNullable(expectedType2) && ConeTypeUtilsKt.isMarkedNullable(argumentType)) {
                sink.reportDiagnostic(new InapplicableWrongReceiver(expectedType2, argumentType));
            }
            return;
        }
        if (!ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, argumentType, expectedType2, position)) {
            ConeKotlinType unstableType;
            FirExpressionWithSmartcast smartcastExpression;
            FirExpressionWithSmartcast firExpressionWithSmartcast = smartcastExpression = argument2 instanceof FirExpressionWithSmartcast ? (FirExpressionWithSmartcast)argument2 : null;
            if (smartcastExpression != null && smartcastExpression.getSmartcastStability() != SmartcastStability.STABLE_VALUE && ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, unstableType = FirTypeUtilsKt.getConeType(smartcastExpression.getSmartcastType()), expectedType2, position)) {
                sink.reportDiagnostic(new UnstableSmartCast(smartcastExpression, expectedType2));
                return;
            }
            if (!isReceiver) {
                CheckerSinkKt.reportDiagnosticIfNotNull(sink, ArgumentsKt.checkApplicabilityForArgumentType$subtypeError(argument2, argumentType, context2, expectedType2));
                return;
            }
            ConeKotlinType nullableExpectedType = TypeUtilsKt.withNullability$default(expectedType2, ConeNullability.NULLABLE, SessionUtilsKt.getTypeContext(context2.getSession()), null, 4, null);
            if (ConstraintSystemBuilderKt.addSubtypeConstraintIfCompatible(csBuilder, argumentType, nullableExpectedType, position)) {
                sink.reportDiagnostic(new UnsafeCall(argumentType));
            } else {
                csBuilder.addSubtypeConstraint(argumentType, expectedType2, position);
                sink.reportDiagnostic(new InapplicableWrongReceiver(expectedType2, argumentType));
            }
        }
    }

    public static final void resolveArgument(@NotNull Candidate $this$resolveArgument, @NotNull CallInfo callInfo, @NotNull FirExpression argument2, @Nullable FirValueParameter parameter, boolean isReceiver, @NotNull CheckerSink sink, @NotNull ResolutionContext context2) {
        Intrinsics.checkNotNullParameter($this$resolveArgument, "<this>");
        Intrinsics.checkNotNullParameter(callInfo, "callInfo");
        Intrinsics.checkNotNullParameter(argument2, "argument");
        Intrinsics.checkNotNullParameter(sink, "sink");
        Intrinsics.checkNotNullParameter(context2, "context");
        FirExpression $this$resultType$iv = argument2;
        boolean $i$f$getResultType = false;
        PhaseUtilsKt.ensureResolvedTypeDeclaration$default($this$resultType$iv.getTypeRef(), context2.getSession(), null, 2, null);
        ConeKotlinType expectedType2 = ArgumentsKt.prepareExpectedType($this$resolveArgument, context2.getSession(), context2.getBodyResolveComponents().getScopeSession(), callInfo, argument2, parameter, context2);
        FirValueParameter firValueParameter = parameter;
        ArgumentsKt.resolveArgumentExpression($this$resolveArgument, $this$resolveArgument.getSystem().getBuilder(), argument2, expectedType2, firValueParameter == null ? null : firValueParameter.getReturnTypeRef(), sink, context2, isReceiver, false);
    }

    private static final ConeKotlinType prepareExpectedType(Candidate $this$prepareExpectedType, FirSession session2, ScopeSession scopeSession, CallInfo callInfo, FirExpression argument2, FirValueParameter parameter, ResolutionContext context2) {
        ConeKotlinType coneKotlinType;
        if (parameter == null) {
            return null;
        }
        ConeKotlinType basicExpectedType = ArgumentsKt.getExpectedTypeForSAMConversion(argument2, parameter);
        ConeKotlinType coneKotlinType2 = ArgumentsKt.getExpectedTypeWithSAMConversion($this$prepareExpectedType, session2, scopeSession, argument2, basicExpectedType, context2);
        if (coneKotlinType2 == null) {
            coneKotlinType = basicExpectedType;
        } else {
            ConeKotlinType coneKotlinType3;
            ConeKotlinType coneKotlinType4 = coneKotlinType2;
            boolean bl = false;
            boolean bl2 = false;
            ConeKotlinType it = coneKotlinType4;
            boolean bl3 = false;
            FirLookupTrackerComponent firLookupTrackerComponent = FirLookupTrackerComponentKt.getLookupTracker(session2);
            if (firLookupTrackerComponent != null) {
                FirLookupTrackerComponent firLookupTrackerComponent2 = firLookupTrackerComponent;
                boolean bl4 = false;
                boolean bl5 = false;
                FirLookupTrackerComponent lookupTracker = firLookupTrackerComponent2;
                boolean bl6 = false;
                ClassId classId = ConeTypeUtilsKt.getClassId(ConeTypesKt.lowerBoundIfFlexible(FirTypeUtilsKt.getConeType(parameter.getReturnTypeRef())));
                if (classId != null) {
                    ClassId classId2;
                    ClassId classId3 = classId;
                    boolean bl7 = false;
                    boolean bl8 = false;
                    ClassId it2 = classId3;
                    boolean bl9 = false;
                    ClassId classId4 = classId2 = !it2.isLocal() ? classId3 : null;
                    if (classId2 != null) {
                        classId3 = classId2;
                        bl7 = false;
                        bl8 = false;
                        ClassId classId5 = classId3;
                        boolean bl10 = false;
                        Name name = ArgumentsKt.getSAM_LOOKUP_NAME();
                        Object object = classId5.asString();
                        Intrinsics.checkNotNullExpressionValue(object, "classId.asString()");
                        lookupTracker.recordLookup(name, (String)object, callInfo.getCallSite().getSource(), callInfo.getContainingFile().getSource());
                        object = classId5.getShortClassName();
                        Intrinsics.checkNotNullExpressionValue(object, "classId.shortClassName");
                        Object object2 = object;
                        object = classId5.getPackageFqName().asString();
                        Intrinsics.checkNotNullExpressionValue(object, "classId.packageFqName.asString()");
                        lookupTracker.recordLookup((Name)object2, (String)object, callInfo.getCallSite().getSource(), callInfo.getContainingFile().getSource());
                    }
                }
            }
            coneKotlinType = coneKotlinType3 = coneKotlinType4;
        }
        ConeKotlinType expectedType2 = coneKotlinType;
        return $this$prepareExpectedType.getSubstitutor().substituteOrSelf(expectedType2);
    }

    private static final ConeKotlinType getExpectedTypeWithSAMConversion(Candidate $this$getExpectedTypeWithSAMConversion, FirSession session2, ScopeSession scopeSession, FirExpression argument2, ConeKotlinType candidateExpectedType, ResolutionContext context2) {
        ConeKotlinType coneKotlinType;
        FirFunction firFunction;
        if (InferenceUtilsKt.isBuiltinFunctionalType(candidateExpectedType, session2)) {
            return null;
        }
        Object obj = $this$getExpectedTypeWithSAMConversion.getSymbol().getFir();
        FirFunction firFunction2 = firFunction = obj instanceof FirFunction ? (FirFunction)obj : null;
        if (firFunction == null) {
            return null;
        }
        FirFunction firFunction3 = firFunction;
        if (!context2.getBodyResolveComponents().getSamResolver().shouldRunSamConversionForFunction(firFunction3)) {
            return null;
        }
        ConeKotlinType expectedFunctionType = context2.getBodyResolveComponents().getSamResolver().getFunctionTypeForPossibleSamType(candidateExpectedType);
        boolean condition$iv = ArgumentsKt.isFunctional(argument2, session2, scopeSession, expectedFunctionType);
        boolean $i$f$runIf = false;
        if (condition$iv) {
            boolean bl = false;
            ConeKotlinType coneKotlinType2 = expectedFunctionType;
            boolean bl2 = false;
            boolean bl3 = false;
            ConeKotlinType $this$getExpectedTypeWithSAMConversion_u24lambda_u2d9_u24lambda_u2d8 = coneKotlinType2;
            boolean bl4 = false;
            $this$getExpectedTypeWithSAMConversion.setUsesSAM(true);
            coneKotlinType = coneKotlinType2;
        } else {
            coneKotlinType = null;
        }
        return coneKotlinType;
    }

    public static final boolean isFunctional(@NotNull FirExpression $this$isFunctional, @NotNull FirSession session2, @NotNull ScopeSession scopeSession, @Nullable ConeKotlinType expectedFunctionType) {
        boolean bl;
        block11: {
            boolean returnTypeCompatible;
            ConeClassLikeType classLikeExpectedFunctionType;
            ConeKotlinType coneKotlinType;
            Intrinsics.checkNotNullParameter($this$isFunctional, "<this>");
            Intrinsics.checkNotNullParameter(session2, "session");
            Intrinsics.checkNotNullParameter(scopeSession, "scopeSession");
            FirExpression firExpression2 = FirExpressionUtilKt.unwrapArgument($this$isFunctional);
            if (firExpression2 instanceof FirAnonymousFunction ? true : firExpression2 instanceof FirCallableReferenceAccess) {
                return true;
            }
            Object $this$coneTypeSafe$iv = $this$isFunctional.getTypeRef();
            boolean $i$f$coneTypeSafe22 = false;
            boolean bl2 = false;
            FirResolvedTypeRef firResolvedTypeRef = $this$coneTypeSafe$iv instanceof FirResolvedTypeRef ? (FirResolvedTypeRef)$this$coneTypeSafe$iv : null;
            ConeKotlinType coneKotlinType2 = firResolvedTypeRef == null ? null : firResolvedTypeRef.getType();
            if (!(coneKotlinType2 instanceof ConeKotlinType)) {
                coneKotlinType2 = null;
            }
            if ((coneKotlinType = coneKotlinType2) == null) {
                return false;
            }
            ConeKotlinType coneType = coneKotlinType;
            if (InferenceUtilsKt.isBuiltinFunctionalType(coneType, session2)) {
                return true;
            }
            FirFunctionSymbol<?> $i$f$coneTypeSafe22 = expectedFunctionType;
            $this$coneTypeSafe$iv = $i$f$coneTypeSafe22 == null ? null : ConeTypesKt.lowerBoundIfFlexible((ConeKotlinType)((Object)$i$f$coneTypeSafe22));
            ConeClassLikeType coneClassLikeType = classLikeExpectedFunctionType = $this$coneTypeSafe$iv instanceof ConeClassLikeType ? (ConeClassLikeType)$this$coneTypeSafe$iv : null;
            if (classLikeExpectedFunctionType == null || coneType instanceof ConeIntegerLiteralType) {
                return false;
            }
            $i$f$coneTypeSafe22 = InferenceUtilsKt.findContributedInvokeSymbol(coneType, session2, scopeSession, classLikeExpectedFunctionType, false);
            if ($i$f$coneTypeSafe22 == null) {
                return false;
            }
            FirFunctionSymbol<?> invokeSymbol2 = $i$f$coneTypeSafe22;
            ConeKotlinType expectedReturnType = ConeTypesKt.lowerBoundIfFlexible(InferenceUtilsKt.returnType(classLikeExpectedFunctionType, session2));
            boolean bl3 = returnTypeCompatible = expectedReturnType instanceof ConeTypeParameterType || AbstractTypeChecker.INSTANCE.isSubtypeOf(InferenceComponentsKt.getInferenceComponents(session2).getCtx().newBaseTypeCheckerContext(false, true), (KotlinTypeMarker)FirTypeUtilsKt.getConeType(((FirFunction)invokeSymbol2.getFir()).getReturnTypeRef()), (KotlinTypeMarker)expectedReturnType, false);
            if (!returnTypeCompatible) {
                return false;
            }
            if (((FirFunction)invokeSymbol2.getFir()).getValueParameters().size() != classLikeExpectedFunctionType.getTypeArguments().length - 1) {
                return false;
            }
            List parameterPairs = CollectionsKt.zip((Iterable)((FirFunction)invokeSymbol2.getFir()).getValueParameters(), (Iterable)InferenceUtilsKt.valueParameterTypesIncludingReceiver(classLikeExpectedFunctionType, session2));
            Iterable $this$all$iv = parameterPairs;
            boolean $i$f$all = false;
            if ($this$all$iv instanceof Collection && ((Collection)$this$all$iv).isEmpty()) {
                bl = true;
            } else {
                for (Object element$iv : $this$all$iv) {
                    Pair $dstr$invokeParameter$expectedParameter = (Pair)element$iv;
                    boolean bl4 = false;
                    FirValueParameter invokeParameter = (FirValueParameter)$dstr$invokeParameter$expectedParameter.component1();
                    ConeKotlinType expectedParameter = (ConeKotlinType)$dstr$invokeParameter$expectedParameter.component2();
                    ConeKotlinType expectedParameterType = ConeTypesKt.lowerBoundIfFlexible(expectedParameter);
                    if (expectedParameterType instanceof ConeTypeParameterType || AbstractTypeChecker.INSTANCE.isSubtypeOf(InferenceComponentsKt.getInferenceComponents(session2).getCtx().newBaseTypeCheckerContext(false, true), (KotlinTypeMarker)FirTypeUtilsKt.getConeType(invokeParameter.getReturnTypeRef()), (KotlinTypeMarker)expectedParameterType, false)) continue;
                    bl = false;
                    break block11;
                }
                bl = true;
            }
        }
        return bl;
    }

    @NotNull
    public static final ConeKotlinType getExpectedTypeForSAMConversion(@NotNull FirExpression $this$getExpectedTypeForSAMConversion, @NotNull FirValueParameter parameter) {
        Intrinsics.checkNotNullParameter($this$getExpectedTypeForSAMConversion, "<this>");
        Intrinsics.checkNotNullParameter(parameter, "parameter");
        FirExpression firExpression2 = $this$getExpectedTypeForSAMConversion;
        boolean shouldUnwrapVarargType = firExpression2 instanceof FirSpreadArgumentExpression ? !((FirSpreadArgumentExpression)$this$getExpectedTypeForSAMConversion).isSpread() : (firExpression2 instanceof FirNamedArgumentExpression ? ((FirNamedArgumentExpression)$this$getExpectedTypeForSAMConversion).getExpression() instanceof FirConstExpression : true);
        return parameter.isVararg() && shouldUnwrapVarargType ? ArgumentsKt.varargElementType(FirTypeUtilsKt.getConeType(parameter.getReturnTypeRef())) : FirTypeUtilsKt.getConeType(parameter.getReturnTypeRef());
    }

    @NotNull
    public static final ConeKotlinType varargElementType(@NotNull ConeKotlinType $this$varargElementType) {
        Intrinsics.checkNotNullParameter($this$varargElementType, "<this>");
        ConeKotlinType coneKotlinType = ArrayUtilsKt.arrayElementType($this$varargElementType);
        return coneKotlinType == null ? $this$varargElementType : coneKotlinType;
    }

    /*
     * WARNING - void declaration
     */
    @NotNull
    public static final ConeKotlinType captureFromTypeParameterUpperBoundIfNeeded(@NotNull ConeKotlinType argumentType, @NotNull ConeKotlinType expectedType2, @NotNull FirSession session2) {
        Object v1;
        ConeInferenceContext context2;
        block7: {
            void $this$singleOrNull$iv;
            void $this$mapTo$iv$iv;
            ConeTypeParameterType coneTypeParameterType;
            Intrinsics.checkNotNullParameter(argumentType, "argumentType");
            Intrinsics.checkNotNullParameter(expectedType2, "expectedType");
            Intrinsics.checkNotNullParameter(session2, "session");
            ClassId classId = ConeTypeUtilsKt.getClassId(ConeTypesKt.upperBoundIfFlexible(expectedType2));
            if (classId == null) {
                return argumentType;
            }
            ClassId expectedTypeClassId = classId;
            ConeKotlinType coneKotlinType = ConeTypesKt.lowerBoundIfFlexible(argumentType);
            ConeTypeParameterType coneTypeParameterType2 = coneTypeParameterType = coneKotlinType instanceof ConeTypeParameterType ? (ConeTypeParameterType)coneKotlinType : null;
            if (coneTypeParameterType == null) {
                return argumentType;
            }
            ConeTypeParameterType simplifiedArgumentType = coneTypeParameterType;
            FirTypeParameter typeParameter = (FirTypeParameter)simplifiedArgumentType.getLookupTag().getTypeParameterSymbol().getFir();
            context2 = SessionUtilsKt.getTypeContext(session2);
            Iterable $this$map$iv = typeParameter.getBounds();
            boolean $i$f$map = false;
            Iterable iterable = $this$map$iv;
            Collection destination$iv$iv = new ArrayList(CollectionsKt.collectionSizeOrDefault($this$map$iv, 10));
            boolean $i$f$mapTo = false;
            for (Object item$iv$iv : $this$mapTo$iv$iv) {
                void it;
                FirTypeRef firTypeRef = (FirTypeRef)item$iv$iv;
                Collection collection = destination$iv$iv;
                boolean bl = false;
                ConeKotlinType coneKotlinType2 = FirTypeUtilsKt.getConeType((FirTypeRef)it);
                collection.add(coneKotlinType2);
            }
            $this$map$iv = (List)destination$iv$iv;
            boolean $i$f$singleOrNull = false;
            Object single$iv = null;
            boolean found$iv = false;
            for (Object element$iv : $this$singleOrNull$iv) {
                ConeKotlinType it = (ConeKotlinType)element$iv;
                boolean bl = false;
                if (!ArgumentsKt.hasSupertypeWithGivenClassId(it, expectedTypeClassId, context2)) continue;
                if (found$iv) {
                    v1 = null;
                    break block7;
                }
                single$iv = element$iv;
                found$iv = true;
            }
            v1 = !found$iv ? null : single$iv;
        }
        ConeKotlinType coneKotlinType = v1;
        if (coneKotlinType == null) {
            return argumentType;
        }
        ConeKotlinType chosenSupertype = coneKotlinType;
        ConeKotlinType coneKotlinType3 = (ConeKotlinType)context2.captureFromExpression(chosenSupertype);
        if (coneKotlinType3 == null) {
            return argumentType;
        }
        ConeKotlinType capturedType = coneKotlinType3;
        return argumentType instanceof ConeDefinitelyNotNullType ? ((coneKotlinType3 = TypeUtilsKt.create$default(ConeDefinitelyNotNullType.Companion, capturedType, SessionUtilsKt.getTypeContext(session2), false, 4, null)) == null ? capturedType : coneKotlinType3) : capturedType;
    }

    private static final boolean hasSupertypeWithGivenClassId(ConeKotlinType $this$hasSupertypeWithGivenClassId, ClassId classId, TypeSystemCommonSuperTypesContext context2) {
        boolean bl = false;
        boolean bl2 = false;
        TypeSystemCommonSuperTypesContext $this$hasSupertypeWithGivenClassId_u24lambda_u2d13 = context2;
        boolean bl3 = false;
        return $this$hasSupertypeWithGivenClassId_u24lambda_u2d13.anySuperTypeConstructor($this$hasSupertypeWithGivenClassId, (Function1<? super TypeConstructorMarker, Boolean>)new Function1<TypeConstructorMarker, Boolean>(classId){
            final /* synthetic */ ClassId $classId;
            {
                this.$classId = $classId;
                super(1);
            }

            @NotNull
            public final Boolean invoke(@NotNull TypeConstructorMarker it) {
                Intrinsics.checkNotNullParameter(it, "it");
                return it instanceof ConeClassLikeLookupTag && Intrinsics.areEqual(((ConeClassLikeLookupTag)it).getClassId(), this.$classId);
            }
        });
    }

    private static final ConeKotlinType checkApplicabilityForArgumentType$subtypeError$tryGetConeTypeThatCompatibleWithKtType(ConeKotlinType type2) {
        if (type2 instanceof ConeTypeVariableType) {
            ConeTypeParameterLookupTag originalTypeParameter;
            ConeClassifierLookupTag coneClassifierLookupTag = ((ConeTypeVariableType)type2).getLookupTag();
            ConeTypeVariableTypeConstructor coneTypeVariableTypeConstructor = coneClassifierLookupTag instanceof ConeTypeVariableTypeConstructor ? (ConeTypeVariableTypeConstructor)coneClassifierLookupTag : null;
            TypeParameterMarker typeParameterMarker = coneTypeVariableTypeConstructor == null ? null : coneTypeVariableTypeConstructor.getOriginalTypeParameter();
            ConeTypeParameterLookupTag coneTypeParameterLookupTag = originalTypeParameter = typeParameterMarker instanceof ConeTypeParameterLookupTag ? (ConeTypeParameterLookupTag)typeParameterMarker : null;
            if (originalTypeParameter != null) {
                return new ConeTypeParameterTypeImpl(originalTypeParameter, ConeTypeUtilsKt.isNullable(type2), type2.getAttributes());
            }
        } else if (type2 instanceof ConeIntegerLiteralType) {
            ConeClassLikeType coneClassLikeType = (ConeClassLikeType)CollectionsKt.firstOrNull((Iterable)((ConeIntegerLiteralType)type2).getPossibleTypes());
            return coneClassLikeType == null ? type2 : (ConeKotlinType)coneClassLikeType;
        }
        return type2;
    }

    private static final ResolutionDiagnostic checkApplicabilityForArgumentType$subtypeError(FirExpression $argument, ConeKotlinType $argumentType, ResolutionContext $context, ConeKotlinType actualExpectedType) {
        if (FirTypeUtilsKt.isNullLiteral($argument) && actualExpectedType.getNullability() == ConeNullability.NOT_NULL) {
            return new NullForNotNullType($argument);
        }
        return new ArgumentTypeMismatch(ArgumentsKt.checkApplicabilityForArgumentType$subtypeError$tryGetConeTypeThatCompatibleWithKtType(actualExpectedType), ArgumentsKt.checkApplicabilityForArgumentType$subtypeError$tryGetConeTypeThatCompatibleWithKtType($argumentType), $argument, ArgumentsKt.isArgumentTypeMismatchDueToNullability($argumentType, actualExpectedType, SessionUtilsKt.getTypeContext($context.getSession())));
    }

    static {
        Name name = Name.special("<SAM-CONSTRUCTOR>");
        Intrinsics.checkNotNullExpressionValue(name, "special(\"<SAM-CONSTRUCTOR>\")");
        SAM_LOOKUP_NAME = name;
    }
}

