"use strict";
var __createBinding = (this && this.__createBinding) || (Object.create ? (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    Object.defineProperty(o, k2, { enumerable: true, get: function() { return m[k]; } });
}) : (function(o, m, k, k2) {
    if (k2 === undefined) k2 = k;
    o[k2] = m[k];
}));
var __setModuleDefault = (this && this.__setModuleDefault) || (Object.create ? (function(o, v) {
    Object.defineProperty(o, "default", { enumerable: true, value: v });
}) : function(o, v) {
    o["default"] = v;
});
var __importStar = (this && this.__importStar) || function (mod) {
    if (mod && mod.__esModule) return mod;
    var result = {};
    if (mod != null) for (var k in mod) if (k !== "default" && Object.prototype.hasOwnProperty.call(mod, k)) __createBinding(result, mod, k);
    __setModuleDefault(result, mod);
    return result;
};
var __importDefault = (this && this.__importDefault) || function (mod) {
    return (mod && mod.__esModule) ? mod : { "default": mod };
};
Object.defineProperty(exports, "__esModule", { value: true });
exports.ProvisionRequest = void 0;
const logging_1 = __importStar(require("../logging"));
const crypto_1 = __importDefault(require("crypto"));
const rootLogger = (0, logging_1.default)("ProvisionRequest");
class ProvisionRequest {
    constructor(req, fnName) {
        this.req = req;
        this.id = crypto_1.default.randomBytes(4).toString('hex');
        this.log = (0, logging_1.newRequestLogger)(rootLogger, `${this.id} ${fnName}`, false);
    }
    get body() {
        return this.req.body;
    }
    get params() {
        return this.req.params;
    }
    static createFake(fnName, log, body = {}) {
        // This is a DANGEROUS operation, used to create a fake request object
        // to make internal requests to the provisioner.
        const r = new ProvisionRequest({
            body,
            params: {},
        }, fnName);
        r.log = log;
        return r;
    }
}
exports.ProvisionRequest = ProvisionRequest;
//# sourceMappingURL=ProvisionRequest.js.map