const BaseCommand = require('../base-command.js')

class Get extends BaseCommand {
  /* istanbul ignore next - see test/lib/load-all-commands.js */
  static get description () {
    return 'Get a value from the npm configuration'
  }

  /* istanbul ignore next - see test/lib/load-all-commands.js */
  static get name () {
    return 'get'
  }

  /* istanbul ignore next - see test/lib/load-all-commands.js */
  static get usage () {
    return ['[<key> ...] (See `npm config`)']
  }

  /* istanbul ignore next - see test/lib/load-all-commands.js */
  async completion (opts) {
    const config = await this.npm.cmd('config')
    return config.completion(opts)
  }

  async exec (args) {
    return this.npm.exec('config', ['get'].concat(args))
  }
}
module.exports = Get
