/*
 * Decompiled with CFR 0.152.
 */
package net.osmand.plus.helpers;

import java.io.File;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.osmand.plus.GPXUtilities;
import net.osmand.plus.OsmAndFormatter;
import net.osmand.util.Algorithms;
import net.sourceforge.offroad.OsmWindow;
import net.sourceforge.offroad.R;

public class GpxUiHelper {
    public static String getDescription(OsmWindow app, GPXUtilities.GPXFile result, File f, boolean html) {
        GPXUtilities.GPXTrackAnalysis analysis = result.getAnalysis(f == null ? 0L : f.lastModified());
        return GpxUiHelper.getDescription(app, analysis, html);
    }

    public static String getDescription(OsmWindow app, GPXUtilities.TrkSegment t, boolean html) {
        return GpxUiHelper.getDescription(app, GPXUtilities.GPXTrackAnalysis.segment(0L, t), html);
    }

    public static String getColorValue(String clr, String value, boolean html) {
        if (!html) {
            return value;
        }
        return "<font color=\"" + clr + "\">" + value + "</font>";
    }

    public static String getColorValue(String clr, String value) {
        return GpxUiHelper.getColorValue(clr, value, true);
    }

    public static String getDescription(OsmWindow app, GPXUtilities.GPXTrackAnalysis analysis, boolean html) {
        String max;
        String formatDuration;
        StringBuilder description = new StringBuilder();
        String nl = html ? "<br/>" : "\n";
        String timeSpanClr = Algorithms.colorToString(app.getResources().getColor(R.color.gpx_time_span_color));
        String distanceClr = Algorithms.colorToString(app.getResources().getColor(R.color.gpx_distance_color));
        String speedClr = Algorithms.colorToString(app.getResources().getColor(R.color.gpx_speed));
        String ascClr = Algorithms.colorToString(app.getResources().getColor(R.color.gpx_altitude_asc));
        String descClr = Algorithms.colorToString(app.getResources().getColor(R.color.gpx_altitude_desc));
        description.append(app.getString(1490, GpxUiHelper.getColorValue(distanceClr, OsmAndFormatter.getFormattedDistance(analysis.totalDistance, app), html), GpxUiHelper.getColorValue(distanceClr, analysis.points + "", html)));
        if (analysis.totalTracks > 1) {
            description.append(nl).append(app.getString(1509, GpxUiHelper.getColorValue(speedClr, analysis.totalTracks + "", html)));
        }
        if (analysis.wptPoints > 0) {
            description.append(nl).append(app.getString(1489, GpxUiHelper.getColorValue(speedClr, analysis.wptPoints + "", html)));
        }
        if (analysis.isTimeSpecified()) {
            description.append(nl).append(app.getString(1491, analysis.startTime));
            description.append(nl).append(app.getString(1492, analysis.endTime));
        }
        if (analysis.timeSpan > 0L && analysis.timeSpan / 1000L != analysis.timeMoving / 1000L) {
            formatDuration = Algorithms.formatDuration((int)(analysis.timeSpan / 1000L));
            description.append(nl).append(app.getString(1498, GpxUiHelper.getColorValue(timeSpanClr, formatDuration, html)));
        }
        if (analysis.isTimeMoving()) {
            formatDuration = Algorithms.formatDuration((int)(analysis.timeMoving / 1000L));
            description.append(nl).append(app.getString(1499, GpxUiHelper.getColorValue(timeSpanClr, formatDuration, html)));
        }
        if (analysis.isElevationSpecified()) {
            description.append(nl);
            description.append(app.getString(1495, GpxUiHelper.getColorValue(speedClr, OsmAndFormatter.getFormattedAlt(analysis.avgElevation, app), html)));
            description.append(nl);
            String min = GpxUiHelper.getColorValue(descClr, OsmAndFormatter.getFormattedAlt(analysis.minElevation, app), html);
            max = GpxUiHelper.getColorValue(ascClr, OsmAndFormatter.getFormattedAlt(analysis.maxElevation, app), html);
            String asc = GpxUiHelper.getColorValue(ascClr, OsmAndFormatter.getFormattedAlt(analysis.diffElevationUp, app), html);
            String desc = GpxUiHelper.getColorValue(descClr, OsmAndFormatter.getFormattedAlt(analysis.diffElevationDown, app), html);
            description.append(app.getString(1496, min + " - " + max));
            description.append(nl);
            description.append(app.getString(1497, "\u2193 " + desc + "   \u2191 " + asc + ""));
        }
        if (analysis.isSpeedSpecified()) {
            String avg = GpxUiHelper.getColorValue(speedClr, OsmAndFormatter.getFormattedSpeed(analysis.avgSpeed, app), html);
            max = GpxUiHelper.getColorValue(ascClr, OsmAndFormatter.getFormattedSpeed(analysis.maxSpeed, app), html);
            description.append(nl).append(app.getString(1493, avg));
            description.append(nl).append(app.getString(1494, max));
        }
        return description.toString();
    }

    public static List<String> getSortedGPXFilenamesByDate(File dir, boolean absolutePath) {
        final HashMap<String, Long> mp = new HashMap<String, Long>();
        GpxUiHelper.readGpxDirectory(dir, mp, "", absolutePath);
        ArrayList<String> list = new ArrayList<String>(mp.keySet());
        Collections.sort(list, new Comparator<String>(){

            @Override
            public int compare(String object1, String object2) {
                long rhs;
                Long l1 = (Long)mp.get(object1);
                Long l2 = (Long)mp.get(object2);
                long lhs = l1 == null ? 0L : l1;
                long l = rhs = l2 == null ? 0L : l2;
                return lhs < rhs ? 1 : (lhs == rhs ? 0 : -1);
            }
        });
        return list;
    }

    public static List<String> getSortedGPXFilenames(File dir, boolean absolutePath) {
        HashMap<String, Long> mp = new HashMap<String, Long>();
        GpxUiHelper.readGpxDirectory(dir, mp, "", absolutePath);
        ArrayList<String> list = new ArrayList<String>(mp.keySet());
        Collections.sort(list, new Comparator<String>(){

            @Override
            public int compare(String object1, String object2) {
                return -object1.compareTo(object2);
            }
        });
        return list;
    }

    private static void readGpxDirectory(File dir, Map<String, Long> map, String parent, boolean absolutePath) {
        File[] files;
        if (dir != null && dir.canRead() && (files = dir.listFiles()) != null) {
            for (File f : files) {
                if (f.getName().toLowerCase().endsWith(".gpx")) {
                    map.put(absolutePath ? f.getAbsolutePath() : parent + f.getName(), f.lastModified());
                    continue;
                }
                if (!f.isDirectory()) continue;
                GpxUiHelper.readGpxDirectory(f, map, parent + f.getName() + File.separator, absolutePath);
            }
        }
    }
}

