CSS: style.css
Use numbered headers: true
HTML use syntax: true
LaTeX use listings: true
LaTeX CJK: false
LaTeX preamble: preamble.tex

![MaRuKu](logo.png){#logo}


Mar**u**k**u**: a Markdown-superset interpreter 
===============================================

[Maruku] is a Markdown interpreter written in [Ruby].

> [Last release](#release_notes) is version 0.5.6 -- 2007-05-22.
>
> Install using [rubygems]: 
>
> 	$ gem install maruku
>
> Use this command to update to latest version:
>
> 	$ gem update maruku
>
{#news}

[rubygems]: http://rubygems.org

* * *


Maruku allows you to write in an easy-to-read-and-write syntax, like this:

> [This document in Markdown][this_md] 

Then it can be translated to HTML:

> [This document in HTML][this_html]
	
or LaTeX, which is then converted to PDF:

> [This document in PDF][this_pdf]

Maruku implements:

* the original [Markdown syntax][markdown_html] 
  ([HTML][markdown_html] or [PDF][markdown_pdf]), translated by Maruku).

* all the improvements in [PHP Markdown Extra]. 

* a new [meta-data syntax][meta_data_proposal]


__Authors__: Maruku has been developed so far by [Andrea Censi].
Contributors are most welcome!

__The name of the game__: Maruku is the [romaji] transliteration of 
the [katakana] transliteration
of "Mark", the first word in Markdown. I chose this name because Ruby 
is Japanese, and also the sillable "ru" appears in Maruku.


[romaji]: http://en.wikipedia.org/wiki/Romaji
[katakana]: http://en.wikipedia.org/wiki/Katakana

[tests]: http://maruku.rubyforge.org/tests/
[maruku]: http://maruku.rubyforge.org/
[markdown_html]: http://maruku.rubyforge.org/markdown_syntax.html
[markdown_pdf]: http://maruku.rubyforge.org/markdown_syntax.pdf
[this_md]: http://maruku.rubyforge.org/maruku.md
[this_html]: http://maruku.rubyforge.org/maruku.html
[this_pdf]: http://maruku.rubyforge.org/maruku.pdf
[Andrea Censi]: http://www.dis.uniroma1.it/~acensi/

[contact]: http://www.dis.uniroma1.it/~acensi/contact.html
[gem]: http://rubygems.rubyforge.org/
[tracker]: http://rubyforge.org/tracker/?group_id=2795


[ruby]: http://www.ruby-lang.org
[bluecloth]: http://www.deveiate.org/projects/BlueCloth
[Markdown syntax]: http://daringfireball.net/projects/markdown/syntax
[PHP Markdown Extra]: http://www.michelf.com/projects/php-markdown/extra/
[math syntax]: http://maruku.rubyforge.org/math.xhtml
[blahtex]: http://www.blahtex.org
[ritex]: http://ritex.rubyforge.org
[itex2mml]: http://golem.ph.utexas.edu/~distler/code/itexToMML/
[syntax]: http://syntax.rubyforge.org/

[listings]: http://www.ctan.org/tex-archive/macros/latex/contrib/listings/
[meta_data_proposal]: http://maruku.rubyforge.org/proposal.html
[markdown-discuss]: http://six.pairlist.net/mailman/listinfo/markdown-discuss

* * *

Table of contents: (**auto-generated by Maruku!**)

* This list will contain the toc (it doesn't matter what you write here)
{:toc}

* * *

{:ruby:     lang=ruby code_background_color='#efffef'}
{:shell:    lang=sh code_background_color='#efefff'}
{:markdown: code_background_color='#ffefef'}
{:html:     lang=xml}


Release notes  {#release_notes}
--------------

Note: Maruku seems to be very robust, nevertheless it is still beta-level
software. So if you want to use it in production environments, please 
check back in a month or so, while we squash the remaining bugs.

In the meantime, feel free to toy around, and please signal problems,
request features, by [contacting me][contact] or using the [tracker][tracker]. 
For issues about the Markdown syntax itself and improvements to it, 
please write to the [Markdown-discuss mailing list][markdown-discuss].

Have fun!

See the [changelog](http://maruku.rubyforge.org/changelog.html#stable).


Usage
--------

### Embedded Maruku ###

This is the basic usage:

	require 'rubygems'
	require 'maruku'

	doc = Maruku.new(markdown_string)
	puts doc.to_html
{:ruby}

The method `to_html` outputs only an HTML fragment, while the method `to_html_document` outputs a complete XHTML 1.0 document:

	puts doc.to_html_document
{:ruby}
	
You can have the REXML document tree with:

	tree = doc.to_html_document_tree
{:ruby}

### From the command line ###

There is one command-line program installed: `maruku`.

Without arguments, it converts  Markdown to HTML:

	$ maruku file.md  # creates file.html
{:shell}

With the `--pdf` arguments, it converts Markdown to LaTeX, then calls `pdflatex` to 
transform to PDF:

	$ maruku --pdf file.md  # creates file.tex and file.pdf
{:shell}



Maruku summary of features                {#features}
--------------------------

*	Supported syntax
	
	*	[Basic Markdown][markdown_syntax]
	*	[Markdown Extra](#extra)
	*	[Meta-data syntax](#meta)
	
*	Output
		
	*	XHTML
	
		*	Syntax highlighting via the [`syntax`][syntax] library.
	
	*	LaTeX

		*	[Translation of HTML entities to LaTeX](#entities)
		*	Syntax highlighting via the [`listings`][listings] package.

*	Misc

	*	[Documentation for supported attributes][supported_attributes]
	
	*	[Automatic generation of the TOC](#toc-generation)


[supported_attributes]: exd.html

**Experimental features (not released yet)**

*	[LaTeX Math syntax][math_syntax] (not enabled by default)
*	An extension system for adding new syntax is available, 
	but the API is bound to change in the future, 
	so please don't use it.
*	LaTeX to MathML using either one of [`ritex`][ritex], [`itex2mml`][itex2mml], 
	[`blahtex`][blahtex].
*	LaTeX to PNG using [`blahtex`][blahtex].

### New meta-data syntax {#meta}

Maruku implements a syntax that allows to attach "meta" information
to objects.

See [this proposal][meta_data_proposal] for how to attach
metadata to the elements.

See the [documentation for supported attributes][supported_attributes].

Meta-data for the document itself is specified through the use
of email headers:

	Title: A simple document containing meta-headers
	CSS: style.css
	
	Content of the document
{:markdown}

When creating the document through 

	Maruku.new(s).to_html_document
{:ruby}

the title and stylesheet are added as expected.

Meta-data keys are assumed to be case-insensitive.


### Automatic generation of the table of contents ###    {#toc-generation}

If you create a list, and then set the `toc` attribute, when rendering
Maruku will create an auto-generated table of contents.

	* This will become a table of contents (this text will be scraped).
	{:toc}

You can see an example of this at the beginning of this document.

### Use HTML entities ### {#entities}

If you want to use HTML entities, go on! We will take care
of the translation to LaTeX:

Entity      | Result
------------|----------
`&copy;`    |  &copy;
`&pound;`   |  &pound;
`&lambda;`  |  &lambda;
`&mdash;`   |  &mdash;

See the [list of supported entities][ent_html] ([pdf][ent_pdf]).

[ent_html]: http://maruku.rubyforge.org/entity_test.html
[ent_pdf]: http://maruku.rubyforge.org/entity_test.pdf


### This header contains *emphasis* **strong text** and `code` ####

Note that this header contains formatting and it still works, also in the table of contents.

And [This is a *link* with **all** ***sort*** of `weird stuff`](#features) in the text.


Examples of PHP Markdown Extra syntax {#extra}
-------------------------------------

*	tables

		Col1 | Very very long head | Very very long head|
		-----|:-------------------:|-------------------:|
		cell | center-align        | right-align        |
	{:markdown}

	Col1 | Very very long head | Very very long head|
	-----|:-------------------:|-------------------:|
	cell | center-align        | right-align        |


*	footnotes [^foot]

		* footnotes [^foot]
	
		[^foot]: I really was missing those.
	{:markdown}

[^foot]: I really was missing those.

*	Markdown inside HTML elements

		<div markdown="1" style="border: solid 1px black">
		   This is a div with Markdown **strong text**
		</div>
	{:html}

	<div markdown="1" style="border: solid 1px black">
	   This is a div with Markdown **strong text**
	</div>


*	header ids

		## Download ##     {#download}
	{:markdown}

	For example, [a link to the download](#download) header.


*	definition lists

		Definition list
		: something very hard to parse
	{:markdown}

	Definition list
	: something very hard to parse

*	abbreviations or ABB for short.

*[ABB]: Simply an abbreviation


<script src="http://www.google-analytics.com/urchin.js" type="text/javascript">
</script>
<script type="text/javascript">
_uacct = "UA-155626-2";
urchinTracker();
</script>

<!--
Future developments                              {#future}

I think that [Pandoc] and [MultiMarkdown] are very cool projects.
However, they are written in Haskell and Perl, respectively. 
I would love to have an equivalent in Ruby.

[Pandoc]: http://sophos.berkeley.edu/macfarlane/pandoc/
[MultiMarkdown]: http://fletcher.freeshell.org/wiki/MultiMarkdown

-->
