/*
 * Decompiled with CFR 0.152.
 */
package org.apache.solr.analytics.function.mapping;

import java.util.function.Consumer;
import org.apache.solr.analytics.value.AnalyticsValueStream;
import org.apache.solr.common.SolrException;

class StreamFillMissingFunction
extends AnalyticsValueStream.AbstractAnalyticsValueStream
implements Consumer<Object> {
    private final AnalyticsValueStream baseExpr;
    private final AnalyticsValueStream fillExpr;
    public static final String name = "fill_missing";
    private final String exprStr;
    private final AnalyticsValueStream.ExpressionType funcType;
    boolean exists = false;
    Consumer<Object> cons;

    public StreamFillMissingFunction(AnalyticsValueStream baseExpr, AnalyticsValueStream fillExpr) throws SolrException {
        this.baseExpr = baseExpr;
        this.fillExpr = fillExpr;
        this.exprStr = AnalyticsValueStream.createExpressionString(name, baseExpr, fillExpr);
        this.funcType = AnalyticsValueStream.determineMappingPhase(this.exprStr, baseExpr, fillExpr);
    }

    @Override
    public void streamObjects(Consumer<Object> cons) {
        this.exists = false;
        this.cons = cons;
        this.baseExpr.streamObjects(this);
        if (!this.exists) {
            this.fillExpr.streamObjects(cons);
        }
    }

    @Override
    public void accept(Object value) {
        this.exists = true;
        this.cons.accept(value);
    }

    @Override
    public String getName() {
        return name;
    }

    @Override
    public String getExpressionStr() {
        return this.exprStr;
    }

    @Override
    public AnalyticsValueStream.ExpressionType getExpressionType() {
        return this.funcType;
    }
}

