/*
 * Decompiled with CFR 0.152.
 */
package com.eteks.sweethome3d.swing;

import com.eteks.sweethome3d.j3d.Component3DManager;
import com.eteks.sweethome3d.j3d.HomePieceOfFurniture3D;
import com.eteks.sweethome3d.j3d.ModelManager;
import com.eteks.sweethome3d.model.CatalogPieceOfFurniture;
import com.eteks.sweethome3d.model.Content;
import com.eteks.sweethome3d.model.HomeMaterial;
import com.eteks.sweethome3d.model.HomePieceOfFurniture;
import com.eteks.sweethome3d.model.Transformation;
import com.eteks.sweethome3d.swing.SwingTools;
import com.eteks.sweethome3d.tools.OperatingSystem;
import com.eteks.sweethome3d.tools.TemporaryURLContent;
import com.sun.j3d.exp.swing.JCanvas3D;
import com.sun.j3d.utils.geometry.Cone;
import com.sun.j3d.utils.geometry.Cylinder;
import com.sun.j3d.utils.picking.PickCanvas;
import com.sun.j3d.utils.picking.PickResult;
import com.sun.j3d.utils.universe.SimpleUniverse;
import com.sun.j3d.utils.universe.Viewer;
import com.sun.j3d.utils.universe.ViewingPlatform;
import java.awt.AWTException;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.KeyboardFocusManager;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Robot;
import java.awt.Toolkit;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelEvent;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import java.awt.image.AreaAveragingScaleFilter;
import java.awt.image.BufferedImage;
import java.awt.image.FilteredImageSource;
import java.awt.image.ImageProducer;
import java.awt.image.MemoryImageSource;
import java.awt.image.RenderedImage;
import java.io.File;
import java.io.IOException;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.EventListener;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicReference;
import javax.imageio.ImageIO;
import javax.media.j3d.AmbientLight;
import javax.media.j3d.Appearance;
import javax.media.j3d.Background;
import javax.media.j3d.BoundingBox;
import javax.media.j3d.BoundingSphere;
import javax.media.j3d.Bounds;
import javax.media.j3d.BranchGroup;
import javax.media.j3d.Canvas3D;
import javax.media.j3d.ColoringAttributes;
import javax.media.j3d.DirectionalLight;
import javax.media.j3d.GraphicsConfigTemplate3D;
import javax.media.j3d.Group;
import javax.media.j3d.Light;
import javax.media.j3d.Link;
import javax.media.j3d.Node;
import javax.media.j3d.RenderingAttributes;
import javax.media.j3d.Shape3D;
import javax.media.j3d.Texture;
import javax.media.j3d.Transform3D;
import javax.media.j3d.TransformGroup;
import javax.swing.BorderFactory;
import javax.swing.JComponent;
import javax.swing.JPanel;
import javax.swing.SwingUtilities;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import javax.swing.event.MouseInputAdapter;
import javax.vecmath.Color3f;
import javax.vecmath.Matrix3f;
import javax.vecmath.Point2d;
import javax.vecmath.Point3d;
import javax.vecmath.Point3f;
import javax.vecmath.Tuple3f;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector3f;

public class ModelPreviewComponent
extends JComponent {
    private static final int MODEL_PREFERRED_SIZE = Math.round(200.0f * SwingTools.getResolutionScale());
    private SimpleUniverse universe;
    private JPanel component3DPanel;
    private Component component3D;
    private BranchGroup sceneTree;
    private float viewYaw = 0.3926991f;
    private float viewPitch = -0.19634955f;
    private float viewScale = 1.0f;
    private boolean parallelProjection;
    private Object iconImageLock;
    private HomePieceOfFurniture previewedPiece;
    private boolean internalRotationAndSize;
    private Map<Texture, Texture> pieceTextures = new HashMap<Texture, Texture>();

    public ModelPreviewComponent() {
        this(false);
    }

    public ModelPreviewComponent(boolean bl) {
        this(true, bl, bl);
    }

    public ModelPreviewComponent(boolean bl, boolean bl2, boolean bl3) {
        this(bl, bl2, bl3, false);
    }

    public ModelPreviewComponent(boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        this.setBorder(BorderFactory.createEtchedBorder(1));
        this.sceneTree = this.createSceneTree(bl4);
        this.component3DPanel = new JPanel();
        this.setLayout(new BorderLayout());
        this.add(this.component3DPanel);
        GraphicsEnvironment graphicsEnvironment = GraphicsEnvironment.getLocalGraphicsEnvironment();
        if (graphicsEnvironment.getScreenDevices().length == 1) {
            this.createComponent3D(graphicsEnvironment.getDefaultScreenDevice().getDefaultConfiguration(), bl, bl2, bl3, bl4);
        }
        this.addAncestorListener(bl, bl2, bl3, bl4);
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.isPreferredSizeSet()) {
            return super.getPreferredSize();
        }
        return new Dimension(MODEL_PREFERRED_SIZE, MODEL_PREFERRED_SIZE);
    }

    @Override
    public void addMouseMotionListener(final MouseMotionListener mouseMotionListener) {
        super.addMouseMotionListener(mouseMotionListener);
        if (this.component3D != null) {
            this.component3D.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    mouseMotionListener.mouseMoved(SwingUtilities.convertMouseEvent(ModelPreviewComponent.this.component3D, mouseEvent, ModelPreviewComponent.this));
                }

                @Override
                public void mouseDragged(MouseEvent mouseEvent) {
                    mouseMotionListener.mouseDragged(SwingUtilities.convertMouseEvent(ModelPreviewComponent.this.component3D, mouseEvent, ModelPreviewComponent.this));
                }
            });
        }
    }

    @Override
    public void addMouseListener(final MouseListener mouseListener) {
        super.addMouseListener(mouseListener);
        if (this.component3D != null) {
            this.component3D.addMouseListener(new MouseListener(){

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    mouseListener.mouseReleased(SwingUtilities.convertMouseEvent(ModelPreviewComponent.this.component3D, mouseEvent, ModelPreviewComponent.this));
                }

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    mouseListener.mousePressed(SwingUtilities.convertMouseEvent(ModelPreviewComponent.this.component3D, mouseEvent, ModelPreviewComponent.this));
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    mouseListener.mouseExited(SwingUtilities.convertMouseEvent(ModelPreviewComponent.this.component3D, mouseEvent, ModelPreviewComponent.this));
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    mouseListener.mouseEntered(SwingUtilities.convertMouseEvent(ModelPreviewComponent.this.component3D, mouseEvent, ModelPreviewComponent.this));
                }

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    mouseListener.mouseClicked(SwingUtilities.convertMouseEvent(ModelPreviewComponent.this.component3D, mouseEvent, ModelPreviewComponent.this));
                }
            });
        }
    }

    JComponent getComponent3D() {
        return this.component3DPanel;
    }

    private void addAncestorListener(final boolean bl, final boolean bl2, final boolean bl3, final boolean bl4) {
        this.addAncestorListener(new AncestorListener(){

            @Override
            public void ancestorAdded(AncestorEvent ancestorEvent) {
                if (ModelPreviewComponent.this.component3D == null) {
                    ModelPreviewComponent.this.createComponent3D(ancestorEvent.getAncestor().getGraphicsConfiguration(), bl, bl2, bl3, bl4);
                }
                if (ModelPreviewComponent.this.universe == null) {
                    ModelPreviewComponent.this.createUniverse();
                }
            }

            @Override
            public void ancestorRemoved(AncestorEvent ancestorEvent) {
                if (ModelPreviewComponent.this.universe != null) {
                    EventQueue.invokeLater(new Runnable(){

                        @Override
                        public void run() {
                            ModelPreviewComponent.this.disposeUniverse();
                            ModelPreviewComponent.this.component3DPanel.removeAll();
                            ModelPreviewComponent.this.component3D = null;
                        }
                    });
                }
            }

            @Override
            public void ancestorMoved(AncestorEvent ancestorEvent) {
            }
        });
    }

    private void createComponent3D(GraphicsConfiguration graphicsConfiguration, boolean bl, boolean bl2, boolean bl3, boolean bl4) {
        if (Boolean.getBoolean("com.eteks.sweethome3d.j3d.useOffScreen3DView")) {
            GraphicsConfigTemplate3D graphicsConfigTemplate3D = new GraphicsConfigTemplate3D();
            graphicsConfigTemplate3D.setSceneAntialiasing(2);
            try {
                this.component3D = (Component)Class.forName(ModelPreviewComponent.class.getName() + "$JCanvas3DWithNotifiedPaint").getConstructor(ModelPreviewComponent.class, GraphicsConfigTemplate3D.class).newInstance(this, graphicsConfigTemplate3D);
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new UnsupportedOperationException("Java 3D 1.5 required to display an offscreen 3D view");
            }
            catch (Exception exception) {
                UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
                unsupportedOperationException.initCause(exception);
                throw unsupportedOperationException;
            }
        } else {
            this.component3D = Component3DManager.getInstance().getOnscreenCanvas3D(graphicsConfiguration, new Component3DManager.RenderingObserver(){

                @Override
                public void canvas3DPreRendered(Canvas3D canvas3D) {
                }

                @Override
                public void canvas3DPostRendered(Canvas3D canvas3D) {
                }

                @Override
                public void canvas3DSwapped(Canvas3D canvas3D) {
                    ModelPreviewComponent.this.canvas3DSwapped();
                }
            });
        }
        this.component3D.setBackground(new Color(0xE5E5E5));
        this.component3DPanel.setLayout(new GridLayout());
        this.component3DPanel.add(this.component3D);
        this.component3D.setFocusable(false);
        this.addMouseListeners(this.component3D, bl, bl2, bl3, bl4);
    }

    private Canvas3D getCanvas3D() {
        if (this.component3D instanceof Canvas3D) {
            return (Canvas3D)this.component3D;
        }
        if (this.component3D != null) {
            try {
                return (Canvas3D)Class.forName("com.sun.j3d.exp.swing.JCanvas3D").getMethod("getOffscreenCanvas3D", new Class[0]).invoke((Object)this.component3D, new Object[0]);
            }
            catch (Exception exception) {
                UnsupportedOperationException unsupportedOperationException = new UnsupportedOperationException();
                unsupportedOperationException.initCause(exception);
                throw unsupportedOperationException;
            }
        }
        return null;
    }

    private void addMouseListeners(final Component component, final boolean bl, final boolean bl2, final boolean bl3, final boolean bl4) {
        MouseInputAdapter mouseInputAdapter = new MouseInputAdapter(){
            private int xLastMouseMove;
            private int yLastMouseMove;
            private boolean boundedPitch;
            private TransformGroup pickedTransformGroup;
            private Point2d pivotCenterPixel;
            private Transform3D translationFromOrigin;
            private Transform3D translationToOrigin;
            private BoundingBox modelBounds;

            private Point getMouseLocation(MouseEvent mouseEvent) {
                if (OperatingSystem.isJavaVersionGreaterOrEqual("1.9")) {
                    try {
                        Field field = Canvas3D.class.getDeclaredField("xscale");
                        field.setAccessible(true);
                        double d = (Double)field.get(mouseEvent.getSource());
                        Field field2 = Canvas3D.class.getDeclaredField("yscale");
                        field2.setAccessible(true);
                        double d2 = (Double)field2.get(mouseEvent.getSource());
                        return new Point((int)((double)mouseEvent.getX() * d), (int)((double)mouseEvent.getY() * d2));
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                return mouseEvent.getPoint();
            }

            @Override
            public void mousePressed(MouseEvent mouseEvent) {
                Point point = this.getMouseLocation(mouseEvent);
                this.xLastMouseMove = point.x;
                this.yLastMouseMove = point.y;
                this.pickedTransformGroup = null;
                this.pivotCenterPixel = null;
                this.boundedPitch = true;
                if (bl4 && ModelPreviewComponent.this.getModelNode() != null) {
                    ModelManager modelManager = ModelManager.getInstance();
                    this.boundedPitch = !modelManager.containsDeformableNode((Node)ModelPreviewComponent.this.getModelNode());
                    Canvas3D canvas3D = ModelPreviewComponent.this.getCanvas3D();
                    PickCanvas pickCanvas = new PickCanvas(canvas3D, (BranchGroup)ModelPreviewComponent.this.getModelNode());
                    pickCanvas.setMode(256);
                    pickCanvas.setShapeLocation(point.x, point.y);
                    PickResult pickResult = pickCanvas.pickClosest();
                    if (pickResult != null) {
                        this.pickedTransformGroup = (TransformGroup)pickResult.getNode(32);
                        if (this.pickedTransformGroup != null) {
                            int n;
                            Group group = (Group)this.pickedTransformGroup.getParent();
                            for (n = group.indexOfChild((Node)this.pickedTransformGroup) - 1; n >= 0 && group.getChild(n) instanceof TransformGroup; --n) {
                            }
                            if (n >= 0) {
                                Node node = group.getChild(n);
                                Point3f point3f = modelManager.getCenter(node);
                                Point3f point3f2 = new Point3f(point3f);
                                Transform3D transform3D = this.getTransformBetweenNodes(node.getParent(), (Node)ModelPreviewComponent.this.sceneTree);
                                transform3D.transform(point3f2);
                                Transform3D transform3D2 = new Transform3D();
                                canvas3D.getVworldToImagePlate(transform3D2);
                                transform3D2.transform(point3f2);
                                this.pivotCenterPixel = new Point2d();
                                canvas3D.getPixelLocationFromImagePlate(new Point3d(point3f2), this.pivotCenterPixel);
                                String string = (String)this.pickedTransformGroup.getUserData();
                                this.translationFromOrigin = new Transform3D();
                                this.translationFromOrigin.setTranslation(new Vector3d((Tuple3f)point3f));
                                Transform3D transform3D3 = this.getTransformBetweenNodes(node.getParent(), (Node)ModelPreviewComponent.this.getModelNode());
                                transform3D3.setTranslation(new Vector3d());
                                transform3D3.invert();
                                this.translationFromOrigin.mul(transform3D3);
                                Transform3D transform3D4 = new Transform3D();
                                transform3D4.rotX((double)ModelPreviewComponent.this.viewPitch);
                                Transform3D transform3D5 = new Transform3D();
                                transform3D5.rotY((double)ModelPreviewComponent.this.viewYaw);
                                if (string.startsWith("sweethome3d_hinge_") || string.startsWith("sweethome3d_rail_")) {
                                    Transform3D transform3D6 = new Transform3D();
                                    Vector3f vector3f = modelManager.getSize(node);
                                    this.getTransformBetweenNodes((Node)this.getModelRoot(node), (Node)ModelPreviewComponent.this.getModelNode()).transform(vector3f);
                                    vector3f.absolute();
                                    Transform3D transform3D7 = new Transform3D(transform3D5);
                                    transform3D7.mul(transform3D4);
                                    transform3D7.invert();
                                    if (vector3f.y > vector3f.x && vector3f.y > vector3f.z) {
                                        Vector3f vector3f2 = new Vector3f(0.0f, 1.0f, 0.0f);
                                        transform3D7.transform(vector3f2);
                                        if (string.startsWith("sweethome3d_rail_") ? vector3f2.y > 0.0f : vector3f2.z < 0.0f) {
                                            transform3D6.rotX(1.5707963267948966);
                                        } else {
                                            transform3D6.rotX(-1.5707963267948966);
                                        }
                                    } else if (vector3f.z > vector3f.x && vector3f.z > vector3f.y) {
                                        Vector3f vector3f3 = new Vector3f(0.0f, 0.0f, 1.0f);
                                        transform3D7.transform(vector3f3);
                                        if (string.startsWith("sweethome3d_rail_") ? vector3f3.x > 0.0f : vector3f3.z < 0.0f) {
                                            transform3D6.rotX(Math.PI);
                                        }
                                    } else {
                                        Vector3f vector3f4 = new Vector3f(1.0f, 0.0f, 0.0f);
                                        transform3D7.transform(vector3f4);
                                        if (string.startsWith("sweethome3d_rail_") ? vector3f4.x > 0.0f : vector3f4.z < 0.0f) {
                                            transform3D6.rotY(-1.5707963267948966);
                                        } else {
                                            transform3D6.rotY(1.5707963267948966);
                                        }
                                    }
                                    this.translationFromOrigin.mul(transform3D6);
                                } else {
                                    this.translationFromOrigin.mul(transform3D5);
                                    this.translationFromOrigin.mul(transform3D4);
                                }
                                this.translationToOrigin = new Transform3D(this.translationFromOrigin);
                                this.translationToOrigin.invert();
                                this.modelBounds = modelManager.getBounds((Node)ModelPreviewComponent.this.getModelNode());
                            }
                        }
                    }
                }
            }

            private Transform3D getTransformBetweenNodes(Node node, Node node2) {
                Transform3D transform3D = new Transform3D();
                if (node instanceof TransformGroup) {
                    ((TransformGroup)node).getTransform(transform3D);
                }
                if (node != node2) {
                    Node node3 = node.getParent();
                    if (node3 instanceof Group) {
                        transform3D.mul(this.getTransformBetweenNodes(node3, node2), transform3D);
                    } else {
                        throw new IllegalStateException("Can't retrieve node transform");
                    }
                }
                return transform3D;
            }

            private BranchGroup getModelRoot(Node node) {
                if (node instanceof BranchGroup && node.getUserData() instanceof Content) {
                    return (BranchGroup)node;
                }
                if (node.getParent() != null) {
                    return this.getModelRoot(node.getParent());
                }
                return null;
            }

            @Override
            public void mouseDragged(MouseEvent mouseEvent) {
                Point point = this.getMouseLocation(mouseEvent);
                if (ModelPreviewComponent.this.getModelNode() != null) {
                    if (this.pivotCenterPixel != null) {
                        String string = (String)this.pickedTransformGroup.getUserData();
                        Transform3D transform3D = new Transform3D();
                        if (string.startsWith("sweethome3d_rail_")) {
                            transform3D.setTranslation(new Vector3f(0.0f, 0.0f, (float)Point2D.distance(point.x, point.y, this.xLastMouseMove, this.yLastMouseMove) * Math.signum(this.xLastMouseMove - point.x)));
                        } else {
                            double d = Math.atan2(this.pivotCenterPixel.y - (double)point.y, (double)point.x - this.pivotCenterPixel.x) - Math.atan2(this.pivotCenterPixel.y - (double)this.yLastMouseMove, (double)this.xLastMouseMove - this.pivotCenterPixel.x);
                            transform3D.rotZ(d);
                        }
                        transform3D.mul(transform3D, this.translationToOrigin);
                        transform3D.mul(this.translationFromOrigin, transform3D);
                        Transform3D transform3D2 = new Transform3D();
                        this.pickedTransformGroup.getTransform(transform3D2);
                        transform3D2.mul(transform3D, transform3D2);
                        this.pickedTransformGroup.setTransform(transform3D2);
                        Point3d point3d = new Point3d();
                        this.modelBounds.getLower(point3d);
                        Point3d point3d2 = new Point3d();
                        this.modelBounds.getUpper(point3d2);
                        ModelManager modelManager = ModelManager.getInstance();
                        BoundingBox boundingBox = modelManager.getBounds((Node)ModelPreviewComponent.this.getModelNode());
                        Point3d point3d3 = new Point3d();
                        boundingBox.getLower(point3d3);
                        Point3d point3d4 = new Point3d();
                        boundingBox.getUpper(point3d4);
                        ModelPreviewComponent.this.previewedPiece.setX(ModelPreviewComponent.this.previewedPiece.getX() + (float)(point3d4.x + point3d3.x) / 2.0f - (float)(point3d2.x + point3d.x) / 2.0f);
                        ModelPreviewComponent.this.previewedPiece.setY(ModelPreviewComponent.this.previewedPiece.getY() + (float)(point3d4.z + point3d3.z) / 2.0f - (float)(point3d2.z + point3d.z) / 2.0f);
                        ModelPreviewComponent.this.previewedPiece.setElevation(ModelPreviewComponent.this.previewedPiece.getElevation() + (float)(point3d3.y - point3d.y));
                        ModelPreviewComponent.this.previewedPiece.setWidth((float)(point3d4.x - point3d3.x));
                        ModelPreviewComponent.this.previewedPiece.setDepth((float)(point3d4.z - point3d3.z));
                        ModelPreviewComponent.this.previewedPiece.setHeight((float)(point3d4.y - point3d3.y));
                        this.modelBounds = boundingBox;
                        Transformation[] transformationArray = ModelPreviewComponent.this.previewedPiece.getModelTransformations();
                        ArrayList<Transformation> arrayList = new ArrayList<Transformation>();
                        if (transformationArray != null) {
                            arrayList.addAll(Arrays.asList(transformationArray));
                        }
                        string = string.substring(0, string.length() - "_transformation".length());
                        Object object = arrayList.iterator();
                        while (object.hasNext()) {
                            Transformation transformation = (Transformation)object.next();
                            if (!string.equals(transformation.getName())) continue;
                            object.remove();
                            break;
                        }
                        object = new float[16];
                        transform3D2.get((float[])object);
                        arrayList.add(new Transformation(string, new float[][]{{(float)object[0], (float)object[1], (float)object[2], (float)object[3]}, {(float)object[4], (float)object[5], (float)object[6], (float)object[7]}, {(float)object[8], (float)object[9], (float)object[10], (float)object[11]}}));
                        ModelPreviewComponent.this.previewedPiece.setModelTransformations(arrayList.toArray(new Transformation[arrayList.size()]));
                    } else {
                        if (bl) {
                            ModelPreviewComponent.this.setViewYaw(ModelPreviewComponent.this.getViewYaw() - 0.02f * (float)(point.x - this.xLastMouseMove));
                        }
                        if (bl3 && mouseEvent.isAltDown()) {
                            ModelPreviewComponent.this.setViewScale(Math.max(0.5f, Math.min(1.3f, ModelPreviewComponent.this.getViewScale() * (float)Math.exp((float)(point.y - this.yLastMouseMove) * 0.02f))));
                        } else if (bl2 && !mouseEvent.isAltDown()) {
                            float f = ModelPreviewComponent.this.getViewPitch() - 0.02f * (float)(point.y - this.yLastMouseMove);
                            if (this.boundedPitch) {
                                ModelPreviewComponent.this.setViewPitch(Math.max(-0.7853982f, Math.min(0.0f, f)));
                            } else {
                                ModelPreviewComponent.this.setViewPitch(f);
                            }
                        }
                    }
                }
                this.xLastMouseMove = point.x;
                this.yLastMouseMove = point.y;
            }
        };
        component.addMouseListener(mouseInputAdapter);
        component.addMouseMotionListener(mouseInputAdapter);
        if (bl3) {
            component.addMouseWheelListener(new MouseWheelListener(){

                @Override
                public void mouseWheelMoved(MouseWheelEvent mouseWheelEvent) {
                    ModelPreviewComponent.this.setViewScale(Math.max(0.5f, Math.min(1.3f, ModelPreviewComponent.this.getViewScale() * (float)Math.exp((float)mouseWheelEvent.getWheelRotation() * 0.02f))));
                }
            });
        }
        for (final MouseMotionListener eventListener : (MouseMotionListener[])this.getListeners(MouseMotionListener.class)) {
            component.addMouseMotionListener(new MouseMotionListener(){

                @Override
                public void mouseMoved(MouseEvent mouseEvent) {
                    eventListener.mouseMoved(SwingUtilities.convertMouseEvent(component, mouseEvent, ModelPreviewComponent.this));
                }

                @Override
                public void mouseDragged(MouseEvent mouseEvent) {
                    eventListener.mouseDragged(SwingUtilities.convertMouseEvent(component, mouseEvent, ModelPreviewComponent.this));
                }
            });
        }
        for (EventListener eventListener : (MouseListener[])this.getListeners(MouseListener.class)) {
            component.addMouseListener(new MouseListener(){
                final /* synthetic */ MouseListener val$l;
                final /* synthetic */ Component val$component3D;
                {
                    this.val$l = mouseListener;
                    this.val$component3D = component;
                }

                @Override
                public void mouseReleased(MouseEvent mouseEvent) {
                    this.val$l.mouseReleased(SwingUtilities.convertMouseEvent(this.val$component3D, mouseEvent, ModelPreviewComponent.this));
                }

                @Override
                public void mousePressed(MouseEvent mouseEvent) {
                    this.val$l.mousePressed(SwingUtilities.convertMouseEvent(this.val$component3D, mouseEvent, ModelPreviewComponent.this));
                }

                @Override
                public void mouseExited(MouseEvent mouseEvent) {
                    this.val$l.mouseExited(SwingUtilities.convertMouseEvent(this.val$component3D, mouseEvent, ModelPreviewComponent.this));
                }

                @Override
                public void mouseEntered(MouseEvent mouseEvent) {
                    this.val$l.mouseEntered(SwingUtilities.convertMouseEvent(this.val$component3D, mouseEvent, ModelPreviewComponent.this));
                }

                @Override
                public void mouseClicked(MouseEvent mouseEvent) {
                    this.val$l.mouseClicked(SwingUtilities.convertMouseEvent(this.val$component3D, mouseEvent, ModelPreviewComponent.this));
                }
            });
        }
    }

    private void createUniverse() {
        Canvas3D canvas3D = this.getCanvas3D();
        ViewingPlatform viewingPlatform = new ViewingPlatform();
        Viewer viewer = new Viewer(canvas3D);
        this.universe = new SimpleUniverse(viewingPlatform, viewer);
        this.universe.addBranchGraph(this.sceneTree);
        this.universe.getViewer().getView().setProjectionPolicy(this.parallelProjection ? 0 : 1);
        this.updateViewPlatformTransform(this.universe.getViewingPlatform().getViewPlatformTransform(), this.getViewYaw(), this.getViewPitch(), this.getViewScale());
        this.revalidate();
        this.repaint();
        if (OperatingSystem.isMacOSX()) {
            final Component component = SwingUtilities.getRoot(this);
            EventQueue.invokeLater(new Runnable(){

                @Override
                public void run() {
                    if (KeyboardFocusManager.getCurrentKeyboardFocusManager().getActiveWindow() != component) {
                        component.requestFocus();
                    }
                }
            });
        }
    }

    private void disposeUniverse() {
        this.universe.getLocale().removeBranchGraph(this.sceneTree);
        this.universe.cleanup();
        this.universe = null;
    }

    protected float getViewYaw() {
        return this.viewYaw;
    }

    protected void setViewYaw(float f) {
        this.viewYaw = f;
        if (this.universe != null) {
            this.updateViewPlatformTransform(this.universe.getViewingPlatform().getViewPlatformTransform(), this.getViewYaw(), this.getViewPitch(), this.getViewScale());
        }
    }

    protected float getViewScale() {
        return this.viewScale;
    }

    protected void setViewScale(float f) {
        this.viewScale = f;
        if (this.universe != null) {
            this.updateViewPlatformTransform(this.universe.getViewingPlatform().getViewPlatformTransform(), this.getViewYaw(), this.getViewPitch(), this.getViewScale());
        }
    }

    protected float getViewPitch() {
        return this.viewPitch;
    }

    protected void setViewPitch(float f) {
        this.viewPitch = f;
        if (this.universe != null) {
            this.updateViewPlatformTransform(this.universe.getViewingPlatform().getViewPlatformTransform(), this.getViewYaw(), this.getViewPitch(), this.getViewScale());
        }
    }

    protected void setParallelProjection(boolean bl) {
        this.parallelProjection = bl;
        if (this.universe != null) {
            this.universe.getViewer().getView().setProjectionPolicy(bl ? 0 : 1);
        }
    }

    protected boolean isParallelProjection() {
        return this.parallelProjection;
    }

    private void updateViewPlatformTransform(TransformGroup transformGroup, float f, float f2, float f3) {
        double d = 1.4 / Math.tan(0.39269908169872414);
        Transform3D transform3D = new Transform3D();
        transform3D.setTranslation(new Vector3d(0.0, 0.0, d));
        Transform3D transform3D2 = new Transform3D();
        transform3D2.rotX((double)f2);
        Transform3D transform3D3 = new Transform3D();
        transform3D3.rotY((double)f);
        Transform3D transform3D4 = new Transform3D();
        transform3D4.setScale((double)f3);
        transform3D2.mul(transform3D);
        transform3D3.mul(transform3D2);
        transform3D4.mul(transform3D3);
        transformGroup.setTransform(transform3D4);
        Transform3D transform3D5 = new Transform3D();
        transform3D5.setScale((double)f3);
        transform3D2.rotX((double)(-f2));
        transform3D3.rotY((double)(-f));
        transform3D5.mul(transform3D3, transform3D5);
        transform3D5.mul(transform3D2, transform3D5);
        transform3D = new Transform3D();
        transform3D.setTranslation(new Vector3f(-0.82f * f3, -0.82f * f3, 0.82f * f3));
        transform3D2.rotX((double)f2);
        transform3D3.rotY((double)f);
        transform3D5.mul(transform3D, transform3D5);
        transform3D5.mul(transform3D2, transform3D5);
        transform3D5.mul(transform3D3, transform3D5);
        ((TransformGroup)this.sceneTree.getChild(2)).setTransform(transform3D5);
    }

    private BranchGroup createSceneTree(boolean bl) {
        BranchGroup branchGroup = new BranchGroup();
        branchGroup.setCapability(17);
        branchGroup.setCapability(12);
        branchGroup.addChild(this.createModelTree());
        branchGroup.addChild(this.createBackgroundNode());
        branchGroup.addChild(this.createAxes(bl));
        for (Light light : this.createLights()) {
            branchGroup.addChild((Node)light);
        }
        return branchGroup;
    }

    private Node createBackgroundNode() {
        Background background = new Background(new Color3f(0.9f, 0.9f, 0.9f));
        background.setCapability(17);
        background.setApplicationBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0));
        return background;
    }

    @Override
    public void setBackground(Color color) {
        super.setBackground(color);
        ((Background)this.sceneTree.getChild(1)).setColor(new Color3f(color));
    }

    private Node createAxes(boolean bl) {
        RenderingAttributes renderingAttributes = new RenderingAttributes();
        renderingAttributes.setVisible(bl);
        Appearance appearance = new Appearance();
        appearance.setColoringAttributes(new ColoringAttributes(new Color3f(1.0f, 0.0f, 0.0f), 2));
        appearance.setRenderingAttributes(renderingAttributes);
        Appearance appearance2 = new Appearance();
        appearance2.setColoringAttributes(new ColoringAttributes(new Color3f(0.0f, 1.0f, 0.0f), 2));
        appearance2.setRenderingAttributes(renderingAttributes);
        Appearance appearance3 = new Appearance();
        appearance3.setColoringAttributes(new ColoringAttributes(new Color3f(0.0f, 0.0f, 1.0f), 2));
        appearance3.setRenderingAttributes(renderingAttributes);
        Group group = new Group();
        Transform3D transform3D = new Transform3D();
        transform3D.rotZ(-1.5707963267948966);
        group.addChild(this.createAxis(transform3D, appearance));
        group.addChild(this.createAxis(new Transform3D(), appearance3));
        transform3D.rotX(1.5707963267948966);
        group.addChild(this.createAxis(transform3D, appearance2));
        TransformGroup transformGroup = new TransformGroup();
        transformGroup.setCapability(18);
        transformGroup.addChild((Node)group);
        return transformGroup;
    }

    private Node createAxis(Transform3D transform3D, Appearance appearance) {
        Cylinder cylinder = new Cylinder(0.00275f, 0.2f, appearance);
        Transform3D transform3D2 = new Transform3D();
        transform3D2.setTranslation(new Vector3f(0.0f, 0.1f, 0.0f));
        TransformGroup transformGroup = new TransformGroup(transform3D2);
        transformGroup.addChild((Node)cylinder);
        Cone cone = new Cone(0.01f, 0.04f, appearance);
        Transform3D transform3D3 = new Transform3D();
        transform3D3.setTranslation(new Vector3f(0.0f, 0.2f, 0.0f));
        TransformGroup transformGroup2 = new TransformGroup(transform3D3);
        transformGroup2.addChild((Node)cone);
        TransformGroup transformGroup3 = new TransformGroup(transform3D);
        transformGroup3.addChild((Node)transformGroup2);
        transformGroup3.addChild((Node)transformGroup);
        return transformGroup3;
    }

    private Light[] createLights() {
        Light[] lightArray;
        for (Light light : lightArray = new Light[]{new DirectionalLight(new Color3f(0.9f, 0.9f, 0.9f), new Vector3f(1.732f, -0.8f, -1.0f)), new DirectionalLight(new Color3f(0.9f, 0.9f, 0.9f), new Vector3f(-1.732f, -0.8f, -1.0f)), new DirectionalLight(new Color3f(0.9f, 0.9f, 0.9f), new Vector3f(0.0f, -0.8f, 1.0f)), new DirectionalLight(new Color3f(0.66f, 0.66f, 0.66f), new Vector3f(0.0f, 1.0f, 0.0f)), new AmbientLight(new Color3f(0.2f, 0.2f, 0.2f))}) {
            light.setInfluencingBounds((Bounds)new BoundingSphere(new Point3d(0.0, 0.0, 0.0), 100.0));
        }
        return lightArray;
    }

    private Node createModelTree() {
        TransformGroup transformGroup = new TransformGroup();
        transformGroup.setCapability(12);
        transformGroup.setCapability(13);
        transformGroup.setCapability(14);
        transformGroup.setCapability(18);
        return transformGroup;
    }

    public Content getModel() {
        return this.previewedPiece != null ? this.previewedPiece.getModel() : null;
    }

    public void setModel(Content content) {
        this.setModel(content, false, null, -1.0f, -1.0f, -1.0f);
    }

    void setModel(final Content content, final boolean bl, final float[][] fArray, final float f, final float f2, final float f3) {
        final TransformGroup transformGroup = (TransformGroup)this.sceneTree.getChild(0);
        transformGroup.removeAllChildren();
        this.previewedPiece = null;
        this.pieceTextures.clear();
        if (content != null) {
            final AtomicReference atomicReference = new AtomicReference();
            ModelManager.getInstance().loadModel(content, true, new ModelManager.ModelObserver(){

                @Override
                public void modelUpdated(BranchGroup branchGroup) {
                    if (branchGroup.numChildren() > 0) {
                        try {
                            Vector3f vector3f = f < 0.0f ? ModelManager.getInstance().getSize((Node)branchGroup) : new Vector3f(f, f3, f2);
                            ModelPreviewComponent.this.internalRotationAndSize = fArray != null;
                            ModelPreviewComponent.this.previewedPiece = new HomePieceOfFurniture(new CatalogPieceOfFurniture(null, null, content, vector3f.x, vector3f.z, vector3f.y, 0.0f, false, null, fArray, bl, 0.0f, false));
                            ModelPreviewComponent.this.previewedPiece.setX(0.0f);
                            ModelPreviewComponent.this.previewedPiece.setY(0.0f);
                            ModelPreviewComponent.this.previewedPiece.setElevation(-ModelPreviewComponent.this.previewedPiece.getHeight() / 2.0f);
                            Transform3D transform3D = new Transform3D();
                            transform3D.setScale(1.8 / (double)Math.max(Math.max(vector3f.x, vector3f.z), vector3f.y));
                            transformGroup.setTransform(transform3D);
                            HomePieceOfFurniture3D homePieceOfFurniture3D = new HomePieceOfFurniture3D(ModelPreviewComponent.this.previewedPiece, null, true, true);
                            if (OperatingSystem.isMacOSX()) {
                                ModelPreviewComponent.this.cloneTextures((Node)homePieceOfFurniture3D, ModelPreviewComponent.this.pieceTextures);
                            }
                            transformGroup.addChild((Node)homePieceOfFurniture3D);
                        }
                        catch (IllegalArgumentException illegalArgumentException) {
                            // empty catch block
                        }
                    }
                }

                @Override
                public void modelError(Exception exception) {
                    atomicReference.set(new IllegalArgumentException("Couldn't load model", exception));
                }
            });
            if (atomicReference.get() != null) {
                throw (IllegalArgumentException)atomicReference.get();
            }
        }
    }

    protected void setBackFaceShown(boolean bl) {
        if (this.previewedPiece != null) {
            this.previewedPiece = new HomePieceOfFurniture(new CatalogPieceOfFurniture(null, null, this.previewedPiece.getModel(), this.previewedPiece.getWidth(), this.previewedPiece.getDepth(), this.previewedPiece.getHeight(), 0.0f, false, this.previewedPiece.getColor(), this.previewedPiece.getModelRotation(), bl, 0.0f, false));
            this.previewedPiece.setX(0.0f);
            this.previewedPiece.setY(0.0f);
            this.previewedPiece.setElevation(-this.previewedPiece.getHeight() / 2.0f);
            TransformGroup transformGroup = (TransformGroup)this.sceneTree.getChild(0);
            HomePieceOfFurniture3D homePieceOfFurniture3D = new HomePieceOfFurniture3D(this.previewedPiece, null, true, true);
            if (OperatingSystem.isMacOSX()) {
                this.pieceTextures.clear();
                this.cloneTextures((Node)homePieceOfFurniture3D, this.pieceTextures);
            }
            transformGroup.addChild((Node)homePieceOfFurniture3D);
            if (transformGroup.numChildren() > 1) {
                transformGroup.removeChild(0);
            }
        }
    }

    private HomePieceOfFurniture3D getModelNode() {
        TransformGroup transformGroup = (TransformGroup)this.sceneTree.getChild(0);
        if (transformGroup.numChildren() > 0) {
            return (HomePieceOfFurniture3D)transformGroup.getChild(0);
        }
        return null;
    }

    protected void setModelRotation(float[][] fArray) {
        HomePieceOfFurniture3D homePieceOfFurniture3D = this.getModelNode();
        if (homePieceOfFurniture3D != null && homePieceOfFurniture3D.numChildren() > 0) {
            Transform3D transform3D;
            if (this.internalRotationAndSize) {
                throw new IllegalStateException("Can't set rotation");
            }
            Transform3D transform3D2 = new Transform3D();
            if (fArray != null) {
                transform3D = new Matrix3f(fArray[0][0], fArray[0][1], fArray[0][2], fArray[1][0], fArray[1][1], fArray[1][2], fArray[2][0], fArray[2][1], fArray[2][2]);
                transform3D2.setRotation((Matrix3f)transform3D);
            }
            transform3D = new Transform3D();
            Vector3f vector3f = ModelManager.getInstance().getSize((Node)homePieceOfFurniture3D);
            transform3D.setScale(1.8 / (double)Math.max(Math.max(vector3f.x, vector3f.z), vector3f.y));
            transform3D.mul(transform3D2);
            TransformGroup transformGroup = (TransformGroup)this.sceneTree.getChild(0);
            transformGroup.setTransform(transform3D);
        }
    }

    protected void setModelRotationAndSize(float[][] fArray, float f, float f2, float f3) {
        HomePieceOfFurniture3D homePieceOfFurniture3D = this.getModelNode();
        if (homePieceOfFurniture3D != null && homePieceOfFurniture3D.numChildren() > 0) {
            Vector3f vector3f;
            if (this.internalRotationAndSize) {
                throw new IllegalStateException("Can't set rotation and size");
            }
            Transform3D transform3D = ModelManager.getInstance().getNormalizedTransform((Node)homePieceOfFurniture3D, fArray, 1.0f);
            Transform3D transform3D2 = new Transform3D();
            if (f != 0.0f && f2 != 0.0f && f3 != 0.0f) {
                transform3D2.setScale(new Vector3d((double)f, (double)f3, (double)f2));
            }
            transform3D2.mul(transform3D);
            Transform3D transform3D3 = new Transform3D();
            if (f != 0.0f && f2 != 0.0f && f3 != 0.0f) {
                transform3D3.setScale(1.8 / (double)Math.max(Math.max(f, f3), f2));
            } else {
                vector3f = ModelManager.getInstance().getSize((Node)homePieceOfFurniture3D);
                transform3D3.setScale(1.8 / (double)Math.max(Math.max(vector3f.x, vector3f.z), vector3f.y));
            }
            transform3D3.mul(transform3D2);
            vector3f = (TransformGroup)this.sceneTree.getChild(0);
            vector3f.setTransform(transform3D3);
        }
    }

    protected void setModelColor(Integer n) {
        if (this.previewedPiece != null && this.previewedPiece.getColor() != n) {
            this.previewedPiece.setColor(n);
            this.getModelNode().update();
        }
    }

    public void setModelMaterials(HomeMaterial[] homeMaterialArray) {
        if (this.previewedPiece != null) {
            this.previewedPiece.setModelMaterials(homeMaterialArray);
            this.getModelNode().update();
            this.cloneTextures((Node)this.getModelNode(), this.pieceTextures);
        }
    }

    public void setModelTranformations(Transformation[] transformationArray) {
        if (this.previewedPiece != null) {
            this.previewedPiece.setModelTransformations(transformationArray);
            this.getModelNode().update();
        }
    }

    void resetModelTranformations() {
        if (this.previewedPiece != null) {
            ModelManager modelManager = ModelManager.getInstance();
            BoundingBox boundingBox = modelManager.getBounds((Node)this.getModelNode());
            Point3d point3d = new Point3d();
            boundingBox.getLower(point3d);
            Point3d point3d2 = new Point3d();
            boundingBox.getUpper(point3d2);
            this.resetTranformations((Node)this.getModelNode());
            BoundingBox boundingBox2 = modelManager.getBounds((Node)this.getModelNode());
            Point3d point3d3 = new Point3d();
            boundingBox2.getLower(point3d3);
            Point3d point3d4 = new Point3d();
            boundingBox2.getUpper(point3d4);
            this.previewedPiece.setX(this.previewedPiece.getX() + (float)(point3d4.x + point3d3.x) / 2.0f - (float)(point3d2.x + point3d.x) / 2.0f);
            this.previewedPiece.setY(this.previewedPiece.getY() + (float)(point3d4.z + point3d3.z) / 2.0f - (float)(point3d2.z + point3d.z) / 2.0f);
            this.previewedPiece.setElevation(this.previewedPiece.getElevation() + (float)(point3d3.y - point3d.y));
            this.previewedPiece.setWidth((float)(point3d4.x - point3d3.x));
            this.previewedPiece.setDepth((float)(point3d4.z - point3d3.z));
            this.previewedPiece.setHeight((float)(point3d4.y - point3d3.y));
            this.previewedPiece.setModelTransformations(null);
        }
    }

    private void resetTranformations(Node node) {
        if (node instanceof Group) {
            if (node instanceof TransformGroup && node.getUserData() instanceof String && ((String)node.getUserData()).endsWith("_transformation")) {
                ((TransformGroup)node).setTransform(new Transform3D());
            }
            Enumeration enumeration = ((Group)node).getAllChildren();
            while (enumeration.hasMoreElements()) {
                this.resetTranformations((Node)enumeration.nextElement());
            }
        }
    }

    Transformation[] getModelTransformations() {
        if (this.previewedPiece != null) {
            return this.previewedPiece.getModelTransformations();
        }
        return null;
    }

    float getModelX() {
        return this.previewedPiece.getX();
    }

    float getModelY() {
        return this.previewedPiece.getY();
    }

    float getModelElevation() {
        return this.previewedPiece.getElevation();
    }

    float getModelWidth() {
        return this.previewedPiece.getWidth();
    }

    float getModelDepth() {
        return this.previewedPiece.getDepth();
    }

    float getModelHeight() {
        return this.previewedPiece.getHeight();
    }

    private void cloneTextures(Node node, Map<Texture, Texture> map) {
        Texture texture;
        Appearance appearance;
        if (node instanceof Group) {
            Enumeration enumeration = ((Group)node).getAllChildren();
            while (enumeration.hasMoreElements()) {
                this.cloneTextures((Node)enumeration.nextElement(), map);
            }
        } else if (node instanceof Link) {
            this.cloneTextures((Node)((Link)node).getSharedGroup(), map);
        } else if (node instanceof Shape3D && (appearance = ((Shape3D)node).getAppearance()) != null && (texture = appearance.getTexture()) != null) {
            Texture texture2 = map.get(texture);
            if (texture2 == null) {
                texture2 = (Texture)texture.cloneNodeComponent(false);
                map.put(texture, texture2);
            }
            appearance.setTexture(texture2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private BufferedImage getIconImage(int n) {
        Color color = this.getBackground();
        BufferedImage bufferedImage = null;
        BufferedImage bufferedImage2 = null;
        this.iconImageLock = new Object();
        try {
            Object object;
            Object object2;
            Point point = new Point();
            SwingUtilities.convertPointToScreen(point, this.component3D);
            if (this.iconImageLock != null && !Color.WHITE.equals(color)) {
                object2 = this.iconImageLock;
                synchronized (object2) {
                    this.setBackground(Color.WHITE);
                    try {
                        this.iconImageLock.wait(n / 2);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
            object2 = Component3DManager.getInstance();
            boolean bl = OperatingSystem.isLinux() && !Boolean.getBoolean("com.eteks.sweethome3d.j3d.useOffScreen3DView") || !((Component3DManager)object2).isOffScreenImageSupported();
            BufferedImage bufferedImage3 = bufferedImage = bl ? new Robot().createScreenCapture(new Rectangle(point, this.component3D.getSize())) : ((Component3DManager)object2).getOffScreenImage(this.getCanvas3D().getView(), this.component3D.getWidth() * 2, this.component3D.getHeight() * 2);
            if (this.iconImageLock != null) {
                object = this.iconImageLock;
                synchronized (object) {
                    this.setBackground(Color.BLACK);
                    try {
                        this.iconImageLock.wait(n / 2);
                    }
                    catch (InterruptedException interruptedException) {
                        interruptedException.printStackTrace();
                    }
                }
            }
            bufferedImage2 = bl ? new Robot().createScreenCapture(new Rectangle(point, this.component3D.getSize())) : ((Component3DManager)object2).getOffScreenImage(this.getCanvas3D().getView(), bufferedImage.getWidth(), bufferedImage.getHeight());
            object = bufferedImage.getRGB(0, 0, bufferedImage.getWidth(), bufferedImage.getHeight(), null, 0, bufferedImage.getWidth());
            int[] nArray = bufferedImage2.getRGB(0, 0, bufferedImage2.getWidth(), bufferedImage2.getHeight(), null, 0, bufferedImage2.getWidth());
            for (int i = 0; i < nArray.length; ++i) {
                if (nArray[i] == object[i] || nArray[i] != -16777216 || object[i] != -1) continue;
                object[i] = false;
            }
            BufferedImage bufferedImage4 = new BufferedImage(this.component3D.getWidth(), this.component3D.getHeight(), 2);
            Graphics2D graphics2D = (Graphics2D)bufferedImage4.getGraphics();
            ImageProducer imageProducer = new MemoryImageSource(bufferedImage.getWidth(), bufferedImage.getHeight(), (int[])object, 0, bufferedImage.getWidth());
            if (bufferedImage4.getWidth() != bufferedImage.getWidth() || bufferedImage4.getHeight() != bufferedImage.getHeight()) {
                imageProducer = new FilteredImageSource(imageProducer, new AreaAveragingScaleFilter(bufferedImage4.getWidth(), bufferedImage4.getHeight()));
            }
            graphics2D.drawImage(Toolkit.getDefaultToolkit().createImage(imageProducer), null, null);
            graphics2D.dispose();
            BufferedImage bufferedImage5 = bufferedImage4;
            return bufferedImage5;
        }
        catch (AWTException aWTException) {
            throw new RuntimeException(aWTException);
        }
        finally {
            this.iconImageLock = null;
            this.setBackground(color);
        }
    }

    public Content getIcon(int n) throws IOException {
        File file = OperatingSystem.createTemporaryFile("icon", ".png");
        ImageIO.write((RenderedImage)this.getIconImage(n), "png", file);
        return new TemporaryURLContent(file.toURI().toURL());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void canvas3DSwapped() {
        if (this.iconImageLock != null) {
            Object object = this.iconImageLock;
            synchronized (object) {
                this.iconImageLock.notify();
            }
        }
    }

    private static class JCanvas3DWithNotifiedPaint
    extends JCanvas3D {
        private final ModelPreviewComponent homeComponent3D;

        public JCanvas3DWithNotifiedPaint(ModelPreviewComponent modelPreviewComponent, GraphicsConfigTemplate3D graphicsConfigTemplate3D) {
            super(graphicsConfigTemplate3D);
            this.homeComponent3D = modelPreviewComponent;
        }

        public void paintComponent(Graphics graphics) {
            super.paintComponent(graphics);
            this.homeComponent3D.canvas3DSwapped();
        }
    }
}

